/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.persistence.ImportMetadataManagementInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.VirtualFolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Document;

public class ImportUtil {
    private static final String PERMISSION_WRITEMETADATA = "WriteMetadata";
    private static final String PERMISSION_WRITEMEMBERMETADATA = "WriteMemberMetadata";
    private static final String PERMISSION_READMETADATA = "ReadMetadata";

    public static boolean validateTargetContainerPermissions(PublicObjectContainerInterface targetContainer, ServerInterface server, boolean throwException) throws ServiceException, RemoteException {
        if (targetContainer == null) {
            return true;
        }
        boolean authorized = false;
        authorized = PromotionUtil.isFolder((PublicObjectInterface)targetContainer) ? (ImportUtil.isVirtualFolder(targetContainer) ? ImportUtil.isVirtualFolderWriteAuthorized(targetContainer, server) : ImportUtil.isFolderWriteAuthorized((PublicObjectInterface)targetContainer, server)) : ImportUtil.isWriteAuthorized((PublicObjectInterface)targetContainer, server);
        if (!authorized && throwException) {
            throw new ServiceException(RB.getStringResource("Common.NoPermission.txt"));
        }
        return authorized;
    }

    public static boolean validateTargetContainerPermissions(PublicObjectContainerInterface targetContainer, ImportOperationInterface operation, boolean throwException) throws ServiceException, RemoteException {
        if (operation.isProjectRepository()) {
            return true;
        }
        return ImportUtil.validateTargetContainerPermissions(targetContainer, operation.getServer(), throwException);
    }

    private static boolean isVirtualFolder(PublicObjectContainerInterface container) {
        return container instanceof VirtualFolderNodeInterface || container instanceof VirtualFolderInterface;
    }

    private static boolean isFolder(PublicObjectContainerInterface container) throws ServiceException, RemoteException {
        TypeDescriptorInterface type = container.getTypeDescriptor();
        return "Folder".equalsIgnoreCase(type.getTypeName()) && !ImportUtil.isVirtualFolder(container);
    }

    private static boolean isRootFolder(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        TypeDescriptorInterface type = publicObject.getTypeDescriptor();
        return type == null ? false : "RootFolder".equalsIgnoreCase(type.getTypeName());
    }

    public static boolean isReadAuthorized(PublicObjectInterface targetObject, ServerInterface server) throws ServiceException, RemoteException {
        return ImportUtil.isAuthorized(PERMISSION_READMETADATA, targetObject, server);
    }

    public static boolean isWriteAuthorized(PublicObjectInterface targetObject, ServerInterface server) throws ServiceException, RemoteException {
        return ImportUtil.isAuthorized(PERMISSION_WRITEMETADATA, targetObject, server);
    }

    public static boolean isFolderWriteAuthorized(PublicObjectInterface targetObject, ServerInterface server) throws ServiceException, RemoteException {
        return ImportUtil.isAuthorized(PERMISSION_WRITEMEMBERMETADATA, targetObject, server);
    }

    public static boolean isFolderWriteAuthorized(String folderId, ServerInterface server) throws ServiceException, RemoteException {
        return ImportUtil.isAuthorized(PERMISSION_WRITEMEMBERMETADATA, "Tree", folderId, server);
    }

    public static boolean isVirtualFolderWriteAuthorized(PublicObjectContainerInterface targetContainer, ServerInterface server) throws ServiceException, RemoteException {
        if (!ImportUtil.isVirtualFolder(targetContainer)) {
            return true;
        }
        boolean authorized = false;
        PublicObjectContainerInterface[] containers = SASFoldersUtil.getContainerPath((PublicObjectInterface)targetContainer);
        if (containers.length > 0) {
            for (int index = containers.length - 1; index >= 0; --index) {
                PublicObjectContainerInterface container = containers[index];
                if (ImportUtil.isRootFolder((PublicObjectInterface)container)) {
                    authorized = ImportUtil.isWriteAuthorized((PublicObjectInterface)container, server);
                    break;
                }
                if (!ImportUtil.isFolder(container)) continue;
                ImportElementInterface importElement = (ImportElementInterface)container.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
                if (importElement != null && importElement.getTargetID() != null) {
                    authorized = ImportUtil.isFolderWriteAuthorized(importElement.getTargetID(), server);
                    break;
                }
                authorized = ImportUtil.isFolderWriteAuthorized(container.getIdentifier(), server);
                break;
            }
        }
        return authorized;
    }

    private static boolean isAuthorized(String permission, PublicObjectInterface targetObject, ServerInterface server) throws ServiceException, RemoteException {
        String metadataType = targetObject.getTypeDescriptor().getMetadataType();
        return ImportUtil.isAuthorized(permission, metadataType, targetObject.getIdentifier(), server);
    }

    private static boolean isAuthorized(String permission, String targetMetadataType, String targetId, ServerInterface server) throws ServiceException, RemoteException {
        String resource = "OMSOBJ:" + targetMetadataType + "/" + targetId;
        return server.isAuthorized(null, resource, permission);
    }

    public static Document getObjectDocument(ImportOperationInterface operation, String objectID) throws MetadataPromotionException {
        ImportMetadataManagementInterface mgmt = (ImportMetadataManagementInterface)operation.getMetadataManager();
        PromotionItemInterface item = mgmt.getPromotionItem(objectID);
        if (item == null) {
            throw new MetadataPromotionException(Message.format((ResourceBundle)RB.getResources(), (String)"ImportUtil.ObjectNotInPackage.fmt.txt", (Object)objectID));
        }
        return mgmt.getObjectDocument(item);
    }

    public static Map<String, Document> getObjectDocuments(ImportOperationInterface operation, List<String> objectIDList) throws MetadataPromotionException {
        if (objectIDList == null) {
            return Collections.emptyMap();
        }
        ImportMetadataManagementInterface mgmt = (ImportMetadataManagementInterface)operation.getMetadataManager();
        ArrayList<PromotionItemInterface> items = new ArrayList<PromotionItemInterface>(objectIDList.size());
        for (String objectID : objectIDList) {
            PromotionItemInterface item = mgmt.getPromotionItem(objectID);
            if (item == null) {
                throw new MetadataPromotionException(Message.format((ResourceBundle)RB.getResources(), (String)"ImportUtil.ObjectNotInPackage.fmt.txt", (Object)objectID));
            }
            items.add(item);
        }
        return mgmt.getObjectDocuments(items);
    }

    public static Map<String, ?> getAssociationsForObject(ImportOperationInterface operation, String objectID, String template) throws MetadataPromotionException {
        ImportMetadataManagementInterface mgmt = (ImportMetadataManagementInterface)operation.getMetadataManager();
        PromotionItemInterface item = mgmt.getPromotionItem(objectID);
        if (item == null) {
            throw new MetadataPromotionException(Message.format((ResourceBundle)RB.getResources(), (String)"ImportUtil.ObjectNotInPackage.fmt.txt", (Object)objectID));
        }
        return mgmt.getAssociationsForObject(item, template);
    }

    public static Map<String, ?> getAssociationsForObjects(ImportOperationInterface operation, List<String> objectIDList, String template) throws MetadataPromotionException {
        if (objectIDList == null) {
            return Collections.emptyMap();
        }
        ImportMetadataManagementInterface mgmt = (ImportMetadataManagementInterface)operation.getMetadataManager();
        ArrayList<PromotionItemInterface> items = new ArrayList<PromotionItemInterface>(objectIDList.size());
        for (String objectID : objectIDList) {
            PromotionItemInterface item = mgmt.getPromotionItem(objectID);
            if (item == null) {
                throw new MetadataPromotionException(Message.format((ResourceBundle)RB.getResources(), (String)"ImportUtil.ObjectNotInPackage.fmt.txt", (Object)objectID));
            }
            items.add(item);
        }
        return mgmt.getAssociationsForObjects(items, template);
    }
}

