/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.promotion.ImportSummaryItem;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.PublicObjectInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportSummary
implements ImportSummaryInterface {
    private List<PublicObjectInterface> _importedItems = new ArrayList<PublicObjectInterface>();
    private Map<String, ImportState> _stateCache = new HashMap<String, ImportState>();
    private int _newCount = 0;
    private int _overwriteCount = 0;

    @Override
    public List<PublicObjectInterface> getImportedObjects() throws ServiceException, RemoteException {
        return new ArrayList<PublicObjectInterface>(this._importedItems);
    }

    @Override
    public void addImportedObject(PublicObjectInterface item, boolean isNewObject) throws ServiceException, RemoteException {
        if (item != null) {
            this._importedItems.add(item);
            if (isNewObject) {
                ++this._newCount;
                this._stateCache.put(item.getIdentifier(), ImportState.CREATED);
            } else {
                ++this._overwriteCount;
                this._stateCache.put(item.getIdentifier(), ImportState.UPDATED);
            }
        }
    }

    @Override
    public boolean wasObjectCreated(PublicObjectInterface item) throws ServiceException, RemoteException {
        return item == null ? false : ImportState.CREATED == this._stateCache.get(item.getIdentifier());
    }

    @Override
    public boolean wasObjectUpdated(PublicObjectInterface item) throws ServiceException, RemoteException {
        return item == null ? false : ImportState.UPDATED == this._stateCache.get(item.getIdentifier());
    }

    @Override
    public List<ImportSummaryItem> getSummaryItems() {
        ArrayList<ImportSummaryItem> summaryItems = new ArrayList<ImportSummaryItem>();
        try {
            for (PublicObjectInterface obj : this._importedItems) {
                PathUrl path = obj.getPathUrl();
                String sPath = path == null ? "" : path.getAbsolutePath();
                ImportSummaryItem item = new ImportSummaryItem(obj.getIdentifier(), obj.getName(), sPath, obj.getTypeDescriptor().getTypeName());
                summaryItems.add(item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error creating summary items");
        }
        return summaryItems;
    }

    @Override
    public void addSummaryItem(ImportSummaryItem item) {
    }

    @Override
    public int getNewImportedItemsCount() {
        return this._newCount;
    }

    @Override
    public int getUpdatedImportedItemsCount() {
        return this._overwriteCount;
    }

    @Override
    public int getTotalImportedItemsCount() {
        return this._importedItems.size();
    }

    private static enum ImportState {
        CREATED,
        UPDATED;

    }
}

