/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.persistence.ImportMetadataManagementInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.services.TransportException;
import com.sas.text.Message;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;

public class ExportHelper {
    public static final int TYPE_FOLDER = 1;
    public static final int TYPE_PUBLIC_OBJECTS = 2;
    private ImportHandler _importHandler;
    private ExportHandler _exportHandler;

    private ExportHelper(ImportHandler importHandler, ExportHandler exportHandler) {
        this._importHandler = importHandler;
        this._exportHandler = exportHandler;
    }

    public static ExportHelper getExportHelper(ImportHandler importHandler, ExportHandler exportHandler) {
        if (importHandler != null && exportHandler != null) {
            return new ExportHelper(importHandler, exportHandler);
        }
        return null;
    }

    public SimpleLogicalObjectInterface[] getPromotionItemsFromPackage(boolean checkValidity) throws RemoteException {
        SimpleLogicalObjectInterface[] validObjects = null;
        ImportMetadataManagementInterface metaMgr = this._importHandler.getMetadataManager();
        List<? extends PromotionItemInterface> promotionItems = metaMgr.getPromotionItems();
        ArrayList<SimpleLogicalObjectInterface> publicObjectItems = new ArrayList<SimpleLogicalObjectInterface>();
        if (promotionItems != null) {
            for (SimpleLogicalObjectInterface simpleLogicalObjectInterface : promotionItems) {
                publicObjectItems.add(simpleLogicalObjectInterface);
            }
        }
        if (!publicObjectItems.isEmpty()) {
            validObjects = checkValidity ? this.getValidLogicalObjects(publicObjectItems) : publicObjectItems.toArray(new SimpleLogicalObjectInterface[0]);
        }
        return validObjects;
    }

    public ImportHandler get_importHandler() {
        return this._importHandler;
    }

    public void set_importHandler(ImportHandler handler) {
        this._importHandler = handler;
    }

    public ExportHandler get_exportHandler() {
        return this._exportHandler;
    }

    public void set_exportHandler(ExportHandler handler) {
        this._exportHandler = handler;
    }

    public int loadPackage(File packageFile) throws TransportException, RemoteException, MetadataPromotionException {
        return this._importHandler.loadExportPackage(packageFile);
    }

    public static String formatPath(List path) {
        StringBuffer exportedFolderPath = new StringBuffer();
        for (Object pathToken : path) {
            exportedFolderPath.append(String.valueOf('/'));
            exportedFolderPath.append((String)pathToken);
        }
        return exportedFolderPath.toString();
    }

    public static String formatPath(String[] path) {
        StringBuffer exportedFolderPath = new StringBuffer();
        for (int i = 0; i < path.length; ++i) {
            exportedFolderPath.append(String.valueOf('/'));
            exportedFolderPath.append(path[i]);
        }
        return exportedFolderPath.toString();
    }

    public String[] getExportedItemsPath(int type) {
        HashSet<String> exportedItems = new HashSet<String>();
        for (PromotionItemInterface promotionItemInterface : this._importHandler.getMetadataManager().getPromotionItems()) {
            String publicType = promotionItemInterface.getTypeInterface().getPublicType();
            if (type == 1) {
                if ("RootFolder".equalsIgnoreCase(promotionItemInterface.getTypeInterface().getPublicType())) {
                    exportedItems.clear();
                    exportedItems.add(String.valueOf('/'));
                    break;
                }
                if ("Folder".equalsIgnoreCase(publicType)) {
                    exportedItems.add(BIPTreeUtil.pathToString(promotionItemInterface.getSourcePath(), promotionItemInterface.getName(), publicType));
                    continue;
                }
                exportedItems.add(ExportHelper.formatPath(promotionItemInterface.getSourcePath()));
                continue;
            }
            if (type == 2) {
                if ("Folder".equalsIgnoreCase(publicType) || "RootFolder".equalsIgnoreCase(publicType)) continue;
                exportedItems.add(BIPTreeUtil.pathToString(promotionItemInterface.getSourcePath(), promotionItemInterface.getName(), publicType));
                continue;
            }
            exportedItems.add(BIPTreeUtil.pathToString(promotionItemInterface.getSourcePath(), promotionItemInterface.getName(), publicType));
        }
        String[] objectPaths = null;
        if (!exportedItems.isEmpty()) {
            objectPaths = exportedItems.toArray(new String[0]);
        }
        return objectPaths;
    }

    public SimpleLogicalObjectInterface[] getValidLogicalObjects(List<SimpleLogicalObjectInterface> objects) throws RemoteException {
        ArrayList<SimpleLogicalObjectInterface> validObjects = new ArrayList<SimpleLogicalObjectInterface>();
        if (objects != null) {
            MdOMIUtil mdUtil = this._exportHandler.getMetadataFactory().getOMIUtil();
            for (SimpleLogicalObjectInterface slo : objects) {
                try {
                    String objName = mdUtil.getMetadataSimple(slo.getTypeInterface().getMetadataType(), slo.getID(), "Name");
                    validObjects.add(slo);
                }
                catch (MdException e) {
                    Object[] values = new Object[]{slo.getTypeInterface().getPublicType(), slo.getName(), e.getLocalizedMessage()};
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchExporter.IgnoringObjectMessage.fmt.txt", (Object[])values);
                    this._exportHandler.getLogger().warn(msg);
                }
            }
        }
        return validObjects.isEmpty() ? null : validObjects.toArray(new SimpleLogicalObjectInterface[0]);
    }
}

