/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableType2Interface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.BatchExporter;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportListener;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ExportSummary;
import com.sas.metadata.promotion.ExportSummaryInterface;
import com.sas.metadata.promotion.LoggingUtil;
import com.sas.metadata.promotion.MetadataExportTree;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NoObjectsToExportException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.promotion.PromotionHandler;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.model.ExportElementInterface;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.model.ExportModelConfiguration;
import com.sas.metadata.promotion.model.ModelFactory;
import com.sas.metadata.promotion.persistence.ExportMetadataManager;
import com.sas.metadata.promotion.persistence.MetadataManagementInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.publicobject.BasePublicObject;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.UUID;

public class ExportHandler
extends PromotionHandler
implements ExportOperationInterface {
    private SimpleLogicalObjectInterface[] _selectedLogicalObjects;
    private SoftwareComponent _bipService;
    private Tree _parentFolder;
    private MetadataExportTree _exportTree = null;
    private boolean _isOldStylePromotion = false;
    private ExportSummaryInterface _summary;
    private ExportMetadataManager _metadataManager;
    private PublicObjectContainerInterface _container;
    private List<PublicObjectInterface> _publicObjects;
    private ExportFolderModelInterface _exportModel = null;
    private List<ExportItemInterface> _dependentObjects;
    private boolean _metadataExported = false;
    private boolean _includeDependencies = false;
    boolean _usedForChangeManagement = false;

    protected ExportHandler(List<String> supportedTypes, int type) throws RemoteException {
        super(supportedTypes, type);
        this.initialize();
    }

    public ExportHandler(PublicObjectContainerInterface container, List<String> supportedTypes, int type) throws RemoteException, ServiceException {
        this(supportedTypes, type);
        this._container = container;
    }

    public ExportHandler(List<PublicObjectInterface> publicObjects, List<String> supportedTypes, int type) throws RemoteException, ServiceException {
        this(supportedTypes, type);
        this._publicObjects = publicObjects;
    }

    protected ExportHandler(MdFactory factory, int type, TypeInterface[] availableTypes) throws RemoteException {
        super(factory, type, availableTypes);
        this.initialize();
        this._isOldStylePromotion = true;
    }

    public ExportHandler(MdFactory factory, Tree parentFolder, int type, TypeInterface[] availableTypes) throws RemoteException {
        this(factory, type, availableTypes);
        this._parentFolder = parentFolder;
        this._reposID = PromotionUtil.getRepositoryID((CMetadata)parentFolder);
    }

    public ExportHandler(MdFactory factory, SoftwareComponent bipService, int type, TypeInterface[] availableTypes) throws RemoteException {
        this(factory, type, availableTypes);
        this._bipService = bipService;
        this._reposID = PromotionUtil.getRepositoryID((CMetadata)bipService);
    }

    public ExportHandler(MdFactory factory, SimpleLogicalObjectInterface[] logicalObjects, int type, TypeInterface[] availableTypes) throws RemoteException {
        this(factory, type, availableTypes);
        this.setSelectedLogicalObjects(logicalObjects);
    }

    public ExportHandler(MdFactory factory, SimpleLogicalObjectInterface[] logicalObjects, int type, TypeInterface[] availableTypes, boolean usedForChangeManagement) throws RemoteException {
        this(factory, type, availableTypes);
        this._usedForChangeManagement = usedForChangeManagement;
        this.setSelectedLogicalObjects(logicalObjects);
    }

    @Override
    public void setSessionContext(SessionContextInterface session, boolean createDetachedTransaction) throws ServiceException, RemoteException {
        super.setSessionContext(session, createDetachedTransaction);
        if (this._reposID == null) {
            try {
                this._reposID = this._factory.getOMIUtil().getFoundationReposID();
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e, e.getLocalizedMessage());
            }
        }
        if (this._isOldStylePromotion) {
            ObjectConverter converter = ObjectConverter.getInstance();
            if (this._selectedLogicalObjects != null) {
                PublicObjectInterface[] objects = converter.convertToPublicObjects(this._selectedLogicalObjects, this._server);
                this._publicObjects = Arrays.asList(objects);
            } else if (this._parentFolder != null) {
                String key = this._parentFolder.getId() + "/" + this._parentFolder.getCMetadataType();
                FolderInterface folder = (FolderInterface)this._server.fetch(key, true);
                if (folder == null) {
                    throw new ServiceException("Unable to retrieve folder from the server.");
                }
                this._container = folder;
            } else if (this._bipService != null) {
                this._container = this._server.getRootFolder();
            }
        }
    }

    @Override
    public MetadataManagementInterface getMetadataManager() {
        return this._metadataManager;
    }

    @Override
    public PublicObjectContainerInterface getExportedContainer() {
        return this._container;
    }

    @Override
    public List<PublicObjectInterface> getExportedObjects() {
        return this._publicObjects;
    }

    public void setSelectedLogicalObjects(SimpleLogicalObjectInterface[] logicalObjects) {
        this._selectedLogicalObjects = logicalObjects;
        if (logicalObjects.length > 0) {
            this._reposID = "A0000001." + logicalObjects[0].getID().substring(0, 8);
        }
    }

    public void setSelectedObjects(List<PublicObjectInterface> publicObjects) throws ServiceException, RemoteException {
        this._publicObjects = publicObjects;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.registerTypes();
        this._summary = new ExportSummary();
    }

    @Override
    protected boolean isSecurityIncluded() {
        return true;
    }

    @Override
    public void setIncludeDependencies(boolean include) {
        this._includeDependencies = include;
    }

    @Override
    public boolean isIncludingDependencies() {
        return this._includeDependencies;
    }

    @Override
    public boolean isUsedForChangeManagement() {
        return this._usedForChangeManagement;
    }

    public void setExportFile(File exportFile) {
        this._packageFile = exportFile;
    }

    @Override
    public File getExportFile() {
        return this.getPackageFile();
    }

    public void clearExportItems() {
        this.clearPromotionItems();
    }

    public int setItemsToExport(Map exportMap, boolean validate) throws MdException {
        this.setPromotionItems(exportMap);
        int rc = 0;
        if (this._selectedObjects == null) {
            return rc;
        }
        if (validate) {
            this._log.info(RB.getStringResource("ExportHandler.BeginAnalyze.Log.txt"));
            for (String publicType : this._selectedObjects.keySet()) {
                List objects = (List)this._selectedObjects.get(publicType);
                ExportListener listener = this.getExportListener(publicType);
                if (objects == null || listener == null) continue;
                String statusMessage = StatusMessageUtil.createDefaultAnalyzingMessage((TypeInterface)listener.getTypeInterface());
                this.fireDisplayMessageForListener(listener, statusMessage);
                rc |= listener.analyzeObjectsToExport(this, objects);
            }
        }
        return rc;
    }

    @Override
    public ExportFolderModelInterface getExportModel() {
        return this._exportModel;
    }

    public void setExportModel(ExportFolderModelInterface exportModel) {
        this._exportModel = exportModel;
    }

    @Override
    public MetadataExportTree getExportTree() {
        return this._exportTree;
    }

    public void setExportTree(MetadataExportTree tree) {
        this._exportTree = tree;
    }

    @Override
    public Map getExportItems() {
        return this._selectedObjects == null ? new HashMap() : this._selectedObjects;
    }

    @Override
    public ExportSummaryInterface getExportSummary() {
        return this._summary;
    }

    @Override
    public ExportListener getExportListener(String logicalType) {
        TransportableTypeInterface type = (TransportableTypeInterface)this._supportedTypesMap.get(logicalType);
        return type == null ? null : (ExportListener)type.getExportListener();
    }

    @Override
    public ExportItemInterface createExportItem(String name, String publicType, String id) {
        ExportItemInterface item = (ExportItemInterface)this.getPromotionItem(id);
        if (item != null) {
            return item;
        }
        TransportableTypeInterface type = this.getTransportableType(publicType);
        if (type != null) {
            ExportListener listener = (ExportListener)type.getExportListener();
            item = listener != null ? listener.createExportItem(name, id, type) : new DefaultExportItem(name, id, type);
            item.setExportOperation(this);
        }
        return item;
    }

    public void setDependentObjects(List<ExportItemInterface> objects) {
        this._dependentObjects = objects;
    }

    @Override
    public void dispose() {
        block5: {
            this.fireNotification(new NotificationEvent(this, this, 100));
            super.dispose();
            try {
                for (PublicObjectInterface po : this._summary.getExportedObjects()) {
                    if (!(po instanceof BasePublicObject)) continue;
                    ((BasePublicObject)po).setServer(null);
                }
            }
            catch (Exception e) {
                if (this._log == null || !this._log.isDebugEnabled()) break block5;
                this._log.debug("Error updating summary items");
            }
        }
        if (this._metadataManager != null) {
            this._metadataManager.dispose();
        }
        this._exportModel = null;
        if (this._log != null && this._promotionType == 0) {
            this._log.destroy();
        }
    }

    public int runExport() throws Exception {
        int rc = 0;
        this._log.info(RB.getStringResource("ExportHandler.Begin.Log.txt"));
        if (this.isBatchProcess()) {
            this._log.info(RB.getStringResource("PromotionHandler.Batch.txt"));
        }
        this._propManager.clearPropertyLists();
        Date exportTime = new Date();
        UUID packageUUID = UUID.randomUUID();
        String prop = this._packageFile.getCanonicalPath();
        this._propertiesFile.addProperty("PackageFile", prop);
        prop = packageUUID.toString();
        this._propertiesFile.addProperty("PackageUUID", prop);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        prop = sdf.format(exportTime);
        this._propertiesFile.addProperty("ExportTime", prop);
        this.exportMetadata();
        if (!this._metadataExported) {
            throw new IllegalStateException(RB.getStringResource("ExportHandler.InvalidState.NoMetadata.txt"));
        }
        rc |= this.exportContent();
        rc |= this.analyzeConnections();
        this._propManager.exportSubstitutions();
        return rc |= this.createPackageFile(exportTime);
    }

    private void exportMetadata() throws MdException, IOException, MetadataPromotionException {
        NotificationEvent event = new NotificationEvent(this, this, 105);
        this.fireNotification(event);
        this.validateExport();
        if (this._log.isInfoEnabled()) {
            if (this._packageFile != null) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.PackageFile.Log.txt", (Object)this._packageFile.getAbsolutePath()));
            }
            try {
                String str = LoggingUtil.displayExportedObjects(this._selectedObjects, this._server, true);
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.ExportingObjects.Log.txt", (Object)str));
                this._log.info(RB.getStringResource("ExportHandler.BeginMetadata.Log.txt"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._metadataManager = new ExportMetadataManager(this);
        this._metadataManager.exportMetadata();
        this.addUserData();
        this._log.info(RB.getStringResource("ExportHandler.MetadataExportSuccess.txt"));
        this._metadataExported = true;
    }

    private int exportContent() throws IOException, TransportException, MdException {
        NotificationEvent event = new NotificationEvent(this, this, 110);
        this.fireNotification(event);
        this._log.info(RB.getStringResource("ExportHandler.BeginContent.Log.txt"));
        int rc = 0;
        if (this._supportedTypesMap.size() > 0) {
            for (String publicType : this._selectedObjects.keySet()) {
                List objects = (List)this._selectedObjects.get(publicType);
                ExportListener listener = this.getExportListener(publicType);
                try {
                    if (objects == null || listener == null) continue;
                    if (this._log.isInfoEnabled()) {
                        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.AddContent.fmt.txt", (Object)listener.getTypeInterface().getDisplayType()));
                    }
                    rc |= listener.exportContent(this, objects);
                }
                catch (Exception e) {
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.ContentError.fmt.txt", (Object)listener.getTypeInterface().getDisplayType()), e);
                    rc |= 8;
                }
            }
        }
        return rc;
    }

    private int analyzeConnections() throws MetadataPromotionException, MdException, RemoteException {
        NotificationEvent event = new NotificationEvent(this, this, 120);
        this.fireNotification(event);
        this._log.info(RB.getStringResource("ExportHandler.BeginConnections.Log.txt"));
        int rc = 0;
        if (this._supportedTypesMap.size() > 0) {
            for (Object publicType : this._selectedObjects.keySet()) {
                List objects = (List)this._selectedObjects.get(publicType);
                ExportListener listener = this.getExportListener((String)publicType);
                if (objects != null && listener != null) {
                    rc |= listener.analyzeConnections(this, objects);
                }
                this.fireDisplayMessageForListener(listener, "");
            }
            List<ConnectionTypeInterface> connectionTypes = this.getConnectionTypes();
            for (ConnectionTypeInterface type : connectionTypes) {
                type.analyzeConnections();
            }
            List<ConnectionPointInterface> connections = this.getConnectionManager().getConnections(true);
            for (ConnectionPointInterface pt : connections) {
                String path;
                String publicType;
                if (pt.isInternalConnection() || (publicType = pt.getPublicType()) == null) continue;
                if (pt.isActive() && this.getPromotionItem(pt.getSourceID()) != null) {
                    pt.setActive(false);
                }
                if (pt.getSourcePath() != null || pt.getSourceID().length() != 17 || (path = this.getObjectPath(pt.getMetadataType(), pt.getPublicType(), pt.getSourceID(), pt.getName())) == null) continue;
                pt.setSourcePath(path);
            }
        }
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Generating connection files");
            }
            this._metadataManager.writeConnections();
            this._propManager.writeConnections();
            String mappings = LoggingUtil.displaySourceConnections(this);
            if (mappings.length() > 0) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.ConnectionMappings.txt", (Object)mappings));
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e, RB.getStringResource("ExportHandler.GeneratingConnectionsError.txt"));
        }
        return rc;
    }

    private String getObjectPath(String metadataType, String publicType, String id, String name) throws MdException, RemoteException {
        String[] path = BIPTreeUtil.getObjectPathFromServer(this.getStore(), id, metadataType);
        if (path.length > 0 || path.length == 0 && "Folder".equalsIgnoreCase(publicType)) {
            String objectPath = BIPTreeUtil.pathToString(path, name, publicType);
            return objectPath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createPackageFile(Date beginTime) throws IOException {
        NotificationEvent event = new NotificationEvent(this, this, 130);
        this.fireNotification(event);
        int rc = 0;
        this._log.info(RB.getStringResource("ExportHandler.CreatePackage.Log.txt"));
        File props = null;
        try {
            try {
                String dir;
                if (!this._propertiesFile.isEmpty() && (props = this._propertiesFile.write(dir = this._contentHandler.getDestinationPath())) != null) {
                    this._contentHandler.addFileToPackage(props, 1);
                }
            }
            catch (IOException e) {
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.AddPropertiesToPackageError.txt", (Object)e.getMessage()));
                rc |= 4;
            }
            try {
                this._propManager.writeProperties();
            }
            catch (IOException e) {
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.AddConnectionPropsToPackageError.txt", (Object)e.getMessage()));
                rc |= 4;
            }
            try {
                String logFileName = this._log.getLogFileName();
                if (logFileName != null) {
                    this._contentHandler.addFileToPackage(new File(logFileName), 0);
                }
            }
            catch (IOException e) {
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.AddLogToPackageError.txt", (Object)e.getMessage()));
                rc |= 4;
            }
            if (this._log.isInfoEnabled()) {
                String command;
                if (this.getPromotionType() == 0 && !this.isBatchProcess() && (command = BatchExporter.generateBatchCommand(this)) != null && command.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(RB.getStringResource("ExportHandler.BatchCommand.txt"));
                    sb.append("\r\n");
                    sb.append(RB.getStringResource("ExportHandler.BatchCommand2.txt"));
                    sb.append("\r\n").append("\r\n");
                    sb.append(command);
                    sb.append("\r\n");
                    this._log.info(sb.toString());
                }
                long endTime = System.currentTimeMillis();
                double totalTime = (double)(endTime - beginTime.getTime()) / 1000.0;
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.TotalTime.txt", (Object)new Double(totalTime)));
            }
            try {
                this._contentHandler.publishPackage();
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.CreatedPackage.fmt.txt", (Object)this._packageFile.getName()));
            }
            catch (TransportException e) {
                rc |= 8;
                String errorMsg = Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.CreatePackageError.fmt.txt", (Object)e.getLocalizedMessage());
                this._log.error(errorMsg);
                if (e.getCause() != null) {
                    Throwable t = e.getCause();
                    this._log.error("  " + t.getLocalizedMessage());
                }
            }
        }
        finally {
            try {
                if (props != null) {
                    props.delete();
                }
            }
            catch (Exception exception) {}
        }
        return rc;
    }

    @Override
    public boolean isTypeSupported(String logicalType) {
        TransportableTypeInterface type = this.getTransportableType(logicalType);
        if (type == null) {
            return false;
        }
        if (type instanceof TransportableType2Interface) {
            if (this._promotionType == 0) {
                return ((TransportableType2Interface)type).isExportAllowed();
            }
            if (this._promotionType == 2 || this._promotionType == 3) {
                return ((TransportableType2Interface)type).isCopyAllowed();
            }
        }
        return true;
    }

    @Override
    protected void registerTypes() {
        super.registerTypes();
        if (this._supportedTypes != null) {
            try {
                for (String type : this._supportedTypes) {
                    this.addRegisteredType(type);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Error registering public type instances.");
            }
        }
    }

    private void addUserData() throws MetadataPromotionException {
        try {
            this.addDependentObjectsMarker();
            this.addFolderPaths();
        }
        catch (Exception e) {
            throw new MetadataPromotionException(RB.getStringResource("ExportHandler.PropertiesError.txt"));
        }
    }

    private void addDependentObjectsMarker() {
        if (this._dependentObjects != null && this._dependentObjects.size() > 0) {
            StringBuilder sb = new StringBuilder(this._dependentObjects.size() * 18);
            for (ExportItemInterface exportItem : this._dependentObjects) {
                if (!this.isObjectBeingPromoted(exportItem.getTypeInterface().getPublicType(), exportItem.getID())) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(exportItem.getID());
            }
            this.getPropertiesFile().addProperty("DependentObjects", sb.toString());
        }
    }

    private void addFolderPaths() throws ServiceException, RemoteException {
        block11: {
            block9: {
                block10: {
                    if (this._container == null) break block9;
                    if (!PromotionUtil.isFolder((PublicObjectInterface)this._container)) break block10;
                    PublicObjectNodeInterface node = this._exportModel.getObject((PublicObjectInterface)this._container);
                    this.getPropertiesFile().addProperty("ExportFolder", node.getDisplayPath());
                    break block11;
                }
                if (!PromotionUtil.isRootFolder((PublicObjectInterface)this._container)) break block11;
                this.getPropertiesFile().addProperty("ExportFolder", String.valueOf('/'));
                break block11;
            }
            if (this._publicObjects != null) {
                int length = this._publicObjects.size();
                if (length == 1 && this.getPromotionType() == 0) {
                    PublicObjectInterface publicObject = this._publicObjects.get(0);
                    String publicType = publicObject.getTypeDescriptor().getTypeName();
                    if (FolderUtil.isFolder((String)publicType)) {
                        PublicObjectNodeInterface node = this._exportModel.getObject(publicObject);
                        this.getPropertiesFile().addProperty("ExportFolder", node.getDisplayPath());
                    } else if ("RootFolder".equals(publicType)) {
                        this.getPropertiesFile().addProperty("ExportFolder", String.valueOf('/'));
                    } else {
                        this.getPropertiesFile().addProperty("ExportFolders", "");
                    }
                } else {
                    ArrayList<String> paths = new ArrayList<String>();
                    for (PublicObjectInterface publicObject : this._publicObjects) {
                        String publicType = publicObject.getTypeDescriptor().getTypeName();
                        if (!FolderUtil.isFolder((String)publicType) || !this.isObjectBeingPromoted(publicType, publicObject.getIdentifier())) continue;
                        PublicObjectNodeInterface node = this._exportModel.getObject(publicObject);
                        paths.add(node.getDisplayPath());
                    }
                    int count = 0;
                    List parentFolders = BIPTreeUtil.getUniqueParentFolders(paths);
                    for (String path : parentFolders) {
                        this.getPropertiesFile().addProperty("ExportFolders_" + count++, path);
                    }
                }
            }
        }
    }

    private void validateExport() {
        try {
            if (this._selectedObjects == null || this._selectedObjects.size() == 0) {
                throw new IllegalStateException(RB.getStringResource("ExportHandler.InvalidState.NoObjects.txt"));
            }
            if (this._packageFile == null) {
                throw new IllegalStateException(RB.getStringResource("ExportHandler.InvalidState.NoFile.txt"));
            }
            if (this._reposID == null || this._factory.getConnection().getCMRHandle() == null) {
                throw new IllegalStateException(RB.getStringResource("ExportHandler.InvalidState.NoConnection.txt"));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void loadObjectsToExport(PublicObjectInterface[] objects, List<SearchFilter> filters) throws ServiceException, RemoteException {
        ExportFolderModelInterface model = ModelFactory.createExportFolderModel(this);
        ExportModelConfiguration config = (ExportModelConfiguration)model.getConfiguration();
        config.setDisplayUnknownObjects(false);
        config.setIncludeDependencies(this._includeDependencies);
        this.loadObjectsToExport(objects, filters, model);
    }

    public void loadObjectsToExport(PublicObjectInterface[] objects, List<SearchFilter> filters, ExportFolderModelInterface model) throws ServiceException, RemoteException {
        if (this._publicObjects == null && this._container == null) {
            this._publicObjects = Arrays.asList(objects);
        }
        this._exportModel = model;
        this._exportModel.setSearchFilters(filters);
        this._exportModel.populateModel(objects);
        try {
            this.setItemsToExport(this.getExportItems(this._exportModel), true);
            this.setDependentObjects(this.getExternalDependencies(this._exportModel));
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
        List<PublicObjectNodeInterface> duplicateObjects = this._exportModel.getDuplicateObjects();
        if (duplicateObjects != null && !duplicateObjects.isEmpty() && this._log.isWarnEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(RB.getStringResource("ExportHandler.DuplicateNames.txt"));
            for (PublicObjectNodeInterface node : duplicateObjects) {
                sb.append("\r\n   ");
                sb.append(node.getAbsolutePath());
            }
            sb.append("\r\n");
            this._log.warn(sb.toString());
        }
        if (this._selectedObjects != null && this._selectedObjects.size() == 0) {
            throw new NoObjectsToExportException(RB.getStringResource("ExportHandler.NoObjectsToExport.txt"));
        }
    }

    private Map<String, List<ExportItemInterface>> getExportItems(ExportFolderModelInterface model) throws ServiceException, RemoteException {
        List<PublicObjectNodeInterface> exportObjects = model.getAllExportedObjects();
        LinkedHashMap<String, List<ExportItemInterface>> exportMap = new LinkedHashMap<String, List<ExportItemInterface>>();
        for (PublicObjectNodeInterface node : exportObjects) {
            ExportItemInterface exportItem;
            String publicType = node.getTypeDescriptor().getTypeName();
            ExportElementInterface exportElement = model.getExportElement((PublicObjectInterface)node);
            if (exportElement == null || (exportItem = exportElement.getExportItem()) == null) continue;
            ArrayList<ExportItemInterface> items = (ArrayList<ExportItemInterface>)exportMap.get(publicType);
            if (items == null) {
                items = new ArrayList<ExportItemInterface>();
                exportMap.put(publicType, items);
                items.add(exportItem);
                continue;
            }
            if (items.contains(exportItem)) continue;
            items.add(exportItem);
        }
        return exportMap;
    }

    protected List<ExportItemInterface> getExternalDependencies(ExportFolderModelInterface model) throws ServiceException, RemoteException {
        List<PublicObjectNodeInterface> dependentObjectNodes = model.getExternalDependentObjects();
        if (dependentObjectNodes != null) {
            ArrayList<ExportItemInterface> dependencies = new ArrayList<ExportItemInterface>(dependentObjectNodes.size());
            for (PublicObjectNodeInterface node : dependentObjectNodes) {
                ExportItemInterface exportItem;
                ExportElementInterface exportElement = model.getExportElement((PublicObjectInterface)node);
                if (exportElement == null || (exportItem = exportElement.getExportItem()) == null) continue;
                dependencies.add(exportItem);
            }
            return dependencies;
        }
        return null;
    }
}

