/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.DefaultPromotionItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.SubstitutionInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultImportItem
extends DefaultPromotionItem
implements ImportItemInterface {
    protected ImportOperationInterface _importOperation;
    protected int _importState = 1;
    protected String _originalName;
    protected String[] _targetPath;
    protected String _targetID;
    protected List<SubstitutionInterface> _substitutionList;

    public DefaultImportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
        this._originalName = name;
    }

    @Override
    public ImportOperationInterface getImportOperation() {
        return this._importOperation;
    }

    @Override
    public void setImportOperation(ImportOperationInterface importOperation) {
        this._importOperation = importOperation;
    }

    @Override
    public String getTargetID() {
        return this._targetID;
    }

    @Override
    public void setTargetID(String id) {
        this._targetID = id;
    }

    @Override
    public String[] getTargetPath() {
        return this._targetPath;
    }

    public void setTargetPath(String[] path) {
        this._targetPath = path;
    }

    @Override
    public void rename(String name) {
        this._name = name;
    }

    @Override
    public String getOriginalName() {
        return this._originalName;
    }

    @Override
    public boolean isRenamed() {
        return this._originalName == null ? false : !this._originalName.equals(this._name);
    }

    @Override
    public int getImportState() {
        return this._importState;
    }

    @Override
    public void setImportState(int state) {
        this._importState = state;
    }

    @Override
    public List<SubstitutionInterface> getSubstitutions() {
        if (this._substitutionList == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SubstitutionInterface>(this._substitutionList);
    }

    protected void addSubstitution(SubstitutionInterface sub) {
        if (this._substitutionList == null) {
            this._substitutionList = new ArrayList<SubstitutionInterface>(5);
        }
        if (!this._substitutionList.contains(sub)) {
            this._substitutionList.add(sub);
        }
    }

    public String toString() {
        if (this._targetPath == null) {
            return this.getName();
        }
        StringBuffer sb = new StringBuffer();
        sb.append('/');
        int length = this._targetPath.length;
        for (int index = 0; index < length; ++index) {
            sb.append(this._targetPath[index]).append('/');
        }
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    public void addNestedItem(NestedImportItemInterface nestedItem) {
        super.addNestedItem(nestedItem);
    }
}

