/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.promotion.LoggingUtil;
import com.sas.metadata.promotion.MetadataFilterInterface;
import com.sas.metadata.promotion.RB;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

@SASScope
public class DateFilter
implements MetadataFilterInterface {
    public static final int TYPE_CREATED_DATE = 0;
    public static final int TYPE_MODIFIED_DATE = 1;
    private static SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.ENGLISH);
    private String _rangeLabel;
    private int _type;
    private Date _beginDate;
    private Date _endDate;

    public DateFilter(int type, Date beginDate) {
        this(type, beginDate, null);
    }

    public DateFilter(int type, Date beginDate, Date endDate) {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
        this._rangeLabel = null;
        this._type = type;
        this._beginDate = beginDate;
        this._endDate = endDate;
    }

    public void setDateRangeLabel(String rangeLabel) {
        this._rangeLabel = rangeLabel;
    }

    public String getDateRangeLabel() {
        return this._rangeLabel;
    }

    public int getType() {
        return this._type;
    }

    public DatePeriod getBeginDatePeriod() {
        return this._beginDate instanceof DatePeriod ? (DatePeriod)this._beginDate : null;
    }

    public Date getBeginDate() {
        return this._beginDate instanceof DatePeriod ? ((DatePeriod)this._beginDate).getStartOfPeriod() : this._beginDate;
    }

    public DatePeriod getEndDatePeriod() {
        return this._endDate instanceof DatePeriod ? (DatePeriod)this._endDate : null;
    }

    public Date getEndDate() {
        return this._endDate instanceof DatePeriod ? ((DatePeriod)this._endDate).getEndOfPeriod() : this._endDate;
    }

    private String formatDate(Date date) throws ParseException {
        if (date == null) {
            return null;
        }
        return sdf.format(date);
    }

    private String getDateAttribute() {
        if (this._type == 0) {
            return "@MetadataCreated";
        }
        return "@MetadataUpdated";
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("DateFilter.FilterName.txt");
    }

    @Override
    public String getFilterString() {
        if (this._type != 0 && this._type != 1) {
            return "";
        }
        String date1 = null;
        String date2 = null;
        try {
            date1 = this.formatDate(this.getBeginDate());
            date2 = this.formatDate(this.getEndDate());
        }
        catch (ParseException e) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean processedBeginDate = false;
        if (date1 != null) {
            processedBeginDate = true;
            sb.append(this.getDateAttribute());
            sb.append(" GT '").append(date1).append("'");
        }
        if (date2 != null) {
            if (processedBeginDate) {
                sb.append(" AND ");
            }
            sb.append(this.getDateAttribute());
            sb.append(" LT '").append(date2).append("'");
        }
        return sb.toString();
    }

    @Override
    public String getFilterDescription() {
        if (this._beginDate != null && this._endDate == null) {
            return Message.format((ResourceBundle)RB.getResources(), (String)(this._type == 0 ? "DateFilter.FilterDesc.Created1.fmt.txt" : "DateFilter.FilterDesc.Modified1.fmt.txt"), (Object)LoggingUtil.getFormattedDate(this._beginDate, false));
        }
        if (this._beginDate == null && this._endDate != null) {
            return Message.format((ResourceBundle)RB.getResources(), (String)(this._type == 0 ? "DateFilter.FilterDesc.Created2.fmt.txt" : "DateFilter.FilterDesc.Modified2.fmt.txt"), (Object)LoggingUtil.getFormattedDate(this._endDate, false));
        }
        if (this._beginDate != null && this._endDate != null) {
            return Message.format((ResourceBundle)RB.getResources(), (String)(this._type == 0 ? "DateFilter.FilterDesc.Created3.fmt.txt" : "DateFilter.FilterDesc.Modified3.fmt.txt"), (Object)LoggingUtil.getFormattedDate(this._beginDate, false), (Object)LoggingUtil.getFormattedDate(this._endDate, false));
        }
        return null;
    }

    public boolean equals(Object obj) {
        DateFilter filter;
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof DateFilter && this._type == (filter = (DateFilter)obj).getType()) {
            Date begin1 = this.getBeginDate();
            Date end1 = this.getEndDate();
            Date begin2 = filter.getBeginDate();
            Date end2 = filter.getEndDate();
            if ((begin1 == null && begin2 == null || begin1 != null && begin1.equals(begin2)) && (end1 == null && end2 == null || end1 != null && end1.equals(end2))) {
                return true;
            }
        }
        return false;
    }
}

