/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.promotion.BinaryStreamWrapper;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.RB;
import com.sas.services.TransportException;
import com.sas.services.publish.BinaryFileEntry;
import com.sas.services.publish.BinaryFileEntryInterface;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.ResultPackage;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TextFileEntry;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.services.publish.TransportFactory;
import com.sas.services.publish.archive.ArchiveTransportInterface;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.text.Message;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;

public class ContentHandler
implements ContentHandlerInterface {
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_PACKAGE_VERSION = "PackageVersion";
    private static final String ATTRIBUTE_VERSION_PRE_9300 = "version";
    protected static final String TEXT_PLAIN_MIMETYPE = "text/plain";
    protected static final String EXPORT_FILE = "MetadataExport.xml";
    protected static final String PACKAGE_EXTENSION = ".spk";
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int BUFFER_SIZE = 4096;
    private Log _log = Log.getInstance(ContentHandler.class.getName());
    private ResultPackageInterface _package;
    private File _packageFile;
    private byte[] _dataBuffer = new byte[4096];
    private Map<String, ResultPackageInterface> _nestedPackagesMap;
    private List<File> _temporaryFilesList = new ArrayList<File>();
    private String _tempDirLocation = null;

    protected ContentHandler() {
    }

    @Override
    public void addBinaryContent(String objectID, String key, InputStream stream) throws IOException, TransportException {
        File contentFile = this.createTempFile(stream);
        this.addContentToPackage(objectID, key, contentFile, 1);
    }

    @Override
    public void addTextContent(String objectID, String key, Reader reader) throws IOException, TransportException {
        File contentFile = this.createTempFile(reader);
        this.addContentToPackage(objectID, key, contentFile, 0);
    }

    @Override
    public Map<String, Reader> getTextContent(String objectID) throws IOException, TransportException {
        ResultPackageInterface nestedPackage = this.getNestedPackage(objectID);
        if (nestedPackage == null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ContentHandler.getObjectContent.Error.txt", (Object)objectID));
            }
            return Collections.emptyMap();
        }
        EntryInterface[] entryArray = nestedPackage.getEntries();
        int length = entryArray.length;
        HashMap<String, Reader> content = new HashMap<String, Reader>(length);
        for (int i = 0; i < length; ++i) {
            EntryInterface entry = entryArray[i];
            AttributeMap attrmap = (AttributeMap)entry.getNameValuePairs();
            String key = attrmap.getAttribute(ATTRIBUTE_KEY);
            if (key == null) continue;
            Reader reader = null;
            if (entry instanceof TextFileEntryInterface) {
                reader = this.getTextReader((TextFileEntryInterface)entry);
            }
            if (reader == null) continue;
            content.put(key, reader);
        }
        return content;
    }

    @Override
    public Map<String, InputStream> getBinaryContent(String objectID) throws IOException, TransportException {
        ResultPackageInterface nestedPackage = this.getNestedPackage(objectID);
        if (nestedPackage == null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ContentHandler.getObjectContent.Error.txt", (Object)objectID));
            }
            return Collections.emptyMap();
        }
        EntryInterface[] entryArray = nestedPackage.getEntries();
        int length = entryArray.length;
        HashMap<String, InputStream> content = new HashMap<String, InputStream>(length);
        for (int i = 0; i < length; ++i) {
            EntryInterface entry = entryArray[i];
            AttributeMap attrmap = (AttributeMap)entry.getNameValuePairs();
            String key = attrmap.getAttribute(ATTRIBUTE_KEY);
            if (key == null) continue;
            InputStream is = null;
            if (entry instanceof BinaryFileEntryInterface) {
                is = this.getBinaryStream((BinaryFileEntryInterface)entry);
            }
            if (is == null) continue;
            content.put(key, is);
        }
        return content;
    }

    @Override
    public void addFileToPackage(File file, int fileType) throws IOException {
        if (file == null) {
            return;
        }
        TextFileEntry entry = null;
        if (fileType == 0) {
            entry = new TextFileEntry(file);
            ((TextFileEntryInterface)entry).setMIMEType(TEXT_PLAIN_MIMETYPE);
        } else {
            entry = new BinaryFileEntry(file);
            ((BinaryFileEntryInterface)entry).setMIMEType(TEXT_PLAIN_MIMETYPE);
        }
        this._package.addEntry((EntryInterface)entry);
    }

    @Override
    public void addFileToPackage(String fileName, String fileContents) throws IOException {
        StringReader reader = new StringReader(fileContents);
        TextFileEntry entry = new TextFileEntry((Reader)reader, fileName);
        ((TextFileEntryInterface)entry).setMIMEType(TEXT_PLAIN_MIMETYPE);
        this._package.addEntry((EntryInterface)entry);
    }

    @Override
    public File getFileFromPackage(String fileName) throws IOException, TransportException {
        for (EntryInterface entry : this._package.getEntries()) {
            TextFileEntryInterface textEntry;
            if (entry instanceof BinaryFileEntryInterface) {
                BinaryFileEntryInterface binEntry = (BinaryFileEntryInterface)entry;
                if (!binEntry.getName().equalsIgnoreCase(fileName)) continue;
                return this.getBinaryFile(binEntry, this.getDestinationPath());
            }
            if (!(entry instanceof TextFileEntryInterface) || !(textEntry = (TextFileEntryInterface)entry).getName().equalsIgnoreCase(fileName)) continue;
            return this.getTextFile((EntryInterface)textEntry, this.getDestinationPath());
        }
        return null;
    }

    @Override
    public String getFileContentsFromPackage(String fileName) throws IOException, TransportException {
        for (EntryInterface entry : this._package.getEntries()) {
            TextFileEntryInterface textEntry;
            if (entry instanceof BinaryFileEntryInterface) {
                BinaryFileEntryInterface binEntry = (BinaryFileEntryInterface)entry;
                if (!binEntry.getName().equals(fileName)) continue;
                return this.readBinaryFile(binEntry);
            }
            if (!(entry instanceof TextFileEntryInterface) || !(textEntry = (TextFileEntryInterface)entry).getName().equals(fileName)) continue;
            return this.readTextFile(textEntry);
        }
        return null;
    }

    @Override
    public boolean containsFile(String fileName) throws IOException, TransportException {
        if (fileName == null) {
            return false;
        }
        for (EntryInterface entry : this._package.getEntries()) {
            TextFileEntryInterface textEntry;
            BinaryFileEntryInterface binEntry;
            if (!(entry instanceof BinaryFileEntryInterface ? fileName.equals((binEntry = (BinaryFileEntryInterface)entry).getName()) : entry instanceof TextFileEntryInterface && fileName.equals((textEntry = (TextFileEntryInterface)entry).getName()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPackageVersion() throws TransportException {
        String version;
        block6: {
            version = null;
            try {
                AttributeMap attrmap = (AttributeMap)this._package.getNameValuePairs();
                if (attrmap == null) {
                    throw new TransportException("Missing attribute information");
                }
                version = attrmap.getAttribute(ATTRIBUTE_PACKAGE_VERSION);
                if (version != null || (version = attrmap.getAttribute(ATTRIBUTE_VERSION_PRE_9300)) == null || Integer.parseInt(version) != 9300) break block6;
                try {
                    if (this.containsFile(EXPORT_FILE)) {
                        return 9200;
                    }
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, "Error retrieving package version");
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return version == null ? 0 : Integer.parseInt(version);
    }

    @Override
    public String readStream(InputStream stream, String encoding) throws IOException {
        String result = null;
        if (stream != null) {
            int currentLength;
            StringBuffer sb = new StringBuffer();
            InputStreamReader ir = new InputStreamReader(stream, encoding);
            BufferedReader br = new BufferedReader(ir);
            char[] buf = new char[1024];
            int cbuflen = buf.length;
            while ((currentLength = br.read(buf, 0, cbuflen)) != -1) {
                sb.append(buf, 0, currentLength);
            }
            result = sb.toString();
            br.close();
        }
        return result;
    }

    @Override
    public byte[] readStream(InputStream stream) throws IOException {
        int bytesRead = 0;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((bytesRead = stream.read(buffer)) > 0) {
            os.write(buffer, 0, bytesRead);
        }
        return os.toByteArray();
    }

    @Override
    public InputStream getInputStream(IBinaryStream inStream) {
        return new BinaryStreamWrapper(inStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToBinaryStream(InputStream inStream, IBinaryStream outStream) throws IOException, GenericError {
        byte[] bytes = new byte[4096];
        int iBytesRead = inStream.read(bytes);
        try {
            while (iBytesRead != -1) {
                if (iBytesRead < 4096) {
                    byte[] tempBytes = new byte[iBytesRead];
                    System.arraycopy(bytes, 0, tempBytes, 0, iBytesRead);
                    outStream.Write(tempBytes);
                } else {
                    outStream.Write(bytes);
                }
                iBytesRead = inStream.read(bytes);
            }
        }
        finally {
            inStream.close();
            outStream.Close();
        }
    }

    @Override
    public File createFile(String fileName) throws IOException {
        if (fileName != null && fileName.indexOf(FILE_SEPARATOR) < 0) {
            fileName = this.getDestinationPath() + fileName;
        }
        return new File(fileName);
    }

    @Override
    public File createFile(InputStream inStream, String fileName) throws IOException {
        if (fileName != null && fileName.indexOf(FILE_SEPARATOR) < 0) {
            fileName = this.getDestinationPath() + fileName;
        }
        File file = new File(fileName);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] bytes = new byte[4096];
        int read = 0;
        while ((read = inStream.read(bytes)) > 0) {
            fos.write(bytes, 0, read);
        }
        fos.close();
        return file;
    }

    @Override
    public File createFile(String contents, String fileName) throws IOException {
        if (fileName != null && fileName.indexOf(FILE_SEPARATOR) < 0) {
            fileName = this.getDestinationPath() + fileName;
        }
        File file = null;
        try (BufferedWriter bw = null;){
            file = new File(fileName);
            OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            bw = new BufferedWriter(ow);
            bw.write(contents);
            bw.flush();
        }
        return file;
    }

    @Override
    public void deleteFileOnPublish(File file) {
        if (!this._temporaryFilesList.contains(file)) {
            this._temporaryFilesList.add(file);
        }
    }

    protected String getDestinationPath() throws IOException {
        if (this._tempDirLocation == null) {
            this._tempDirLocation = this.createTempDirectory();
        }
        return this._tempDirLocation;
    }

    public void dispose() {
        File tmpDir;
        if (this._tempDirLocation != null && (tmpDir = new File(this._tempDirLocation)).exists()) {
            File[] files = tmpDir.listFiles();
            if (files != null && files.length > 0) {
                for (int index = 0; index < files.length; ++index) {
                    files[index].delete();
                }
            }
            tmpDir.delete();
        }
    }

    protected void closePackage() {
        if (this._package != null) {
            try {
                this._package.close();
            }
            catch (Exception e) {
                this._log.debug((Object)"Unable to close package file", e);
            }
        }
        this.deleteTemporaryFiles();
        if (this._nestedPackagesMap != null) {
            this._nestedPackagesMap.clear();
        }
    }

    @Override
    public void createNewPackage(File packageFile, int versionNumber) throws IOException {
        this._packageFile = packageFile;
        this._package = new ResultPackage();
        this._package.setDescription(RB.getStringResource("ContentHandler.createPkg.desc.txt"));
        this._package.setAbstract(RB.getStringResource("ContentHandler.createPkg.abstract.txt"));
        try {
            AttributeMap nv = new AttributeMap();
            nv.setAttribute(ATTRIBUTE_PACKAGE_VERSION, String.valueOf(versionNumber));
            this._package.setNameValuePairs((AttributeMapInterface)nv);
        }
        catch (Exception e) {
            this._log.debug((Object)"Unable to set the platform version for this package", e);
        }
    }

    protected void loadExistingPackage(File packageFile) throws TransportException {
        TransportFactory factory = new TransportFactory();
        ArchiveTransportInterface archive = factory.getArchiveTransport(packageFile, null);
        this._package = archive.getResultPackage();
        this._nestedPackagesMap = null;
    }

    public String getMetadataExportFileContents() throws IOException, TransportException {
        BinaryFileEntryInterface binEntry;
        EntryInterface metadataEntry = this._package.getEntry(0);
        if (metadataEntry != null && metadataEntry instanceof BinaryFileEntryInterface && (binEntry = (BinaryFileEntryInterface)metadataEntry).getName().equalsIgnoreCase(EXPORT_FILE)) {
            return this.readBinaryFile(binEntry);
        }
        return this.getFileContentsFromPackage(EXPORT_FILE);
    }

    protected void publishPackage() throws IOException, TransportException {
        TransportFactory factory = new TransportFactory();
        ArchiveTransportInterface archive = factory.getArchiveTransport(this._packageFile, null);
        try {
            archive.publishResultPackage(this._package, false);
        }
        finally {
            this.closePackage();
        }
    }

    protected void deleteTemporaryFiles() {
        if (this._temporaryFilesList != null && this._temporaryFilesList.size() > 0) {
            for (File tempFile : this._temporaryFilesList) {
                try {
                    tempFile.delete();
                }
                catch (Exception e) {
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug((Object)"Attempt to delete temporary file failed", e);
                }
            }
            this._temporaryFilesList.clear();
        }
    }

    private ResultPackageInterface createNestedPackage(String objectID) throws IOException {
        ResultPackageInterface nested;
        if (this._nestedPackagesMap == null) {
            this._nestedPackagesMap = new HashMap<String, ResultPackageInterface>();
        }
        if ((nested = this._nestedPackagesMap.get(objectID)) == null) {
            nested = new ResultPackage();
            nested.setName(objectID);
            this._package.addEntry((EntryInterface)nested);
            this._nestedPackagesMap.put(objectID, nested);
        }
        return nested;
    }

    private ResultPackageInterface getNestedPackage(String objectID) throws IOException, TransportException {
        if (this._nestedPackagesMap == null) {
            this._nestedPackagesMap = new HashMap<String, ResultPackageInterface>();
            EntryInterface[] entryArray = this._package.getEntries();
            int length = entryArray.length;
            for (int i = 0; i < length; ++i) {
                if (!(entryArray[i] instanceof ResultPackageInterface)) continue;
                ResultPackageInterface nested = (ResultPackageInterface)entryArray[i];
                String id = nested.getName();
                int index = id.indexOf(PACKAGE_EXTENSION);
                if (index > -1) {
                    id = id.substring(0, index);
                }
                this._nestedPackagesMap.put(id, nested);
            }
        }
        return this._nestedPackagesMap.get(objectID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(InputStream stream) throws IOException {
        File tmpFile = File.createTempFile("Export-", ".dat");
        this._temporaryFilesList.add(tmpFile);
        BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(tmpFile));
        try {
            int bytesRead = stream.read(this._dataBuffer);
            while (bytesRead > 0) {
                oStream.write(this._dataBuffer, 0, bytesRead);
                bytesRead = stream.read(this._dataBuffer);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(Reader reader) throws IOException {
        File tmpFile = File.createTempFile("Export-", ".dat");
        this._temporaryFilesList.add(tmpFile);
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));
        char[] buffer = new char[4096];
        try {
            int charsRead = reader.read(buffer);
            while (charsRead > 0) {
                writer.write(buffer, 0, charsRead);
                charsRead = reader.read(buffer);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tmpFile;
    }

    private void addContentToPackage(String objectID, String key, File contentFile, int fileType) throws IOException, TransportException {
        EntryInterface[] entries;
        ResultPackageInterface nestedPackage = this.createNestedPackage(objectID);
        if (key == null) {
            key = objectID;
        }
        if ((entries = nestedPackage.getEntries()).length > 0) {
            int length = entries.length;
            for (int i = 0; i < length; ++i) {
                AttributeMapInterface map = entries[i].getNameValuePairs();
                if (map == null || !key.equals(map.getAttribute(ATTRIBUTE_KEY))) continue;
                throw new IllegalArgumentException("Multiple entries found for \"" + objectID + "\" with the same key: " + key);
            }
        }
        TextFileEntry entry = null;
        if (fileType == 0) {
            entry = new TextFileEntry(contentFile);
            ((TextFileEntryInterface)entry).setMIMEType(TEXT_PLAIN_MIMETYPE);
        } else {
            entry = new BinaryFileEntry(contentFile);
            ((BinaryFileEntryInterface)entry).setMIMEType(TEXT_PLAIN_MIMETYPE);
        }
        AttributeMap nv = new AttributeMap();
        nv.setAttribute(ATTRIBUTE_KEY, key);
        entry.setNameValuePairs((AttributeMapInterface)nv);
        nestedPackage.addEntry((EntryInterface)entry);
    }

    private InputStream getBinaryStream(BinaryFileEntryInterface entry) throws IOException {
        return entry.getInputStream();
    }

    private Reader getTextReader(TextFileEntryInterface entry) throws IOException {
        return entry.getReader();
    }

    private File getBinaryFile(BinaryFileEntryInterface entry, String destinationPath) throws TransportException, IOException {
        int len;
        if (entry.getName() == null) {
            return null;
        }
        DataInputStream dis = new DataInputStream(entry.getInputStream());
        String fname = destinationPath == null ? entry.getName() : destinationPath + entry.getName();
        FileOutputStream fos = new FileOutputStream(fname);
        byte[] bb = new byte[4096];
        while ((len = dis.read(bb)) != -1) {
            fos.write(bb, 0, len);
        }
        dis.close();
        fos.close();
        return new File(fname);
    }

    private File getTextFile(EntryInterface entry, String destinationPath) throws TransportException, IOException {
        String fname;
        BufferedReader br = null;
        BufferedWriter bw = null;
        TextFileEntryInterface textEntry = (TextFileEntryInterface)entry;
        String string = fname = destinationPath == null ? textEntry.getName() : destinationPath + textEntry.getName();
        if (fname == null) {
            return null;
        }
        try {
            br = new BufferedReader(textEntry.getReader());
            bw = new BufferedWriter(new FileWriter(fname));
        }
        catch (UnsupportedEncodingException e) {
            String errorMsg = Message.format((ResourceBundle)RB.getResources(), (String)"ContentHandler.encoding.Error.txt", (Object)textEntry.getName());
            if (this._log.isErrorEnabled()) {
                this._log.error(errorMsg);
            }
            throw new TransportException((Throwable)e, errorMsg);
        }
        String line = null;
        int maxLength = 0;
        try {
            while ((line = br.readLine()) != null) {
                bw.write(line, 0, line.length());
                bw.write(13);
                bw.write(10);
                if (line.length() + 2 <= maxLength) continue;
                maxLength = line.length() + 2;
            }
            bw.flush();
        }
        catch (IOException e) {
            String errorMsg = Message.format((ResourceBundle)RB.getResources(), (String)"ContentHandler.fileReading.Error.txt", (Object)textEntry.getName());
            if (this._log.isErrorEnabled()) {
                this._log.error(errorMsg);
            }
            throw new TransportException((Throwable)e, errorMsg);
        }
        finally {
            if (br != null) {
                block22: {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        if (!this._log.isErrorEnabled()) break block22;
                        this._log.error(e.getLocalizedMessage());
                    }
                }
                br = null;
            }
            if (bw != null) {
                block23: {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        if (!this._log.isErrorEnabled()) break block23;
                        this._log.error(e.getLocalizedMessage());
                    }
                }
                bw = null;
            }
        }
        return new File(fname);
    }

    private String readBinaryFile(BinaryFileEntryInterface entry) throws IOException {
        InputStream is = entry.getInputStream();
        return this.readStream(is, "UTF-8");
    }

    private String readTextFile(TextFileEntryInterface entry) throws IOException {
        int numCharsRead;
        BufferedReader br = new BufferedReader(entry.getReader());
        char[] buffer = new char[4096];
        StringBuffer sb = new StringBuffer();
        while ((numCharsRead = br.read(buffer)) != -1) {
            sb.append(buffer, 0, numCharsRead);
        }
        return sb.toString();
    }

    protected String createTempDirectory() throws IOException {
        String path;
        String dirPath = System.getProperty("java.io.tmpdir");
        if (dirPath == null) {
            File f = File.createTempFile("tmp", ".tmp");
            dirPath = f.getParent();
            f.delete();
        }
        File tempDir = null;
        try {
            int max = Integer.MAX_VALUE;
            Random random = new Random();
            File parentDir = new File(dirPath);
            boolean created = false;
            while (!created || tempDir.exists()) {
                String dirName = "Promotion_" + random.nextInt(max);
                tempDir = new File(parentDir, dirName);
                created = true;
            }
            tempDir.mkdirs();
        }
        catch (Exception e) {
            this._log.debug("Could not create temporary directory");
        }
        String string = path = tempDir == null ? dirPath : tempDir.getAbsolutePath();
        if (path != null && !path.endsWith(FILE_SEPARATOR)) {
            path = path + FILE_SEPARATOR;
        }
        return path;
    }
}

