/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.ConnectionTypeInterface;
import java.util.Comparator;

class ConnectionTypeSorter
implements Comparator<ConnectionTypeInterface> {
    private static final String[] DEFAULT_ORDER = new String[]{"Application Server", "Other Server", "Scheduling Server", "OLAP Schema", "Library", "Table", "Cube", "External File", "Job", "Stored Process", "InformationMap", "Report"};

    ConnectionTypeSorter() {
    }

    @Override
    public int compare(ConnectionTypeInterface obj1, ConnectionTypeInterface obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        return this.runCompare(obj1, obj2);
    }

    private int runCompare(ConnectionTypeInterface type1, ConnectionTypeInterface type2) {
        int index1 = this.getDefaultOrderIndex(type1);
        int index2 = this.getDefaultOrderIndex(type2);
        if (index1 == -1 && index2 == -1) {
            return 0;
        }
        if (index1 == -1) {
            return 1;
        }
        if (index2 == -1) {
            return -1;
        }
        if (index1 < index2) {
            return -1;
        }
        if (index1 > index2) {
            return 1;
        }
        return 0;
    }

    private int getDefaultOrderIndex(ConnectionTypeInterface type) {
        int index = -1;
        String typeName = type.getConnectionTypeName();
        if (typeName != null) {
            int len = DEFAULT_ORDER.length;
            for (int i = 0; i < len; ++i) {
                if (!typeName.equalsIgnoreCase(DEFAULT_ORDER[i])) continue;
                index = i;
                break;
            }
        }
        return index;
    }
}

