/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.ConnectionComparatorInterface;
import com.sas.metadata.promotion.ConnectionCreationInterface;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionSearchInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ConnectionValidationException;
import com.sas.metadata.promotion.DependentConnectionInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.SearchCriteria;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SectionedPropertyList;
import com.sas.storage.editableproperties.SectionedPropertyMap;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

class ConnectionPropertiesHandler {
    private static final char SPACE = ' ';
    private static final String VALUES_KEY = "#VALUES#";
    protected static final String CONNECTIONS_SECTION = "Connections: ";
    protected static final String SOURCE_PATH = "SourcePath";
    protected static final String TARGET_PATH = "TargetPath";
    protected static final String SOURCE_NAME = "SourceName";
    protected static final String TARGET_NAME = "TargetName";
    protected static final String TARGET_DIRECTORY = "TargetDirectory";
    protected static final String SOURCE = "Source";
    protected static final String TARGET = "Target";
    protected static final String CREATE_IF_NEEDED = "CreateIfNeeded";
    private static final String FALSE = Boolean.toString(false);
    private static final String TRUE = Boolean.toString(true);
    private Log _log;
    private PromotionInterface _operation;
    private ConnectionManagerInterface _connectionManager;

    public ConnectionPropertiesHandler(PropertiesManager propManager) {
        this._operation = propManager.getPromotionOperation();
        this._log = propManager.getPromotionOperation().getLogger();
        this._connectionManager = propManager.getPromotionOperation().getConnectionManager();
    }

    public void writeConnectionsToPropertyList(SectionedPropertyList substitutionPropList) throws MetadataPromotionException {
        List<ConnectionTypeInterface> connectionTypes = this._operation.getConnectionTypes();
        for (ConnectionTypeInterface type : connectionTypes) {
            String formattedTypeName = this.getFormattedConnectionName(type);
            PropertyList propList = new PropertyList();
            int count = 1;
            try {
                if (type instanceof DependentConnectionTypeInterface) {
                    DependentConnectionTypeInterface childType = (DependentConnectionTypeInterface)type;
                    ConnectionTypeInterface parentType = childType.getDependentType();
                    String parentTypeName = parentType.getConnectionTypeName();
                    String parentFormattedName = this.getFormattedConnectionName(parentTypeName);
                    DependentConnectionMapping mapping = childType.getDependentConnectionMapping();
                    List connections = mapping.getDependentConnections();
                    for (DependentConnectionInterface dependentConnection : connections) {
                        SourceConnectionInterface parentConnection = dependentConnection.getDependentConnection();
                        String parentValue = parentConnection.getSourcePath();
                        if (parentValue == null) {
                            parentValue = parentConnection.getDisplayName();
                        }
                        List childConnections = dependentConnection.getChildConnections();
                        Iterator childIter = childConnections.iterator();
                        while (childIter.hasNext()) {
                            if (count > 1) {
                                propList.addBlankLine();
                            }
                            SourceConnectionInterface childConnection = (SourceConnectionInterface)childIter.next();
                            PropertyList nestedList = new PropertyList();
                            String parentKey = this.getParentPropertyKey(substitutionPropList, parentType, parentTypeName, parentValue);
                            nestedList.addProperty(parentFormattedName, parentKey);
                            this.addConnectionToPropertyList(childConnection, nestedList);
                            propList.addProperty(formattedTypeName, count++, nestedList);
                        }
                    }
                } else {
                    List<SourceConnectionInterface> sourceConnections = type.getSourceConnections();
                    if (sourceConnections != null) {
                        for (SourceConnectionInterface conn : sourceConnections) {
                            if (count > 1) {
                                propList.addBlankLine();
                            }
                            PropertyList nestedList = new PropertyList();
                            this.addConnectionToPropertyList(conn, nestedList);
                            propList.addProperty(formattedTypeName, count++, nestedList);
                        }
                    }
                }
                if (propList.isEmpty()) continue;
                String typeName = type.getConnectionTypeName();
                substitutionPropList.addSection(this.getSectionName(typeName), propList);
            }
            catch (Exception e) {
                this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.WriteError.fmt.txt", (Object)type.getLocalizedTypeName()));
                throw new MetadataPromotionException(e);
            }
        }
    }

    public void readConnectionsFromPropertyList(SectionedPropertyMap propertyMap) throws MetadataPromotionException {
        if (propertyMap == null) {
            throw new IllegalArgumentException(RB.getStringResource("ConnectionPropertiesHandler.NoConnections.txt"));
        }
        this._log.info(RB.getStringResource("ConnectionPropertiesHandler.MappingConnections.txt"));
        List<ConnectionTypeInterface> connectionTypes = this._operation.getConnectionTypes();
        for (ConnectionTypeInterface connectionType : connectionTypes) {
            String sectionName;
            PropertyMap props;
            String connectionTypeName = connectionType.getConnectionTypeName();
            boolean isDependentType = connectionType instanceof DependentConnectionTypeInterface;
            ArrayList<SourceConnectionInterface> connectionList = new ArrayList<SourceConnectionInterface>();
            List<SourceConnectionInterface> sourceConnections = connectionType.getSourceConnections();
            if (sourceConnections == null || sourceConnections.size() == 0) continue;
            connectionList.addAll(sourceConnections);
            if (this._log.isInfoEnabled()) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.Processing.fmt.txt", (Object)connectionType.getLocalizedTypeName()));
            }
            if ((props = propertyMap.getSection(sectionName = this.getSectionName(connectionTypeName))) != null) {
                HashMap targetValuesMap = null;
                String formattedName = this.getFormattedConnectionName(connectionTypeName);
                int[] indexes = props.getNestedPropertyIndexes(formattedName);
                if (indexes != null) {
                    int length = indexes.length;
                    for (int i = 0; i < length; ++i) {
                        PropertyMap nestedMap = props.getNestedProperties(formattedName, indexes[i]);
                        if (nestedMap.containsProperty(SOURCE_PATH)) {
                            String sourcePathValue = this.getPropertyValue(nestedMap, SOURCE_PATH);
                            SourceConnectionInterface sourceConnection = this.getSourceConnectionByPath(sourceConnections, sourcePathValue);
                            if (sourceConnection != null) {
                                connectionList.remove(sourceConnection);
                                String targetPathValue = this.getPropertyValue(nestedMap, TARGET_PATH);
                                this._connectionManager.mapConnectionByPath((ImportOperationInterface)this._operation, connectionType, sourceConnection, targetPathValue);
                                this.validateConnection(sourceConnection);
                                continue;
                            }
                            this.handleInvalidSourceProperty(sourcePathValue, connectionType);
                            continue;
                        }
                        String sourceAttr = this.getSourceAttribute(connectionType);
                        if (!nestedMap.containsProperty(sourceAttr)) continue;
                        if (targetValuesMap == null) {
                            targetValuesMap = new HashMap();
                        }
                        if (isDependentType) {
                            PropertyMap parentMap;
                            DependentConnectionTypeInterface type = (DependentConnectionTypeInterface)connectionType;
                            String parentName = type.getDependentType().getConnectionTypeName();
                            String parentValue = this.getPropertyValue(nestedMap, this.getFormattedConnectionName(parentName));
                            boolean parentFound = false;
                            if (parentValue != null && (parentMap = this.getNestedPropertyMap(propertyMap, parentName, parentValue)) != null) {
                                String childSourceValue;
                                SourceConnectionInterface sourceConnection;
                                parentFound = true;
                                boolean isPath = false;
                                String parentSourceAttr = this.getSourceAttribute(type.getDependentType());
                                String parentSourceValue = this.getPropertyValue(parentMap, parentSourceAttr);
                                if (parentSourceValue == null) {
                                    isPath = true;
                                    parentSourceValue = this.getPropertyValue(parentMap, SOURCE_PATH);
                                }
                                if ((sourceConnection = this.getSourceConnection(type, sourceConnections, childSourceValue = this.getPropertyValue(nestedMap, sourceAttr), parentSourceValue, isPath)) != null) {
                                    connectionList.remove(sourceConnection);
                                    this.mapConnection(connectionType, sourceConnection, nestedMap, targetValuesMap);
                                } else {
                                    this.handleInvalidSourceProperty(childSourceValue, connectionType);
                                }
                            }
                            if (parentFound) continue;
                            this.handleInvalidSourceProperty(this.getPropertyValue(nestedMap, sourceAttr), parentValue, connectionType);
                            continue;
                        }
                        String sourceValue = this.getPropertyValue(nestedMap, sourceAttr);
                        SourceConnectionInterface sourceConnection = this.getSourceConnection(sourceConnections, sourceValue);
                        if (sourceConnection != null) {
                            connectionList.remove(sourceConnection);
                            this.mapConnection(connectionType, sourceConnection, nestedMap, targetValuesMap);
                            continue;
                        }
                        this.handleInvalidSourceProperty(sourceValue, connectionType);
                    }
                }
            } else if (this._log.isDebugEnabled()) {
                this._log.debug("Missing section in properties file for type: " + connectionType.getLocalizedTypeName());
            }
            if (connectionList.size() <= 0) continue;
            this.processMissingConnections(connectionList, connectionType);
        }
    }

    private String getPropertyValue(PropertyMap propertyMap, String propName) {
        String value = propertyMap.getProperty(propName);
        return value == null ? null : value.trim();
    }

    private void mapConnection(ConnectionTypeInterface connectionType, SourceConnectionInterface sourceConnection, PropertyMap propMap, Map targetValuesMap) throws MetadataPromotionException {
        String targetAttr = this.getTargetAttribute(connectionType);
        String targetValue = this.getPropertyValue(propMap, targetAttr);
        if (targetValue == null || targetValue.length() == 0) {
            this._connectionManager.mapConnectionByTargetValue((ImportOperationInterface)this._operation, connectionType, sourceConnection, null);
        } else {
            String flag;
            TargetConnectionInterface target = this.findTargetConnection(sourceConnection, targetValue, targetValuesMap);
            if (target == null && propMap.containsProperty(CREATE_IF_NEEDED) && TRUE.equalsIgnoreCase(flag = this.getPropertyValue(propMap, CREATE_IF_NEEDED)) && connectionType instanceof ConnectionCreationInterface) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.CreateNew.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)targetValue);
                this._operation.getLogger().info(msg);
                target = ((ConnectionCreationInterface)((Object)connectionType)).createTargetConnection(sourceConnection, targetValue);
                if (target != null) {
                    this.cacheNewTargetConnection(sourceConnection, target, targetValuesMap);
                }
            }
            if (target == null) {
                this._connectionManager.mapConnectionTargetNotFound(connectionType, sourceConnection, targetValue);
            } else {
                this._connectionManager.mapConnectionByTargetValue((ImportOperationInterface)this._operation, connectionType, sourceConnection, target);
            }
        }
        this.validateConnection(sourceConnection);
    }

    private void processMissingConnections(List missingConnectionsList, ConnectionTypeInterface type) throws MetadataPromotionException {
        HashMap targetValuesMap = new HashMap(5);
        for (Object obj : missingConnectionsList) {
            if (!(obj instanceof SourceConnectionInterface)) continue;
            SourceConnectionInterface sourceConnection = (SourceConnectionInterface)obj;
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.MissingConnection.fmt.txt", (Object)type.getLocalizedTypeName(), (Object)sourceConnection.getDisplayName());
            this._log.warn(msg);
            String targetValue = sourceConnection.getDisplayName();
            TargetConnectionInterface targetConnection = this.findTargetConnection(sourceConnection, targetValue, targetValuesMap);
            if (targetConnection == null) {
                this._connectionManager.mapConnectionTargetNotFound(type, sourceConnection, targetValue);
            } else {
                this._connectionManager.mapConnectionByTargetValue((ImportOperationInterface)this._operation, type, sourceConnection, targetConnection);
            }
            this.validateConnection(sourceConnection);
        }
    }

    private void handleInvalidSourceProperty(String sourceValue, ConnectionTypeInterface connectionType) {
        if (this._log.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.InvalidSource.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)sourceValue);
            this._log.debug(msg);
        }
    }

    private void handleInvalidSourceProperty(String childValue, String parentValue, ConnectionTypeInterface connectionType) {
        if (this._log.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.MissingParent.fmt.txt", (Object)parentValue, (Object)connectionType.getLocalizedTypeName(), (Object)childValue);
            this._log.debug(msg);
        }
    }

    private TargetConnectionInterface findTargetConnection(SourceConnectionInterface connection, String value, Map targetValues) throws MetadataPromotionException {
        ConnectionTypeInterface type = connection.getConnectionType();
        if (type instanceof ConnectionSearchInterface) {
            ConnectionSearchInterface search = (ConnectionSearchInterface)((Object)type);
            SearchCriteria criteria = search.generateSearchCriteria(connection, value);
            return this._connectionManager.searchForTargetConnection((ImportOperationInterface)this._operation, criteria);
        }
        if (type instanceof DependentConnectionTypeInterface) {
            DependentConnectionTypeInterface dependentType = (DependentConnectionTypeInterface)type;
            DependentConnectionMapping mapping = dependentType.getDependentConnectionMapping();
            SourceConnectionInterface parentConnection = mapping.getDependentConnection(connection);
            List<TargetConnectionInterface> targetValuesList = this.getTargetValues(dependentType, targetValues, parentConnection);
            return this.findTargetConnection(connection, value, targetValuesList);
        }
        List<TargetConnectionInterface> targetValuesList = this.getTargetValues(type, targetValues);
        return this.findTargetConnection(connection, value, targetValuesList);
    }

    private TargetConnectionInterface findTargetConnection(SourceConnectionInterface source, String targetName, List<TargetConnectionInterface> targetValues) {
        if (targetValues == null) {
            return null;
        }
        for (TargetConnectionInterface target : targetValues) {
            if (!target.getDisplayName().equals(targetName)) continue;
            ConnectionTypeInterface type = source.getConnectionType();
            if (type instanceof ConnectionComparatorInterface) {
                if (!((ConnectionComparatorInterface)((Object)type)).compareConnection(source, target)) continue;
                return target;
            }
            return target;
        }
        return null;
    }

    private List<TargetConnectionInterface> getTargetValues(ConnectionTypeInterface connectionType, Map targetValuesMap) throws MetadataPromotionException {
        if (targetValuesMap.containsKey(VALUES_KEY)) {
            return (List)targetValuesMap.get(VALUES_KEY);
        }
        try {
            List<TargetConnectionInterface> values = connectionType.getTargetConnections();
            targetValuesMap.put(VALUES_KEY, values);
            return values;
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.TargetValueError.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)e.getLocalizedMessage());
            throw new MetadataPromotionException(e, msg);
        }
    }

    private List<TargetConnectionInterface> getTargetValues(DependentConnectionTypeInterface connectionType, Map targetValuesMap, SourceConnectionInterface parentConnection) throws MetadataPromotionException {
        if (targetValuesMap.containsKey(parentConnection)) {
            return (List)targetValuesMap.get(parentConnection);
        }
        try {
            List values = connectionType.getTargetValues(parentConnection);
            targetValuesMap.put(parentConnection, values);
            return values;
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.TargetValueError.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)e.getLocalizedMessage());
            throw new MetadataPromotionException(e, msg);
        }
    }

    private void cacheNewTargetConnection(SourceConnectionInterface connection, TargetConnectionInterface target, Map targetValuesMap) {
        if (targetValuesMap == null) {
            return;
        }
        ConnectionTypeInterface type = connection.getConnectionType();
        List targetConnections = null;
        if (type instanceof DependentConnectionTypeInterface) {
            DependentConnectionTypeInterface dependentType = (DependentConnectionTypeInterface)type;
            DependentConnectionMapping mapping = dependentType.getDependentConnectionMapping();
            SourceConnectionInterface parentConnection = mapping.getDependentConnection(connection);
            if (targetValuesMap.containsKey(parentConnection)) {
                targetConnections = (List)targetValuesMap.get(parentConnection);
            }
        } else if (targetValuesMap.containsKey(VALUES_KEY)) {
            targetConnections = (List)targetValuesMap.get(VALUES_KEY);
        }
        if (targetConnections != null && !targetConnections.contains(target)) {
            targetConnections.add(target);
        }
    }

    private void validateConnection(SourceConnectionInterface sourceConnection) throws MetadataPromotionException, ConnectionValidationException {
        ValidationResponse response = null;
        try {
            response = this._connectionManager.validateConnection((ImportOperationInterface)this._operation, sourceConnection);
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.ValidateFailure.fmt.txt", (Object)sourceConnection.getDisplayName());
            throw new MetadataPromotionException(e, msg);
        }
        switch (response.getReturnCode()) {
            case 0: {
                break;
            }
            case 1: {
                String warning = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.ValidationWarning.fmt.txt", (Object)response.getMessage());
                this._log.warn(warning);
                break;
            }
            case 2: {
                String error = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.ValidationError.fmt.txt", (Object)response.getMessage());
                throw new ConnectionValidationException(error);
            }
        }
    }

    private SourceConnectionInterface getSourceConnection(List connections, String sourceValue) {
        if (sourceValue == null) {
            return null;
        }
        int length = connections.size();
        for (int i = 0; i < length; ++i) {
            SourceConnectionInterface sourceConnection = (SourceConnectionInterface)connections.get(i);
            String displayName = sourceConnection.getDisplayName();
            if (!displayName.equals(sourceValue)) continue;
            return sourceConnection;
        }
        return null;
    }

    private SourceConnectionInterface getSourceConnection(DependentConnectionTypeInterface type, List connections, String childSourceValue, String parentSourceValue, boolean isPath) {
        if (childSourceValue == null || parentSourceValue == null) {
            return null;
        }
        DependentConnectionMapping mapping = type.getDependentConnectionMapping();
        int length = connections.size();
        for (int i = 0; i < length; ++i) {
            SourceConnectionInterface sourceConnection = (SourceConnectionInterface)connections.get(i);
            String displayName = sourceConnection.getDisplayName();
            if (!displayName.equals(childSourceValue)) continue;
            SourceConnectionInterface parentConnection = mapping.getDependentConnection(sourceConnection);
            if (isPath) {
                List<ConnectionPointInterface> connPoints = sourceConnection.getConnectionPoints();
                for (ConnectionPointInterface pt : connPoints) {
                    if (pt.getSourcePath() == null || !parentSourceValue.equals(pt.getSourcePath())) continue;
                    return sourceConnection;
                }
                continue;
            }
            String parentDisplayName = parentConnection.getDisplayName();
            if (!parentDisplayName.equals(parentSourceValue)) continue;
            return sourceConnection;
        }
        return null;
    }

    private SourceConnectionInterface getSourceConnectionByPath(List<SourceConnectionInterface> connections, String sourcePath) {
        if (sourcePath == null) {
            return null;
        }
        int length = connections.size();
        for (int i = 0; i < length; ++i) {
            SourceConnectionInterface sourceConnection = connections.get(i);
            List<ConnectionPointInterface> connPoints = sourceConnection.getConnectionPoints();
            for (ConnectionPointInterface pt : connPoints) {
                if (pt.getSourcePath() == null || !sourcePath.equals(pt.getSourcePath())) continue;
                return sourceConnection;
            }
        }
        return null;
    }

    private String getSectionName(String connectionTypeName) {
        return CONNECTIONS_SECTION + connectionTypeName;
    }

    private String getFormattedConnectionName(ConnectionTypeInterface type) {
        String typeName = type.getConnectionTypeName();
        return this.getFormattedConnectionName(typeName);
    }

    private String getFormattedConnectionName(String typeName) {
        return typeName != null && typeName.indexOf(32) > -1 ? Strings.removeWhitespace((String)typeName) : typeName;
    }

    private PropertyMap getNestedPropertyMap(SectionedPropertyMap sectionedMap, String connectionTypeName, String value) {
        String sectionName = this.getSectionName(connectionTypeName);
        PropertyMap propMap = sectionedMap.getSection(sectionName);
        if (propMap != null) {
            PropertyMap nestedMap = propMap.getNestedProperties(value);
            return nestedMap;
        }
        return null;
    }

    private String getParentPropertyKey(SectionedPropertyList sectionPropList, ConnectionTypeInterface type, String typeName, String sourceValue) {
        String sectionName = this.getSectionName(typeName);
        PropertyList propList = sectionPropList.getSection(sectionName);
        if (propList != null) {
            PropertyMap map = propList.getMap();
            String formattedName = this.getFormattedConnectionName(typeName);
            int[] indexes = map.getNestedPropertyIndexes(formattedName);
            for (int i = 0; i < indexes.length; ++i) {
                String attr;
                PropertyMap nestedMap = map.getNestedProperties(formattedName, indexes[i]);
                String value = this.getPropertyValue(nestedMap, attr = this.getSourceAttribute(type));
                if (value == null) {
                    value = this.getPropertyValue(nestedMap, SOURCE_PATH);
                }
                if (!sourceValue.equals(value)) continue;
                return PropertyMap.makeIndexedPropertyName((String)formattedName, (int)indexes[i]);
            }
        }
        return sourceValue;
    }

    private void addConnectionToPropertyList(SourceConnectionInterface connection, PropertyList propList) throws ServiceException, RemoteException {
        boolean displayPathValue = false;
        String path = connection.getSourcePath();
        if (path != null) {
            List<ConnectionPointInterface> list = connection.getConnectionPoints();
            if (list == null) {
                return;
            }
            for (ConnectionPointInterface pt : list) {
                String publicType = pt.getPublicType();
                if (SASFoldersUtil.isContainedByVirtualFolder((String)publicType, (ServerInterface)this._operation.getServer())) continue;
                if (PromotionUtil.isTypeContainedByFolder(publicType)) {
                    displayPathValue = true;
                    break;
                }
                PathUrl url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._operation.getServer(), (String)path);
                String type = url.getType();
                if (type == null || !PromotionUtil.isTypeContainedByFolder(type)) continue;
                displayPathValue = true;
                break;
            }
        }
        if (displayPathValue) {
            propList.addProperty(SOURCE_PATH, path);
            propList.addProperty(TARGET_PATH, path);
        } else {
            String sourceAttr = this.getSourceAttribute(connection.getConnectionType());
            String targetAttr = this.getTargetAttribute(connection.getConnectionType());
            propList.addProperty(sourceAttr, connection.getDisplayName());
            propList.addProperty(targetAttr, connection.getDisplayName());
        }
        ConnectionTypeInterface type = connection.getConnectionType();
        if (type instanceof ConnectionCreationInterface) {
            propList.addProperty(CREATE_IF_NEEDED, FALSE);
        }
    }

    private String getSourceAttribute(ConnectionTypeInterface type) {
        String attr = type.getTypeAttributeLabel();
        return attr == null ? SOURCE_NAME : SOURCE + attr;
    }

    private String getTargetAttribute(ConnectionTypeInterface type) {
        String attr = type.getTypeAttributeLabel();
        return attr == null ? TARGET_NAME : TARGET + attr;
    }

    public Map<String, PropertyList> getConnectionSections(SectionedPropertyList sectionList) {
        LinkedHashMap<String, PropertyList> sectionMap = new LinkedHashMap<String, PropertyList>();
        Collection sections = sectionList.getSections();
        for (String sectionName : sections) {
            if (sectionName.indexOf(CONNECTIONS_SECTION) != 0) continue;
            String connectionTypeName = sectionName.substring(CONNECTIONS_SECTION.length());
            String formattedName = this.getFormattedConnectionName(connectionTypeName);
            PropertyList propList = sectionList.getSection(formattedName);
            sectionMap.put(formattedName, propList);
        }
        return sectionMap;
    }

    class ConnectionWrapper {
        private SourceConnectionInterface _connection;
        private String _searchString;

        public ConnectionWrapper(SourceConnectionInterface connection, String search) {
            this._connection = connection;
            this._searchString = search;
        }

        public SourceConnectionInterface getConnection() {
            return this._connection;
        }

        public String getSearchString() {
            return this._searchString;
        }
    }
}

