/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import java.util.ArrayList;

public class ConnectionPointUtil {
    public static ConnectionPointInterface createExportConnectionPoint(ExportOperationInterface operation, ExportItemInterface exportItem, PathUrl pathUrl) throws MetadataPromotionException {
        ConnectionPointInterface pt = null;
        ConnectionManagerInterface manager = operation.getConnectionManager();
        String path = pathUrl.getAbsolutePath();
        String type = pathUrl.getType();
        if (path != null && type != null) {
            pt = manager.getConnectionByPath(ConnectionObjectType.PublicType, type, path);
        }
        if (pt == null) {
            try {
                ServerInterface server = operation.getServer();
                MetadataInterface mi = server.getObjectByPath(pathUrl);
                if (mi != null) {
                    String metadataType = mi.getTypeDescriptor().getMetadataType();
                    pt = manager.createConnection(metadataType, mi.getReposId(), mi.getName());
                    pt.setDescription(mi.getDescription());
                    pt.setPublicType(mi.getTypeDescriptor().getTypeName());
                    pt.setSourcePath(pathUrl.getAbsolutePath());
                } else {
                    String metadataType = PromotionUtil.getMetadataTypeForPublicType(type);
                    if (metadataType != null) {
                        pt = manager.createUnknownConnection(metadataType, pathUrl.getName());
                    }
                }
            }
            catch (Exception e) {
                throw new MetadataPromotionException(e);
            }
        }
        if (pt != null) {
            pt.addAssociatedObject(exportItem);
        }
        return pt;
    }

    static ConnectionPointInterface createExportConnectionPoint(ExportOperationInterface operation, ExportItemInterface exportItem, String objectID, String metadataType) throws MetadataPromotionException {
        ConnectionManagerInterface manager = operation.getConnectionManager();
        ConnectionPointInterface pt = manager.getConnection(objectID);
        if (pt == null) {
            try {
                MdObjectStore store = operation.getStore();
                MdOMIUtil omiUtil = operation.getMetadataFactory().getOMIUtil();
                CMetadata meta = store.getObject(objectID);
                if (meta == null) {
                    ArrayList<String> assocList = new ArrayList<String>(1);
                    assocList.add("Trees");
                    meta = omiUtil.getMetadataAllDepths((MdStore)store, metadataType, objectID, null, assocList, "", 8);
                }
                if (meta != null) {
                    pt = manager.createConnection(metadataType, objectID, meta.getName());
                    pt.setDescription(meta.getDesc());
                    if (meta instanceof PrimaryType) {
                        PrimaryType publicObject = (PrimaryType)meta;
                        String publicType = publicObject.getPublicType();
                        pt.setPublicType(publicType);
                        if (publicObject.getTrees().size() > 0) {
                            String path = omiUtil.getObjectPath(store, publicObject, true);
                            pt.setSourcePath(path);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new MetadataPromotionException(e);
            }
        }
        if (pt != null) {
            pt.addAssociatedObject(exportItem);
        }
        return pt;
    }

    public static ConnectionPointInterface createImportConnectionPoint(ImportOperationInterface operation, ImportItemInterface importItem, PathUrl pathUrl) throws MetadataPromotionException {
        if (pathUrl == null) {
            return null;
        }
        ConnectionPointInterface pt = null;
        ConnectionManagerInterface manager = operation.getConnectionManager();
        ImportItemInterface connectionItem = (ImportItemInterface)operation.getPromotionItem(pathUrl, true);
        String path = pathUrl.getAbsolutePath();
        String type = pathUrl.getType();
        if (path != null && type != null) {
            pt = manager.getConnectionByPath(ConnectionObjectType.PublicType, type, path);
        }
        if (pt == null) {
            try {
                if (connectionItem != null) {
                    String metadataType = connectionItem.getTypeInterface().getMetadataType();
                    String sourceID = connectionItem.getID();
                    String name = connectionItem.getOriginalName();
                    pt = manager.createConnection(metadataType, sourceID, name);
                } else {
                    String metadataType = PromotionUtil.getMetadataTypeForPublicType(type);
                    if (metadataType != null) {
                        pt = manager.createUnknownConnection(metadataType, pathUrl.getName());
                    }
                }
                if (pt != null) {
                    if (type != null) {
                        pt.setPublicType(type);
                    }
                    if (path != null) {
                        pt.setSourcePath(path);
                    }
                }
            }
            catch (Exception e) {
                throw new MetadataPromotionException(e);
            }
        }
        if (pt != null) {
            ConnectionPointUtil.activateConnection(connectionItem, pt);
            pt.addAssociatedObject(importItem);
        }
        return pt;
    }

    private static void activateConnection(ImportItemInterface connectionItem, ConnectionPointInterface pt) {
        if (connectionItem == null) {
            if (!pt.isActive() && pt instanceof ConnectionPoint) {
                ((ConnectionPoint)pt).setActive(true);
            }
        } else if (connectionItem.getImportState() != 0 && pt.isActive() && pt instanceof ConnectionPoint) {
            ((ConnectionPoint)pt).setActive(false);
        }
    }

    static ConnectionPointInterface createImportConnectionPoint(ImportOperationInterface operation, ImportItemInterface importItem, String objectID, String objectName, String metadataType, String publicType, String objectPath) {
        ConnectionPointInterface pt = null;
        ConnectionManagerInterface manager = operation.getConnectionManager();
        if (objectID != null) {
            pt = manager.getConnection(objectID);
            if (pt == null) {
                pt = manager.createConnection(metadataType, objectID, objectName);
                if (publicType != null) {
                    pt.setPublicType(publicType);
                }
                if (objectPath != null) {
                    pt.setSourcePath(objectPath);
                }
            }
        } else {
            if (objectPath != null && publicType != null) {
                pt = manager.getConnectionByPath(ConnectionObjectType.PublicType, publicType, objectPath);
            }
            if (pt == null) {
                pt = manager.createUnknownConnection(metadataType, objectName);
                if (publicType != null) {
                    pt.setPublicType(publicType);
                }
                if (objectPath != null) {
                    pt.setSourcePath(objectPath);
                }
            }
        }
        if (pt != null) {
            ConnectionPointUtil.activateConnection(operation, pt);
            pt.addAssociatedObject(importItem);
        }
        return pt;
    }

    private static void activateConnection(ImportOperationInterface operation, ConnectionPointInterface pt) {
        ImportItemInterface item = null;
        if (pt.getSourceID() != null) {
            item = operation.getImportItem(pt.getSourceID());
        } else if (pt.getSourcePath() != null) {
            // empty if block
        }
        if (item == null) {
            if (!pt.isActive()) {
                ((ConnectionPoint)pt).setActive(true);
            }
        } else if (item.getImportState() != 0 && pt.isActive()) {
            ((ConnectionPoint)pt).setActive(false);
        }
    }
}

