/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.DefaultPromotionItem;
import com.sas.metadata.promotion.PromotionItemInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SASScope
public class ConnectionPoint
implements ConnectionPointInterface {
    private String _metadataType;
    private String _name;
    private String _publicType;
    private String _description;
    private String _sourceID;
    private String _targetID;
    private String _sourcePath;
    private String _targetPath;
    private List<String> _sourceSearchList;
    private List<String> _targetSearchList;
    private Map<String, String> _propertyMap;
    private Set<PromotionItemInterface> _associatedObjects;
    private boolean _active = true;
    private boolean _automapped = false;
    private boolean _direct = true;
    private boolean _internalConnection = false;
    private boolean _unknown = false;
    private boolean _conflict = false;
    private int _action = 0;

    protected ConnectionPoint(String name, String type, String id) {
        this._name = name;
        this._metadataType = type;
        this._sourceID = id;
        this._associatedObjects = new LinkedHashSet<PromotionItemInterface>();
        this._sourceSearchList = new ArrayList<String>(1);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getMetadataType() {
        return this._metadataType;
    }

    @Override
    public String getPublicType() {
        return this._publicType;
    }

    @Override
    public String getSourceID() {
        return this._sourceID;
    }

    @Override
    public String getTargetID() {
        return this._targetID;
    }

    @Override
    public String getSourcePath() {
        return this._sourcePath;
    }

    @Override
    public String getTargetPath() {
        return this._targetPath;
    }

    @Override
    public List<String> getSourceSearchList() {
        return this._sourceSearchList;
    }

    @Override
    public List<String> getTargetSearchList() {
        if (this._targetSearchList == null) {
            return Collections.emptyList();
        }
        return this._targetSearchList;
    }

    @Override
    public String getSourceSearchString() {
        if (this._sourceSearchList == null || this._sourceSearchList.size() == 0) {
            return null;
        }
        return this._sourceSearchList.get(0);
    }

    @Override
    public String getTargetSearchString() {
        if (this._targetSearchList == null || this._targetSearchList.size() == 0) {
            return null;
        }
        return this._targetSearchList.get(0);
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setPublicType(String type) {
        this._publicType = type;
    }

    @Override
    public void setTargetID(String targetID) {
        this._targetID = targetID;
    }

    @Override
    public void setSourcePath(String path) {
        this._sourcePath = path;
    }

    @Override
    public void setTargetPath(String path) {
        this._targetPath = path;
    }

    @Override
    public void addSourceSearch(String search) {
        this._sourceSearchList.add(search);
    }

    @Override
    public void addTargetSearch(String search) {
        if (this._targetSearchList == null) {
            this._targetSearchList = new ArrayList<String>(1);
        }
        this._targetSearchList.add(search);
    }

    @Override
    public void setDescription(String desc) {
        this._description = desc;
    }

    protected void removeAssociatedObject(PromotionItemInterface item) {
        if (this._associatedObjects.contains(item)) {
            this._associatedObjects.remove(item);
            if (item instanceof DefaultPromotionItem) {
                ((DefaultPromotionItem)item).removeConnectionPoint(this);
            }
        }
    }

    @Override
    public void addAssociatedObject(PromotionItemInterface item) {
        if (!this._associatedObjects.contains(item)) {
            this._associatedObjects.add(item);
            if (item instanceof DefaultPromotionItem) {
                ((DefaultPromotionItem)item).addConnectionPoint(this);
            }
        }
    }

    @Override
    public void addAssociatedObjects(List<? extends PromotionItemInterface> targetList) {
        for (PromotionItemInterface promotionItemInterface : targetList) {
            this.addAssociatedObject(promotionItemInterface);
        }
    }

    @Override
    public List<PromotionItemInterface> getAssociatedObjects() {
        return new ArrayList<PromotionItemInterface>(this._associatedObjects);
    }

    @Override
    public boolean isConnectionForImportType(String publicType) {
        if (publicType == null) {
            return false;
        }
        if (this._active && this._associatedObjects != null) {
            for (PromotionItemInterface item : this._associatedObjects) {
                if (!publicType.equalsIgnoreCase(item.getTypeInterface().getPublicType())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getConnectionAction() {
        return this._action;
    }

    public void setConnectionAction(int action) {
        this._action = action;
    }

    @Override
    public boolean isActive() {
        return this._active;
    }

    @Override
    public void setActive(boolean active) {
        this._active = active;
    }

    @Override
    public boolean isAutoMapped() {
        return this._automapped;
    }

    public void setAutoMapped(boolean automapped) {
        this._automapped = automapped;
    }

    @Override
    public boolean isDirectConnection() {
        return this._direct;
    }

    public void setDirectConnection(boolean direct) {
        this._direct = direct;
    }

    @Override
    public boolean isUnknown() {
        return this._unknown;
    }

    protected void setUnknownConnection(boolean unknown) {
        this._unknown = unknown;
    }

    @Override
    public String getUserDefinedProperty() {
        return this.getUserDefinedProperty("temp key");
    }

    @Override
    public void setUserDefinedProperty(String property) {
        this.addUserDefinedProperty("temp key", property);
    }

    @Override
    public void addUserDefinedProperty(String propertyKey, String propertyValue) {
        if (this._propertyMap == null) {
            this._propertyMap = new LinkedHashMap<String, String>(5);
        }
        this._propertyMap.put(propertyKey, propertyValue);
    }

    @Override
    public String getUserDefinedProperty(String propertyKey) {
        if (this._propertyMap == null) {
            return null;
        }
        return this._propertyMap.get(propertyKey);
    }

    @Override
    public void removeUserDefinedProperty(String propertyKey) {
        if (this._propertyMap != null) {
            this._propertyMap.remove(propertyKey);
        }
    }

    @Override
    public Map<String, String> getUserDefinedProperties() {
        return this._propertyMap;
    }

    public void setInternalConnection(boolean internal) {
        this._internalConnection = internal;
    }

    public void setConflict(boolean conflict) {
        this._conflict = conflict;
    }

    public boolean hasConflict() {
        return this._conflict;
    }

    @Override
    public boolean isInternalConnection() {
        return this._internalConnection;
    }

    public String toString() {
        if (this._publicType != null) {
            return this._publicType + ": " + this._name + " (" + this._sourceID + ")";
        }
        return this._metadataType + ": " + this._name + " (" + this._sourceID + ")";
    }
}

