/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import java.io.IOException;
import java.io.InputStream;

@SASScope
class BinaryStreamWrapper
extends InputStream {
    public static final int BLOCK_SIZE = 4096;
    private byte[] buffer = null;
    private int boffset = 0;
    private int blen = 0;
    private boolean eof = false;
    private IBinaryStream _inStream;

    public BinaryStreamWrapper(IBinaryStream inStream) {
        this._inStream = inStream;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.read(null, 0, (int)n);
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) > 0) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        int i = 0;
        for (i = 0; i < len; ++i) {
            if (this.boffset >= this.blen) {
                this.getMore();
                if (this.blen <= 0) {
                    this.eof = true;
                    if (i == 0) {
                        i = -1;
                    }
                    return i;
                }
            }
            if (b != null) {
                b[i + off] = this.buffer[this.boffset];
            }
            ++this.boffset;
        }
        return i;
    }

    @Override
    public int available() throws IOException {
        if (this.buffer == null) {
            this.getMore();
        }
        return this.blen - this.boffset;
    }

    @Override
    public void close() throws IOException {
        try {
            this._inStream.Close();
        }
        catch (GenericError e) {
            throw new IOException(e.getMessage());
        }
    }

    private void getMore() throws IOException {
        OctetSeqHolder binIn = new OctetSeqHolder();
        if (this.eof) {
            this.blen = 0;
            this.boffset = 0;
            return;
        }
        try {
            this._inStream.Read(4096, binIn);
        }
        catch (GenericError e) {
            throw new IOException(e.getMessage());
        }
        this.buffer = binIn.value;
        this.blen = this.buffer.length;
        this.boffset = 0;
    }
}

