/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.batch.ConfigPropertiesInstaller2;
import com.sas.metadata.promotion.AbstractPromotionDriver;
import com.sas.metadata.promotion.BatchImporterOptions;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.LoggingUtil;
import com.sas.metadata.promotion.NoObjectsToImportException;
import com.sas.metadata.promotion.PromotionConfiguration;
import com.sas.metadata.promotion.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class BatchImporter
extends AbstractPromotionDriver {
    private ImportSummaryInterface _summary;
    private ImportHandler _importOperation;
    private Map<String, String> _importedObjectsMap;
    private int _importMode = 1;
    private PublicObjectContainerInterface _targetContainer = null;
    private boolean _includeSecurity = false;
    private boolean _preservePaths = false;
    private int _importType = 0;
    private String _targetFolder = null;
    private PathUrl _targetFolderPath = null;
    private boolean _localize = false;
    private boolean _localizeForAllLocales = false;
    private boolean _applySubstitutions = false;
    private String _substitutionPropertiesFileName = null;
    private String _localizablePropertiesDirName = null;
    private String _productID = null;
    private String _productKey = null;

    public BatchImporter() {
        this.setLogFilePrefix("Import");
    }

    public BatchImporter(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public BatchImporter(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    public void setExternalSubstitutionPropertiesFile(String file) {
        this.setApplySubstitutions(true, file);
    }

    public void setApplySubstitutions(boolean apply) {
        this.setApplySubstitutions(apply, null);
    }

    public void setApplySubstitutions(boolean apply, String fileName) {
        if (apply) {
            this._applySubstitutions = true;
            this._substitutionPropertiesFileName = fileName;
        } else {
            this._applySubstitutions = false;
            this._substitutionPropertiesFileName = null;
        }
    }

    public void setImportType(int type) {
        this._importType = type;
    }

    public void setIncludeSecurity(boolean importSecurity) {
        this._includeSecurity = importSecurity;
    }

    public void setPreservePaths(boolean preservePaths) {
        this._preservePaths = preservePaths;
    }

    public void setLocalize(boolean localize) {
        this.setLocalize(localize, null);
    }

    public void setLocalize(boolean localize, String directory) {
        if (localize) {
            this._localize = true;
            this._localizablePropertiesDirName = directory;
        } else {
            this._localize = false;
            this._localizablePropertiesDirName = null;
        }
    }

    public void setLocalizeForAllLocales(boolean localize) {
        if (localize) {
            this._localize = true;
        }
        this._localizeForAllLocales = this._localize;
    }

    public void setTargetFolder(String targetFolder) {
        this._targetFolder = targetFolder;
        this._targetFolderPath = null;
    }

    public void setTargetFolder(PathUrl targetFolder) {
        this._targetFolder = null;
        this._targetFolderPath = targetFolder;
    }

    protected void setTargetFolder(FolderInterface targetFolder) throws ServiceException, RemoteException {
        if (this._server != null) {
            String key = targetFolder.getID() + "/" + targetFolder.getTypeInterface().getMetadataType();
            com.sas.services.information.metadata.FolderInterface folder = (com.sas.services.information.metadata.FolderInterface)this._server.fetch(key, true);
            this.setTargetContainer((PublicObjectContainerInterface)folder);
        }
    }

    protected void setTargetContainer(PublicObjectContainerInterface targetContainer) {
        this._targetContainer = targetContainer;
    }

    protected void setImportMode(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Invalid import mode");
        }
        this._importMode = mode;
    }

    public void setConfigurationProductID(String prodID) {
        this._productID = prodID;
    }

    public void setConfigurationProductKey(String prodKey) {
        this._productKey = prodKey;
    }

    public int getNumberOfObjectsImported() {
        return this._importedObjectsMap == null ? 0 : this._importedObjectsMap.size();
    }

    public Map<String, String> getObjectsImported() {
        return this._importedObjectsMap;
    }

    public ImportSummaryInterface getImportSummary() {
        return this._summary;
    }

    @Override
    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new BatchImporterOptions();
        if (args == null || args.length == 0) {
            this._help = true;
            return;
        }
        super.parse(args);
        if (this._help) {
            return;
        }
        if (this._commandLine.hasOption("newOnly")) {
            this._importType = 1;
        }
        this._includeSecurity = this._commandLine.hasOption("includeACL");
        this._preservePaths = this._commandLine.hasOption("preservePaths");
        if (this._commandLine.hasOption("localize")) {
            this._localize = true;
            this._localizablePropertiesDirName = this._commandLine.getOptionValue("localize");
        } else if (this._commandLine.hasOption("locprop")) {
            this._localize = true;
            this._localizablePropertiesDirName = this._commandLine.getOptionValue("locprop");
        }
        if (this._commandLine.hasOption("multiLocale")) {
            this._localize = true;
            this._localizeForAllLocales = true;
        }
        if (this._commandLine.hasOption("subprop")) {
            this._applySubstitutions = true;
            this._substitutionPropertiesFileName = this._commandLine.getOptionValue("subprop");
        }
        this._targetFolder = this._commandLine.getOptionValue("target");
        if (this._commandLine.hasOption("configProductID")) {
            this._productID = this._commandLine.getOptionValue("configProductID");
        }
        if (this._commandLine.hasOption("configProductKey")) {
            this._productKey = this._commandLine.getOptionValue("configProductKey");
        }
    }

    public int importPackage(String packageFileName, String targetFolder) throws Exception {
        this.setPackageFileName(packageFileName);
        this.setTargetFolder(targetFolder);
        return this.importPackage();
    }

    public int importPackage(String packageFileName, PathUrl targetFolder) throws Exception {
        this.setPackageFileName(packageFileName);
        this.setTargetFolder(targetFolder);
        return this.importPackage();
    }

    public int importPackage() throws Exception {
        try {
            int autoMapState;
            this.initialize();
            this._importedObjectsMap = null;
            this.validateSetup();
            List<String> supportedTypes = this.configureFilteredPublicTypes();
            if (this._targetContainer != null) {
                this._importOperation = new ImportHandler(this._targetContainer, supportedTypes, this._importMode);
            } else {
                if (this._targetFolderPath == null && this._targetFolder != null) {
                    this._targetFolderPath = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)this._targetFolder);
                }
                if (this._targetFolderPath == null) {
                    throw new IllegalArgumentException(RB.getStringResource("BatchImporter.MissingPath.txt"));
                }
                if (this._targetFolderPath.getType() == null) {
                    this._targetFolderPath.setType("Folder");
                }
                if (this._targetFolderPath.getPath() == null && String.valueOf('/').equals(this._targetFolderPath.getName())) {
                    RootFolderInterface rootFolder = this._server.getRootFolder();
                    this._importOperation = new ImportHandler((PublicObjectContainerInterface)rootFolder, supportedTypes, this._importMode);
                } else {
                    MetadataInterface mi = this._server.getObjectByPath(this._targetFolderPath);
                    if (mi == null) {
                        throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"BatchImporter.FolderNotFound.fmt.txt", (Object)this._targetFolderPath.getDisplayPath()));
                    }
                    if (!(mi instanceof com.sas.services.information.metadata.FolderInterface)) {
                        throw new ServiceException(RB.getStringResource("BatchImporter.NotAFolder.txt"));
                    }
                    this._importOperation = new ImportHandler((PublicObjectContainerInterface)((com.sas.services.information.metadata.FolderInterface)mi), supportedTypes, this._importMode);
                }
            }
            this._summary = this._importOperation.getImportSummary();
            PromotionConfiguration config = this._importOperation.getPromotionConfiguration();
            config.setBatchProcess(true);
            config.setInstallProcess(this._install);
            this._importOperation.setSessionContext(this._session, !this._privateServicesDeployment);
            this._logFileName = this._importOperation.getLogger().getLogFileName();
            LoggingUtil.logServerInformation(this._user, this._importOperation.getLogger(), false);
            this._importOperation.setImportType(this._importType);
            this._importOperation.importSecurityMetadata(this._includeSecurity);
            this._importOperation.setPreservePaths(this._preservePaths);
            if (this._localize) {
                this._importOperation.getPropertiesManager().setProcessLocalizableProperties(true, true);
                if (this._localizablePropertiesDirName != null) {
                    this._importOperation.getPropertiesManager().setUserDefinedLocalizablePropertiesDirectory(this._localizablePropertiesDirName);
                }
                if (this._localizeForAllLocales) {
                    this._importOperation.getPropertiesManager().setUseMultiLocaleProperties(true);
                }
            }
            if (this._applySubstitutions) {
                this._importOperation.getPropertiesManager().setProcessSubstitutionProperties(true, true);
                if (this._substitutionPropertiesFileName != null) {
                    this._importOperation.getPropertiesManager().setUserDefinedSubstitutionFile(this._substitutionPropertiesFileName);
                }
            } else if (this._importMode == 1) {
                this._importOperation.getPropertiesManager().setProcessSubstitutionProperties(true, false);
            } else {
                this._importOperation.getPropertiesManager().setProcessSubstitutionProperties(false, false);
            }
            this._rc |= this._importOperation.loadExportPackage(this._packageFile);
            this._importOperation.loadObjectsToImport(this._importMode == 1);
            if (this._noExecute) {
                if (!this._expandSummary) {
                    String str = LoggingUtil.displayImportedObjects(this._importOperation.getImportItems(), this._importOperation.getServer(), true);
                    this._importOperation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.ImportingObjects.Log.txt", (Object)str));
                    this._importOperation.getLogger().info(RB.getStringResource("BatchImporter.NoExecuteMode.txt"));
                    int n = this._rc;
                    return n;
                }
                this._importOperation.getLogger().debug("expandSummary option has been specified");
                this._importOperation.setDryRun(true);
            }
            this._rc |= this._importOperation.fireAnalyzeObjects();
            switch (this._importMode) {
                case 1: {
                    autoMapState = 3;
                    break;
                }
                case 2: {
                    autoMapState = 1;
                    break;
                }
                default: {
                    autoMapState = 2;
                }
            }
            this._rc |= this._importOperation.runImport(autoMapState);
            if (this._noExecute && this._expandSummary) {
                this._importOperation.getLogger().info(RB.getStringResource("BatchImporter.NoExecuteMode.txt"));
                int n = this._rc;
                return n;
            }
            if (this._productID != null) {
                this._rc |= this.setConfigurationProperties();
            }
        }
        catch (NoObjectsToImportException e) {
            if (this._importType == 1) {
                this._importOperation.getLogger().info(e.getMessage());
            } else {
                this._importOperation.getLogger().warn(e.getMessage());
                this._rc |= 4;
            }
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchImporter.ImportFailed.fmt.txt", (Object)e.getLocalizedMessage());
            this._rc |= 8;
            if (this._importOperation != null) {
                this._importOperation.getLogger().error(msg);
                this._importOperation.getLogger().debug((Object)"Batch Import Process Failed", e);
            }
            throw e;
        }
        finally {
            if (this._importOperation != null) {
                this._importedObjectsMap = this._importOperation.getTargetObjectIDs();
                Log log = this._importOperation.getLogger();
                if (log != null && log.isInfoEnabled()) {
                    if ((this._rc & 8) > 0) {
                        log.info(RB.getStringResource("BatchImporter.FinishedError.Log.txt"));
                    } else if ((this._rc & 4) > 0) {
                        log.info(RB.getStringResource("BatchImporter.FinishedWarning.Log.txt"));
                    } else {
                        log.info(RB.getStringResource("BatchImporter.FinishedSuccess.Log.txt"));
                    }
                }
                this._importOperation.dispose();
            }
            this.terminate();
        }
        return this._rc;
    }

    private int setConfigurationProperties() throws Exception {
        int rc = 0;
        if (this._summary.getTotalImportedItemsCount() > 0) {
            ArrayList<String> objectPaths = new ArrayList<String>();
            List<PublicObjectInterface> importedObjects = this._summary.getImportedObjects();
            for (PublicObjectInterface item : importedObjects) {
                PathUrl path;
                String type = item.getTypeDescriptor().getTypeName();
                if ("Folder".equalsIgnoreCase(type) && this._summary.wasObjectUpdated(item) || (path = item.getPathUrl()) == null) continue;
                objectPaths.add(path.getAbsolutePath());
            }
            if (objectPaths.size() > 0) {
                ConfigPropertiesInstaller2 props = new ConfigPropertiesInstaller2(this._productID, this._factory, this._logger);
                rc |= props.addProperties(objectPaths, this._productKey);
            }
        }
        return rc;
    }

    public static String generateBatchCommand(ImportOperationInterface operation) {
        String packageName;
        String profile = BatchImporter.getDisplayableProfileName(operation);
        if (profile == null) {
            return null;
        }
        String string = packageName = operation.getPackageFile() == null ? null : operation.getPackageFile().getAbsolutePath();
        if (packageName == null) {
            return null;
        }
        String targetContainerPath = operation.getTargetContainerPath();
        if (targetContainerPath == null || targetContainerPath.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ImportPackage ");
        BatchImporter.addOptionAndValue(sb, "profile", profile);
        BatchImporter.addOptionAndValue(sb, "package", packageName);
        BatchImporter.addOptionAndValue(sb, "target", targetContainerPath);
        BatchImporter.addOptionAndValue(sb, "subprop", null);
        if (operation.isSecurityMetadataIncluded()) {
            BatchImporter.addOptionAndValue(sb, "includeACL", null);
        }
        if (operation.isPreservingPaths()) {
            BatchImporter.addOptionAndValue(sb, "preservePaths", null);
        }
        if (operation.getImportType() == 1) {
            BatchImporter.addOptionAndValue(sb, "newOnly", null);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BatchImporter importer = new BatchImporter();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        int rc = 0;
        try {
            importer.parse(args);
            if (importer._help) {
                HelpFormatter help = new HelpFormatter();
                String[] exclusions = new String[]{"localize", "locprop", "multiLocale", "debug", "install", "configProductID", "configProductKey"};
                Options helpOptions = BatchImporter.getHelpOptions((Options)importer._options, (String[])exclusions);
                String usage = "ImportPackage -package packageFile -target folderPath [options...]";
                help.printHelp(usage, RB.getStringResource("AbstractPromotionDriverOptions.Options.txt"), helpOptions, null);
                return;
            }
            rc = importer.importPackage();
            System.out.println(RB.getStringResource("BatchImporter.ImportComplete.txt"));
        }
        catch (ParseException e) {
            System.err.println(RB.getStringResource("AbstractPromotionDriver.InvalidOptions.txt"));
            System.err.println(e.getLocalizedMessage());
            rc = 8;
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchImporter.ImportFailed.fmt.txt", (Object)e.getLocalizedMessage());
            System.err.println(msg);
            rc = 8;
        }
        finally {
            if (importer != null) {
                rc |= importer.getReturnCode();
                String logFileName = importer.getLogFileName();
                if (logFileName != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchImporter.ViewLog.fmt.txt", (Object)logFileName));
                }
            }
        }
        System.exit(rc);
    }
}

