/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.DateParser;
import com.sas.metadata.promotion.AbstractPromotionDriverOptions;
import com.sas.metadata.promotion.RB;
import com.sas.text.Message;
import java.util.ResourceBundle;
import org.apache.commons.cli.Option;

@SASScope
public class BatchExporterOptions
extends AbstractPromotionDriverOptions {
    private static final String NEW_LINE = "\r\n";
    public static final String OPTION_OBJECTS = "objects";
    public static final String OPTION_DEPENDENCIES = "includeDep";
    public static final String OPTION_EMPTY_FOLDERS = "includeEmptyFolders";
    public static final String OPTION_LOCALIZE = "locprop";
    public static final String OPTION_SUBSTITUTION = "subprop";
    public static final String OPTION_CREATED_DATE = "created";
    public static final String OPTION_MODIFIED_DATE = "modified";
    public static final String OPTION_SINCE_DATE = "since";
    public static final String OPTION_BEFORE_DATE = "before";
    public static final String OPTION_NAME = "name";
    public static final String OPTION_NAME_MATCH_TYPE = "nameMatchType";
    public static final String OPTION_INCLUDE_DESCRIPTION = "includeDesc";
    public static final String OPTION_KEYWORDS = "keywords";
    public static final String OPTION_NOTES = "notes";
    public static final String OPTION_EXTENSIONS_NAME = "extName";
    public static final String OPTION_EXTENSIONS_VALUE = "extValue";
    public static final String OPTION_RESP_USERNAME = "respName";
    public static final String OPTION_RESP_ROLE = "respRole";
    public static final String OPTION_REPACKAGE = "repackage";
    public static final String OPTION_REPACKAGE_VAL_FULL = "full";

    protected BatchExporterOptions() {
        String example = "-objects \"/Shared Data\" \"/Users/MyFolder\" \"/StoredProcesses/Test Stored Process(StoredProcess)\" \"/Tables/Shared Tables/Test Table(Table)\"";
        Option option = new Option(OPTION_OBJECTS, true, Message.format((ResourceBundle)RB.getResources(), (String)"BatchExporterOptions.Objects.Desc.fmt.txt", (Object)"-objects \"/Shared Data\" \"/Users/MyFolder\" \"/StoredProcesses/Test Stored Process(StoredProcess)\" \"/Tables/Shared Tables/Test Table(Table)\""));
        option.setArgName(RB.getStringResource("BatchExporterOptions.Objects.ArgName.txt"));
        option.setArgs(-2);
        this.addOption(option);
        option = new Option(OPTION_DEPENDENCIES, RB.getStringResource("BatchExporterOptions.IncludeDependencies.Desc.txt"));
        this.addOption(option);
        option = new Option(OPTION_NAME, true, RB.getStringResource("BatchExporterOptions.Name.Desc.txt"));
        option.setArgName(RB.getStringResource("BatchExporterOptions.Name.ArgName.txt"));
        this.addOption(option);
        option = new Option(OPTION_NAME_MATCH_TYPE, true, RB.getStringResource("BatchExporterOptions.NameMatchType.Desc.txt"));
        option.setArgName(RB.getStringResource("BatchExporterOptions.NameMatchType.ArgName.txt"));
        this.addOption(option);
        option = new Option(OPTION_INCLUDE_DESCRIPTION, RB.getStringResource("BatchExporterOptions.IncludeDescription.Desc.txt"));
        this.addOption(option);
        option = new Option(OPTION_EMPTY_FOLDERS, RB.getStringResource("BatchExporterOptions.IncludeEmptyFolders.Desc.txt"));
        this.addOption(option);
        option = new Option(OPTION_CREATED_DATE, RB.getStringResource("BatchExporterOptions.CreatedDate.Desc.txt"));
        this.addOption(option);
        option = new Option(OPTION_MODIFIED_DATE, RB.getStringResource("BatchExporterOptions.ModifiedDate.Desc.txt"));
        this.addOption(option);
        option = new Option(OPTION_SINCE_DATE, true, BatchExporterOptions.getSinceDateDescriptor());
        option.setArgName(RB.getStringResource("BatchExporterOptions.SinceDate.ArgName.txt"));
        this.addOption(option);
        option = new Option(OPTION_BEFORE_DATE, true, RB.getStringResource("BatchExporterOptions.BeforeDate.Desc.txt"));
        option.setArgName(RB.getStringResource("BatchExporterOptions.BeforeDate.ArgName.txt"));
        this.addOption(option);
        option = new Option(OPTION_KEYWORDS, true, RB.getStringResource("BatchExporterOptions.Keywords.Desc.txt"));
        option.setArgName(RB.getStringResource("BatchExporterOptions.Keywords.ArgName.txt"));
        option.setArgs(-2);
        this.addOption(option);
        option = new Option(OPTION_NOTES, true, RB.getStringResource("BatchExporterOptions.Notes.Desc.txt"));
        option.setArgName(RB.getStringResource("BatchExporterOptions.Notes.ArgName.txt"));
        option.setArgs(-2);
        this.addOption(option);
        option = new Option(OPTION_EXTENSIONS_NAME, true, RB.getStringResource("BatchExporterOptions.ExtensionsName.Desc.txt"));
        option.setArgName(RB.getStringResource("BatchExporterOptions.ExtensionsName.ArgName.txt"));
        this.addOption(option);
        option = new Option(OPTION_EXTENSIONS_VALUE, true, RB.getStringResource("BatchExporterOptions.ExtensionsValue.Desc.txt"));
        option.setArgName(RB.getStringResource("BatchExporterOptions.ExtensionsValue.ArgName.txt"));
        this.addOption(option);
        option = new Option(OPTION_RESP_USERNAME, true, RB.getStringResource("BatchExporterOptions.RespName.Desc.txt"));
        option.setArgName(RB.getStringResource("BatchExporterOptions.RespName.ArgName.txt"));
        this.addOption(option);
        option = new Option(OPTION_RESP_ROLE, true, RB.getStringResource("BatchExporterOptions.RespRole.Desc.txt"));
        option.setArgName(RB.getStringResource("BatchExporterOptions.RespRole.ArgName.txt"));
        this.addOption(option);
        option = new Option(OPTION_LOCALIZE, RB.getStringResource("BatchExporterOptions.Localize.Desc.txt"));
        this.addOption(option);
        option = new Option(OPTION_SUBSTITUTION, RB.getStringResource("BatchExporterOptions.Substitution.Desc.txt"));
        this.addOption(option);
        option = new Option(OPTION_REPACKAGE, true, RB.getStringResource("BatchExporterOptions.Repackage.Desc.txt"));
        option.setOptionalArg(true);
        option.setArgName(RB.getStringResource("BatchExporterOptions.Repackage.ArgName.txt"));
        this.addOption(option);
        option = new Option("noexecute", RB.getStringResource("BatchExporterOptions.NoExecute.Desc.txt"));
        this.addOption(option);
    }

    private static String getSinceDateDescriptor() {
        DateParser parser = DateParser.getInstance();
        String[] absoluteDatePatterns = parser.getAbsoluteDatePatterns();
        String[] relativeDatePatterns = parser.getRelativeDatePatterns();
        String dateInfo = Message.format((ResourceBundle)RB.getResources(), (String)"BatchExporterOptions.DateInfo.fmt.txt", (Object)BatchExporterOptions.getDisplayTextForPatterns(absoluteDatePatterns), (Object)BatchExporterOptions.getDisplayTextForPatterns(relativeDatePatterns));
        StringBuffer desc = new StringBuffer();
        desc.append(RB.getStringResource("BatchExporterOptions.SinceDate.Desc.txt"));
        desc.append(NEW_LINE).append(dateInfo);
        return desc.toString();
    }

    private static String getDisplayTextForPatterns(String[] patterns) {
        StringBuffer sb = new StringBuffer();
        if (patterns != null && patterns.length > 0) {
            sb.append(NEW_LINE);
            int length = patterns.length;
            for (int i = 0; i < length; ++i) {
                sb.append("\"").append(patterns[i]).append("\"");
                if (i == length - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }
}

