/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TransportableContainerTypeInterface;
import com.sas.metadata.logical.TransportableType2Interface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.AbstractPromotionDriver;
import com.sas.metadata.promotion.BatchCopierOptions;
import com.sas.metadata.promotion.BatchExporter;
import com.sas.metadata.promotion.BatchImporter;
import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.promotion.ImportUtil;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.VirtualFolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class BatchCopyObjects
extends AbstractPromotionDriver {
    private List<PublicObjectInterface> _copyList = new ArrayList<PublicObjectInterface>();
    private ImportSummaryInterface _summary;
    private String _targetContainerPath = null;
    private String[] _objectPaths = null;

    private BatchCopyObjects() {
        this.setLogFilePrefix("CopyPaste");
        this.setLogFileTimestamp(false);
        this.setAppendToLogFile(false);
    }

    public BatchCopyObjects(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public BatchCopyObjects(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    @Override
    public final void setPackageFileName(String fileName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(RB.getStringResource("BatchCopier.PackageFilesUnsupported.txt"));
    }

    @Override
    public final void setPackageFile(File packageFile) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(RB.getStringResource("BatchCopier.PackageFilesUnsupported.txt"));
    }

    @Override
    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new BatchCopierOptions();
        if (args == null || args.length == 0) {
            this._help = true;
            return;
        }
        super.parse(args);
        if (this._help) {
            return;
        }
        if (this._commandLine.hasOption("objects") && this._commandLine.hasOption("target")) {
            this._objectPaths = this._commandLine.getOptionValues("objects");
            this._targetContainerPath = this._commandLine.getOptionValue("target");
        } else if (!this._commandLine.hasOption("objects") && !this._commandLine.hasOption("target")) {
            List remainingArgs = this._commandLine.getArgList();
            if (remainingArgs.size() < 2) {
                this._help = true;
                return;
            }
            this._objectPaths = remainingArgs.subList(0, remainingArgs.size() - 1).toArray(new String[0]);
            this._targetContainerPath = (String)remainingArgs.get(remainingArgs.size() - 1);
        } else {
            this._help = true;
            return;
        }
    }

    public boolean isCopyAllowed(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        ArrayList<PublicObjectInterface> items = new ArrayList<PublicObjectInterface>(1);
        items.add(publicObject);
        return this.isCopyAllowed(items);
    }

    public boolean isCopyAllowed(List<PublicObjectInterface> publicObjects) throws ServiceException, RemoteException {
        if (publicObjects == null || publicObjects.isEmpty()) {
            return false;
        }
        try {
            HashMap<String, List<String>> objectMap = new HashMap<String, List<String>>(5);
            Factory factory = Factory.getInstance();
            for (PublicObjectInterface publicObject : publicObjects) {
                TypeDescriptorInterface typeDesc = publicObject.getTypeDescriptor();
                if (typeDesc == null) {
                    return false;
                }
                TypeInterface ti = factory.getTypeInterface(typeDesc.getTypeName());
                if (ti instanceof TransportableType2Interface && !((TransportableType2Interface)ti).isCopyAllowed()) {
                    return false;
                }
                if (!(ti instanceof TransportableTypeInterface)) {
                    return false;
                }
                String typeName = typeDesc.getTypeName();
                if (!BatchCopyObjects.isDuplicate(publicObject.getName(), typeName, objectMap)) continue;
                return false;
            }
        }
        catch (LogicalTypeException e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
        return true;
    }

    private static boolean isDuplicate(String name, String type, Map<String, List<String>> objectMap) {
        List<String> names = objectMap.get(type);
        if (names == null) {
            names = new ArrayList<String>();
            names.add(name);
            objectMap.put(type, names);
        } else {
            for (String objectName : names) {
                if (!name.equalsIgnoreCase(objectName)) continue;
                return true;
            }
            names.add(name);
        }
        return false;
    }

    public boolean isPasteAllowed() {
        return this._copyList != null && this._copyList.size() > 0;
    }

    public boolean isPasteAllowed(PublicObjectContainerInterface targetContainer) throws ServiceException, RemoteException {
        if (!this.isPasteAllowed()) {
            return false;
        }
        TypeDescriptorInterface typeDesc = targetContainer.getTypeDescriptor();
        if (typeDesc == null) {
            return false;
        }
        try {
            Factory factory = Factory.getInstance();
            TypeInterface ti = factory.getTypeInterface(typeDesc.getTypeName());
            if (ti instanceof TransportableContainerTypeInterface && ((TransportableContainerTypeInterface)ti).isPasteAllowed() || PromotionUtil.isRootFolder((PublicObjectInterface)targetContainer)) {
                boolean valid = true;
                for (PublicObjectInterface obj : this._copyList) {
                    if (this.isVirtualFolder(targetContainer)) {
                        return SASFoldersUtil.isContainedByVirtualFolder((PublicObjectInterface)obj);
                    }
                    if (SASFoldersUtil.isValidContainerForChild((PublicObjectInterface)obj, (PublicObjectContainerInterface)targetContainer)) continue;
                    valid = false;
                    break;
                }
                return valid;
            }
        }
        catch (LogicalTypeException e) {
            throw new ServiceException((Throwable)e);
        }
        return false;
    }

    private boolean isVirtualFolder(PublicObjectContainerInterface container) {
        return container instanceof VirtualFolderNodeInterface || container instanceof VirtualFolderInterface;
    }

    public List<PublicObjectInterface> getCopyList() {
        return Collections.unmodifiableList(this._copyList);
    }

    public void clearCopyList() {
        this._copyList.clear();
    }

    public void removeItemFromCopyList(PublicObjectInterface publicObject) {
        if (this._copyList.contains(publicObject)) {
            this._copyList.remove(publicObject);
        }
    }

    public ImportSummaryInterface getCopySummary() {
        return this._summary;
    }

    public void copy(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        if (this.isCopyAllowed(publicObject)) {
            this._copyList.clear();
            this._copyList.add(publicObject);
        }
    }

    public void copy(List<PublicObjectInterface> publicObjects) throws ServiceException, RemoteException {
        if (this.isCopyAllowed(publicObjects)) {
            this._copyList.clear();
            this._copyList.addAll(publicObjects);
        }
    }

    public int paste(PublicObjectContainerInterface targetContainer) throws ServiceException, RemoteException {
        int rc = 0;
        this._summary = null;
        if (this.isPasteAllowed()) {
            if (targetContainer == null) {
                throw new IllegalArgumentException(RB.getStringResource("BatchCopier.MissingPath.txt"));
            }
            File packageFile = null;
            try {
                if (this.isPastingObjectsIntoRoot(targetContainer, this._copyList)) {
                    throw new MetadataPromotionException(RB.getStringResource("BatchCopier.ObjectsUnderRoot.txt"));
                }
                this.initialize();
                if (targetContainer != null) {
                    if (!this.isPasteAllowed(targetContainer)) {
                        throw new MetadataPromotionException(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.InvalidTarget.fmt.txt", (Object)targetContainer.getName()));
                    }
                    if (!ImportUtil.validateTargetContainerPermissions(targetContainer, this._server, false)) {
                        throw new MetadataPromotionException(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.NoPermission.fmt.txt", (Object)targetContainer.getName()));
                    }
                }
                packageFile = File.createTempFile("CopyPaste", ".spk");
                rc |= this.runExport(packageFile, this._copyList);
                rc |= this.runImport(packageFile, targetContainer);
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e, e.getLocalizedMessage());
            }
            finally {
                if (packageFile != null) {
                    packageFile.delete();
                }
                try {
                    this.terminate();
                }
                catch (Exception e) {
                    throw new ServiceException((Throwable)e, e.getLocalizedMessage());
                }
            }
        }
        return rc;
    }

    private int runExport(File packageFile, List<PublicObjectInterface> selectedObjects) throws Exception {
        BatchExporter exporter = new BatchExporter(this._session);
        exporter.setWorkspaceEnabled(this.isWorkspaceEnabled());
        exporter.setParent(this);
        exporter.setLogFile(null);
        exporter.setExportMode(2);
        exporter.setPackageFile(packageFile);
        exporter.setGenerateExternalSubstitutionProperties(false);
        exporter.setGenerateLocalizableProperties(false);
        exporter.initialize();
        PublicObjectInterface[] objects = selectedObjects.toArray(new PublicObjectInterface[selectedObjects.size()]);
        exporter.setSelectedObjects(objects);
        List<String> supportedTypes = this.configureFilteredPublicTypes();
        if (supportedTypes != null) {
            exporter.addSearchFilter((SearchFilter)new PublicTypeFilter(supportedTypes));
        }
        int rc = exporter.exportPackage();
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runImport(File packageFile, PublicObjectContainerInterface targetContainer) throws Exception {
        int rc = 0;
        BatchImporter importer = new BatchImporter(this._session);
        try {
            importer.setWorkspaceEnabled(this.isWorkspaceEnabled());
            importer.setParent(this);
            importer.setLogFile(null);
            importer.setImportMode(2);
            importer.setPackageFile(packageFile);
            importer.setLocalize(false);
            importer.setTargetContainer(targetContainer);
            importer.setIncludeSecurity(true);
            rc = importer.importPackage();
        }
        finally {
            this._summary = importer.getImportSummary();
        }
        return rc;
    }

    private boolean isPastingObjectsIntoRoot(PublicObjectContainerInterface container, List<PublicObjectInterface> publicObjects) throws ServiceException, RemoteException {
        if (PromotionUtil.isRootFolder((PublicObjectInterface)container)) {
            for (PublicObjectInterface publicObject : publicObjects) {
                String type;
                TypeDescriptorInterface typeDesc = publicObject.getTypeDescriptor();
                if (typeDesc == null || "Folder".equalsIgnoreCase(type = typeDesc.getTypeName())) continue;
                return true;
            }
        }
        return false;
    }

    private PublicObjectContainerInterface getTargetContainer() throws ServiceException, RemoteException, LogicalTypeException {
        if (this._targetContainerPath == null) {
            throw new IllegalArgumentException(RB.getStringResource("BatchCopier.MissingPath.txt"));
        }
        PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)this._targetContainerPath);
        if (path == null) {
            throw new IllegalArgumentException(RB.getStringResource("BatchCopier.MissingPath.txt"));
        }
        if (path.getType() == null) {
            path.setType("Folder");
        }
        if (path.getPath() == null && String.valueOf('/').equals(path.getName())) {
            return this._server.getRootFolder();
        }
        MetadataInterface mi = this._server.getObjectByPath(path);
        if (mi == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.FolderNotFound.fmt.txt", (Object)path.getDisplayPath()));
        }
        if (!(mi instanceof FolderInterface)) {
            throw new ServiceException(RB.getStringResource("BatchCopier.NotAFolder.txt"));
        }
        return (FolderInterface)mi;
    }

    private List<PublicObjectInterface> getSelectedItems() throws ServiceException, RemoteException, LogicalTypeException {
        if (this._objectPaths == null || this._objectPaths.length == 0) {
            throw new IllegalArgumentException(RB.getStringResource("BatchCopier.NoObjects.txt"));
        }
        ArrayList<PublicObjectInterface> objectList = new ArrayList<PublicObjectInterface>();
        if (this._objectPaths.length == 1 && this._objectPaths[0].equalsIgnoreCase(String.valueOf('/'))) {
            RootFolderInterface rootFolder = this._server.getRootFolder();
            objectList.add((PublicObjectInterface)rootFolder);
        } else {
            for (String path : this._objectPaths) {
                MetadataInterface mi;
                PathUrl url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)path);
                if (url.getType() == null) {
                    url.setType("Folder");
                }
                if ((mi = this._server.getObjectByPath(url)) == null) continue;
                objectList.add((PublicObjectInterface)mi);
            }
        }
        return objectList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int rc;
        block16: {
            BatchCopyObjects copier = new BatchCopyObjects();
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
            String logFileName = null;
            rc = 0;
            try {
                copier.parse(args);
                if (copier._help) {
                    HelpFormatter help = new HelpFormatter();
                    String[] exclusions = new String[]{"debug"};
                    Options helpOptions = BatchCopyObjects.getHelpOptions((Options)copier._options, (String[])exclusions);
                    help.printHelp(80, BatchCopyObjects.getUsage(help), RB.getStringResource("AbstractPromotionDriverOptions.Options.txt"), helpOptions, null);
                    if (copier != null) {
                        rc |= copier.getReturnCode();
                        if (logFileName != null) {
                            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.ViewLog.fmt.txt", (Object)logFileName));
                        }
                    }
                    return;
                }
                copier.initialize();
                copier.validateSetup();
                List<PublicObjectInterface> objectsToCopy = copier.getSelectedItems();
                if (!copier.isCopyAllowed(objectsToCopy)) {
                    throw new MetadataPromotionException(RB.getStringResource("BatchCopier.CopyNotSupported.txt"));
                }
                copier.copy(objectsToCopy);
                logFileName = copier.getLogFileName();
                PublicObjectContainerInterface target = copier.getTargetContainer();
                rc = copier.paste(target);
                System.out.println(RB.getStringResource("BatchCopier.Complete.txt"));
                if (copier == null) break block16;
                rc |= copier.getReturnCode();
                if (logFileName != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.ViewLog.fmt.txt", (Object)logFileName));
                }
            }
            catch (ParseException e) {
                System.err.println(RB.getStringResource("AbstractPromotionDriver.InvalidOptions.txt"));
                System.err.println(e.getLocalizedMessage());
                rc = 8;
                if (copier == null) break block16;
                rc |= copier.getReturnCode();
                if (logFileName != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.ViewLog.fmt.txt", (Object)logFileName));
                }
                {
                    catch (Throwable throwable) {
                        if (copier != null) {
                            rc |= copier.getReturnCode();
                            if (logFileName != null) {
                                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.ViewLog.fmt.txt", logFileName));
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Exception e2) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.Failed.fmt.txt", (Object)e2.getLocalizedMessage());
                    System.err.println(msg);
                    rc = 8;
                    if (copier == null) break block16;
                    rc |= copier.getReturnCode();
                    if (logFileName != null) {
                        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.ViewLog.fmt.txt", (Object)logFileName));
                    }
                }
            }
        }
        System.exit(rc);
    }

    private static String getUsage(HelpFormatter help) {
        String NEW_LINE = help.getNewLine();
        StringBuffer usage = new StringBuffer();
        usage.append("CopyObjects [options...] -objects objectPath ... -target folderPath");
        usage.append(NEW_LINE).append("CopyObjects [options...] objectPath ... folderPath");
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchCopier.HelpExample1.txt"));
        usage.append(NEW_LINE).append("CopyObjects -profile \"Default\" \"/Shared Data\" \"/Target Folder\"");
        usage.append(NEW_LINE);
        return usage.toString();
    }
}

