/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.promotion.AbstractPromotionDriverOptions;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceInitializationCallback;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;

@SASScope
public abstract class AbstractPromotionDriver
extends BatchDriver2 {
    private static final char SUBTYPE_SEPARATOR = '.';
    protected boolean _install = false;
    protected boolean _noExecute = false;
    protected boolean _expandSummary = false;
    protected String _packageFileName = null;
    protected File _packageFile = null;
    protected List<String> _filteredTypes = null;
    protected boolean _includeSubTypes = true;
    protected boolean _initialized = false;
    private boolean _workspaceEnabled = true;

    public AbstractPromotionDriver() {
        this.setLogContextName("com.sas.metadata.promotion");
    }

    public void initialize() throws ServiceException, LogicalTypeException, RemoteException {
        if (this._initialized) {
            return;
        }
        super.initialize();
        Log.initAlreadyConfiguredLogger(this._logContextName, this._logFileName);
        if (this.isWorkspaceEnabled()) {
            this.initializeWorkspace();
        } else {
            Workspace.setDeferredWorkspaceInitializer((WorkspaceInitializationCallback)new WorkspaceInitializer());
        }
        this._initialized = true;
    }

    protected List<BatchDriver2.DefaultLoggingContext> getDefaultLoggingContexts() {
        return Collections.emptyList();
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        super.parse(args);
        if (this._help) {
            return;
        }
        String types = this._commandLine.getOptionValue("types");
        if (types != null) {
            this._filteredTypes = AbstractPromotionDriver.getValuesAsList(types);
        }
        if (this._commandLine.hasOption("excludeSubTypes")) {
            this._includeSubTypes = false;
        }
        if (this._commandLine.hasOption("install")) {
            this._install = true;
        }
        this._noExecute = this._commandLine.hasOption("noexecute");
        if (this._noExecute) {
            this._expandSummary = this._commandLine.hasOption("expandSummary");
        }
        if (this._commandLine.hasOption("disableX11")) {
            this.setWorkspaceEnabled(false);
        }
        this._debug = this._commandLine.hasOption("debug");
        if (this._commandLine.hasOption("package")) {
            this.setPackageFileName(this._commandLine.getOptionValue("package"));
        }
    }

    public boolean isWorkspaceEnabled() {
        return this._workspaceEnabled;
    }

    public void setWorkspaceEnabled(boolean enabled) {
        this._workspaceEnabled = enabled;
    }

    public final void setSupportedTypes(List supportedTypes) {
        throw new UnsupportedOperationException("This method is not supported.  Use setFilteredTypes instead.");
    }

    public void setFilteredTypes(List<String> filteredTypes) {
        this._filteredTypes = filteredTypes;
    }

    public List<String> getFilteredTypes() {
        if (this._filteredTypes == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this._filteredTypes);
    }

    public void setNoExecute(boolean noexecute) {
        this._noExecute = noexecute;
    }

    public String getPackageFileName() {
        return this._packageFileName;
    }

    public void setPackageFileName(String fileName) {
        this._packageFileName = fileName;
        this._packageFile = PromotionUtil.createPromotionFile(this._packageFileName, ".spk", null, false);
    }

    public File getPackageFile() {
        return this._packageFile;
    }

    public void setPackageFile(File packageFile) {
        this._packageFile = packageFile;
        if (packageFile != null) {
            this._packageFileName = packageFile.getName();
        }
    }

    protected static List<String> getValuesAsList(String values) {
        if (values == null) {
            return null;
        }
        HashSet<String> typesSet = new HashSet<String>(5);
        StringTokenizer st = new StringTokenizer(values, ", ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() <= 0) continue;
            typesSet.add(token);
        }
        return new ArrayList<String>(typesSet);
    }

    protected static List<String> getValuesAsList(String[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> typesList = new ArrayList<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            typesList.add(values[i].trim());
        }
        return typesList;
    }

    protected static void addOptionAndValue(StringBuilder sb, String optionName, String value) {
        sb.append(AbstractPromotionDriverOptions.getFullyQualifiedOptionName(optionName));
        if (value != null) {
            sb.append(" ");
            sb.append("\"").append(value).append("\"");
        }
        sb.append(" ");
    }

    protected static void addOptionAndValues(StringBuilder sb, String optionName, List<String> values) {
        sb.append(AbstractPromotionDriverOptions.getFullyQualifiedOptionName(optionName));
        if (values != null && values.size() > 0) {
            for (String s : values) {
                sb.append(" ");
                sb.append("\"").append(s).append("\"");
            }
        }
        sb.append(" ");
    }

    protected static String addValuesToString(List<String> values) {
        StringBuilder sb = new StringBuilder();
        int len = values.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(values.get(i));
        }
        return sb.toString();
    }

    protected static String getDisplayableProfileName(PromotionInterface operation) {
        String profileName = operation.getProfileName();
        if (profileName != null) {
            int index;
            File profile;
            String fileSeparator = System.getProperty("file.separator");
            if (profileName.lastIndexOf(fileSeparator) > -1 && (profile = new File(profileName)).exists()) {
                profileName = profile.getName();
            }
            String profileExtension = ".swa";
            if (profileName.endsWith(".swa") && (index = profileName.indexOf(".swa")) > 0) {
                profileName = profileName.substring(0, index);
            }
        }
        return profileName;
    }

    protected List<String> configureFilteredPublicTypes() throws ServiceException, LogicalTypeException, RemoteException {
        if (this._filteredTypes == null) {
            return null;
        }
        if (this._server instanceof MetadataServerInterface) {
            Map typesMap = ((MetadataServerInterface)this._server).getTypeDictionaryMap();
            Object[] types = this._filteredTypes.toArray();
            int length = types.length;
            for (int i = 0; i < length; ++i) {
                List<String> subTypeList;
                String typeName = (String)types[i];
                if (typeName.indexOf(46) >= 0 || (subTypeList = this.getSubTypes(typesMap, typeName)) == null) continue;
                for (String name : subTypeList) {
                    if (this._filteredTypes.contains(name)) continue;
                    this._filteredTypes.add(name);
                }
            }
        }
        return this._filteredTypes == null ? null : new ArrayList<String>(this._filteredTypes);
    }

    private List<String> getSubTypes(Map<String, TypeDescriptorInterface> typesMap, String typeName) {
        ArrayList<String> subTypeList = null;
        for (String subTypeName : typesMap.keySet()) {
            if (subTypeName.indexOf(46) <= -1 || !subTypeName.startsWith(typeName)) continue;
            if (subTypeList == null) {
                subTypeList = new ArrayList<String>();
            }
            subTypeList.add(subTypeName);
        }
        return subTypeList;
    }

    private class WorkspaceInitializer
    implements WorkspaceInitializationCallback {
        private WorkspaceInitializer() {
        }

        public Workspace initializeWorkspace() {
            throw new IllegalStateException(RB.getStringResource("AbstractPromotionDriver.IllegalWorkspaceAccess.txt"));
        }
    }
}

