/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SASScopeExtension;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentObjectsProviderInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@SASScopeExtension(value="sas")
public abstract class AbstractConnectionType
implements ConnectionTypeInterface {
    protected String _connectionTypeName;
    protected PromotionInterface _operation;
    protected ConnectionManagerInterface _connectionManager;
    protected Log _log;
    protected Map<SourceConnectionInterface, TargetConnectionInterface> _connectionMap;
    private Map<ConnectionPointInterface, SourceConnectionInterface> _sourceConnectionCache;

    public AbstractConnectionType(PromotionInterface promotionOperation) {
        this._operation = promotionOperation;
        this._connectionManager = promotionOperation.getConnectionManager();
        this._log = promotionOperation.getLogger();
        this._connectionMap = new LinkedHashMap<SourceConnectionInterface, TargetConnectionInterface>();
        this._sourceConnectionCache = new HashMap<ConnectionPointInterface, SourceConnectionInterface>();
    }

    @Override
    public abstract String getConnectionTypeName();

    @Override
    public abstract String getLocalizedTypeName();

    @Override
    public abstract String getPanelName();

    @Override
    public abstract List<SourceConnectionInterface> getSourceConnections();

    @Override
    public abstract List<TargetConnectionInterface> getTargetConnections() throws MdException, RemoteException;

    @Override
    public String getTargetConnectionID(ConnectionPointInterface pt, TargetConnectionInterface targetValue) throws MdException, RemoteException {
        return targetValue != null ? targetValue.getTargetID() : null;
    }

    @Override
    public void validate(ValidationResponse response, ImportOperationInterface importOperation, SourceConnectionInterface sourceValue) throws MdException, RemoteException {
        response.setReturnCode(0);
    }

    @Override
    public void analyzeConnections() throws MdException, RemoteException {
    }

    @Override
    public String getTypeAttributeLabel() {
        return "Name";
    }

    public final PromotionInterface getPromotionOperation() {
        return this._operation;
    }

    public final ConnectionManagerInterface getConnectionManager() {
        return this._connectionManager;
    }

    @Override
    public final void addConnectionMapping(SourceConnectionInterface sourceValue, TargetConnectionInterface targetValue) {
        this._connectionMap.put(sourceValue, targetValue);
    }

    @Override
    public final TargetConnectionInterface getTargetConnection(SourceConnectionInterface sourceValue) {
        return this._connectionMap.get(sourceValue);
    }

    @Override
    public final Map<SourceConnectionInterface, TargetConnectionInterface> getConnectionMapping() {
        return this._connectionMap;
    }

    public final List<SourceConnectionInterface> getSourceConnectionsByType(ConnectionObjectType type, String typeValue) {
        List<ConnectionPointInterface> connectionPoints = this._connectionManager.getConnections(type, typeValue);
        ArrayList<SourceConnectionInterface> connections = new ArrayList<SourceConnectionInterface>(connectionPoints.size());
        for (ConnectionPointInterface pt : connectionPoints) {
            SourceConnectionInterface sourceConnection = this.createSourceConnection(pt, pt.getName());
            connections.add(sourceConnection);
        }
        return connections;
    }

    public final SourceConnectionInterface createSourceConnection(ConnectionPointInterface pt, String displayName) {
        if (this._sourceConnectionCache.containsKey(pt)) {
            return this._sourceConnectionCache.get(pt);
        }
        SourceConnection source = new SourceConnection(pt, displayName, this);
        this._sourceConnectionCache.put(pt, source);
        return source;
    }

    public final TargetConnectionInterface createTargetConnection(String targetID, String metadataType, String displayName) throws RemoteException {
        return new TargetConnection(targetID, metadataType, displayName, this);
    }

    public final TargetConnectionInterface createTargetConnection(CMetadata target, String displayName) throws RemoteException {
        return new TargetConnection(target, displayName, this);
    }

    @SASScope
    class SourceConnection
    implements SourceConnectionInterface,
    DependentObjectsProviderInterface {
        private List<ConnectionPointInterface> _connections;
        private String _displayName;
        private ConnectionTypeInterface _type;

        public SourceConnection(ConnectionPointInterface pt, String displayName, ConnectionTypeInterface type) {
            this._displayName = displayName;
            this._type = type;
            this._connections = new ArrayList<ConnectionPointInterface>(1);
            this.addConnectionPoint(pt);
        }

        @Override
        public void addConnectionPoint(ConnectionPointInterface pt) {
            if (!this._connections.contains(pt)) {
                this._connections.add(pt);
            }
        }

        @Override
        public ConnectionPointInterface getConnectionPoint() {
            return this._connections.size() > 0 ? this._connections.get(0) : null;
        }

        @Override
        public List<ConnectionPointInterface> getConnectionPoints() {
            return this._connections;
        }

        @Override
        public boolean containsMultipleConnectionPoints() {
            return this._connections.size() > 1;
        }

        @Override
        public String getDisplayName() {
            return this._displayName;
        }

        @Override
        public String getSourcePath() {
            ConnectionPointInterface pt = this.getConnectionPoint();
            return pt == null ? null : pt.getSourcePath();
        }

        @Override
        public ConnectionTypeInterface getConnectionType() {
            return this._type;
        }

        public String toString() {
            return this._displayName;
        }

        @Override
        public List<ImportItemInterface> getDependentObjects() {
            HashSet<ImportItemInterface> set = new HashSet<ImportItemInterface>();
            int len = this._connections.size();
            for (int i = 0; i < len; ++i) {
                ConnectionPointInterface conn = this._connections.get(i);
                List<PromotionItemInterface> items = conn.getAssociatedObjects();
                for (PromotionItemInterface item : items) {
                    ImportItemInterface importItem;
                    if (!(item instanceof ImportItemInterface) || (importItem = (ImportItemInterface)item).getImportState() == 0) continue;
                    set.add(importItem);
                }
            }
            return new ArrayList<ImportItemInterface>(set);
        }
    }

    @SASScope
    class TargetConnection
    implements TargetConnectionInterface {
        private CMetadata _target;
        private String _targetID;
        private String _metadataType;
        private String _displayName;
        private ConnectionTypeInterface _type;

        public TargetConnection(String targetID, String metadataType, String displayName, ConnectionTypeInterface type) throws RemoteException {
            this._targetID = targetID;
            this._type = type;
            this._metadataType = metadataType;
            this._displayName = displayName;
            this.setMetadataObject();
        }

        public TargetConnection(CMetadata target, String displayName, ConnectionTypeInterface type) throws RemoteException {
            this._target = target;
            this._type = type;
            this._displayName = displayName;
            this._targetID = target.getId();
            this._metadataType = target.getCMetadataType();
        }

        @Override
        public String getTargetID() {
            return this._targetID;
        }

        @Override
        public String getMetadataType() {
            return this._metadataType;
        }

        @Override
        public String getDisplayName() {
            return this._displayName;
        }

        @Override
        public ConnectionTypeInterface getConnectionType() {
            return this._type;
        }

        public String toString() {
            return this._displayName;
        }

        @Override
        public CMetadata getMetadataObject() {
            return this._target;
        }

        private void setMetadataObject() throws RemoteException {
            MdFactory factory = AbstractConnectionType.this._operation.getMetadataFactory();
            MdObjectStore store = AbstractConnectionType.this._operation.getStore();
            this._target = factory.createComplexMetadataObject(store, this._displayName, this._metadataType, this._targetID);
        }
    }
}

