/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.responses;

import MITI.bridges.mimb.BridgeLibrary;
import MITI.mimb.executable.responses.Response;
import MITI.util.XmlUtil;
import MITI.util.log.LogEvent;
import MITI.util.text.BridgeSpecificationLiteral;
import MITI.util.xml.SoapUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BridgeListResponse
extends Response {
    private String lastBridge = "";
    private Map<BridgeLibrary, BridgeSpecificationLiteral> bridges = new LinkedHashMap<BridgeLibrary, BridgeSpecificationLiteral>();
    private boolean isExport = false;
    private boolean withSpecification = false;

    public BridgeListResponse() {
    }

    protected BridgeListResponse(String string, Element element) {
        super(string, element);
        this.isExport = element.getAttribute("direction").equals("EXPORT");
        boolean bl = false;
        for (Element element2 : XmlUtil.getChildElements(element, "Bridge")) {
            String string2 = element2.getAttribute("bridgeIdentifier");
            Element element3 = XmlUtil.getFirstElement(element2, "DisplayName");
            String string3 = element3.getAttribute("bridgeDisplayName");
            BridgeLibrary bridgeLibrary = new BridgeLibrary(string2, string3, true, false);
            Element element4 = XmlUtil.getFirstElement(element2, "Specification");
            BridgeSpecificationLiteral bridgeSpecificationLiteral = null;
            if (element4 != null) {
                bridgeSpecificationLiteral = BridgeListResponse.createLiteral(element4);
                bl = true;
            }
            this.bridges.put(bridgeLibrary, bridgeSpecificationLiteral);
        }
        this.withSpecification = bl;
    }

    private static BridgeSpecificationLiteral createLiteral(Element element) {
        String string = "";
        BridgeSpecificationLiteral bridgeSpecificationLiteral = null;
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = element.getAttribute("isMultiModel").equals("true");
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        String string4 = "";
        String string5 = "";
        String string6 = element.getAttribute("productCompany");
        String string7 = "";
        String string8 = "";
        String string9 = element.getAttribute("productName");
        String string10 = "";
        String string11 = element.getAttribute("productVersion");
        String string12 = element.getAttribute("productWeb");
        String string13 = element.getAttribute("methodology");
        String string14 = "";
        String string15 = "";
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        String string16 = "";
        boolean bl20 = false;
        boolean bl21 = false;
        boolean bl22 = false;
        boolean bl23 = false;
        String string17 = "";
        boolean bl24 = false;
        boolean bl25 = false;
        boolean bl26 = false;
        boolean bl27 = false;
        boolean bl28 = false;
        boolean bl29 = false;
        boolean bl30 = false;
        boolean bl31 = false;
        boolean bl32 = false;
        boolean bl33 = false;
        boolean bl34 = false;
        String string18 = "";
        String string19 = "";
        String string20 = "";
        String string21 = "";
        String string22 = "";
        BridgeSpecificationLiteral bridgeSpecificationLiteral2 = new BridgeSpecificationLiteral(string, bridgeSpecificationLiteral, string2, string3, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, bl10, bl11, bl12, bl13, bl14, bl15, bl16, bl17, bl18, bl19, string16, bl20, bl21, bl22, bl23, string17, bl24, bl25, bl26, bl27, bl28, bl29, bl30, bl31, bl32, bl33, bl34, string18, string19, string20, string21, string22);
        return bridgeSpecificationLiteral2;
    }

    public void setLastBridge(String string) {
        this.lastBridge = string;
    }

    public void addBridge(BridgeLibrary bridgeLibrary, BridgeSpecificationLiteral bridgeSpecificationLiteral) {
        this.bridges.put(bridgeLibrary, bridgeSpecificationLiteral);
    }

    public BridgeSpecificationLiteral getBridgeSpec(BridgeLibrary bridgeLibrary) {
        return this.bridges.get(bridgeLibrary);
    }

    public void setIsExport(boolean bl) {
        this.isExport = bl;
    }

    public boolean isExport() {
        return this.isExport;
    }

    public String lastBridge() {
        return this.lastBridge;
    }

    public Collection<BridgeLibrary> getBridges() {
        return this.bridges.keySet();
    }

    public void setWithSpecification(boolean bl) {
        this.withSpecification = bl;
    }

    public boolean getWithSpecification() {
        return this.withSpecification;
    }

    @Override
    public Element printTo(Node node, Collection<LogEvent> collection) {
        Element element = XmlUtil.appendNewElement(node == null ? this.document : node, null, "GetBridgeListResponse");
        element.setAttribute("xmlns", SoapUtil.NS_MIMB_EXE.getUri());
        element.setAttribute("direction", this.isExport() ? "EXPORT" : "IMPORT");
        for (Map.Entry<BridgeLibrary, BridgeSpecificationLiteral> entry : this.bridges.entrySet()) {
            BridgeLibrary bridgeLibrary = entry.getKey();
            Element element2 = XmlUtil.appendNewElement(element, null, "Bridge");
            element2.setAttribute("bridgeIdentifier", bridgeLibrary.getBridgeId());
            element2.setAttribute("direction", this.isExport() ? "EXPORT" : "IMPORT");
            Element element3 = XmlUtil.appendNewElement(element2, null, "DisplayName");
            element3.setAttribute("bridgeDisplayName", bridgeLibrary.getDisplayName());
            if (bridgeLibrary.getDisplayName().equals(this.lastBridge())) {
                element3.setAttribute("lastUsed", "true");
            }
            if (!this.getWithSpecification()) continue;
            Element element4 = XmlUtil.appendNewElement(element2, null, "Specification");
            BridgeSpecificationLiteral bridgeSpecificationLiteral = entry.getValue();
            if (bridgeSpecificationLiteral != null) {
                element4.setAttribute("version", bridgeSpecificationLiteral.getTool_Versions());
                element4.setAttribute("methodology", bridgeSpecificationLiteral.getMethodology_Summary());
                element4.setAttribute("productName", bridgeSpecificationLiteral.getTool_Name());
                element4.setAttribute("productVersion", bridgeSpecificationLiteral.getTool_Versions());
                element4.setAttribute("productCompany", bridgeSpecificationLiteral.getVendor_Name());
                element4.setAttribute("productWeb", bridgeSpecificationLiteral.getTool_Web());
                element4.setAttribute("isMultiModel", bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel() ? "true" : "false");
                continue;
            }
            element4.setAttribute("version", "UNDEFINED");
            element4.setAttribute("methodology", "UNDEFINED");
            element4.setAttribute("productName", "UNDEFINED");
            element4.setAttribute("productVersion", "UNDEFINED");
            element4.setAttribute("productCompany", "UNDEFINED");
            element4.setAttribute("productWeb", "http://UNDEFINED");
            element4.setAttribute("isMultiModel", "false");
        }
        return element;
    }

    @Override
    public void printTo(StringBuilder stringBuilder) {
        for (Map.Entry<BridgeLibrary, BridgeSpecificationLiteral> entry : this.bridges.entrySet()) {
            BridgeLibrary bridgeLibrary = entry.getKey();
            stringBuilder.append(bridgeLibrary.getBridgeId()).append("\n");
        }
    }
}

