/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.responses;

import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.mimb.executable.handler.BridgeDescription;
import MITI.mimb.executable.responses.Response;
import MITI.util.XmlUtil;
import MITI.util.log.LogEvent;
import MITI.util.xml.SoapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BridgeInformationResponse
extends Response {
    private String bridgeId;
    private String bridgeDisplayName;
    private String bridgeDescription = "";
    private boolean isExport;
    private BridgeSpecification specification;
    private Parameters parameters;

    public BridgeInformationResponse() {
    }

    /*
     * WARNING - void declaration
     */
    public BridgeInformationResponse(String string, Element element) {
        super(string, element);
        this.bridgeId = element.getAttribute("bridgeIdentifier");
        this.bridgeDisplayName = element.getAttribute("bridgeDisplayName");
        this.isExport = element.getAttribute("direction").equals("EXPORT");
        this.bridgeDescription = element.getAttribute("description");
        Element element2 = XmlUtil.getFirstElement(element, "Specification");
        if (element2 != null) {
            this.specification = new BridgeSpecification(element2.getAttribute("productWeb"), element2.getAttribute("productCompany"), element2.getAttribute("productName"), element2.getAttribute("productVersion"), "", "", "", element2.getAttribute("methodology"), this.bridgeId, element2.getAttribute("version"), element2.getAttribute("bridgeTooltip"), element2.getAttribute("isMultiModel").equals("true"), element2.getAttribute("isDriverLiveDownloadEnabled").equals("true"));
        }
        this.parameters = new Parameters();
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, "BridgeParameter");
        if (arrayList != null) {
            for (Element element3 : arrayList) {
                void var20_22;
                String string2;
                String[] stringArray;
                String string3 = element3.getAttribute("bridgeParameterIdentifier");
                String string4 = element3.getAttribute("displayName");
                Parameter.Type type = Parameter.Type.valueOf((String)element3.getAttribute("type"));
                boolean bl = element3.getAttribute("mandatory").equals("true");
                boolean bl2 = element3.getAttribute("deprecated").equals("true");
                String string5 = element3.getAttribute("description");
                boolean bl3 = element3.getAttribute("transferable").equals("true");
                Parameter.OpenMode openMode = Parameter.OpenMode.DEFAULT;
                if (type == Parameter.Type.FILE || type == Parameter.Type.DIRECTORY) {
                    openMode = Parameter.OpenMode.valueOf((String)element3.getAttribute("openMode"));
                }
                LinkedHashMap<String[], String> linkedHashMap = new LinkedHashMap<String[], String>();
                ArrayList<Element> arrayList3 = XmlUtil.getChildElements(element3, "PossibleValue");
                if (arrayList3 != null) {
                    for (Element element4 : arrayList3) {
                        stringArray = element4.getAttribute("identifier");
                        String string6 = XmlUtil.getElementValue(element4);
                        linkedHashMap.put(stringArray, string6);
                    }
                }
                ArrayList arrayList4 = new ArrayList();
                ArrayList<Element> arrayList22 = XmlUtil.getChildElements(element3, "FileExtension");
                if (arrayList22 != null) {
                    for (Element element5 : arrayList22) {
                        arrayList4.add(XmlUtil.getElementValue(element5));
                    }
                }
                stringArray = new String[arrayList4.size()];
                stringArray = arrayList4.toArray(stringArray);
                String string7 = "";
                Element element6 = XmlUtil.getFirstElement(element3, "DefaultValue");
                if (element6 != null && (string2 = XmlUtil.getElementValue(element6)) != null) {
                    String string8 = string2;
                }
                string2 = new Parameter(string3, string4, string5, (String)var20_22, type, bl, bl2, stringArray, openMode, bl3, linkedHashMap);
                this.parameters.addParameter((Parameter)string2);
            }
        }
    }

    public void setBridgeId(String string) {
        this.bridgeId = string;
    }

    public void setBridgeDisplayName(String string) {
        this.bridgeDisplayName = string;
    }

    public void setIsExport(boolean bl) {
        this.isExport = bl;
    }

    public void setSpecification(BridgeSpecification bridgeSpecification) {
        this.specification = bridgeSpecification;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public String getBridgeDisplayName() {
        return this.bridgeDisplayName;
    }

    public boolean isExport() {
        return this.isExport;
    }

    public BridgeSpecification getSpecification() {
        return this.specification;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public String getBridgeDescription() {
        if (this.bridgeDescription.isEmpty()) {
            this.bridgeDescription = BridgeDescription.build(this.bridgeId, this.specification);
        }
        return this.bridgeDescription;
    }

    @Override
    public Element printTo(Node node, Collection<LogEvent> collection) {
        Element element = XmlUtil.appendNewElement(node == null ? this.document : node, null, "GetBridgeInformationResponse");
        element.setAttribute("xmlns", SoapUtil.NS_MIMB_EXE.getUri());
        element.setAttribute("bridgeIdentifier", this.getBridgeId());
        element.setAttribute("bridgeDisplayName", this.getBridgeDisplayName());
        element.setAttribute("direction", this.isExport ? "EXPORT" : "IMPORT");
        element.setAttribute("description", this.getBridgeDescription());
        Element element2 = XmlUtil.appendNewElement(element, null, "Specification");
        element2.setAttribute("version", this.specification.getBridgeVersion());
        element2.setAttribute("methodology", this.specification.getProductMethodology());
        element2.setAttribute("productName", this.specification.getProductName());
        element2.setAttribute("productVersion", this.specification.getProductVersion());
        element2.setAttribute("productCompany", this.specification.getProductCompany());
        element2.setAttribute("productWeb", this.specification.getProductWeb());
        element2.setAttribute("isMultiModel", this.specification.getMultiModel() ? "true" : "false");
        element2.setAttribute("isDriverLiveDownloadEnabled", this.specification.getDriverLiveDownloadEnabled() ? "true" : "false");
        for (Parameter parameter : this.parameters) {
            Object object;
            Object object2;
            Element element3 = XmlUtil.appendNewElement(element, null, "BridgeParameter");
            element3.setAttribute("bridgeParameterIdentifier", parameter.getName());
            element3.setAttribute("displayName", parameter.getDisplayName());
            element3.setAttribute("type", parameter.getType().toString());
            element3.setAttribute("mandatory", parameter.isMandatory() ? "true" : "false");
            element3.setAttribute("deprecated", parameter.isDeprecated() ? "true" : "false");
            element3.setAttribute("description", parameter.getDescription());
            if (parameter.getType() == Parameter.Type.FILE || parameter.getType() == Parameter.Type.DIRECTORY) {
                element3.setAttribute("transferable", parameter.isTransferable() ? "true" : "false");
                element3.setAttribute("openMode", parameter.getOpenMode().toString());
            }
            if (parameter.getType() == Parameter.Type.ENUMERATED) {
                object2 = parameter.getPossibleValues();
                if (object2 != null) {
                    for (String string : object2.keySet()) {
                        object = (String)object2.get(string);
                        Element element4 = XmlUtil.appendNewElement(element3, null, "PossibleValue");
                        element4.setAttribute("identifier", string);
                        XmlUtil.setElementValue(element4, (String)object);
                    }
                }
            } else if ((parameter.getType() == Parameter.Type.FILE || parameter.getType() == Parameter.Type.DIRECTORY) && (object2 = parameter.getFileExtensions()) != null) {
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string;
                    string = (String)iterator.next();
                    object = XmlUtil.appendNewElement(element3, null, "FileExtension");
                    XmlUtil.setElementValue((Element)object, string);
                }
            }
            object2 = XmlUtil.appendNewElement(element3, null, "DefaultValue");
            XmlUtil.setElementValue((Element)object2, parameter.getDefaultValue());
        }
        return element;
    }

    @Override
    public void printTo(StringBuilder stringBuilder) {
        BridgeSpecification bridgeSpecification = this.getSpecification();
        Parameters parameters = this.getParameters();
        String string = this.getBridgeDescription();
        stringBuilder.append("[" + this.getBridgeId() + "]").append("\n");
        stringBuilder.append(string).append("\n");
        stringBuilder.append("[Bridge Specification]").append("\n");
        stringBuilder.append("  version:" + bridgeSpecification.getBridgeVersion()).append("\n");
        stringBuilder.append("  methodology:" + bridgeSpecification.getProductMethodology()).append("\n");
        stringBuilder.append("  productName:" + bridgeSpecification.getProductName()).append("\n");
        stringBuilder.append("  productVersion:" + bridgeSpecification.getProductVersion()).append("\n");
        stringBuilder.append("  productCompany:" + bridgeSpecification.getProductCompany()).append("\n");
        stringBuilder.append("  productWeb:" + bridgeSpecification.getProductWeb());
        stringBuilder.append("  isMultiModel:" + (bridgeSpecification.getMultiModel() ? "1" : "0")).append("\n");
        stringBuilder.append("[Bridge Parameters]");
        for (Parameter parameter : parameters) {
            Object object;
            stringBuilder.append("  [" + parameter.getName() + "]").append("\n");
            stringBuilder.append("    displayName:" + parameter.getDisplayName()).append("\n");
            stringBuilder.append("    type:" + parameter.getType().toString()).append("\n");
            stringBuilder.append("    mandatory:" + (parameter.isMandatory() ? "true" : "false")).append("\n");
            stringBuilder.append("    deprecated:" + (parameter.isDeprecated() ? "true" : "false")).append("\n");
            stringBuilder.append("    description:" + parameter.getDescription()).append("\n");
            if (parameter.getType() == Parameter.Type.FILE || parameter.getType() == Parameter.Type.DIRECTORY) {
                stringBuilder.append("    transferable:" + (parameter.isTransferable() ? "true" : "false")).append("\n");
                stringBuilder.append("    openMode:" + parameter.getOpenMode().toString()).append("\n");
            }
            if (parameter.getType() == Parameter.Type.ENUMERATED) {
                stringBuilder.append("    [Possible Values]").append("\n");
                object = parameter.getPossibleValues();
                if (object != null) {
                    for (String string2 : object.keySet()) {
                        stringBuilder.append("      " + string2).append("\n");
                    }
                }
            } else if (parameter.getType() == Parameter.Type.FILE || parameter.getType() == Parameter.Type.DIRECTORY) {
                stringBuilder.append("    file extensions:");
                object = parameter.getFileExtensions();
                if (object != null) {
                    Iterator<Object> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string2;
                        string2 = (String)iterator.next();
                        stringBuilder.append(string2 + " ");
                    }
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append("    default value:" + parameter.getDefaultValue()).append("\n");
        }
    }
}

