/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.requests;

import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.mimb.executable.requests.Request;
import MITI.util.XmlUtil;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SaveBridgeParametersRequest
extends Request {
    protected String bridgeId = "";
    protected boolean isExport = false;
    protected MimbOptions userOptions = new MimbOptions();

    @Override
    public void parse(Element element) {
        super.parse(element);
        this.bridgeId = element.getAttribute("bridgeIdentifier");
        this.isExport = element.getAttribute("direction").equals("EXPORT");
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, "BridgeParameter");
        for (Element element2 : arrayList) {
            String string = element2.getAttribute("bridgeParameterIdentifier");
            String string2 = XmlUtil.getElementValue(element2);
            String string3 = element2.getAttribute("clientSpecifiedText");
            this.userOptions.addOption(string, string2, string3);
        }
    }

    protected void serialize(Document document, Element element) {
        element.setAttribute("userIdentity", this.userIdentity);
        element.setAttribute("bridgeIdentifier", this.bridgeId);
        element.setAttribute("direction", this.isExport ? "EXPORT" : "IMPORT");
        for (MimbOption mimbOption : this.userOptions) {
            Element element2 = document.createElement("BridgeParameter");
            element.appendChild(element2);
            element2.setAttribute("bridgeParameterIdentifier", mimbOption.getName());
            element2.setAttribute("clientSpecifiedText", mimbOption.getClientSpecifiedText());
            XmlUtil.setElementValue(element2, mimbOption.getValue());
        }
    }

    @Override
    public String toString() {
        Document document;
        try {
            document = XmlUtil.getDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return parserConfigurationException.toString();
        }
        Element element = document.createElement("SaveBridgeParametersRequest");
        document.appendChild(element);
        this.serialize(document, element);
        String string = this.toString(document, element);
        return string;
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public boolean isExport() {
        return this.isExport;
    }

    public void setBridgeId(String string) {
        this.bridgeId = string;
    }

    public void setIsExport(boolean bl) {
        this.isExport = bl;
    }

    public MimbOptions getUserOptions() {
        return this.userOptions;
    }

    public void setUserOptions(MimbOptions mimbOptions) {
        this.userOptions = mimbOptions;
    }
}

