/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.requests;

import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.XmlUtil;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BrowseRequest
extends BridgeRunRequest {
    protected boolean isExport = false;
    protected String browseParameterIdentifier = "";
    protected String browseFile = "";
    protected String logLevel = "";
    protected MIRValidationLevel.Enum validationLevel = MIRValidationLevel.getDefaultLevel();

    @Override
    public void parse(Element element) {
        super.parse(element);
        this.isExport = element.getAttribute("direction").equals("EXPORT");
        this.browseParameterIdentifier = element.getAttribute("browseParameterIdentifier");
        this.browseFile = element.getAttribute("file");
        this.logLevel = element.getAttribute("logLevel");
    }

    @Override
    protected void serialize(Document document, Element element) {
        super.serialize(document, element);
        element.setAttribute("direction", this.isExport ? "EXPORT" : "IMPORT");
        element.setAttribute("browseParameterIdentifier", this.browseParameterIdentifier);
        element.setAttribute("file", this.browseFile);
        element.setAttribute("logLevel", this.logLevel);
    }

    public boolean isExport() {
        return this.isExport;
    }

    public void setIsExport(boolean bl) {
        this.isExport = bl;
    }

    public String getBrowseParameterIdentifier() {
        return this.browseParameterIdentifier;
    }

    public void setBowseParameterIdentifier(String string) {
        this.browseParameterIdentifier = string;
    }

    public String getBrowseFile() {
        return this.browseFile;
    }

    public void setBrowseFile(String string) {
        this.browseFile = string;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String string) {
        this.logLevel = string;
    }

    public void setValidationLevel(MIRValidationLevel.Enum enum_) {
        this.validationLevel = enum_;
    }

    public MIRValidationLevel.Enum getValidationLevel() {
        return this.validationLevel;
    }

    @Override
    public String toString() {
        Document document;
        try {
            document = XmlUtil.getDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return parserConfigurationException.toString();
        }
        Element element = document.createElement("BrowseRequest");
        document.appendChild(element);
        this.serialize(document, element);
        String string = this.toString(document, element);
        return string;
    }
}

