/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.executable.MimbCpp;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Bridge;
import MITI.mimb.executable.actions.BridgeAction;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.requests.TestRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.log.MIRLogger;
import MITI.util.os.MachineInfo;

public class TestAction
extends BridgeAction {
    protected boolean isExport;
    protected String logLevel;

    public TestAction(RequestHandler<?, ?> requestHandler, TestRequest testRequest) {
        super(requestHandler, testRequest, MIRValidationLevel.BASIC);
        this.isExport = testRequest.isExport();
        this.logLevel = testRequest.getLogLevel();
    }

    public TestAction(RequestHandler<?, ?> requestHandler, MITI.mimb.message.mimb.request.TestRequest testRequest) {
        super(requestHandler, testRequest.getBridge(), MIRValidationLevel.BASIC, testRequest.getLanguage());
        this.isExport = testRequest.getBridge().getBridgeId().getDirection() == BridgeId.Direction.EXPORT;
        this.logLevel = String.valueOf(testRequest.getLogLevel());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean run() {
        try (Bridge bridge = Bridge.load(this.env, this.bridgeId, this.isExport, this.bridgeDisplayName);){
            Object object;
            if (bridge == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                return bl;
            }
            if (bridge.getInterface() == null) {
                if (!MachineInfo.isWindows()) {
                    MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(this.bridgeId, MachineInfo.getOsInfo().getName());
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                    return bl;
                }
                object = new TestRequest();
                ((Request)object).setLanguage(this.language);
                ((BridgeRunRequest)object).setBridgeId(this.bridgeId);
                ((BridgeRunRequest)object).setBridgeDisplayName(this.bridgeDisplayName);
                ((BridgeRunRequest)object).setDisableLog(this.disableLog);
                ((BridgeRunRequest)object).setUserOptions(this.userOptions.get());
                ((TestRequest)object).setIsExport(this.isExport);
                ((TestRequest)object).setLogLevel(this.logLevel);
                Response response = MimbCpp.execute((Request)object, this.env.getSetup(), MIRLogger.getLogger(), this.getOemToken());
                if (response != null && !(response instanceof ErrorResponse)) {
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.SUCCESS);
                    return bl;
                }
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                return bl;
            }
            object = this.buildOptions(bridge);
            if (object == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                return bl;
            }
            this.displayBridgeInfo(bridge, (MimbOptions)object);
            MIMB.CALLING_TEST_METHOD.log(new Object[0]);
            BridgeEnvironment bridgeEnvironment = new BridgeEnvironment(this.env.getSetup(), this.getOemToken(), MIRValidationLevel.NONE);
            boolean bl = bridge.getInterface().test(this.bridgeId, (MimbOptions)object, bridgeEnvironment, MIRLogger.getLogger());
            if (!bl) {
                boolean bl2 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                return bl2;
            }
            boolean bl3 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.SUCCESS);
            return bl3;
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(throwable, throwable.getMessage());
            return this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
        }
    }
}

