/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.MIRException;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.messages.MIRBridgeConstants.MBLST;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.requests.GetBridgeSpecsRequest;
import MITI.util.text.BridgeSpecificationLiteral;
import java.util.LinkedHashMap;

public class GetBridgeSpecsAction
extends Action {
    private String bridgeId;
    private boolean isExport;

    public GetBridgeSpecsAction(RequestHandler<?, ?> requestHandler, GetBridgeSpecsRequest getBridgeSpecsRequest) {
        super(requestHandler);
        this.bridgeId = getBridgeSpecsRequest.getBridgeId();
        this.isExport = getBridgeSpecsRequest.isExport();
    }

    public GetBridgeSpecsAction(RequestHandler<?, ?> requestHandler, MITI.mimb.message.mimb.request.GetBridgeSpecsRequest getBridgeSpecsRequest) {
        super(requestHandler);
        this.bridgeId = getBridgeSpecsRequest.getBridgeId();
        this.isExport = getBridgeSpecsRequest.isExport();
    }

    @Override
    public boolean run() {
        LinkedHashMap<BridgeSpecificationLiteral, BridgeLibrary> linkedHashMap = new LinkedHashMap<BridgeSpecificationLiteral, BridgeLibrary>();
        if (this.bridgeId != null && !this.bridgeId.isEmpty()) {
            BridgeSpecificationLiteral bridgeSpecificationLiteral = MBLST.getBridgeSpecification(this.bridgeId, this.isExport);
            if (bridgeSpecificationLiteral != null) {
                linkedHashMap.put(bridgeSpecificationLiteral, this.getBridgeLibrary(bridgeSpecificationLiteral));
            }
        } else {
            for (BridgeSpecificationLiteral bridgeSpecificationLiteral : MBLST.listAllSpecifications()) {
                BridgeLibrary bridgeLibrary = this.getBridgeLibrary(bridgeSpecificationLiteral);
                if (bridgeLibrary == null || !bridgeLibrary.isEnabled()) continue;
                linkedHashMap.put(bridgeSpecificationLiteral, bridgeLibrary);
            }
        }
        return this.handler.buildResponse(linkedHashMap);
    }

    private BridgeLibrary getBridgeLibrary(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
        BridgeLibrary bridgeLibrary = null;
        if (bridgeSpecificationLiteral != null) {
            try {
                if (bridgeSpecificationLiteral.getBridge_Direction().equalsIgnoreCase("Export")) {
                    bridgeLibrary = this.env.getModelBridges().loadBridgeLibrary(bridgeSpecificationLiteral.getBridge_Id(), true);
                } else if (bridgeSpecificationLiteral.getBridge_Direction().equalsIgnoreCase("Import")) {
                    bridgeLibrary = this.env.getModelBridges().loadBridgeLibrary(bridgeSpecificationLiteral.getBridge_Id(), false);
                }
            }
            catch (MIRException mIRException) {
                // empty catch block
            }
        }
        return bridgeLibrary;
    }
}

