/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeInterface;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.converter.MIRBiModelConverter;
import MITI.converter.MIRErModelConverter;
import MITI.converter.MIRErMultiModelConverter;
import MITI.converter.MIRExcelModelConverter;
import MITI.converter.MIRModelConverter;
import MITI.converter.MIRMultiModelConverter;
import MITI.converter.MIRNoModelConverter;
import MITI.converter.etl.MIREtlModelConverter;
import MITI.messages.MIRBridgeConstants.MBLST;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbCpp;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Bridge;
import MITI.mimb.executable.actions.BridgeAction;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.message.mimb.request.BridgeConfig;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import MITI.util.os.MachineInfo;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.File;

public class ExportAction
extends BridgeAction {
    private String logLevel;

    public ExportAction(RequestHandler<?, ?> requestHandler, BridgeRunRequest bridgeRunRequest, MIRValidationLevel.Enum enum_, String string, String string2) {
        super(requestHandler, bridgeRunRequest, enum_);
        this.logLevel = string;
        this.language = string2;
    }

    public ExportAction(RequestHandler<?, ?> requestHandler, BridgeConfig bridgeConfig, MIRValidationLevel.Enum enum_, String string, String string2) {
        super(requestHandler, bridgeConfig, enum_, string2);
        this.logLevel = string;
    }

    public BridgeSpecificationLiteral getBridgeSpec() {
        return MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean run() {
        try (Bridge bridge = Bridge.load(this.env, this.bridgeId, true, this.bridgeDisplayName);){
            Object object;
            if (bridge == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return bl;
            }
            if (this.isMIMBIntermediateStep()) {
                File file;
                MimbOption mimbOption;
                boolean bl = false;
                File file2 = MIRMixManager.getMultiModelFile(this.dir);
                if (file2.exists()) {
                    mimbOption = this.userOptions.getOption("Directory");
                    if (mimbOption == null) {
                        MIMB.GENERAL_ERROR.log("Directory parameter is not set");
                        boolean bl2 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                        return bl2;
                    }
                    file = new File(mimbOption.getValue());
                    bl = FileUtil.move(this.dir, file);
                    if (!bl) {
                        BLIB.DBG_ERROR_COPYING_FILE.log(this.dir.getPath(), file.getPath());
                    }
                    this.dir = file;
                } else {
                    File file3;
                    mimbOption = this.userOptions.getOption("File");
                    if (mimbOption == null) {
                        mimbOption = this.userOptions.getOption("Directory");
                        if (mimbOption == null) {
                            MIMB.GENERAL_ERROR.log("File parameter is not set");
                            boolean bl3 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                            return bl3;
                        }
                        file = new File(mimbOption.getValue());
                        file3 = new File(file, "model.xml");
                        mimbOption.setValue(file3.getPath());
                    }
                    file = MIRMixManager.getModelFile(this.dir);
                    file3 = new File(mimbOption.getValue());
                    MIMB.DBG_MOVING_FILES.log(file.getPath(), file3.getPath());
                    bl = FileUtil.move(file, file3);
                    if (!bl) {
                        BLIB.DBG_ERROR_COPYING_FILE.log(file.getPath(), file3.getPath());
                    }
                }
                boolean bl4 = this.handler.buildResponse(bl ? MimbExecutable.MIMBReturnCode.SUCCESS : MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return bl4;
            }
            BridgeSpecificationLiteral bridgeSpecificationLiteral = MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)true);
            MIRModelConverter mIRModelConverter = this.getConverter(bridgeSpecificationLiteral, bridge.getInterface());
            if (mIRModelConverter != null) {
                object = this.userOptions.getOptionValue("Connection");
                mIRModelConverter.setSubsetValue((String)object);
                if (!mIRModelConverter.run(this.dir)) {
                    MIMB.GENERAL_ERROR.log("Failed to convert model");
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                    return bl;
                }
            } else {
                MIMB.DBG_NO_CONVERTER.log(new Object[0]);
            }
            if (bridge.getInterface() == null) {
                if (!MachineInfo.isWindows()) {
                    MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(this.bridgeId, MachineInfo.getOsInfo().getName());
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                    return bl;
                }
                object = new BridgeRunRequest();
                ((Request)object).setLanguage("");
                ((BridgeRunRequest)object).setBridgeId("MetaIntegrationMultiModelXml");
                ((BridgeRunRequest)object).setBridgeDisplayName("MIMB Intermediate Step");
                MimbOptions mimbOptions = new MimbOptions();
                mimbOptions.addOption("Directory", this.dir.getPath(), "");
                ((BridgeRunRequest)object).setUserOptions(mimbOptions);
                ((BridgeRunRequest)object).setDisableLog(true);
                BridgeRunRequest bridgeRunRequest = new BridgeRunRequest();
                bridgeRunRequest.setLanguage("");
                bridgeRunRequest.setBridgeId(this.bridgeId);
                bridgeRunRequest.setBridgeDisplayName(this.bridgeDisplayName);
                bridgeRunRequest.setUserOptions(this.userOptions.get());
                bridgeRunRequest.setDisableLog(this.disableLog);
                RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
                runMimbExtendedRequest.setLanguage(this.language);
                runMimbExtendedRequest.setImportRequest((BridgeRunRequest)object);
                runMimbExtendedRequest.setExportRequest(bridgeRunRequest);
                runMimbExtendedRequest.setValidationLevel(this.validationLevel);
                runMimbExtendedRequest.setCommandLineFile("");
                runMimbExtendedRequest.setLogLevel(this.logLevel);
                Response response = MimbCpp.execute(runMimbExtendedRequest, this.env.getSetup(), MIRLogger.getLogger(), this.getOemToken());
                if (response != null && !(response instanceof ErrorResponse)) {
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.SUCCESS);
                    return bl;
                }
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return bl;
            }
            object = this.buildOptions(bridge);
            if (object == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return bl;
            }
            this.displayBridgeInfo(bridge, (MimbOptions)object);
            MIMB.CALLING_RUN_METHOD.log(new Object[0]);
            BridgeEnvironment bridgeEnvironment = new BridgeEnvironment(this.env.getSetup(), this.getOemToken(), MIRValidationLevel.NONE);
            boolean bl = bridge.getInterface().run(this.bridgeId, this.dir, (MimbOptions)object, bridgeEnvironment, MIRLogger.getLogger());
            if (!bl) {
                boolean bl5 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return bl5;
            }
            MIMB.TOOL_MODEL_EXPORTED.log(this.getCurrentDate());
            boolean bl6 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.SUCCESS);
            return bl6;
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(throwable, throwable.getMessage());
            return this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
        }
    }

    private MIRModelConverter getConverter(BridgeSpecificationLiteral bridgeSpecificationLiteral, BridgeInterface bridgeInterface) {
        Object object = null;
        if (bridgeSpecificationLiteral != null) {
            if (bridgeInterface != null && bridgeSpecificationLiteral.getBridge_Id().equals(MBLST.BRIDGE_SPEC_EMBARCADEROERSTUDIODM1_EXPORT.getBridge_Id())) {
                return null;
            }
            object = bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Business Intelligence") ? new MIRBiModelConverter() : (bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Data Integration") ? (bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel() ? new MIREtlModelConverter() : new MIRErModelConverter()) : (bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Metadata Management") ? (bridgeSpecificationLiteral.getTool_Name().equals("Metadata Excel Format") ? new MIRExcelModelConverter() : (bridgeSpecificationLiteral.getBridge_Id().equals("MicrosoftAzureDataCatalog") || bridgeSpecificationLiteral.getBridge_Id().equals("ApacheAtlas") ? new MIRNoModelConverter() : (bridgeSpecificationLiteral.getVendor_Id().equals("MITI") ? new MIRNoModelConverter() : (bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel() ? new MIRMultiModelConverter() : new MIRErModelConverter())))) : (bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel() ? new MIRErMultiModelConverter() : new MIRErModelConverter())));
        }
        return object;
    }
}

