/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.CloudIdentity.CloudProvider;
import MITI.CloudIdentity.CloudProviderType;
import MITI.CloudIdentity.MIRCloudIdentity;
import MITI.MIRException;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.actions.Bridge;
import MITI.mimb.executable.actions.BrowseAction;
import MITI.mimb.executable.actions.ExportAction;
import MITI.mimb.executable.actions.ImportAction;
import MITI.mimb.executable.actions.ImportGenericOperationAction;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.message.mimb.request.BridgeConfig;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.Encryption;
import MITI.util.MiscParams;
import MITI.util.StringUtil;
import MITI.util.VersionInfo;
import MITI.util.file.FileUtil;
import MITI.util.text.MessageLiteral;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BridgeAction
extends Action {
    private static final String MASK = "******";
    protected String bridgeId;
    protected String bridgeDisplayName;
    protected MIRValidationLevel.Enum validationLevel;
    protected String language;
    private static final Collection<String> MISC_INTERNAL_OPTIONS = Arrays.asList("-dp", "-dpo", "-dpt", "-dpv", "-dps", "-Informatica", "-purview");
    private static final Pattern MISC_PARAM_KEY = Pattern.compile("^(-[^\\s]++)(.*+)$", 8);
    private static final String MIMB_ENCRYPTED_PASSWORD_START = "$MIMB_Encrypted_Start$";
    private static final String MIMB_ENCRYPTED_PASSWORD_END = "$MIMB_Encrypted_End$";

    public BridgeAction(RequestHandler<?, ?> requestHandler, BridgeRunRequest bridgeRunRequest, MIRValidationLevel.Enum enum_) {
        super(requestHandler);
        this.bridgeId = bridgeRunRequest.getBridgeId();
        this.bridgeDisplayName = bridgeRunRequest.getBridgeDisplayName();
        this.userOptions.add(bridgeRunRequest.getUserOptions());
        this.disableLog = bridgeRunRequest.getDisablelog() || this.isMIMBIntermediateStep();
        this.validationLevel = enum_;
        this.language = bridgeRunRequest.getLanguage();
    }

    public BridgeAction(RequestHandler<?, ?> requestHandler, BridgeConfig bridgeConfig, MIRValidationLevel.Enum enum_, String string) {
        super(requestHandler);
        this.bridgeId = bridgeConfig.getBridgeId().getId();
        this.bridgeDisplayName = bridgeConfig.getBridgeDisplayName();
        this.userOptions.add(bridgeConfig.getBridgeOptions());
        this.disableLog = this.isMIMBIntermediateStep();
        this.validationLevel = enum_;
        this.language = string;
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public String getBridgeDisplayName() {
        return this.bridgeDisplayName;
    }

    public MIRValidationLevel.Enum getValidationLevel() {
        return this.validationLevel;
    }

    public String getLanguage() {
        return this.language;
    }

    public final boolean isMIMBIntermediateStep() {
        return BridgeAction.isMitiBridge(this.bridgeId) && this.bridgeDisplayName.equals("MIMB Intermediate Step") && this.userOptions.getCount() == 1 && (this.userOptions.getOption("File") != null || this.userOptions.getOption("Directory") != null);
    }

    protected MimbOptions buildOptions(Bridge bridge) throws MIRException {
        Object object102;
        Object object2;
        Object object3;
        Object object422;
        boolean bl = true;
        boolean bl2 = this instanceof ImportAction || this instanceof ImportGenericOperationAction;
        boolean bl3 = this instanceof ExportAction;
        MimbOptions mimbOptions = new MimbOptions();
        for (Object object422 : bridge.getInterface().getParameters()) {
            object3 = mimbOptions.addOption((Parameter)object422);
            object2 = this.getOption(this.userOptions.get(), (MimbOption)object3);
            if (object2 != null) {
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                object2.setParameter((Parameter)object422);
                object102 = this.getValue((Parameter)object422, (MimbOption)object2);
                if (object102 == null) {
                    MIMB.TOOL_INVALID_BRIDGE_OPTION_VALUE.log(object2.getName(), object2.getValue());
                    continue;
                }
                object3.setValue((String)object102);
                if (object422.getType() == Parameter.Type.FILE || object422.getType() == Parameter.Type.DIRECTORY) {
                    object3.setClientSpecifiedText(object2.getClientSpecifiedText());
                    if (object422.isMandatory()) {
                        if (bl2) {
                            if (object422.getOpenMode() != Parameter.OpenMode.WRITE && !((File)(object9 = new File((String)object102))).exists()) {
                                BLIB.ERR_MISSING_REQUIRED_FILE.log(object102);
                                bl = false;
                            }
                        } else if (bl3 && object422.getType() == Parameter.Type.FILE && object422.getOpenMode() != Parameter.OpenMode.READ) {
                            object9 = new File((String)object102);
                            object8 = ((File)object9).getParentFile();
                            if (object8 != null && !((File)object8).isDirectory()) {
                                BLIB.ERR_MISSING_REQUIRED_FILE.log(((File)object8).getPath());
                                bl = false;
                            } else if (((File)object9).exists() && !((File)object9).canWrite()) {
                                BLIB.ERR_FILE_NOT_WRITABLE.log(object102);
                                bl = false;
                            }
                        }
                    }
                }
                if (!"Miscellaneous".equals(object3.getName()) || ((String)object102).isEmpty()) continue;
                object9 = MiscParams.validate((String)object102);
                object9.keySet().removeAll(MISC_INTERNAL_OPTIONS);
                object8 = MISC_PARAM_KEY.matcher(object422.getDescription());
                while (((Matcher)object8).find()) {
                    int n;
                    object7 = ((Matcher)object8).group(1);
                    object6 = ((Matcher)object8).group(2).trim();
                    Collection collection = (Collection)object9.remove(((Matcher)object8).group(1));
                    if (collection == null) continue;
                    if (((String)object6).endsWith(")") && (n = ((String)object6).lastIndexOf(40)) != -1) {
                        object6 = ((String)object6).substring(0, n).trim();
                    }
                    int n2 = n = ((String)object6).contains("=") || ((String)object6).endsWith("...") ? 1 : 0;
                    if (collection.size() > 1 && n == 0) {
                        MIMB.TOOL_MULTI_VALUED_MISC_OPTION.log(object422.getDisplayName(), object7);
                    }
                    for (String string : collection) {
                        if (string == null && !((String)object6).isEmpty()) {
                            MIMB.TOOL_EMPTY_MISC_OPTION.log(object422.getDisplayName(), object7);
                            continue;
                        }
                        if (string == null || !((String)object6).isEmpty()) continue;
                        MIMB.TOOL_NON_EMPTY_MISC_OPTION.log(object422.getDisplayName(), object7, string);
                    }
                }
                object7 = (Collection)object9.remove("#");
                for (Map.Entry entry : object9.entrySet()) {
                    MIMB.TOOL_UNSUPPORTED_MISC_OPTION.log(object422.getDisplayName(), entry.getKey());
                }
                if (object7 == null) continue;
                object6 = object7.iterator();
                while (object6.hasNext()) {
                    String string = (String)object6.next();
                    MIMB.TOOL_INVALID_MISC_OPTION.log(object422.getDisplayName(), string);
                }
                continue;
            }
            if (!object422.isMandatory() || (object422.getType() == Parameter.Type.REPOSITORY_MODEL || object422.getType() == Parameter.Type.REPOSITORY_SUBSET) && this instanceof BrowseAction) continue;
            MIMB.TOOL_INVALID_MANDATORY_OPTION.log(object3.getName());
            bl = false;
        }
        for (Object object422 : this.userOptions.get()) {
            if (object422.getName().startsWith("__") || mimbOptions.getOption(object422.getName()) != null) continue;
            MIMB.TOOL_INVALID_BRIDGE_OPTION.log(object422.getName());
        }
        Iterator iterator = mimbOptions.getOption("Miscellaneous");
        object422 = null;
        if (iterator != null) {
            object422 = MiscParams.parse(iterator.getValue());
            if (bl2) {
                if (this.env.getTroubleshootingPackage() != null && !((MiscParams)object422).contains("-backup")) {
                    ((MiscParams)object422).addValue("-backup", this.env.getTroubleshootingPackage().getBackupFolder().getAbsolutePath());
                    iterator.setValue(((MiscParams)object422).toString());
                }
                if (((MiscParams)object422).contains("-java.memory")) {
                    this.setMiscParams((MiscParams)object422);
                }
            } else if (bl3 && this.getMiscParams() != null && !((MiscParams)object422).contains("-java.memory")) {
                ((MiscParams)object422).addValue("-java.memory", this.getMiscParams().getValue("-java.memory"));
                iterator.setValue(((MiscParams)object422).toString());
            }
        }
        if (this.env.getTroubleshootingPackage() != null) {
            object3 = new ArrayList();
            if (object422 != null) {
                object2 = null;
                if (bl2) {
                    object2 = ((MiscParams)object422).getValue("-backup");
                } else if (bl3) {
                    object2 = ((MiscParams)object422).getValue("-backup.only");
                }
                if (object2 != null && !((String)object2).isEmpty()) {
                    ((ArrayList)object3).add(new File((String)object2));
                }
            }
            for (Object object102 : mimbOptions) {
                if (object102.getValue().isEmpty() || !object102.getParameter().isTransferable() || object102.getParameter().getType() != Parameter.Type.FILE && object102.getParameter().getType() != Parameter.Type.DIRECTORY || (!bl2 || object102.getParameter().getOpenMode() == Parameter.OpenMode.WRITE) && (!bl3 || object102.getParameter().getOpenMode() == Parameter.OpenMode.READ)) continue;
                ((ArrayList)object3).add(new File(object102.getValue()));
            }
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                object102 = (File)object2.next();
                if (bl2) {
                    this.env.getTroubleshootingPackage().addImportFile((File)object102);
                    continue;
                }
                if (!bl3) continue;
                this.env.getTroubleshootingPackage().addExportFile((File)object102);
            }
        }
        return bl ? mimbOptions : null;
    }

    private MimbOption getOption(MimbOptions mimbOptions, MimbOption mimbOption) {
        MimbOption mimbOption2 = mimbOptions.getOption(mimbOption.getName());
        if (mimbOption2 == null && ("File".equals(mimbOption.getName()) || "Directory".equals(mimbOption.getName()))) {
            mimbOption2 = mimbOptions.getOption("File/Directory");
        }
        return mimbOption2;
    }

    private String getValue(Parameter parameter, MimbOption mimbOption) {
        String string = mimbOption.getValue();
        if (!parameter.isPossibleValue(string)) {
            if (!string.isEmpty() && parameter.getType() == Parameter.Type.FILE) {
                MIMB.TOOL_INVALID_FILE_EXTENSION.log(string, StringUtil.join(parameter.getFileExtensions()));
            } else {
                return null;
            }
        }
        if (!string.isEmpty()) {
            String string2;
            File file;
            File file2;
            if (parameter.getType() == Parameter.Type.PASSWORD) {
                Object object;
                if (string.startsWith(MIMB_ENCRYPTED_PASSWORD_START) && string.endsWith(MIMB_ENCRYPTED_PASSWORD_END)) {
                    object = Encryption.decrypt(Encryption.hexToBytes(string.substring(MIMB_ENCRYPTED_PASSWORD_START.length(), string.length() - MIMB_ENCRYPTED_PASSWORD_END.length())));
                    string = new String((byte[])object, 8, ((CloudProviderType)object).length - 8, FileUtil.UTF8);
                }
                if ((object = CloudProviderType.get((String)string)) != null) {
                    try {
                        string = MIRCloudIdentity.getSecret((MIRSetup)this.env.getSetup(), (CloudProviderType)object, (CloudProvider.Service)CloudProvider.Service.SECRET, (String)string, null);
                    }
                    catch (Exception exception) {
                        MIMB.TOOL_INVALID_BRIDGE_OPTION_VALUE.log(mimbOption.getName(), MASK);
                    }
                }
                return string;
            }
            if (parameter.getType() == Parameter.Type.FILE) {
                File file3 = new File(string);
                if (file3.exists() && !file3.isFile()) {
                    return null;
                }
            } else if (parameter.getType() == Parameter.Type.DIRECTORY) {
                File file4 = new File(string);
                if (file4.exists() && !file4.isDirectory()) {
                    return null;
                }
            } else if ((parameter.getType() == Parameter.Type.STRING || parameter.getType() == Parameter.Type.REPOSITORY_MODEL || parameter.getType() == Parameter.Type.REPOSITORY_SUBSET) && FileUtil.isSubPath(file2 = this.env.getSetup().getDataParamsDirectory(), string) && (file = new File(file2, string)).exists() && file.isFile() && file.canRead() && (string2 = FileUtil.readContent(file, StandardCharsets.UTF_8)) != null) {
                return string2;
            }
        }
        return string;
    }

    protected void displayBridgeInfo(Bridge bridge, MimbOptions mimbOptions) {
        MessageLiteral messageLiteral;
        MessageLiteral messageLiteral2;
        MessageLiteral messageLiteral3;
        if (bridge.isExport()) {
            messageLiteral3 = MIMB.TOOL_EXPORT_SPECIFICATION;
            messageLiteral2 = MIMB.TOOL_MODEL_EXPORT;
            messageLiteral = MIMB.TOOL_EXPORT_BRIDGE;
        } else {
            messageLiteral3 = MIMB.TOOL_IMPORT_SPECIFICATION;
            messageLiteral2 = MIMB.TOOL_MODEL_IMPORT;
            messageLiteral = MIMB.TOOL_IMPORT_BRIDGE;
        }
        VersionInfo versionInfo = VersionInfo.loadMitiJar(bridge.getInterface().getClass());
        messageLiteral3.log(bridge.getBridgeSpecs().getVendor_Name(), bridge.getBridgeSpecs().getTool_Name(), bridge.getBridgeSpecs().getTool_Versions(), bridge.getBridgeSpecs().getTool_Web());
        messageLiteral2.log(bridge.getBridgeSpecs().getMethodology_Summary(), bridge.getDisplayName(), this.getCurrentDate());
        messageLiteral.log(bridge.getBridgeId(), versionInfo != null ? versionInfo.toString() : "");
        for (MimbOption mimbOption : mimbOptions) {
            Parameter parameter = mimbOption.getParameter();
            String string = parameter.getDisplayName();
            if (!mimbOption.getName().equals(string)) {
                string = string + " (" + mimbOption.getName() + ")";
            }
            String string2 = this.getDisplayValue(mimbOption, parameter);
            if (!mimbOption.getValue().equals(string2)) {
                string2 = string2 + " (" + mimbOption.getValue() + ")";
            }
            if (parameter.getType() == Parameter.Type.PASSWORD) {
                string2 = MASK;
            } else if (parameter.getType() == Parameter.Type.STRING) {
                if ("Miscellaneous".equals(parameter.getName())) {
                    string2 = BridgeAction.hideSensitivePasswords(string2);
                }
            } else if (!(parameter.getType() != Parameter.Type.FILE && parameter.getType() != Parameter.Type.DIRECTORY || mimbOption.getClientSpecifiedText().isEmpty())) {
                string2 = mimbOption.getClientSpecifiedText();
            }
            MIMB.TOOL_BRIDGE_PARAMETER.log(string, string2);
        }
    }

    private static String hideSensitivePasswords(String string) {
        boolean bl = false;
        MiscParams miscParams = MiscParams.parse(string);
        MiscParams miscParams2 = MiscParams.parse("");
        ArrayList<String> arrayList = new ArrayList<String>(miscParams.getKeys());
        for (String string2 : arrayList) {
            Map<String, String> map = miscParams.getMappedValues(string2);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string3 = entry.getKey();
                String string4 = entry.getValue();
                if (string4 == null) {
                    if (BridgeAction.isSensitivePassword(string2) || string3 != null && BridgeAction.isSensitivePassword(string3)) {
                        miscParams2.addValue(string2, MASK);
                        bl = true;
                        continue;
                    }
                    miscParams2.addValue(string2, string3);
                    continue;
                }
                if (BridgeAction.isSensitivePassword(string3)) {
                    miscParams2.addValue(string2, string3 + "=" + MASK);
                    bl = true;
                    continue;
                }
                miscParams2.addValue(string2, string3 + "=" + string4);
            }
        }
        String string5 = bl ? miscParams2.toString() : string;
        return string5;
    }

    private static boolean isSensitivePassword(String string) {
        String[] stringArray;
        String string2 = string.toLowerCase();
        for (String string3 : stringArray = new String[]{"password", "passwd"}) {
            if (!string2.contains(string3)) continue;
            return true;
        }
        return false;
    }

    private String getDisplayValue(MimbOption mimbOption, Parameter parameter) {
        if (parameter.getType() == Parameter.Type.ENUMERATED || parameter.getType() == Parameter.Type.BOOLEAN) {
            return parameter.getDisplayPossibleValue(mimbOption.getValue());
        }
        return mimbOption.getValue();
    }
}

