/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.mimb.executable.MimbEnv;
import MITI.mimb.executable.actions.UserOptions;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.oem.OEM;
import MITI.util.DateUtil;
import MITI.util.MiscParams;
import MITI.util.log.BufferedLogger;
import MITI.util.log.LogEvent;
import MITI.util.log.MIRLogger;
import java.io.File;

public abstract class Action {
    public static final String BO_FILE = "File";
    public static final String BO_DIRECTORY = "Directory";
    public static final String BO_MISCELLANEOUS = "Miscellaneous";
    public static final String BO_FILE_DIRECTORY = "File/Directory";
    protected MimbEnv env;
    protected RequestHandler<?, ?> handler;
    protected boolean disableLog;
    protected File dir;
    protected UserOptions userOptions = new UserOptions();
    private MiscParams miscParams = null;

    public Action(RequestHandler<?, ?> requestHandler) {
        this.env = requestHandler.getEnv();
        this.handler = requestHandler;
        this.disableLog = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        boolean bl = true;
        MIRLogger mIRLogger = MIRLogger.getLogger();
        BufferedLogger bufferedLogger = new BufferedLogger();
        bufferedLogger.setLocalLevel(mIRLogger.getLevel());
        try {
            if (this.disableLog) {
                MIRLogger.setLogger(bufferedLogger);
            }
            bl = this.run();
        }
        finally {
            if (this.disableLog && !bl) {
                for (LogEvent logEvent : bufferedLogger.getEvents()) {
                    mIRLogger.log(logEvent);
                }
                bufferedLogger.clearEvents();
            }
            MIRLogger.setLogger(mIRLogger);
            this.userOptions.restore();
        }
        return bl;
    }

    protected abstract boolean run();

    protected String getOemToken() {
        return OEM.getOemToken(this.env.getOemCode());
    }

    public File getDirectory() {
        return this.dir;
    }

    public void setDirectory(File file) {
        this.dir = file;
    }

    public MiscParams getMiscParams() {
        return this.miscParams;
    }

    public void setMiscParams(MiscParams miscParams) {
        this.miscParams = miscParams;
    }

    public String getCurrentDate() {
        return "<" + DateUtil.formatSimpleDate(System.currentTimeMillis(), false) + ">";
    }

    public static boolean isMitiBridge(String string) {
        return string.equals("MetaIntegrationXml") || string.equals("MetaIntegrationMultiModelXml") || string.equals("MetaIntegrationXmlExport.MetaIntegrationDataModelXml");
    }
}

