/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable;

import MITI.bridges.mimb.MIRSetup;
import MITI.bridges.mimb.MimbMessageLogOutputStream;
import MITI.bridges.mimb.MimbUtf8PrintStream;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.responses.Response;
import MITI.util.ProcessBuilder;
import MITI.util.config.MitiDebug;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import MITI.util.os.MachineInfo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;

public class MimbCpp {
    private static File getMimbCppHomeDir(File file) {
        File file2;
        if (MitiDebug.getFlag(MitiDebug.Flag.CPP_DEBUG_DIR) && (file2 = new File(file.getParentFile(), "_Debug")).isDirectory()) {
            return file2;
        }
        return file;
    }

    public static Response execute(Request request, MIRSetup mIRSetup, MIRLogger mIRLogger, String string) throws IOException {
        File file = mIRSetup.getHomeDirectory();
        File file2 = MimbCpp.getMimbCppHomeDir(file);
        File file3 = new File(file2, "bin");
        File file4 = new File(file2, "lib");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PATH", file3.getPath() + File.pathSeparator + System.getenv("PATH"));
        hashMap.put("MIR_I18N_LANG", request.getLanguage());
        hashMap.put("MITI_OEM_CALLER_ID", string);
        hashMap.put("MIR_LOG_LEVEL", String.valueOf(mIRLogger.getLevel()));
        hashMap.put("LD_LIBRARY_PATH", file4.getPath() + File.pathSeparator + System.getenv("LD_LIBRARY_PATH"));
        MitiDebug.setFlags(hashMap);
        File file5 = File.createTempFile("mimbResponse", ".xml", mIRSetup.getTempDirectory());
        file5.deleteOnExit();
        ProcessBuilder processBuilder = new ProcessBuilder().setArguments(new File(file3, "MIMB" + (MachineInfo.isWindows() ? ".exe" : "")).getPath(), "-r", "STDIN", "-y", file5.getAbsolutePath()).setEnvironmentVariables(hashMap).setBaseDirectory(file3).setInputStream(request.toString()).setOutputStream((PrintStream)new MimbUtf8PrintStream((OutputStream)new MimbMessageLogOutputStream(mIRLogger))).redirectErrToOut(true).setCharset(FileUtil.UTF8);
        int n = processBuilder.exec();
        if (n < -6 || n > 12) {
            MBCM.ERR_MIMB_EXE.log(mIRLogger, n);
            return null;
        }
        String string2 = FileUtil.readContent(file5, FileUtil.UTF8);
        file5.delete();
        return Response.parse(string2, mIRLogger);
    }
}

