/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Isomer;
import com.sas.sxle.map.Sample;
import com.sas.sxle.map.Schema;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class XSDTreeModel
implements TreeModel {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private Vector<TreeModelListener> m_treeModelListeners = new Vector();
    Schema m_root;

    public XSDTreeModel() {
        Schema s = new Schema();
        s.setName(res.getString("SchemaDefaultName.txt"));
        this.m_root = s;
    }

    public XSDTreeModel(Schema root) {
        this.m_root = root;
    }

    @Override
    public Object getRoot() {
        return this.m_root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        assert (parent != null);
        assert (index >= 0);
        if (parent instanceof Schema) {
            return ((Schema)parent).getFilteredChildren().get(index);
        }
        Isomer i = (Isomer)parent;
        int n = i.getChildren().size();
        assert (index <= n);
        if (i.hasSample()) {
            if (index == 0) {
                return i.getSample();
            }
            --index;
        }
        return i.getChildren().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (!(parent instanceof Isomer)) {
            return 0;
        }
        if (parent instanceof Schema) {
            return ((Schema)parent).getFilteredChildCount();
        }
        Isomer i = (Isomer)parent;
        int n = i.getChildren().size();
        if (i.hasSample()) {
            ++n;
        }
        return n;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof Sample) {
            return true;
        }
        return this.getChildCount(node) <= 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (!(parent instanceof Isomer)) {
            return -1;
        }
        if (parent instanceof Schema) {
            return ((Schema)parent).getFilteredChildren().indexOf(child);
        }
        Isomer m = (Isomer)parent;
        if (m.hasSample() && child instanceof Sample) {
            return 0;
        }
        return m.getChildren().indexOf(child);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener tml) {
        this.m_treeModelListeners.remove(tml);
    }

    @Override
    public void addTreeModelListener(TreeModelListener tml) {
        this.m_treeModelListeners.add(tml);
    }

    public void fireTreeNodesChanged(TreeModelEvent e) {
        Enumeration<TreeModelListener> listeners = this.m_treeModelListeners.elements();
        while (listeners.hasMoreElements()) {
            TreeModelListener listener = listeners.nextElement();
            listener.treeNodesChanged(e);
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent e) {
        Enumeration<TreeModelListener> listeners = this.m_treeModelListeners.elements();
        while (listeners.hasMoreElements()) {
            TreeModelListener listener = listeners.nextElement();
            listener.treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        Enumeration<TreeModelListener> listeners = this.m_treeModelListeners.elements();
        while (listeners.hasMoreElements()) {
            TreeModelListener listener = listeners.nextElement();
            listener.treeNodesRemoved(e);
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        Enumeration<TreeModelListener> listeners = this.m_treeModelListeners.elements();
        while (listeners.hasMoreElements()) {
            TreeModelListener listener = listeners.nextElement();
            listener.treeStructureChanged(e);
        }
    }

    public void debugDump() {
    }

    private void debugDump(Isomer p, int nestLevel) {
    }
}

