/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Counter;
import com.sas.sxle.map.Isomer;
import com.sas.sxle.map.LogItem;
import com.sas.sxle.map.Logger;
import com.sas.sxle.map.Namespace;
import com.sas.sxle.map.NamespaceList;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Schema;
import com.sas.sxle.map.Tuple;
import com.sas.sxle.map.XSDTreeModel;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;

public class XSDParser
implements XMLErrorHandler {
    private static HashMap<String, Counter> m_refCount;
    static ResourceBundle res;
    private File m_file;
    private Schema m_root = null;
    private NamespaceList m_namespaces = new NamespaceList();
    int m_prefixCount = 0;
    private ArrayList<Tuple> m_recurseTags = new ArrayList();
    private long howMany = 0L;

    public XSDTreeModel parse(File schemaFile) {
        this.m_file = schemaFile;
        m_refCount = new HashMap();
        this.m_prefixCount = 0;
        this.m_root = new Schema();
        XSDTreeModel xsdTreeM = new XSDTreeModel(this.m_root);
        String uri = schemaFile.toURI().toASCIIString();
        XMLInputSource xis = new XMLInputSource(null, uri, null);
        this.m_root.setName(schemaFile.getName());
        this.m_root.setType(0);
        XMLGrammarPreparser xgpp = new XMLGrammarPreparser();
        xgpp.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        xgpp.setErrorHandler((XMLErrorHandler)this);
        if (SXLEContext.validationLevel() != 10) {
            xgpp.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        try {
            Grammar g = xgpp.preparseGrammar("http://www.w3.org/2001/XMLSchema", xis);
            if (g == null) {
                String msg = MessageFormat.format(res.getString("MsgErrBadSchema.txt"), uri);
                Logger.log(new LogItem(msg, null, 1));
                return null;
            }
            XSModel xsm = ((XSGrammar)g).toXSModel();
            XSNamespaceItemList nsil = xsm.getNamespaceItems();
            if (nsil != null) {
                for (int n = 0; n < nsil.getLength(); ++n) {
                    this.tryAddNamespace(nsil.item(n));
                }
            }
            XSNamedMap xnm = xsm.getComponents((short)2);
            for (int i = 0; i < xnm.getLength(); ++i) {
                XSObject o = xnm.item(i);
                if (!(o instanceof XSElementDeclaration)) continue;
                XSElementDeclaration xsed = (XSElementDeclaration)o;
                Isomer child = new Isomer();
                child.setName(xsed.getName());
                this.count(child);
                child.setParent(this.m_root);
                child.setType(1);
                String ns = xsed.getNamespace();
                if (ns != null) {
                    child.setNamespace(this.m_namespaces.lookupNamespace(ns));
                }
                XSTypeDefinition xstd = xsed.getTypeDefinition();
                XSComplexTypeDecl xctd = null;
                child.setLength(this.getLengthFacet(xstd));
                child.setEnum(this.getEnumFacet(xstd));
                if (xstd instanceof XSComplexTypeDecl) {
                    xctd = (XSComplexTypeDecl)xstd;
                    XSAttributeGroupDecl xsagd = xctd.getAttrGrp();
                    if (xsagd != null) {
                        this.addSchemaAttrs(child, xsagd);
                    }
                    XSParticle xsp = xctd.getParticle();
                    this.addSchemaChild(child, xsp);
                } else {
                    String typeName = xstd.getName();
                    if (typeName == null) {
                        typeName = xstd.getBaseType().getName();
                    }
                    child.setXSDDatatype(typeName);
                }
                child = this.m_root.tryAddChild(child);
            }
            this.propagateNodes(this.m_root);
        }
        catch (IOException exception) {
            ArrayList<Tuple> details = new ArrayList<Tuple>();
            details.add(new Tuple(res.getString("MsgExClass.txt"), exception.getClass().getName()));
            details.add(new Tuple(res.getString("MsgExMsg.txt"), exception.getLocalizedMessage()));
            String msg = MessageFormat.format(res.getString("MsgErrParseXSDErr.txt"), uri);
            Logger.log(new LogItem(msg, details, 1));
            return null;
        }
        catch (XMLParseException exception) {
            ArrayList<Tuple> details = this.saxExceptionDetail(exception);
            String msg = MessageFormat.format(res.getString("MsgErrParseXSDErr.txt"), uri);
            Logger.log(new LogItem(msg, details, 1));
            return null;
        }
        catch (OutOfMemoryError exception) {
            ArrayList<Tuple> details = new ArrayList<Tuple>();
            details.add(new Tuple(res.getString("MsgExClass.txt"), exception.getClass().getName()));
            details.add(new Tuple(res.getString("MsgExMsg.txt"), exception.getLocalizedMessage()));
            String msg = MessageFormat.format(res.getString("MsgErrParseXSDErr.txt"), uri);
            Logger.log(new LogItem(msg, details, 1));
            return null;
        }
        xsdTreeM.debugDump();
        if (this.m_root.isRecursive()) {
            String msg = MessageFormat.format(res.getString("MsgInfoSchemaRecursive.txt"), uri);
            ArrayList<Tuple> details = new ArrayList<Tuple>();
            for (int i = 0; i < this.m_recurseTags.size(); ++i) {
                int val = Integer.parseInt(this.m_recurseTags.get(i).getValue());
                String msg2 = val > 1 ? MessageFormat.format(res.getString("MsgRecursivePluralItem.txt"), val) : res.getString("MsgRecursiveItem.txt");
                details.add(new Tuple(this.m_recurseTags.get(i).getAttribute(), msg2));
            }
            Logger.log(new LogItem(msg, details, 3));
        }
        return xsdTreeM;
    }

    private ArrayList<Tuple> saxExceptionDetail(XMLParseException ex) {
        ArrayList<Tuple> details = new ArrayList<Tuple>();
        details.add(new Tuple(res.getString("MsgExClass.txt"), ((Object)((Object)ex)).getClass().getName()));
        details.add(new Tuple(res.getString("MsgExID.txt"), ex.getPublicId()));
        details.add(new Tuple(res.getString("MsgExMsg.txt"), ex.getLocalizedMessage()));
        details.add(new Tuple(res.getString("MsgExLine.txt"), Integer.toString(ex.getLineNumber())));
        details.add(new Tuple(res.getString("MsgExColumn.txt"), Integer.toString(ex.getColumnNumber())));
        return details;
    }

    private void propagateNodes(Schema root) {
        for (int n = 0; n < root.getChildCount(); ++n) {
            Isomer node = (Isomer)root.getChildren().get(n);
            this.propHelper(node, root);
        }
    }

    private void propHelper(Isomer node, Schema root) {
        for (int c = 0; c < node.getChildCount(); ++c) {
            Isomer child = (Isomer)node.getChildren().get(c);
            this.propHelper(child, root);
        }
        for (int b = 0; b < root.getChildCount(); ++b) {
            Isomer base = (Isomer)root.getChildren().get(b);
            if (!node.matches(base)) continue;
            node.setChildren(base.getChildren());
        }
    }

    private int getLengthFacet(XSTypeDefinition xstd) {
        int len = 0;
        if (xstd != null && xstd instanceof XSSimpleTypeDefinition) {
            XSSimpleTypeDefinition xsstd = (XSSimpleTypeDefinition)xstd;
            String lenS = xsstd.getLexicalFacetValue((short)1);
            String lenMaxS = xsstd.getLexicalFacetValue((short)4);
            int length = lenS == null ? 0 : Integer.parseInt(lenS);
            int maxlength = lenMaxS == null ? 0 : Integer.parseInt(lenMaxS);
            len = Math.max(length, maxlength);
        }
        return len;
    }

    private ArrayList<String> getEnumFacet(XSTypeDefinition xstd) {
        XSSimpleTypeDefinition xsstd;
        StringList vals;
        ArrayList<String> enumList = null;
        if (xstd != null && xstd instanceof XSSimpleTypeDefinition && (vals = (xsstd = (XSSimpleTypeDefinition)xstd).getLexicalEnumeration()) != null && vals.getLength() > 0) {
            enumList = new ArrayList<String>();
            for (int v = 0; v < vals.getLength(); ++v) {
                enumList.add(vals.item(v));
            }
        }
        return enumList;
    }

    private void addSchemaChild(Isomer node, XSParticle part) {
        XSTerm term;
        if (node.isRecursive()) {
            boolean found = false;
            for (int i = 0; i < this.m_recurseTags.size(); ++i) {
                Tuple t = this.m_recurseTags.get(i);
                String nn = t.getAttribute();
                if (nn.compareTo(node.getName()) != 0) continue;
                int val = Integer.parseInt(t.getValue()) + 1;
                t.setValue(Integer.toString(val));
                found = true;
                break;
            }
            if (!found) {
                Tuple tup = new Tuple(node.getName(), "1");
                this.m_recurseTags.add(tup);
            }
            this.m_root.setRecursive(true);
            return;
        }
        if (part != null && (term = part.getTerm()) != null) {
            if (term instanceof XSElementDeclaration) {
                XSElementDeclaration xsed = (XSElementDeclaration)term;
                Isomer child = new Isomer();
                child.setName(term.getName());
                child.setParent(node);
                String ns = xsed.getNamespace();
                if (ns != null) {
                    child.setNamespace(this.m_namespaces.lookupNamespace(ns));
                }
                this.count(child);
                child.setType(1);
                XSTypeDefinition xstd = xsed.getTypeDefinition();
                if (xstd instanceof XSComplexTypeDecl) {
                    XSComplexTypeDecl xsctd = (XSComplexTypeDecl)xstd;
                    XSAttributeGroupDecl xsagd = xsctd.getAttrGrp();
                    if (xsagd != null) {
                        this.addSchemaAttrs(child, xsagd);
                    }
                    XSParticle xsp = xsctd.getParticle();
                    this.addSchemaChild(child, xsp);
                } else {
                    String typeName = xstd.getName();
                    if (typeName == null) {
                        typeName = xstd.getBaseType().getName();
                    }
                    child.setXSDDatatype(typeName);
                    child.setLength(this.getLengthFacet(xstd));
                    child.setEnum(this.getEnumFacet(xstd));
                }
                child = node.tryAddChild(child);
            }
            if (term instanceof XSModelGroupImpl) {
                XSModelGroupImpl xsmgi = (XSModelGroupImpl)term;
                for (int p = 0; p < xsmgi.fParticleCount; ++p) {
                    this.addSchemaChild(node, (XSParticle)xsmgi.fParticles[p]);
                }
            }
        }
    }

    private void addSchemaAttrs(Isomer node, XSAttributeGroupDecl xsagd) {
        XSObjectList xsolAttrs = xsagd.getAttributeUses();
        Isomer group = null;
        if (xsolAttrs != null) {
            int len = xsolAttrs.getLength();
            if (len > 0) {
                group = new Isomer();
                group.setType(6);
                group.setName("Attributes");
                group = node.tryAddChild(group);
            }
            for (int a = 0; a < len; ++a) {
                XSAttributeUseImpl xsaui;
                XSAttributeDecl xsad;
                XSObject xso = xsolAttrs.item(a);
                if (xso == null || !(xso instanceof XSAttributeUseImpl) || (xsad = (XSAttributeDecl)(xsaui = (XSAttributeUseImpl)xso).getAttrDeclaration()) == null) continue;
                XSSimpleTypeDefinition xstd = xsad.getTypeDefinition();
                Isomer attr = new Isomer();
                attr.setType(7);
                attr.setName(xsad.getName());
                attr.setXSDDatatype(xstd.getName());
                attr.setLength(this.getLengthFacet((XSTypeDefinition)xstd));
                attr.setEnum(this.getEnumFacet((XSTypeDefinition)xstd));
                String ns = xsad.getNamespace();
                if (ns != null) {
                    attr.setNamespace(this.m_namespaces.lookupNamespace(ns));
                }
                assert (group != null);
                attr = group.tryAddChild(attr);
            }
        }
    }

    private void count(Isomer iso) {
        String key = iso.getName();
        assert (key != null);
        Counter val = null;
        if (m_refCount.containsKey(key)) {
            val = m_refCount.get(key);
            val.increment();
        } else {
            val = new Counter(1);
            m_refCount.put(key, val);
        }
        iso.setCounter(val);
    }

    public void warning(String domain, String key, XMLParseException exception) {
        ArrayList<Tuple> details = this.saxExceptionDetail(exception);
        String uri = this.m_file.toURI().toASCIIString();
        String msg = MessageFormat.format(res.getString("MsgErrParseXSDErr.txt"), uri);
        Logger.log(new LogItem(msg, details, 2));
    }

    public void error(String domain, String key, XMLParseException exception) {
        ArrayList<Tuple> details = this.saxExceptionDetail(exception);
        String uri = this.m_file.toURI().toASCIIString();
        String msg = MessageFormat.format(res.getString("MsgErrParseXSDErr.txt"), uri);
        Logger.log(new LogItem(msg, details, 1));
    }

    public void fatalError(String domain, String key, XMLParseException exception) {
        ArrayList<Tuple> details = this.saxExceptionDetail(exception);
        String uri = this.m_file.toURI().toASCIIString();
        String msg = MessageFormat.format(res.getString("MsgErrParseXSDErr.txt"), uri);
        Logger.log(new LogItem(msg, details, 1));
    }

    public NamespaceList getNamespaces() {
        return this.m_namespaces;
    }

    private void tryAddNamespace(XSNamespaceItem xsni) {
        if (xsni != null) {
            String sn = xsni.getSchemaNamespace();
            String prefix = "p" + String.format("%d", ++this.m_prefixCount);
            if (sn != null) {
                this.m_namespaces.add(new Namespace(prefix, sn));
            }
        }
    }

    static {
        res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    }
}

