/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Map;
import com.sas.sxle.map.MapperProxy;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;

public class SXLEContext {
    private static boolean isLocal = false;
    private static MapperProxy.Options mpOpts = null;
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    public static boolean assertsEnabled = false;
    public static final boolean debugEnabled = false;
    public static final boolean traceEnabled = false;
    private static final String prefPath = "sas/com.sas.sxle.map/";
    private static final String notProxyOpt = res.getString("MsgErrNotProxyOpt.txt");

    public static void SetLocal(MapperProxy.Options opts) {
        if (opts == null) {
            return;
        }
        isLocal = true;
        mpOpts = opts;
    }

    public static boolean isLocal() {
        return isLocal;
    }

    public static String getVersion() {
        return Package.getPackage("com.sas.sxle.map").getImplementationVersion();
    }

    private static String getPref(String group, String key) {
        Preferences userPref = Preferences.userRoot();
        userPref = userPref.node(prefPath + group);
        return userPref.get(key, null);
    }

    private static String getPref(String group, String key, String def) {
        Preferences userPref = Preferences.userRoot();
        userPref = userPref.node(prefPath + group);
        return userPref.get(key, def);
    }

    private static void putPref(String group, String key, String val) {
        Preferences userPref = Preferences.userRoot();
        userPref = userPref.node(prefPath + group);
        userPref.put(key, val);
    }

    private static int getPrefInt(String group, String key) {
        return SXLEContext.getPrefInt(group, key, -1);
    }

    private static int getPrefInt(String group, String key, int def) {
        Preferences userPref = Preferences.userRoot();
        userPref = userPref.node(prefPath + group);
        return userPref.getInt(key, def);
    }

    private static void putPrefInt(String group, String key, int val) {
        Preferences userPref = Preferences.userRoot();
        userPref = userPref.node(prefPath + group);
        userPref.putInt(key, val);
    }

    private static boolean getPrefBoolean(String group, String key) {
        return SXLEContext.getPrefBoolean(group, key, false);
    }

    private static boolean getPrefBoolean(String group, String key, boolean def) {
        Preferences userPref = Preferences.userRoot();
        userPref = userPref.node(prefPath + group);
        return userPref.getBoolean(key, def);
    }

    private static void putPrefBoolean(String group, String key, boolean val) {
        Preferences userPref = Preferences.userRoot();
        userPref = userPref.node(prefPath + group);
        userPref.putBoolean(key, val);
    }

    public static boolean useIntern() {
        String ver = System.getProperty("java.vm.version");
        boolean modernJRE = (ver = ver.substring(0, 3)).compareTo("1.5") >= 0;
        return modernJRE;
    }

    public static boolean useNonSupportedPathSyntaxMode() {
        if (isLocal) {
            return false;
        }
        String inMuddMode = System.getProperty("sas.xmlatlas.undoc.MyNameIsMudd", "false");
        return inMuddMode != null && inMuddMode.compareTo("true") == 0;
    }

    public static int validationLevel() {
        if (isLocal) {
            return 2;
        }
        int val = SXLEContext.getPrefInt("processing", "validation_level", 1);
        if (val == 0) {
            val = 1;
        }
        return val;
    }

    public static void setValidationLevel(int m_ValLevel) throws Exception {
        if (isLocal) {
            throw new Exception(notProxyOpt);
        }
        SXLEContext.putPrefInt("processing", "validation_level", m_ValLevel);
    }

    public static int sampleLimit() {
        if (isLocal) {
            return 0;
        }
        return SXLEContext.getPrefInt("processing", "sample_limit", 10);
    }

    public static void setSampleLimit(int samples) throws Exception {
        if (isLocal) {
            throw new Exception(notProxyOpt);
        }
        SXLEContext.putPrefInt("processing", "sample_limit", samples);
    }

    public static boolean duplicateSamples() {
        if (isLocal) {
            return false;
        }
        return SXLEContext.getPrefBoolean("processing", "duplicate_samples", false);
    }

    public static void setDuplicateSamples(boolean m_dupes) throws Exception {
        if (isLocal) {
            throw new Exception(notProxyOpt);
        }
        SXLEContext.putPrefBoolean("processing", "duplicate_samples", m_dupes);
    }

    public static boolean verboseLogging() {
        if (isLocal) {
            return false;
        }
        return SXLEContext.getPrefBoolean("options", "verbose");
    }

    public static void setVerboseLogging(boolean verbose) throws Exception {
        if (isLocal) {
            throw new Exception(notProxyOpt);
        }
        SXLEContext.putPrefBoolean("options", "verbose", verbose);
    }

    public static boolean prefixAttributeNames() {
        if (isLocal) {
            return SXLEContext.mpOpts.PrefixAttributes;
        }
        return SXLEContext.getPrefBoolean("processing", "prefix_attribute_names", true);
    }

    public static void updatePrefixAttributeNames(boolean prefix) throws Exception {
        if (isLocal) {
            throw new Exception(notProxyOpt);
        }
        SXLEContext.putPrefBoolean("processing", "prefix_attribute_names", prefix);
    }

    public static boolean prefixNSNames() {
        if (isLocal) {
            return SXLEContext.mpOpts.PrefixNamespaces;
        }
        return SXLEContext.getPrefBoolean("processing", "prepend_namespaces", false);
    }

    public static void updatePrefixNSNames(boolean prefix) throws Exception {
        if (isLocal) {
            throw new Exception(notProxyOpt);
        }
        SXLEContext.putPrefBoolean("processing", "prepend_namespaces", prefix);
    }

    public static boolean genOrdinals() {
        if (isLocal) {
            return SXLEContext.mpOpts.GenerateOrdinals;
        }
        return SXLEContext.getPrefBoolean("auto_map", "generate_ordinals", true);
    }

    public static void updateGenOrdinals(boolean gen) throws Exception {
        if (isLocal) {
            throw new Exception(notProxyOpt);
        }
        SXLEContext.putPrefBoolean("auto_map", "generate_ordinals", gen);
    }

    public static boolean filterSchema() {
        if (isLocal) {
            return true;
        }
        return SXLEContext.getPrefBoolean("processing", "hide_xsd_floaters");
    }

    public static void updateFilterSchema(boolean filter) throws Exception {
        if (isLocal) {
            throw new Exception();
        }
        if (!isLocal) {
            SXLEContext.putPrefBoolean("processing", "hide_xsd_floaters", filter);
        }
    }

    public static String version() {
        if (isLocal) {
            return Map.VERSIONS[4];
        }
        return SXLEContext.getPref("defaults", "version", Map.VERSIONS[4]);
    }

    public static void setVersion(String ver) throws Exception {
        if (isLocal) {
            throw new Exception(notProxyOpt);
        }
        SXLEContext.putPref("defaults", "version", ver);
    }

    public static String encoding() {
        if (isLocal) {
            return "UTF-8";
        }
        return SXLEContext.getPref("defaults", "encoding");
    }

    public static void setEncoding(String enc) throws Exception {
        if (isLocal) {
            throw new Exception(notProxyOpt);
        }
        SXLEContext.putPref("defaults", "encoding", enc);
    }

    static {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertsEnabled) {
            // empty if block
        }
        assert (false) : res.getString("MsgContextNoAssert.txt");
    }
}

