/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.SXLEContext;
import java.util.regex.Pattern;

public class SASName {
    public static final int kNAME = 0;
    public static final int kREF = 1;
    public static final int kFORMAT = 2;
    private static Pattern m_name = Pattern.compile("^[a-zA-Z_]\\w{0,31}$");
    private static Pattern m_format = Pattern.compile("^[a-zA-Z$]\\w{0,30}[^.\\d]$");
    private static Pattern m_degformat = Pattern.compile("^[a-zA-Z$]$");
    private static Pattern m_reference = Pattern.compile("^[a-zA-Z_]\\w{0,7}$");
    private static Pattern m_reserved = Pattern.compile("^_\\w+_$");
    private static final String[] m_resNames = new String[]{"SASHELP", "SASMSG", "SASUSER", "WORK", "SASCAT"};

    public static boolean isValid(String val) {
        return SASName.isValid(val, 0);
    }

    public static boolean isValid(String val, int type) {
        if (val == null || val.length() < 1) {
            return false;
        }
        if (type == 0 && !m_name.matcher(val).matches()) {
            return false;
        }
        if (type == 1 && !m_reference.matcher(val).matches()) {
            return false;
        }
        if (type == 2 && (val.length() == 1 ? !m_degformat.matcher(val).matches() : !m_format.matcher(val).matches())) {
            return false;
        }
        return !m_reserved.matcher(val).matches();
    }

    public static boolean isReserved(String val) {
        if (val == null) {
            return false;
        }
        for (int rn = 0; rn < m_resNames.length; ++rn) {
            if (val.compareToIgnoreCase(m_resNames[rn]) != 0) continue;
            return true;
        }
        return false;
    }

    public static String sasify(String s) {
        return SASName.sasify(s, 0);
    }

    public static String sasify(String s, int type) {
        if (SXLEContext.useNonSupportedPathSyntaxMode()) {
            return s;
        }
        String sasName = s;
        String suffix = null;
        if (type == 2 && sasName.contains(".")) {
            suffix = sasName.substring(sasName.indexOf(46));
            sasName = sasName.substring(0, sasName.indexOf(46) - 1);
        }
        if (sasName == null) {
            return null;
        }
        if ((sasName = sasName.trim()).length() > 32) {
            sasName = sasName.substring(0, 32);
        }
        if (!Character.isLetter(sasName.charAt(0))) {
            sasName = '_' + sasName.substring(1);
        }
        for (int c = 1; c < sasName.length(); ++c) {
            Character glyph = new Character(sasName.charAt(c));
            char code = glyph.charValue();
            if (Character.isLetterOrDigit(glyph.charValue()) && code >= ' ' && code <= '~') continue;
            sasName = sasName.replace(glyph.charValue(), '_');
        }
        if (suffix != null) {
            sasName = sasName + suffix;
        }
        if (!SASName.isValid(sasName, type)) {
            return "_NAME";
        }
        return sasName;
    }

    public static String uniquify(String s, Atom parent) {
        if (parent == null || s == null) {
            return s;
        }
        String baseName = s;
        String unName = s;
        boolean rolledOver = false;
        int i = 0;
        int bnl = baseName.length();
        while (parent.hasChildNamed(unName)) {
            String suffix;
            int lenSuffix;
            if (bnl + (lenSuffix = (suffix = Integer.toString(++i)).length()) > 32) {
                bnl = 32 - lenSuffix;
                if (bnl <= 0) {
                    if (rolledOver) {
                        return s;
                    }
                    rolledOver = true;
                    baseName = "_COL";
                    i = 1;
                    bnl = baseName.length();
                }
                baseName = baseName.substring(0, bnl);
            }
            unName = baseName + suffix;
        }
        return unName;
    }
}

