/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Namespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;

public class NamespaceList
extends Atom
implements List<Namespace> {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private int m_nextIdx = 1;

    public NamespaceList() {
        String lns = res.getString("LabelNamespaces.txt");
        this.setName(lns);
    }

    public NamespaceList(NamespaceList nsl) {
        String lns = res.getString("LabelNamespaces.txt");
        this.setName(lns);
        this.m_nextIdx = nsl.m_nextIdx;
        this.m_description = nsl.m_description;
        this.m_dirty = nsl.m_dirty;
        this.m_namespace = nsl.m_namespace;
        this.m_parent = nsl.m_parent;
        int oldcc = nsl.getChildCount();
        for (int i = 0; i < oldcc; ++i) {
            Namespace newns = new Namespace((Namespace)nsl.getChildren().get(i));
            newns.setParent(this);
            this.m_children.add(i, newns);
        }
    }

    @Override
    public boolean add(Namespace ns) {
        Namespace mns = this.findMatchingNamespace(ns);
        if (mns == null) {
            this.m_children.add(ns);
            ns.setIndex(this.m_nextIdx++);
        } else {
            ns.setIndex(mns.getIndex());
        }
        ns.setParent(this);
        return true;
    }

    public Namespace findMatchingNamespace(Namespace ns) {
        if (ns == null) {
            return null;
        }
        String uri = ns.getURI();
        String prefix = ns.getPrefix();
        for (int n = 0; n < this.m_children.size(); ++n) {
            Namespace cns = (Namespace)this.m_children.get(n);
            if (!cns.matchesAll(uri, prefix)) continue;
            return (Namespace)this.m_children.get(n);
        }
        return null;
    }

    public Namespace lookupNamespace(String uri) {
        for (int n = 0; n < this.m_children.size(); ++n) {
            Namespace cns = (Namespace)this.m_children.get(n);
            if (!cns.matches(uri)) continue;
            return (Namespace)this.m_children.get(n);
        }
        return null;
    }

    @Override
    public int size() {
        return this.m_children.size();
    }

    @Override
    public void add(int index, Namespace element) {
        this.m_children.add(index, element);
        element.setParent(this);
    }

    @Override
    public boolean addAll(Collection<? extends Namespace> c) {
        Iterator<? extends Namespace> it = c.iterator();
        while (it.hasNext()) {
            it.next().setParent(this);
        }
        return this.m_children.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Namespace> c) {
        Iterator<? extends Namespace> it = c.iterator();
        while (it.hasNext()) {
            it.next().setParent(this);
        }
        return this.m_children.addAll(index, c);
    }

    @Override
    public void clear() {
        this.m_children.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_children.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_children.containsAll(c);
    }

    @Override
    public Namespace get(int index) {
        return (Namespace)this.m_children.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.m_children.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.m_children.isEmpty();
    }

    @Override
    public Iterator<Namespace> iterator() {
        return this.subList(0, this.m_children.size() - 1).iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.m_children.lastIndexOf(o);
    }

    @Override
    public ListIterator<Namespace> listIterator() {
        return this.subList(0, this.m_children.size() - 1).listIterator();
    }

    @Override
    public ListIterator<Namespace> listIterator(int index) {
        return this.subList(0, this.m_children.size() - 1).listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.m_children.remove(o);
    }

    @Override
    public Namespace remove(int index) {
        return (Namespace)this.m_children.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.m_children.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.m_children.retainAll(c);
    }

    @Override
    public Namespace set(int index, Namespace element) {
        element.setParent(this);
        return this.m_children.set(index, element);
    }

    @Override
    public List<Namespace> subList(int fromIndex, int toIndex) {
        int count = toIndex - fromIndex + 1;
        ArrayList<Namespace> sub = new ArrayList<Namespace>(count);
        for (int i = fromIndex; i <= toIndex; ++i) {
            sub.add((Namespace)this.m_children.get(i));
        }
        return sub;
    }

    @Override
    public Object[] toArray() {
        return this.m_children.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_children.toArray(a);
    }

    public String expandPath(String path) {
        if (path == null) {
            return null;
        }
        String val = "";
        try {
            int p = 0;
            int s = path.indexOf(123, p);
            while (s > p) {
                int e = path.indexOf(125, s);
                String num = path.substring(s + 1, e);
                int idx = Integer.parseInt(num);
                val = val + path.substring(p, s + 1);
                val = val + ((Atom)this.m_children.get(idx - 1)).getERName();
                p = e;
                s = path.indexOf(123, p);
            }
            val = val + path.substring(p);
            return val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String compressPath(String path) {
        String val = "";
        try {
            int p = 0;
            int s = path.indexOf(123, p);
            while (s > p) {
                int e = path.indexOf(125, s);
                String ns = path.substring(s + 1, e);
                int idx = this.lookupNamespace(ns).getIndex();
                val = val + path.substring(p, s + 1);
                val = val + Integer.toString(idx);
                p = e;
                s = path.indexOf(123, p);
            }
            val = val + path.substring(p);
            return val;
        }
        catch (Exception e) {
            return null;
        }
    }
}

