/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;

public class Namespace
extends Atom {
    private String m_prefix = null;
    private String m_uri = null;
    private int m_index = -1;

    public Namespace(String prefix, String uri) throws IllegalArgumentException {
        if (prefix != null && prefix != "" && (uri == null || uri.length() < 1)) {
            throw new IllegalArgumentException("uri", new Throwable("value may not be null or empty if a prefix is specified"));
        }
        this.m_prefix = prefix;
        this.m_uri = uri;
        this.setName(this.m_uri);
    }

    public Namespace(Namespace namespace) throws IllegalArgumentException {
        if (namespace == null) {
            throw new IllegalArgumentException("namespace", new Throwable("value may not be null"));
        }
        this.m_prefix = namespace.getPrefix();
        this.m_uri = namespace.getURI();
        this.m_index = namespace.getIndex();
        this.setName(this.m_uri);
    }

    public String getURI() {
        return this.m_uri;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public boolean matches(String uri) {
        if (uri == null) {
            return this.m_uri == null;
        }
        return uri.equals(this.m_uri);
    }

    public boolean matchesAll(String uri, String pre) {
        boolean uriMatch = false;
        if (uri == null) {
            boolean bl = uriMatch = this.m_uri == null;
        }
        if (!(uriMatch = uri.equals(this.m_uri))) {
            return false;
        }
        if (pre == null) {
            return this.m_prefix == null;
        }
        return pre.equals(this.m_prefix);
    }

    @Override
    public String toString() {
        String ns = "xmlns";
        if (this.m_prefix != null && this.m_prefix.length() > 0) {
            ns = ns + ":" + this.m_prefix;
        }
        ns = ns + "=" + this.m_uri;
        return ns;
    }
}

