/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.AVPair;
import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Map;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MapTreeModel
implements TreeModel {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private Vector<TreeModelListener> m_treeModelListeners = new Vector();
    Map m_root;

    public MapTreeModel() {
        Map m = new Map();
        m.setName(res.getString("DefaultMapName.txt"));
        this.m_root = m;
    }

    public MapTreeModel(Map root) {
        this.m_root = root;
    }

    @Override
    public Object getRoot() {
        return this.m_root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Atom m = (Atom)parent;
        if (m.getChildCount() == 0) {
            return null;
        }
        Atom c = m.getChildren().get(index);
        return c;
    }

    @Override
    public int getChildCount(Object parent) {
        if (!(parent instanceof Atom)) {
            return 0;
        }
        Atom m = (Atom)parent;
        if (m.getChildren() == null) {
            return 0;
        }
        return m.getChildren().size();
    }

    @Override
    public boolean isLeaf(Object node) {
        int cc = 0;
        if (node instanceof Atom) {
            Atom a = (Atom)node;
            cc = a.getChildCount();
        }
        return cc == 0 || node instanceof Column || node instanceof AVPair;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        Atom m = (Atom)parent;
        return m.getChildren().indexOf(child);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener tml) {
        this.m_treeModelListeners.remove(tml);
    }

    @Override
    public void addTreeModelListener(TreeModelListener tml) {
        this.m_treeModelListeners.add(tml);
    }

    public void debugDump() {
    }

    private void debugDump(Atom a, int nestLevel) {
    }

    public void fireTreeNodesChanged(TreeModelEvent e) {
        Enumeration<TreeModelListener> listeners = this.m_treeModelListeners.elements();
        while (listeners.hasMoreElements()) {
            TreeModelListener listener = listeners.nextElement();
            listener.treeNodesChanged(e);
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent e) {
        Enumeration<TreeModelListener> listeners = this.m_treeModelListeners.elements();
        while (listeners.hasMoreElements()) {
            TreeModelListener listener = listeners.nextElement();
            listener.treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        Enumeration<TreeModelListener> listeners = this.m_treeModelListeners.elements();
        while (listeners.hasMoreElements()) {
            TreeModelListener listener = listeners.nextElement();
            listener.treeNodesRemoved(e);
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        Enumeration<TreeModelListener> listeners = this.m_treeModelListeners.elements();
        while (listeners.hasMoreElements()) {
            TreeModelListener listener = listeners.nextElement();
            listener.treeStructureChanged(e);
        }
    }
}

