/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Column;
import com.sas.sxle.map.SortTableModel;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MapTableModel
implements SortTableModel {
    protected static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private Vector<TableModelListener> m_tableModelListeners = new Vector();
    ArrayList<?> m_rowset = null;
    ArrayList<?> m_cols = null;
    private String m_name = res.getString("NoData.txt");

    public MapTableModel() {
        this.m_rowset = new ArrayList();
        this.m_cols = new ArrayList();
    }

    public MapTableModel(ArrayList<?> rowset, ArrayList<?> cols, String name) {
        this.m_rowset = rowset;
        this.m_cols = cols;
        this.setName(name);
    }

    @Override
    public void update() {
        for (int l = 0; l < this.m_tableModelListeners.size(); ++l) {
            TableModelEvent event = new TableModelEvent(this, -1);
            this.m_tableModelListeners.get(l).tableChanged(event);
        }
    }

    @Override
    public int getRowCount() {
        if (this.m_rowset == null) {
            return 0;
        }
        return this.m_rowset.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_cols.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        assert (columnIndex >= 0 && columnIndex < this.getColumnCount());
        Object o = this.m_cols.get(columnIndex);
        if (o instanceof Column) {
            return ((Column)o).getName();
        }
        return o.toString();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        String s = "";
        return s.getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        assert (rowIndex >= 0 && rowIndex < this.getRowCount());
        assert (columnIndex >= 0 && columnIndex < this.getColumnCount());
        ArrayList row = (ArrayList)this.m_rowset.get(rowIndex);
        return row.get(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("Method setValueAt() not implemented - MapTableModel is read only.");
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public void addTableModelListener(TableModelListener tml) {
        this.m_tableModelListeners.add(tml);
    }

    @Override
    public void removeTableModelListener(TableModelListener tml) {
        this.m_tableModelListeners.add(tml);
    }

    @Override
    public boolean isSortable(int col) {
        return false;
    }

    @Override
    public void sortColumn(int col, boolean ascending) {
    }

    @Override
    public void sort() {
    }

    @Override
    public int getSortedColumnIndex() {
        return -1;
    }

    @Override
    public void setSortedColumnIndex(int col) {
    }

    @Override
    public boolean getSortedColumnDirection() {
        return false;
    }

    @Override
    public void setSortedColumnDirection(boolean asc) {
    }

    public Column getColumn(int index) {
        if (index < 0 || index >= this.m_cols.size()) {
            return (Column)this.m_cols.get(0);
        }
        return (Column)this.m_cols.get(index);
    }
}

