/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.AVPair;
import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Format;
import com.sas.sxle.map.LogItem;
import com.sas.sxle.map.Logger;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.Namespace;
import com.sas.sxle.map.Output;
import com.sas.sxle.map.SASName;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Table;
import com.sas.sxle.map.Tuple;
import com.sas.sxle.map.ValidationIssue;
import com.sas.sxle.map.XMLFile;
import com.sas.sxle.map.XPath;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Stack;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XNIException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class MapParserVS
extends SAXParser
implements ContentHandler,
LexicalHandler {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    protected Stack<Atom> context = new Stack();
    protected Stack<Attributes> attrStack = new Stack();
    protected boolean bailOut = false;
    protected int m_status = 0;
    protected int[] m_ver = new int[]{0, 0, 0, 0};
    protected static final int V_MAJ = 0;
    protected static final int V_MIN = 1;
    protected static final int V_REV = 2;
    protected static final int V_BLD = 3;
    protected static final String m_noName = "_UNNAMED";
    protected int m_mapVer = -1;
    protected boolean m_inEnum = false;
    protected boolean m_inOutput = false;
    protected boolean m_inNamespaces = false;
    protected long elements;
    protected long attributes;
    protected long characters;
    protected long ignorableWhitespace;
    protected Map m_map;
    protected String m_val;
    protected String m_declEncName;
    protected String m_mapUri = null;
    MapParserVSH m_helper = null;

    public MapParserVS() {
        this.setContentHandler(this);
        try {
            this.setLexicalHandler(this);
            if (SXLEContext.validationLevel() != 10) {
                this.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
        }
        catch (SAXNotRecognizedException e) {
            this.bailOut = true;
        }
        catch (SAXNotSupportedException e) {
            this.bailOut = true;
        }
    }

    @Override
    public void startDocument() {
        if (this.bailOut) {
            return;
        }
        this.m_ver[0] = 0;
        this.m_ver[1] = 0;
        this.m_ver[2] = 0;
        this.m_ver[3] = 0;
        this.elements = 0L;
        this.attributes = 0L;
        this.characters = 0L;
        this.ignorableWhitespace = 0L;
        this.m_inEnum = false;
        this.m_helper = null;
        this.context.clear();
        this.attrStack.clear();
    }

    @Override
    public void endDocument() {
        if (this.bailOut) {
            return;
        }
        if (this.m_map.getVersionID() >= 3 && this.m_map.getOutput() == null) {
            this.m_map.setOutput(new Output());
        }
    }

    @Override
    public void startElement(String uri, String lname, String qname, Attributes attrs) {
        if (this.bailOut) {
            return;
        }
        assert (lname != null);
        Attributes a = attrs;
        if (a == null) {
            a = new AttributesImpl();
        }
        this.attrStack.push(a);
        ++this.elements;
        this.m_val = "";
        String name = lname.toUpperCase();
        if (name.equals("SXLEMAP") || name.equals("XMLMAP")) {
            this.m_map = this.newMap(attrs);
            if (this.m_map.getName() == null || this.m_map.getName().length() < 1) {
                this.m_map.setName(lname);
            }
            if (this.m_declEncName == null) {
                this.m_declEncName = "UTF-8";
            }
            this.m_map.setEncoding(Charset.forName(this.m_declEncName));
            this.context.push(this.m_map);
            this.parseVersion(a.getValue("version"));
            this.setHelper();
        } else if (this.context.isEmpty()) {
            this.bailOut = true;
            this.m_map = null;
            String msg = MessageFormat.format(res.getString("MsgErrBadMap.txt"), this.m_mapUri);
            Logger.log(msg, 1);
        } else {
            this.m_helper.startElementVSH(uri, lname, qname, attrs);
        }
    }

    protected void setHelper() {
        switch (this.m_mapVer) {
            case 4: {
                this.m_helper = new MapParserVSH_2_1(this);
                break;
            }
            case 3: {
                this.m_helper = new MapParserVSH_1_9(this);
                break;
            }
            case 2: {
                this.m_helper = new MapParserVSH_1_2(this);
                break;
            }
            case 1: {
                this.m_helper = new MapParserVSH_1_1(this);
                break;
            }
            default: {
                this.m_helper = new MapParserVSH_1_0(this);
            }
        }
    }

    protected void parseVersion(String ver) {
        if (ver == null) {
            this.m_mapVer = 0;
            return;
        }
        int pos = 0;
        for (int idx = 0; idx < 4; ++idx) {
            Integer i;
            int pdot = ver.indexOf(".", pos);
            if (pos >= ver.length()) break;
            if (pdot < 0) {
                pdot = ver.length();
            }
            String vtemp = ver.substring(pos, pdot);
            try {
                i = Integer.valueOf(vtemp);
            }
            catch (Exception e) {
                i = null;
            }
            this.m_ver[idx] = i == null ? 0 : i;
            pos = pdot + 1;
        }
        this.m_mapVer = this.mapVersion();
        if (this.m_mapVer == -1) {
            this.bailOut = true;
            this.m_map = null;
            String msg = MessageFormat.format(res.getString("VMsgMapVersionInvalidExp.txt"), ver);
            Logger.log(msg, 1);
        } else {
            this.m_map.setVersion(this.m_mapVer);
        }
    }

    protected int mapVersion() {
        if (this.m_ver[0] == 1 && this.m_ver[1] == 0) {
            return 0;
        }
        if (this.m_ver[0] == 1 && this.m_ver[1] == 1) {
            return 1;
        }
        if (this.m_ver[0] == 1 && this.m_ver[1] == 2) {
            return 2;
        }
        if (this.m_ver[0] == 1 && this.m_ver[1] == 9) {
            return 3;
        }
        if (this.m_ver[0] == 2 && this.m_ver[1] == 1) {
            return 4;
        }
        return -1;
    }

    protected boolean VerEQ(int maj, int min) {
        return this.m_ver[0] == maj && this.m_ver[1] == min;
    }

    protected boolean VerGE(int maj, int min) {
        if (this.m_ver[0] > maj) {
            return true;
        }
        return this.m_ver[0] == maj && this.m_ver[1] >= min;
    }

    protected boolean VerLE(int maj, int min) {
        if (this.m_ver[0] < maj) {
            return true;
        }
        return this.m_ver[0] == maj && this.m_ver[1] <= min;
    }

    protected boolean VerGT(int maj, int min) {
        if (this.m_ver[0] > maj) {
            return true;
        }
        return this.m_ver[0] == maj && this.m_ver[1] > min;
    }

    protected boolean VerLT(int maj, int min) {
        if (this.m_ver[0] < maj) {
            return true;
        }
        return this.m_ver[0] == maj && this.m_ver[1] < min;
    }

    @Override
    public void endElement(String uri, String lname, String qname) {
        if (this.bailOut) {
            return;
        }
        assert (lname != null);
        this.m_helper.endElementVSH(uri, lname, qname);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.bailOut) {
            return;
        }
        String val = new String(ch, start, length);
        this.characters += (long)length;
        boolean startWS = false;
        if (length > 0) {
            startWS = Character.isWhitespace(val.charAt(0));
        }
        boolean endWS = false;
        if (length > 2 || length > 1 && !startWS) {
            endWS = Character.isWhitespace(val.charAt(length - 1));
        }
        val = val.trim();
        if (startWS) {
            val = " " + val;
        }
        if (endWS) {
            val = val + " ";
        }
        this.m_val = this.m_val + val;
        Atom mc = this.context.peek();
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.bailOut) {
            return;
        }
        String val = new String(ch, start, length);
        this.ignorableWhitespace += (long)length;
    }

    public void warning(SAXParseException ex) {
        if (this.bailOut) {
            return;
        }
        this.m_status = 1;
        ArrayList<Tuple> details = new ArrayList<Tuple>();
        details.add(new Tuple(res.getString("MsgExClass.txt"), ex.getClass().getName()));
        details.add(new Tuple(res.getString("MsgExID.txt"), ex.getPublicId()));
        details.add(new Tuple(res.getString("MsgExMsg.txt"), ex.getLocalizedMessage()));
        details.add(new Tuple(res.getString("MsgExLine.txt"), Integer.toString(ex.getLineNumber())));
        details.add(new Tuple(res.getString("MsgExColumn.txt"), Integer.toString(ex.getColumnNumber())));
        Logger.log(res.getString("MsgExXMLWarn.txt"), details, 1);
    }

    public void error(SAXParseException ex) {
        if (this.bailOut) {
            return;
        }
        this.m_status = 2;
        ArrayList<Tuple> details = new ArrayList<Tuple>();
        details.add(new Tuple(res.getString("MsgExClass.txt"), ex.getClass().getName()));
        details.add(new Tuple(res.getString("MsgExID.txt"), ex.getPublicId()));
        details.add(new Tuple(res.getString("MsgExMsg.txt"), ex.getLocalizedMessage()));
        details.add(new Tuple(res.getString("MsgExLine.txt"), Integer.toString(ex.getLineNumber())));
        details.add(new Tuple(res.getString("MsgExColumn.txt"), Integer.toString(ex.getColumnNumber())));
        Logger.log(res.getString("MsgExXMLErr.txt"), details, 1);
    }

    public void fatalError(SAXParseException ex) {
        if (this.bailOut) {
            return;
        }
        this.m_status = 3;
        ArrayList<Tuple> details = new ArrayList<Tuple>();
        details.add(new Tuple(res.getString("MsgExClass.txt"), ex.getClass().getName()));
        details.add(new Tuple(res.getString("MsgExID.txt"), ex.getPublicId()));
        details.add(new Tuple(res.getString("MsgExMsg.txt"), ex.getLocalizedMessage()));
        details.add(new Tuple(res.getString("MsgExLine.txt"), Integer.toString(ex.getLineNumber())));
        details.add(new Tuple(res.getString("MsgExColumn.txt"), Integer.toString(ex.getColumnNumber())));
        Logger.log(res.getString("MsgExXMLFatal.txt"), details, 1);
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        if (this.bailOut) {
            return;
        }
        String val = new String(ch, start, length);
    }

    @Override
    public void endCDATA() {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void endDTD() {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void endEntity(String name) {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void startCDATA() {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void startEntity(String name) {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (this.bailOut) {
            return;
        }
        this.m_declEncName = encoding;
    }

    public void debugDump(String uri) {
    }

    public Map getMap() {
        return this.m_map;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void parse(XMLFile file) throws SAXException, IOException {
        String uri;
        this.m_mapUri = uri = file.toURI().toString();
        super.parse(uri);
    }

    public Table newTable(Attributes attrs) {
        Table t = new Table();
        for (int a = 0; a < attrs.getLength(); ++a) {
            String name = attrs.getLocalName(a).toLowerCase();
            if (name.equals("name")) {
                t.setName(attrs.getValue(a));
            }
            if (!name.equals("description") || this.m_mapVer < 3) continue;
            t.setDescription(attrs.getValue(a));
        }
        return t;
    }

    public Column newColumn(Attributes attrs) {
        Column c = new Column();
        for (int a = 0; a < attrs.getLength(); ++a) {
            String val;
            ArrayList<Tuple> details;
            String name = attrs.getLocalName(a).toLowerCase();
            if (name.equals("name")) {
                c.setName(attrs.getValue(a));
            }
            if (name.equals("class")) {
                if (this.m_mapVer < 3) {
                    this.m_status = 1;
                    details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), "COLUMN"));
                    details.add(new Tuple(res.getString("MsgParseAttr.txt"), "ordinal"));
                    Logger.log(res.getString("MsgParseClassNotSupp.txt"), details, 2);
                } else {
                    String v = attrs.getValue(a);
                    if (v.equals("ORDINAL")) {
                        c.setOrdinal();
                    }
                    if (v.equals("FILENAME")) {
                        c.setFilename();
                    }
                    if (v.equals("FILEPATH")) {
                        c.setFilePath();
                    }
                }
            }
            if (name.equals("ordinal")) {
                if (this.m_mapVer <= 0) {
                    this.m_status = 1;
                    details = new ArrayList();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), "COLUMN"));
                    details.add(new Tuple(res.getString("MsgParseAttr.txt"), "ordinal"));
                    Logger.log(res.getString("MsgParseOrdNotSupp.txt"), details, 2);
                } else if (this.m_mapVer >= 3) {
                    this.m_status = 1;
                    details = new ArrayList();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), "COLUMN"));
                    details.add(new Tuple(res.getString("MsgParseAttr.txt"), "ordinal"));
                    Logger.log(res.getString("MsgParseOrdNowClass.txt"), details, 2);
                } else {
                    val = attrs.getValue(a);
                    if (val != null && val.toUpperCase().equals("YES")) {
                        c.setOrdinal();
                    }
                }
            }
            if (!name.equals("retain") || (val = attrs.getValue(a)) == null) continue;
            c.setRetention(val.toUpperCase().equals("YES"));
        }
        return c;
    }

    public Map newMap(Attributes attrs) {
        Map m = new Map();
        for (int a = 0; a < attrs.getLength(); ++a) {
            String name = attrs.getLocalName(a).toLowerCase();
            if (name.equals("name")) {
                m.setName(attrs.getValue(a));
            }
            if (!name.equals("description")) continue;
            m.setDescription(attrs.getValue(a));
        }
        return m;
    }

    protected boolean issuesHaveErr(ArrayList<ValidationIssue> al) {
        for (int issue = 0; issue < al.size(); ++issue) {
            ValidationIssue item = al.get(issue);
            if (item.getSeverity() != 1) continue;
            Logger.log(item.getDescription(), item.getSeverity());
            return true;
        }
        return false;
    }

    protected void failContext(String name) {
        String msg = MessageFormat.format(res.getString("MsgParseBadSequence.txt"), name);
        Logger.log(new LogItem(msg, 1));
    }

    protected String fixupName(String name, int type) {
        if (SASName.isValid(name, type)) {
            return name;
        }
        String sname = SASName.sasify(name, type);
        this.m_status = 1;
        String msg = MessageFormat.format(res.getString("VMsgNameTruncated.txt"), name, sname);
        Logger.log(msg, 2);
        return sname;
    }

    static interface MapParserVSH {
        public void startElementVSH(String var1, String var2, String var3, Attributes var4);

        public void endElementVSH(String var1, String var2, String var3);
    }

    class MapParserVSH_2_1
    implements MapParserVSH {
        MapParserVS m_parent = null;

        public MapParserVSH_2_1(MapParserVS parent) {
            this.m_parent = parent;
        }

        @Override
        public void startElementVSH(String uri, String lname, String qname, Attributes attrs) {
            String name = lname;
            assert (lname != null);
            if ((name = name.toUpperCase()).equals("TABLE")) {
                Table t = MapParserVS.this.newTable(attrs);
                if (t.getName() == null) {
                    t.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.m_map.addTable(t);
                MapParserVS.this.context.push(t);
            } else if (name.equals("COLUMN")) {
                Column c = MapParserVS.this.newColumn(attrs);
                Atom peeked = MapParserVS.this.context.peek();
                if (!(peeked instanceof Table)) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                Table t = (Table)peeked;
                t.addColumn(c);
                if (c.getName() == null) {
                    c.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.context.push(c);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = true;
            } else if (name.equals("OUTPUT")) {
                MapParserVS.this.m_inOutput = true;
                MapParserVS.this.m_map.setOutput(new Output());
            } else if (name.equals("NAMESPACES")) {
                MapParserVS.this.m_inNamespaces = true;
            } else if (name.equals("PATH")) {
                Atom peeked = MapParserVS.this.context.peek();
                if (!(peeked instanceof Column)) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                Column c = (Column)peeked;
                String val = attrs.getValue("notSupported");
                if (val != null) {
                    boolean v = val.compareTo("true") == 0;
                    c.setUsesNonSupportedSyntax(v);
                    MapParserVS.this.m_map.setOutput(new Output());
                }
            }
        }

        @Override
        public void endElementVSH(String uri, String lname, String qname) {
            Column c;
            String name = lname.toUpperCase();
            Attributes a = MapParserVS.this.attrStack.pop();
            Atom ctxObj = MapParserVS.this.context.peek();
            Table t = ctxObj instanceof Table ? (Table)ctxObj : null;
            Column column = c = ctxObj instanceof Column ? (Column)ctxObj : null;
            if (name.equals("SXLEMAP")) {
                MapParserVS.this.context.pop();
            } else if (name.equals("TABLE")) {
                MapParserVS.this.context.pop();
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                t.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Map m = (Map)t.getParent();
                    m.getChildren().remove(t);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropTable.txt"), t.getName());
                    Logger.log(msg, null, 2);
                }
            } else if (name.equals("COLUMN")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                c.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Table tp = (Table)c.getParent();
                    tp.getColumns().remove(c);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropColumn.txt"), c.getName(), tp.getName());
                    Logger.log(msg, null, 2);
                }
                MapParserVS.this.context.pop();
            } else if (name.equals("TABLE-PATH")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setXPath(new XPath(MapParserVS.this.m_val));
            } else if (name.equals("TABLE-DESCRIPTION")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TABLE-END-PATH")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath toxp = new XPath(MapParserVS.this.m_val);
                t.setOptXPath(toxp);
                String be = a.getValue("beginend");
                toxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    toxp.setBeginEnd(1);
                }
            } else if (name.equals("DESCRIPTION")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setType(MapParserVS.this.m_val);
            } else if (name.equals("DATATYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDatatype(MapParserVS.this.m_val, MapParserVS.this.m_mapVer);
            } else if (name.equals("LENGTH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                int i = 0;
                try {
                    i = Integer.parseInt(MapParserVS.this.m_val.trim());
                    c.setLength(i);
                }
                catch (NumberFormatException be) {
                    // empty catch block
                }
                if (i == 0) {
                    MapParserVS.this.m_status = 1;
                    ArrayList<Tuple> details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                    details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                    String msg = MessageFormat.format(res.getString("MsgWarnBadLength.txt"), c.getName());
                    Logger.log(msg, details, 2);
                }
            } else if (name.equals("PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (c.getUsesNonSupportedSyntax()) {
                    c.setXPath(MapParserVS.this.m_val);
                } else {
                    c.parseXPath(MapParserVS.this.m_val);
                }
            } else if (name.equals("INCREMENT-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath cixp = new XPath(MapParserVS.this.m_val);
                c.setIncrementXPath(cixp);
                String be = a.getValue("beginend");
                cixp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    cixp.setBeginEnd(1);
                }
            } else if (name.equals("DECREMENT-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath cdxp = new XPath(MapParserVS.this.m_val);
                c.setDecrementXPath(cdxp);
                String be = a.getValue("beginend");
                cdxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    cdxp.setBeginEnd(1);
                }
            } else if (name.equals("RESET-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath crxp = new XPath(MapParserVS.this.m_val);
                c.setResetXPath(crxp);
                String be = a.getValue("beginend");
                crxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    crxp.setBeginEnd(1);
                }
            } else if (name.equals("FORMAT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_val != null && MapParserVS.this.m_val.length() > 0) {
                    String n;
                    String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                    Format f = new Format(sname);
                    String w = a.getValue("width");
                    if (w != null) {
                        int width = Integer.parseInt(w);
                        f.setLength(width);
                    }
                    if ((n = a.getValue("ndec")) != null) {
                        int ndec = Integer.parseInt(n);
                        f.setNDec(ndec);
                    }
                    c.setFormat(f);
                }
            } else if (name.equals("INFORMAT")) {
                String n;
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                Format f = new Format(sname);
                String w = a.getValue("width");
                if (w != null) {
                    int width = Integer.parseInt(w);
                    f.setLength(width);
                }
                if ((n = a.getValue("ndec")) != null) {
                    int ndec = Integer.parseInt(n);
                    f.setNDec(ndec);
                }
                c.setInformat(f);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = false;
            } else if (name.equals("VALUE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_inEnum) {
                    c.addEnumValue(MapParserVS.this.m_val);
                }
            } else if (name.equals("DEFAULT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDefault(MapParserVS.this.m_val);
            } else if (name.equals("OUTPUT")) {
                MapParserVS.this.m_inOutput = false;
            } else if (!name.equals("HEADING")) {
                if (name.equals("ATTRIBUTE")) {
                    if (MapParserVS.this.m_inOutput) {
                        String attr = a.getValue("name");
                        String val = a.getValue("value");
                        Output o = MapParserVS.this.m_map.getOutput();
                        o.addAVPair(new AVPair(attr, val));
                    }
                } else if (name.equals("TABLEREF")) {
                    if (MapParserVS.this.m_inOutput) {
                        String tab = a.getValue("name");
                        Output o = MapParserVS.this.m_map.getOutput();
                        o.setTable(tab);
                    }
                } else if (name.equals("NAMESPACES")) {
                    MapParserVS.this.m_inNamespaces = false;
                } else if (name.equals("NS")) {
                    if (!MapParserVS.this.m_inNamespaces) {
                        MapParserVS.this.failContext(name);
                        return;
                    }
                    Namespace n = new Namespace(a.getValue("prefix"), MapParserVS.this.m_val);
                    MapParserVS.this.m_map.getNamespaces().add(n);
                } else {
                    MapParserVS.this.m_status = 1;
                    ArrayList<Tuple> details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                    details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                    Logger.log(res.getString("MsgParseBadEle.txt"), details, 2);
                }
            }
        }
    }

    class MapParserVSH_1_9
    implements MapParserVSH {
        MapParserVS m_parent = null;

        public MapParserVSH_1_9(MapParserVS parent) {
            this.m_parent = parent;
        }

        @Override
        public void startElementVSH(String uri, String lname, String qname, Attributes attrs) {
            String name = lname;
            assert (lname != null);
            if ((name = name.toUpperCase()).equals("TABLE")) {
                Table t = MapParserVS.this.newTable(attrs);
                if (t.getName() == null) {
                    t.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.m_map.addTable(t);
                MapParserVS.this.context.push(t);
            } else if (name.equals("COLUMN")) {
                Column c = MapParserVS.this.newColumn(attrs);
                Atom peeked = MapParserVS.this.context.peek();
                if (!(peeked instanceof Table)) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                Table t = (Table)peeked;
                t.addColumn(c);
                if (c.getName() == null) {
                    c.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.context.push(c);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = true;
            } else if (name.equals("OUTPUT")) {
                MapParserVS.this.m_inOutput = true;
                MapParserVS.this.m_map.setOutput(new Output());
            } else if (!name.equals("HEADING") && !name.equals("ATTRIBUTE") && !name.equals("TABLEREF") && name.equals("PATH")) {
                Atom peeked = MapParserVS.this.context.peek();
                if (!(peeked instanceof Column)) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                Column c = (Column)peeked;
                String val = attrs.getValue("notSupported");
                if (val != null) {
                    boolean v = val.compareTo("true") == 0;
                    c.setUsesNonSupportedSyntax(v);
                }
            }
        }

        @Override
        public void endElementVSH(String uri, String lname, String qname) {
            Column c;
            String name = lname.toUpperCase();
            Attributes a = MapParserVS.this.attrStack.pop();
            Atom ctxObj = MapParserVS.this.context.peek();
            Table t = ctxObj instanceof Table ? (Table)ctxObj : null;
            Column column = c = ctxObj instanceof Column ? (Column)ctxObj : null;
            if (name.equals("SXLEMAP")) {
                MapParserVS.this.context.pop();
            } else if (name.equals("TABLE")) {
                MapParserVS.this.context.pop();
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                t.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Map m = (Map)t.getParent();
                    m.getChildren().remove(t);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropTable.txt"), t.getName());
                    Logger.log(msg, null, 2);
                }
            } else if (name.equals("COLUMN")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                c.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Table tp = (Table)c.getParent();
                    tp.getColumns().remove(c);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropColumn.txt"), c.getName(), tp.getName());
                    Logger.log(msg, null, 2);
                }
                MapParserVS.this.context.pop();
            } else if (name.equals("TABLE-PATH")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setXPath(new XPath(MapParserVS.this.m_val));
            } else if (name.equals("TABLE-DESCRIPTION")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TABLE-END-PATH")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath toxp = new XPath(MapParserVS.this.m_val);
                t.setOptXPath(toxp);
                String be = a.getValue("beginend");
                toxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    toxp.setBeginEnd(1);
                }
            } else if (name.equals("DESCRIPTION")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setType(MapParserVS.this.m_val);
            } else if (name.equals("DATATYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDatatype(MapParserVS.this.m_val, MapParserVS.this.m_mapVer);
            } else if (name.equals("LENGTH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                int i = 0;
                try {
                    i = Integer.parseInt(MapParserVS.this.m_val.trim());
                    c.setLength(i);
                }
                catch (NumberFormatException be) {
                    // empty catch block
                }
                if (i == 0) {
                    MapParserVS.this.m_status = 1;
                    ArrayList<Tuple> details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                    details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                    String msg = MessageFormat.format(res.getString("MsgWarnBadLength.txt"), c.getName());
                    Logger.log(msg, details, 2);
                }
            } else if (name.equals("PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (c.getUsesNonSupportedSyntax()) {
                    c.setXPath(MapParserVS.this.m_val);
                } else {
                    c.parseXPath(MapParserVS.this.m_val);
                }
            } else if (name.equals("INCREMENT-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath cixp = new XPath(MapParserVS.this.m_val);
                c.setIncrementXPath(cixp);
                String be = a.getValue("beginend");
                cixp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    cixp.setBeginEnd(1);
                }
            } else if (name.equals("DECREMENT-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath cdxp = new XPath(MapParserVS.this.m_val);
                c.setDecrementXPath(cdxp);
                String be = a.getValue("beginend");
                cdxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    cdxp.setBeginEnd(1);
                }
            } else if (name.equals("RESET-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath crxp = new XPath(MapParserVS.this.m_val);
                c.setResetXPath(crxp);
                String be = a.getValue("beginend");
                crxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    crxp.setBeginEnd(1);
                }
            } else if (name.equals("FORMAT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_val != null && MapParserVS.this.m_val.length() > 0) {
                    String n;
                    String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                    Format f = new Format(sname);
                    String w = a.getValue("width");
                    if (w != null) {
                        int width = Integer.parseInt(w);
                        f.setLength(width);
                    }
                    if ((n = a.getValue("ndec")) != null) {
                        int ndec = Integer.parseInt(n);
                        f.setNDec(ndec);
                    }
                    c.setFormat(f);
                }
            } else if (name.equals("INFORMAT")) {
                String n;
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                Format f = new Format(sname);
                String w = a.getValue("width");
                if (w != null) {
                    int width = Integer.parseInt(w);
                    f.setLength(width);
                }
                if ((n = a.getValue("ndec")) != null) {
                    int ndec = Integer.parseInt(n);
                    f.setNDec(ndec);
                }
                c.setInformat(f);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = false;
            } else if (name.equals("VALUE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_inEnum) {
                    c.addEnumValue(MapParserVS.this.m_val);
                }
            } else if (name.equals("DEFAULT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDefault(MapParserVS.this.m_val);
            } else if (name.equals("OUTPUT")) {
                MapParserVS.this.m_inOutput = false;
            } else if (!name.equals("HEADING")) {
                if (name.equals("ATTRIBUTE")) {
                    if (MapParserVS.this.m_inOutput) {
                        String attr = a.getValue("name");
                        String val = a.getValue("value");
                        Output o = MapParserVS.this.m_map.getOutput();
                        o.addAVPair(new AVPair(attr, val));
                    }
                } else if (name.equals("TABLEREF")) {
                    if (MapParserVS.this.m_inOutput) {
                        String tab = a.getValue("name");
                        Output o = MapParserVS.this.m_map.getOutput();
                        o.setTable(tab);
                    }
                } else {
                    MapParserVS.this.m_status = 1;
                    ArrayList<Tuple> details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                    details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                    Logger.log(res.getString("MsgParseBadEle.txt"), details, 2);
                }
            }
        }
    }

    class MapParserVSH_1_2
    implements MapParserVSH {
        MapParserVS m_parent = null;

        public MapParserVSH_1_2(MapParserVS parent) {
            this.m_parent = parent;
        }

        @Override
        public void startElementVSH(String uri, String lname, String qname, Attributes attrs) {
            String name = lname;
            assert (lname != null);
            if ((name = name.toUpperCase()).equals("TABLE")) {
                Table t = MapParserVS.this.newTable(attrs);
                if (t.getName() == null) {
                    t.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.m_map.addTable(t);
                MapParserVS.this.context.push(t);
            } else if (name.equals("COLUMN")) {
                Column c = MapParserVS.this.newColumn(attrs);
                Atom peeked = MapParserVS.this.context.peek();
                if (!(peeked instanceof Table)) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                Table t = (Table)peeked;
                t.addColumn(c);
                if (c.getName() == null) {
                    c.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.context.push(c);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = true;
            }
        }

        @Override
        public void endElementVSH(String uri, String lname, String qname) {
            Column c;
            String name = lname.toUpperCase();
            Attributes a = MapParserVS.this.attrStack.pop();
            Atom ctxObj = MapParserVS.this.context.peek();
            Table t = ctxObj instanceof Table ? (Table)ctxObj : null;
            Column column = c = ctxObj instanceof Column ? (Column)ctxObj : null;
            if (name.equals("SXLEMAP")) {
                MapParserVS.this.context.pop();
            } else if (name.equals("TABLE")) {
                MapParserVS.this.context.pop();
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                t.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Map m = (Map)t.getParent();
                    m.getChildren().remove(t);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropTable.txt"), t.getName());
                    Logger.log(msg, null, 2);
                }
            } else if (name.equals("COLUMN")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                c.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Table tp = (Table)c.getParent();
                    tp.getColumns().remove(c);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropColumn.txt"), c.getName(), tp.getName());
                    Logger.log(msg, null, 2);
                }
                MapParserVS.this.context.pop();
            } else if (name.equals("TABLE-PATH")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setXPath(new XPath(MapParserVS.this.m_val));
            } else if (name.equals("TABLE-DESCRIPTION")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TABLE-END-PATH")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath toxp = new XPath(MapParserVS.this.m_val);
                t.setOptXPath(toxp);
                String be = a.getValue("beginend");
                toxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    toxp.setBeginEnd(1);
                }
            } else if (name.equals("DESCRIPTION")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setType(MapParserVS.this.m_val);
            } else if (name.equals("DATATYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDatatype(MapParserVS.this.m_val, MapParserVS.this.m_mapVer);
            } else if (name.equals("LENGTH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                int i = 0;
                try {
                    i = Integer.parseInt(MapParserVS.this.m_val.trim());
                    c.setLength(i);
                }
                catch (NumberFormatException be) {
                    // empty catch block
                }
                if (i == 0) {
                    MapParserVS.this.m_status = 1;
                    ArrayList<Tuple> details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                    details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                    String msg = MessageFormat.format(res.getString("MsgWarnBadLength.txt"), c.getName());
                    Logger.log(msg, details, 2);
                }
            } else if (name.equals("PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.parseXPath(MapParserVS.this.m_val);
            } else if (name.equals("INCREMENT-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath cixp = new XPath(MapParserVS.this.m_val);
                c.setIncrementXPath(cixp);
                String be = a.getValue("beginend");
                cixp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    cixp.setBeginEnd(1);
                }
            } else if (name.equals("DECREMENT-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath cdxp = new XPath(MapParserVS.this.m_val);
                c.setDecrementXPath(cdxp);
                String be = a.getValue("beginend");
                cdxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    cdxp.setBeginEnd(1);
                }
            } else if (name.equals("RESET-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath crxp = new XPath(MapParserVS.this.m_val);
                c.setResetXPath(crxp);
                String be = a.getValue("beginend");
                crxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    crxp.setBeginEnd(1);
                }
            } else if (name.equals("FORMAT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_val != null && MapParserVS.this.m_val.length() > 0) {
                    String n;
                    String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                    Format f = new Format(sname);
                    String w = a.getValue("width");
                    if (w != null) {
                        int width = Integer.parseInt(w);
                        f.setLength(width);
                    }
                    if ((n = a.getValue("ndec")) != null) {
                        int ndec = Integer.parseInt(n);
                        f.setNDec(ndec);
                    }
                    c.setFormat(f);
                }
            } else if (name.equals("INFORMAT")) {
                String n;
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                Format f = new Format(sname);
                String w = a.getValue("width");
                if (w != null) {
                    int width = Integer.parseInt(w);
                    f.setLength(width);
                }
                if ((n = a.getValue("ndec")) != null) {
                    int ndec = Integer.parseInt(n);
                    f.setNDec(ndec);
                }
                c.setInformat(f);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = false;
            } else if (name.equals("VALUE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_inEnum) {
                    c.addEnumValue(MapParserVS.this.m_val);
                }
            } else if (name.equals("DEFAULT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDefault(MapParserVS.this.m_val);
            } else {
                MapParserVS.this.m_status = 1;
                ArrayList<Tuple> details = new ArrayList<Tuple>();
                details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                Logger.log(res.getString("MsgParseBadEle.txt"), details, 2);
            }
        }
    }

    class MapParserVSH_1_1
    implements MapParserVSH {
        MapParserVS m_parent = null;

        public MapParserVSH_1_1(MapParserVS parent) {
            this.m_parent = parent;
        }

        @Override
        public void startElementVSH(String uri, String lname, String qname, Attributes attrs) {
            String name = lname;
            assert (lname != null);
            if ((name = name.toUpperCase()).equals("TABLE")) {
                Table t = MapParserVS.this.newTable(attrs);
                if (t.getName() == null) {
                    t.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.m_map.addTable(t);
                MapParserVS.this.context.push(t);
            } else if (name.equals("COLUMN")) {
                Column c = MapParserVS.this.newColumn(attrs);
                Atom peeked = MapParserVS.this.context.peek();
                if (!(peeked instanceof Table)) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                Table t = (Table)peeked;
                t.addColumn(c);
                if (c.getName() == null) {
                    c.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.context.push(c);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = true;
            }
        }

        @Override
        public void endElementVSH(String uri, String lname, String qname) {
            Column c;
            String name = lname.toUpperCase();
            Attributes a = MapParserVS.this.attrStack.pop();
            Atom ctxObj = MapParserVS.this.context.peek();
            Table t = ctxObj instanceof Table ? (Table)ctxObj : null;
            Column column = c = ctxObj instanceof Column ? (Column)ctxObj : null;
            if (name.equals("SXLEMAP")) {
                MapParserVS.this.context.pop();
            } else if (name.equals("TABLE")) {
                MapParserVS.this.context.pop();
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                t.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Map m = (Map)t.getParent();
                    m.getChildren().remove(t);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropTable.txt"), t.getName());
                    Logger.log(msg, null, 2);
                }
            } else if (name.equals("COLUMN")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                c.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Table tp = (Table)c.getParent();
                    tp.getColumns().remove(c);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropColumn.txt"), c.getName(), tp.getName());
                    Logger.log(msg, null, 2);
                }
                MapParserVS.this.context.pop();
            } else if (name.equals("TABLE-PATH")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setXPath(new XPath(MapParserVS.this.m_val));
            } else if (name.equals("TABLE-DESCRIPTION")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TABLE-END-PATH")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath toxp = new XPath(MapParserVS.this.m_val);
                t.setOptXPath(toxp);
                String be = a.getValue("beginend");
                toxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    toxp.setBeginEnd(1);
                }
            } else if (name.equals("DESCRIPTION")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setType(MapParserVS.this.m_val);
            } else if (name.equals("DATATYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDatatype(MapParserVS.this.m_val, MapParserVS.this.m_mapVer);
            } else if (name.equals("LENGTH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                int i = 0;
                try {
                    i = Integer.parseInt(MapParserVS.this.m_val.trim());
                    c.setLength(i);
                }
                catch (NumberFormatException be) {
                    // empty catch block
                }
                if (i == 0) {
                    MapParserVS.this.m_status = 1;
                    ArrayList<Tuple> details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                    details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                    String msg = MessageFormat.format(res.getString("MsgWarnBadLength.txt"), c.getName());
                    Logger.log(msg, details, 2);
                }
            } else if (name.equals("PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.parseXPath(MapParserVS.this.m_val);
            } else if (name.equals("INCREMENT-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath cixp = new XPath(MapParserVS.this.m_val);
                c.setIncrementXPath(cixp);
                String be = a.getValue("beginend");
                cixp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    cixp.setBeginEnd(1);
                }
            } else if (name.equals("RESET-PATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                XPath crxp = new XPath(MapParserVS.this.m_val);
                c.setResetXPath(crxp);
                String be = a.getValue("beginend");
                crxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    crxp.setBeginEnd(1);
                }
            } else if (name.equals("FORMAT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_val != null && MapParserVS.this.m_val.length() > 0) {
                    String n;
                    String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                    Format f = new Format(sname);
                    String w = a.getValue("width");
                    if (w != null) {
                        int width = Integer.parseInt(w);
                        f.setLength(width);
                    }
                    if ((n = a.getValue("ndec")) != null) {
                        int ndec = Integer.parseInt(n);
                        f.setNDec(ndec);
                    }
                    c.setFormat(f);
                }
            } else if (name.equals("INFORMAT")) {
                String n;
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                Format f = new Format(sname);
                String w = a.getValue("width");
                if (w != null) {
                    int width = Integer.parseInt(w);
                    f.setLength(width);
                }
                if ((n = a.getValue("ndec")) != null) {
                    int ndec = Integer.parseInt(n);
                    f.setNDec(ndec);
                }
                c.setInformat(f);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = false;
            } else if (name.equals("VALUE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_inEnum) {
                    c.addEnumValue(MapParserVS.this.m_val);
                }
            } else if (name.equals("DEFAULT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDefault(MapParserVS.this.m_val);
            } else {
                MapParserVS.this.m_status = 1;
                ArrayList<Tuple> details = new ArrayList<Tuple>();
                details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                Logger.log(res.getString("MsgParseBadEle.txt"), details, 2);
            }
        }
    }

    class MapParserVSH_1_0
    implements MapParserVSH {
        MapParserVS m_parent = null;

        public MapParserVSH_1_0(MapParserVS parent) {
            this.m_parent = parent;
        }

        @Override
        public void startElementVSH(String uri, String lname, String qname, Attributes attrs) {
            String name = lname;
            assert (lname != null);
            if ((name = name.toUpperCase()).equals("TABLE")) {
                Table t = MapParserVS.this.newTable(attrs);
                if (t.getName() == null) {
                    t.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.m_map.addTable(t);
                MapParserVS.this.context.push(t);
            } else if (name.equals("COLUMN")) {
                Column c = MapParserVS.this.newColumn(attrs);
                Atom peeked = MapParserVS.this.context.peek();
                if (!(peeked instanceof Table)) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                Table t = (Table)peeked;
                t.addColumn(c);
                if (c.getName() == null) {
                    c.setName(MapParserVS.m_noName);
                }
                MapParserVS.this.context.push(c);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = true;
            }
        }

        @Override
        public void endElementVSH(String uri, String lname, String qname) {
            Column c;
            String name = lname.toUpperCase();
            Attributes a = MapParserVS.this.attrStack.pop();
            Atom ctxObj = MapParserVS.this.context.peek();
            Table t = ctxObj instanceof Table ? (Table)ctxObj : null;
            Column column = c = ctxObj instanceof Column ? (Column)ctxObj : null;
            if (name.equals("XMLMAP") || name.equals("SXLEMAP")) {
                MapParserVS.this.context.pop();
            } else if (name.equals("TABLE")) {
                MapParserVS.this.context.pop();
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                t.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Map m = (Map)t.getParent();
                    m.getChildren().remove(t);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropTable.txt"), t.getName());
                    Logger.log(msg, null, 2);
                }
            } else if (name.equals("COLUMN")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                ArrayList<ValidationIssue> foo = new ArrayList<ValidationIssue>();
                c.validate(foo);
                if (MapParserVS.this.issuesHaveErr(foo)) {
                    Table tp = (Table)c.getParent();
                    tp.getColumns().remove(c);
                    MapParserVS.this.m_status = 1;
                    String msg = MessageFormat.format(res.getString("MsgParseDropColumn.txt"), c.getName(), tp.getName());
                    Logger.log(msg, null, 2);
                }
                MapParserVS.this.context.pop();
            } else if (MapParserVS.this.VerLT(1, 0) && (name.equals("TABLE_NAME") || name.equals("NAME") && t != null)) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setName(MapParserVS.this.m_val);
            } else if (name.equals("TABLE_XPATH")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setXPath(new XPath(MapParserVS.this.m_val));
            } else if (name.equals("TABLE_LABEL")) {
                if (t == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                t.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TABLE_END_XPATH")) {
                assert (t != null);
                XPath toxp = new XPath(MapParserVS.this.m_val);
                t.setOptXPath(toxp);
                String be = a.getValue("beginend");
                toxp.setBeginEnd(0);
                if (be != null && be.compareToIgnoreCase("END") == 0) {
                    toxp.setBeginEnd(1);
                }
            } else if (MapParserVS.this.VerLE(1, 0) && (name.equals("COLUMN_NAME") || name.equals("NAME") && c != null)) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setName(MapParserVS.this.m_val);
            } else if (name.equals("LABEL") || name.equals("DESCRIPTION") || MapParserVS.this.VerLE(1, 0) && name.equals("COLUMN_LABEL")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDescription(MapParserVS.this.m_val);
            } else if (name.equals("TYPE") || MapParserVS.this.VerLE(1, 0) && name.equals("SASTYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.VerLT(1, 0) && "NUM".equals(MapParserVS.this.m_val)) {
                    c.setType("numeric");
                } else {
                    c.setType(MapParserVS.this.m_val);
                }
            } else if (name.equals("DATATYPE") || MapParserVS.this.VerLE(1, 0) && name.equals("XMLTYPE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDatatype(MapParserVS.this.m_val, MapParserVS.this.m_mapVer);
            } else if (name.equals("LENGTH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                int i = 0;
                try {
                    i = Integer.parseInt(MapParserVS.this.m_val.trim());
                    c.setLength(i);
                }
                catch (NumberFormatException be) {
                    // empty catch block
                }
                if (i == 0) {
                    MapParserVS.this.m_status = 1;
                    ArrayList<Tuple> details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                    details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                    String msg = MessageFormat.format(res.getString("MsgWarnBadLength.txt"), c.getName());
                    Logger.log(msg, details, 2);
                }
            } else if (name.equals("XPATH")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.parseXPath(MapParserVS.this.m_val);
            } else if (name.equals("FORMAT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_val != null && MapParserVS.this.m_val.length() > 0) {
                    String n;
                    String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                    Format f = new Format(sname);
                    String w = a.getValue("width");
                    if (w != null) {
                        int width = Integer.parseInt(w);
                        f.setLength(width);
                    }
                    if ((n = a.getValue("ndec")) != null) {
                        int ndec = Integer.parseInt(n);
                        f.setNDec(ndec);
                    }
                    c.setFormat(f);
                }
            } else if (name.equals("INFORMAT")) {
                String n;
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                String sname = MapParserVS.this.fixupName(MapParserVS.this.m_val, 2);
                Format f = new Format(sname);
                String w = a.getValue("width");
                if (w != null) {
                    int width = Integer.parseInt(w);
                    f.setLength(width);
                }
                if ((n = a.getValue("ndec")) != null) {
                    int ndec = Integer.parseInt(n);
                    f.setNDec(ndec);
                }
                c.setInformat(f);
            } else if (name.equals("ENUM")) {
                MapParserVS.this.m_inEnum = false;
            } else if (name.equals("VALUE")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                if (MapParserVS.this.m_inEnum) {
                    c.addEnumValue(MapParserVS.this.m_val);
                }
            } else if (name.equals("DEFAULT")) {
                if (c == null) {
                    MapParserVS.this.failContext(name);
                    return;
                }
                c.setDefault(MapParserVS.this.m_val);
            } else {
                MapParserVS.this.m_status = 1;
                ArrayList<Tuple> details = new ArrayList<Tuple>();
                details.add(new Tuple(res.getString("MsgParseElement.txt"), lname));
                details.add(new Tuple(res.getString("MsgParseData.txt"), MapParserVS.this.m_val));
                Logger.log(res.getString("MsgParseBadEle.txt"), details, 2);
            }
        }
    }
}

