/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.Molecule;
import com.sas.sxle.map.Polymer;
import com.sas.sxle.map.Table;
import com.sas.sxle.map.ValidationIssue;
import com.sas.sxle.map.XPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class MapDataComparator {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private static ArrayList<String> m_paths = null;
    private static Polymer m_prevRoot = null;

    public static void validate(Map map, Polymer root, ArrayList<ValidationIssue> issues) {
        if (map == null || root == null) {
            return;
        }
        if (m_paths == null) {
            m_paths = new ArrayList();
        }
        if (root != m_prevRoot) {
            m_paths.clear();
            MapDataComparator.getValidPaths(root);
        }
        MapDataComparator.compareMap(map, issues);
    }

    private static void getValidPaths(Molecule root) {
        String xp = root.getXPathName();
        if (xp != null && xp.length() > 0) {
            m_paths.add(xp);
        }
        for (int c = 0; c < root.getChildCount(); ++c) {
            Atom child = root.getChildren().get(c);
            if (!(child instanceof Molecule)) continue;
            MapDataComparator.getValidPaths((Molecule)child);
        }
    }

    private static void compareMap(Map map, ArrayList<ValidationIssue> issues) {
        for (int t = 0; t < map.getTableCount(); ++t) {
            Table tab = map.getTable(t);
            if (!MapDataComparator.validPath(tab.getXPath(), m_paths)) {
                String msg = MessageFormat.format(res.getString("VMsgTablePathNoSynch.txt"), tab.getName());
                ValidationIssue vi = new ValidationIssue(4, msg, tab);
                issues.add(vi);
            }
            for (int c = 0; c < tab.getColumnCount(); ++c) {
                Column col = tab.getColumn(c);
                if (MapDataComparator.validPath(col.getXPath(), m_paths)) continue;
                String msg = MessageFormat.format(res.getString("VMsgColumnPathNoSynch.txt"), col.getName(), tab.getName());
                ValidationIssue vi = new ValidationIssue(4, msg, col);
                issues.add(vi);
            }
        }
    }

    private static boolean validPath(XPath path, ArrayList<String> paths) {
        if (path == null || path.getValue() == null || path.getValue().length() < 1) {
            return true;
        }
        String xpv = path.getValue();
        for (int i = 0; i < paths.size(); ++i) {
            String p = paths.get(i);
            if (xpv.compareTo(p) != 0) continue;
            return true;
        }
        return false;
    }
}

