/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Isomer;
import com.sas.sxle.map.ModelBundle;
import com.sas.sxle.map.Namespace;
import com.sas.sxle.map.NamespaceList;
import com.sas.sxle.map.Output;
import com.sas.sxle.map.Polymer;
import com.sas.sxle.map.SASName;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Table;
import com.sas.sxle.map.ValidationIssue;
import com.sas.sxle.map.XMLFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class Map
extends Atom
implements Serializable {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    public static final int kVT_NONE = 0;
    public static final int kVT_XSD = 1;
    public static final int kVT_DTD = 2;
    public static final int kMV_1_0 = 0;
    public static final int kMV_1_1 = 1;
    public static final int kMV_1_2 = 2;
    public static final int kMV_1_9 = 3;
    public static final int kMV_2_1 = 4;
    public static final int kBadVer = -1;
    public static final int kMinVer = 0;
    public static final int kMaxVer = 4;
    public static final int kCurrentVer = 4;
    public static final String[] VERSIONS = new String[]{"1.0", "1.1", "1.2", "1.9", "2.1"};
    public static final String[] EMITVERSIONS = new String[]{"2.1"};
    private int m_validationType = 0;
    public static final int kMMQuasiNormalized = 0;
    public static final int kMMFlattened = 1;
    public static final int kMMPooled = 2;
    public static final int kMMShredded = 3;
    public static final int kMMDefault = 0;
    private int m_version = 4;
    private transient Charset m_encoding = null;
    private NamespaceList m_namespaces = null;
    private Output m_output = null;
    boolean m_makeOrds = true;
    boolean _prefixAttrName = false;

    public Map() {
        this.setVersion(SXLEContext.version());
        if (this.getVersionID() < 4) {
            this.setVersion(4);
        }
        if (this.getVersionID() >= 3) {
            this.m_output = new Output();
        }
        if (this.getVersionID() >= 4) {
            this.m_output = new Output();
            this.addChild(this.m_output);
            this.m_namespaces = new NamespaceList();
            this.addChild(this.m_namespaces);
        }
        String enc = SXLEContext.encoding();
        Charset cs = null;
        cs = enc == null ? XMLFile.getDefaultEncoding() : Charset.forName(enc);
        this.setEncoding(cs);
    }

    public Charset getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String enc) {
        Charset cs = Charset.forName(enc);
        if (cs == null) {
            cs = XMLFile.getDefaultEncoding();
        }
        this.setEncoding(cs);
    }

    public void setEncoding(Charset cs) {
        if (cs != null) {
            this.m_encoding = cs;
        }
        this.m_dirty = true;
    }

    public int getVersionID() {
        return this.m_version;
    }

    public String getVersion() {
        return VERSIONS[this.m_version];
    }

    public void setVersion(String vername) {
        this.m_version = -1;
        this.m_dirty = true;
        if (vername == null) {
            this.m_version = 0;
            return;
        }
        this.m_version = Map.lookupVersion(vername);
    }

    public static int lookupVersion(String vername) {
        for (int v = 0; v < VERSIONS.length; ++v) {
            if (!vername.equalsIgnoreCase(VERSIONS[v])) continue;
            return v;
        }
        return -1;
    }

    public void setVersion(int version) {
        this.m_dirty = true;
        this.m_version = version;
    }

    public void setValidation(int val) {
        this.m_validationType = val;
        this.m_dirty = true;
    }

    public int getValidation() {
        return this.m_validationType;
    }

    public void addTable(Table tab) {
        this.m_children.add(tab);
        tab.setParent(this);
        this.m_dirty = true;
    }

    public void clearMap() {
        this.m_children = null;
    }

    public ArrayList<Table> getTables() {
        ArrayList<Table> tabs = new ArrayList<Table>();
        for (int a = 0; a < this.m_children.size(); ++a) {
            if (!(this.m_children.get(a) instanceof Table)) continue;
            tabs.add((Table)this.m_children.get(a));
        }
        return tabs;
    }

    public Table getTable(int t) {
        if (this.getTables() == null) {
            return null;
        }
        if (t + 1 > this.getTables().size()) {
            return null;
        }
        return this.getTables().get(t);
    }

    public int getTableCount() {
        if (this.getTables() == null) {
            return 0;
        }
        return this.getTables().size();
    }

    public void debugDump() {
    }

    private void debugDump(Atom a, int nestLevel) {
    }

    public boolean validate(ArrayList<ValidationIssue> issues) {
        String msg;
        boolean isOK = true;
        if (!SASName.isValid(this.getName())) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgMapNameInvalid.txt"), this.getName());
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (SASName.isReserved(this.getName())) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgMapNameReserved.txt"), this.getName());
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.getName() != null && (this.getName().compareToIgnoreCase("SXLEMAP") == 0 || this.getName().compareToIgnoreCase("XMLMAP") == 0)) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgMapNameDefault.txt"), this.getName());
            issues.add(new ValidationIssue(2, msg, this));
        }
        if (this.m_version < 0 || this.m_version > 4) {
            isOK = false;
            msg = res.getString("VMsgMapVersionInvalid.txt");
            issues.add(new ValidationIssue(1, msg, this));
        } else if (this.m_version < 4) {
            msg = MessageFormat.format(res.getString("VMsgMapVersionOld.txt"), VERSIONS[this.m_version]);
            issues.add(new ValidationIssue(3, msg, this));
        }
        ArrayList<Table> tabs = this.getTables();
        if (tabs == null || tabs.size() == 0) {
            isOK = false;
            String msg2 = res.getString("VMsgMapEmpty.txt");
            issues.add(new ValidationIssue(1, msg2, this));
        } else {
            for (int t = 0; t < this.getTables().size(); ++t) {
                String tabName = tabs.get(t).getName();
                for (int t2 = t + 1; t2 < tabs.size(); ++t2) {
                    String tab2Name = tabs.get(t2).getName();
                    if (tabName.compareToIgnoreCase(tab2Name) != 0) continue;
                    isOK = false;
                    String msg3 = MessageFormat.format(res.getString("VMsgMapDupTable.txt"), tabName);
                    issues.add(new ValidationIssue(1, msg3, tabs.get(t)));
                }
                isOK &= tabs.get(t).validate(issues);
            }
        }
        if (isOK) {
            issues.add(new ValidationIssue(3, res.getString("VMsgSuccess.txt"), null));
        } else {
            issues.add(new ValidationIssue(3, res.getString("VMsgError.txt"), null));
        }
        return isOK;
    }

    public void autoMake(Isomer realRoot, ModelBundle bundle, ArrayList<ValidationIssue> issues) {
        this._prefixAttrName = SXLEContext.prefixAttributeNames();
        this.m_makeOrds = SXLEContext.genOrdinals();
        this.setName("AUTO_GEN");
        this.setNamespaces(bundle.getNamespaces());
        this.makerIso(realRoot, issues, null, "");
        if (!this.m_makeOrds) {
            for (int c = this.m_children.size() - 1; c >= 0; --c) {
                Table child;
                if (!(this.m_children.get(c) instanceof Table) || (child = (Table)this.m_children.get(c)).getColumnCount() != 0) continue;
                this.m_children.remove(child);
            }
        }
    }

    public void autoMake(Polymer root, ModelBundle bundle, ArrayList<ValidationIssue> issues) {
        this._prefixAttrName = SXLEContext.prefixAttributeNames();
        this.m_makeOrds = SXLEContext.genOrdinals();
        this.setName("AUTO_GEN");
        this.setNamespaces(bundle.getNamespaces());
        this.maker(root, issues, null);
        if (!this.m_makeOrds) {
            for (int c = this.m_children.size() - 1; c >= 0; --c) {
                Table child;
                Object o = this.m_children.get(c);
                if (!(o instanceof Table) || (child = (Table)o).getColumnCount() != 0) continue;
                this.m_children.remove(child);
            }
        }
    }

    private void maker(Polymer node, ArrayList<ValidationIssue> issues, Table parent) {
        boolean isTable;
        if (node.getType() == 6) {
            for (int c = 0; c < node.m_children.size(); ++c) {
                Object child = node.m_children.get(c);
                if (!(child instanceof Polymer)) continue;
                this.maker((Polymer)child, issues, parent);
            }
        }
        if (node.getType() != 1 && node.getType() != 7) {
            return;
        }
        Table current = new Table();
        String tname = node.getName();
        tname = SASName.sasify(tname);
        if (parent != null) {
            tname = SASName.uniquify(tname, this);
        }
        String ptname = this.prependNamepace(tname, node.getNamespace());
        current.setName(ptname);
        current.setDescription(node.getName());
        current.setXPath(node.getXPathName());
        boolean bl = isTable = node.hasChildren() || node.hasAttributes() || node.getMaxCardinality() > 1 || parent == null;
        if (isTable) {
            this.addTable(current);
            if (this.m_makeOrds) {
                if (parent != null) {
                    Column c = new Column();
                    c.setOrdinal();
                    c.setName(parent.getName() + "_ORDINAL");
                    c.setName(SASName.uniquify(SASName.sasify(c.getName()), current));
                    c.setIncrementXPath(parent.getXPath());
                    current.addColumn(c);
                }
                Column k = new Column();
                k.setOrdinal();
                k.setName(tname + "_ORDINAL");
                k.setName(SASName.uniquify(SASName.sasify(k.getName()), current));
                k.setIncrementXPath(node.getXPathName());
                current.addColumn(k);
            }
            for (int c = 0; c < node.m_children.size(); ++c) {
                Object child = node.m_children.get(c);
                if (!(child instanceof Polymer)) continue;
                this.maker((Polymer)child, issues, current);
            }
        }
        if (node.hasData() || !isTable) {
            Column c = new Column();
            c.setDescription(node.getDescription());
            c.setXPath(node.getXPathName());
            c.setPolymer(node);
            if (node.hasData()) {
                c.setTypeAndDatatype(node.getDatatype());
                c.setLength(node.getLength());
            } else {
                c.setTypeAndDatatype(1);
                c.setLength(0);
            }
            if (node.getType() == 7) {
                if (this._prefixAttrName) {
                    String parName = parent.getName();
                    tname = SASName.sasify(parName + "_" + tname);
                }
                tname = this.prependNamepace(tname, node.getNamespace());
                c.setName(SASName.uniquify(tname, parent));
                parent.addColumn(c);
            } else if (isTable) {
                this.prependNamepace(tname, node.getNamespace());
                c.setName(SASName.uniquify(tname, current));
                current.addColumn(c);
            } else {
                tname = this.prependNamepace(tname, node.getNamespace());
                c.setName(SASName.uniquify(tname, parent));
                parent.addColumn(c);
            }
        }
    }

    private void makerIso(Isomer node, ArrayList<ValidationIssue> issues, Table parent, String pxpath) {
        boolean isTable;
        if (node.getType() == 6) {
            for (int c = 0; c < node.m_children.size(); ++c) {
                Object child = node.m_children.get(c);
                if (!(child instanceof Isomer)) continue;
                Isomer i = (Isomer)child;
                this.makerIso(i, issues, parent, pxpath);
            }
        }
        if (node.getType() != 0 && node.getType() != 1 && node.getType() != 7) {
            return;
        }
        String xpath = pxpath + '/';
        if (node.hasNamespace()) {
            xpath = xpath + "{" + node.getNamespace().getIndex() + "}";
        }
        if (node.getType() == 7) {
            xpath = xpath + '@';
        }
        xpath = xpath + node.getName();
        Table current = new Table();
        String tname = node.getName();
        tname = this.prependNamepace(tname, node.getNamespace());
        tname = SASName.sasify(tname);
        tname = SASName.uniquify(tname, this);
        current.setName(tname);
        current.setDescription(node.getName());
        current.setXPath(xpath);
        boolean bl = isTable = node.hasChildren() || node.hasAttributes();
        if (isTable) {
            this.addTable(current);
            if (this.m_makeOrds) {
                if (parent != null) {
                    Column c = new Column();
                    c.setOrdinal();
                    c.setName(parent.getName() + "_ORDINAL");
                    c.setDescription(parent.getName() + "_ORDINAL");
                    c.setName(SASName.uniquify(SASName.sasify(c.getName()), current));
                    c.setIncrementXPath(pxpath);
                    current.addColumn(c);
                }
                Column k = new Column();
                k.setOrdinal();
                k.setName(tname + "_ORDINAL");
                k.setDescription(tname + "_ORDINAL");
                k.setName(SASName.uniquify(SASName.sasify(k.getName()), current));
                k.setIncrementXPath(xpath);
                current.addColumn(k);
            }
            for (int c = 0; c < node.m_children.size(); ++c) {
                Object child = node.m_children.get(c);
                if (!(child instanceof Isomer)) continue;
                Isomer i = (Isomer)child;
                this.makerIso(i, issues, current, xpath);
            }
        }
        if (node.hasData() || !isTable) {
            Column c = new Column();
            c.setDescription(node.getName());
            c.setXPath(xpath);
            if (node.hasData() && node.getDatatype() != 0) {
                c.setTypeAndDatatype(node.getDatatype());
                c.setLength(node.getLength());
                c.setEnumValues(node.getEnum());
            } else {
                c.setTypeAndDatatype(1);
                c.setLength(node.getLength());
                c.setEnumValues(node.getEnum());
            }
            if (node.getType() == 7) {
                if (this._prefixAttrName) {
                    String parName = parent.getName();
                    tname = SASName.sasify(parName + "_" + tname);
                }
                this.prependNamepace(tname, node.getNamespace());
                c.setName(SASName.uniquify(tname, parent));
                parent.addColumn(c);
            } else if (isTable) {
                this.prependNamepace(tname, node.getNamespace());
                c.setName(SASName.uniquify(tname, current));
                current.addColumn(c);
            } else if (parent != null) {
                this.prependNamepace(tname, node.getNamespace());
                c.setName(SASName.uniquify(tname, parent));
                parent.addColumn(c);
            }
        }
    }

    public int getColumnCount() {
        int cols = 0;
        for (int t = 0; t < this.getTableCount(); ++t) {
            cols += this.getTable(t).getColumnCount();
        }
        return cols;
    }

    public void setNamespaces(NamespaceList namespaces) {
        this.m_namespaces = new NamespaceList(namespaces);
        Atom nsl = this.getChildNamed(res.getString("LabelNamespaces.txt"));
        if (nsl != null) {
            int nsli = this.getChildren().indexOf(nsl);
            this.getChildren().set(nsli, this.m_namespaces);
        }
    }

    public NamespaceList getNamespaces() {
        return this.m_namespaces;
    }

    public void setOutput(Output output) {
        this.m_output = output;
        Atom outp = this.getChildNamed(res.getString("LabelOutput.txt"));
        if (outp != null) {
            int outpi = this.getChildren().indexOf(outp);
            this.getChildren().set(outpi, this.m_output);
        }
    }

    public Output getOutput() {
        return this.m_output;
    }

    public void extractNamespaces(Atom atom) {
        Atom a = atom;
        while (a != null) {
            if (a.getNamespace() != null) {
                this.m_namespaces.add(new Namespace(a.m_namespace));
            }
            a = a.m_parent;
        }
    }

    public String prependNamepace(String sasName, Namespace ns) {
        String nsName;
        boolean prependNSName = SXLEContext.prefixNSNames();
        if (prependNSName && ns != null && (nsName = ns.getPrefix()) != null) {
            String tmpname = nsName + "_" + sasName;
            sasName = SASName.sasify(tmpname);
        }
        return sasName;
    }
}

