/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.LogItem;
import com.sas.sxle.map.LogItemComparator;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Tuple;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Logger {
    private static ArrayList<LogItem> m_log = null;
    private static ArrayList<ChangeListener> m_listeners = null;
    static boolean m_verbose = false;

    private Logger() {
    }

    public static void init() {
        if (m_listeners == null) {
            m_listeners = new ArrayList(10);
        }
        m_log = new ArrayList();
        m_verbose = SXLEContext.verboseLogging();
        Logger.fireStateChanged(new ChangeEvent(m_log));
    }

    public static void log(LogItem item) {
        assert (m_log != null);
        m_log.add(item);
        Logger.fireStateChanged(new ChangeEvent(m_log));
    }

    public static void log(String event, int severity) {
        assert (m_log != null);
        m_log.add(new LogItem(event, severity));
        Logger.fireStateChanged(new ChangeEvent(m_log));
    }

    public static void logVerbose(String event, int severity) {
        if (m_verbose) {
            Logger.log(event, severity);
        }
    }

    public static void log(String event, ArrayList<Tuple> details, int severity) {
        assert (m_log != null);
        m_log.add(new LogItem(event, details, severity));
        Logger.fireStateChanged(new ChangeEvent(m_log));
    }

    public static void logVerbose(String event, ArrayList<Tuple> details, int severity) {
        if (m_verbose) {
            Logger.log(event, details, severity);
        }
    }

    public static ArrayList<LogItem> getLog() {
        return m_log;
    }

    public static void addChangeListener(ChangeListener cl) {
        assert (m_listeners != null);
        m_listeners.add(cl);
    }

    public static void removeChangeListener(ChangeListener cl) {
        assert (m_listeners != null);
        m_listeners.remove(cl);
    }

    public static void fireStateChanged(ChangeEvent e) {
        assert (m_listeners != null);
        for (int l = 0; l < m_listeners.size(); ++l) {
            m_listeners.get(l).stateChanged(e);
        }
    }

    private static void writeItemsToDom(Element parent, String name, Document doc) {
        for (int i = 0; i < m_log.size(); ++i) {
            LogItem li = m_log.get(i);
            Element event = doc.createElement(name);
            parent.appendChild(event);
            Element id = doc.createElement("EventID");
            event.appendChild(id);
            id.appendChild(doc.createTextNode(Integer.toString(i)));
            Element desc = doc.createElement("Description");
            event.appendChild(desc);
            desc.appendChild(doc.createTextNode(li.getDescription()));
            Element sev = doc.createElement("Severity");
            event.appendChild(sev);
            String sevText = "";
            switch (li.getSeverity()) {
                default: {
                    sevText = "Error";
                    break;
                }
                case 2: {
                    sevText = "Warning";
                    break;
                }
                case 3: {
                    sevText = "Information";
                }
            }
            sev.appendChild(doc.createTextNode(sevText));
            Element tstamp = doc.createElement("Timestamp");
            event.appendChild(tstamp);
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern("yyyy-MM-dd'T'HH:mm:ss");
            GregorianCalendar cal = new GregorianCalendar();
            long tzo = cal.getTimeZone().getOffset(li.getTimestamp().getTime());
            int min = Math.abs((int)((tzo /= 60000L) % 60L));
            int hrs = Math.abs((int)(tzo / 60L % 24L));
            String tztxt = tzo < 0L ? "-" : "+";
            tztxt = tztxt + (hrs < 10 ? "0" : "");
            tztxt = tztxt + Integer.toString(hrs);
            tztxt = tztxt + ":";
            tztxt = tztxt + (min < 10 ? "0" : "");
            tztxt = tztxt + Integer.toString(min);
            String dt = sdf.format(li.getTimestamp());
            tstamp.appendChild(doc.createTextNode(dt + tztxt));
            if (!li.hasDetails()) continue;
            for (int d = 0; d < li.getDetails().size(); ++d) {
                Tuple tup = li.getDetails().get(d);
                Element detail = doc.createElement("Detail");
                parent.appendChild(detail);
                Element evid = doc.createElement("EventID");
                detail.appendChild(evid);
                evid.appendChild(doc.createTextNode(Integer.toString(i)));
                Element detid = doc.createElement("DetailID");
                detail.appendChild(detid);
                detid.appendChild(doc.createTextNode(Integer.toString(d)));
                Element attr = doc.createElement("Item");
                detail.appendChild(attr);
                attr.appendChild(doc.createTextNode(tup.getAttribute()));
                Element val = doc.createElement("Value");
                detail.appendChild(val);
                String v = tup.getValue() == null ? "" : tup.getValue();
                val.appendChild(doc.createTextNode(v));
            }
        }
    }

    public static void save(File f) throws Exception {
        LogItemComparator comp = new LogItemComparator();
        comp.setMode(2, false);
        Collections.sort(m_log, comp);
        DocumentBuilderFactory xdbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder xdb = null;
        Document doc = null;
        xdb = xdbf.newDocumentBuilder();
        doc = xdb.newDocument();
        Element root = doc.createElement("XMLMapperLog");
        doc.appendChild(root);
        Logger.writeItemsToDom(root, "Event", doc);
        TransformerFactory xtf = TransformerFactory.newInstance();
        Transformer xt = xtf.newTransformer();
        xt.setOutputProperty("encoding", "UTF-8");
        xt.setOutputProperty("indent", "yes");
        FileOutputStream fos = new FileOutputStream(f);
        xt.transform(new DOMSource(doc), new StreamResult(fos));
        fos.close();
    }

    public static LogItem lastItem() {
        if (m_log == null || m_log.size() == 0) {
            return null;
        }
        return m_log.get(m_log.size() - 1);
    }

    public static void clear() {
        m_log = new ArrayList();
    }
}

