/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Counter;
import com.sas.sxle.map.Datatype;
import com.sas.sxle.map.Molecule;
import com.sas.sxle.map.Sample;
import java.util.ArrayList;

public class Isomer
extends Molecule {
    private static final long serialVersionUID = -5248340251753589220L;
    private int m_maxLen = 0;
    public Counter m_refCount = null;
    private int m_probDatype = 0;
    private ArrayList<String> m_enumData = null;

    public Isomer() {
    }

    public Isomer(Isomer iso) {
        this.setName(iso.getName());
        this.m_description = iso.m_description;
        this.m_hasAttrs = iso.m_hasAttrs;
        this.m_type = iso.m_type;
        this.m_children = iso.m_children;
        this.m_probDatype = iso.m_probDatype;
        this.m_refCount = iso.m_refCount;
        this.m_accumulate = iso.m_accumulate;
        this.m_maxLen = iso.m_maxLen;
        this.m_parent = iso.m_parent;
        this.m_value = iso.m_value;
        this.m_enumData = iso.m_enumData;
        this.m_namespace = iso.m_namespace;
    }

    public boolean matches(Isomer iso) {
        if (this.getType() != iso.getType()) {
            return false;
        }
        if (this.getName().compareTo(iso.getName()) != 0) {
            return false;
        }
        if (this.getNamespace() == null) {
            return iso.getNamespace() == null;
        }
        if (iso.getNamespace() == null) {
            return false;
        }
        return this.getNamespace().matches(iso.getNamespace().getURI());
    }

    public Isomer tryAddChild(Isomer child) {
        Isomer sib = null;
        sib = child.getNamespace() == null ? (Isomer)this.getChildNamed(child.getName()) : (Isomer)this.getChildMatching(child.getName(), child.getNamespace().getURI());
        if (sib == null) {
            Isomer kid = new Isomer(child);
            this.addChild(kid);
            return kid;
        }
        return sib;
    }

    public int getDatatype() {
        return this.m_probDatype;
    }

    public void setXSDDatatype(String dtName) {
        this.m_probDatype = Datatype.simplifyXSDType(dtName);
    }

    @Override
    public String toString() {
        if (this.m_refCount == null) {
            return this.getName();
        }
        String nm = this.getName() + "(" + Integer.toString(this.m_refCount.get()) + ")";
        if (this.hasNamespace()) {
            nm = "{" + this.m_namespace.getURI() + "}" + nm;
        }
        return nm;
    }

    @Override
    public int getLength() {
        return this.m_maxLen;
    }

    public void setLength(int len) {
        this.m_maxLen = len;
    }

    public boolean hasSample() {
        return this.m_probDatype != 0;
    }

    public Sample getSample() {
        Sample s = new Sample(Datatype.DATATYPE[this.m_probDatype]);
        s.setDatatype(this.m_probDatype);
        return s;
    }

    public void setCounter(Counter c) {
        this.m_refCount = c;
    }

    public Counter getCounter() {
        return this.m_refCount;
    }

    public boolean isRecursive() {
        for (Atom p = this.getParent(); p != null; p = p.getParent()) {
            if (p.getName().compareTo(this.getName()) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnum() {
        return this.m_enumData != null && this.m_enumData.size() > 0;
    }

    public ArrayList<String> getEnum() {
        return this.m_enumData;
    }

    public void setEnum(ArrayList<String> data) {
        this.m_enumData = data;
    }

    public void addEnumValue(String val) {
        if (this.m_enumData == null) {
            this.m_enumData = new ArrayList();
        }
        this.m_enumData.add(val);
    }
}

