/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Format;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public final class Datatype {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    public static final int kDT_UNKNOWN = 0;
    public static final int kDT_STRING = 1;
    public static final int kDT_INT = 2;
    public static final int kDT_FLOAT = 3;
    public static final int kDT_8601DATE = 4;
    public static final int kDT_8601DATETIME = 5;
    public static final int kDT_8601TIME = 6;
    public static final int kDT_SASMMDDYY = 7;
    public static final int kDT_SASDATE = 8;
    public static final int kDT_SASDATETIME = 9;
    public static final int kDT_SASTIME = 10;
    public static final int kDT_SASANYDTDTE = 11;
    public static final int kDT_SASANYDTDTM = 12;
    public static final int kDT_SASANYDTTME = 13;
    public static final int[] m_dt2base = new int[]{0, 0, 1, 2, 3, 4, 5, 3, 3, 4, 5, 4, 5, 6};
    public static final Object[][] XSDDATATYPE = new Object[][]{{"string", new Integer(1)}, {"integer", new Integer(2)}, {"double", new Integer(3)}, {"dateTime", new Integer(5)}, {"time", new Integer(6)}, {"date", new Integer(4)}, {"float", new Integer(3)}, {"int", new Integer(2)}, {"short", new Integer(2)}, {"long", new Integer(2)}, {"decimal", new Integer(3)}, {"nonPositiveInteger", new Integer(2)}, {"negativeInteger", new Integer(2)}, {"nonNegativeInteger", new Integer(2)}, {"positiveInteger", new Integer(2)}, {"unsignedByte", new Integer(2)}, {"gYearMonth", new Integer(2)}, {"gYear", new Integer(2)}, {"gMonthDay", new Integer(2)}, {"gDay", new Integer(2)}, {"gMonth", new Integer(2)}, {"duration", new Integer(1)}, {"unsignedShort", new Integer(2)}, {"unsignedInt", new Integer(2)}, {"unsignedLong", new Integer(2)}, {"boolean", new Integer(1)}, {"byte", new Integer(2)}, {"normalizedString", new Integer(1)}, {"base64binary", new Integer(1)}, {"hexBinary", new Integer(1)}, {"ID", new Integer(1)}, {"token", new Integer(1)}, {"language", new Integer(1)}, {"anyType", new Integer(1)}, {"anySimpleType", new Integer(1)}, {"anyURI", new Integer(1)}, {"Name", new Integer(1)}, {"NCName", new Integer(1)}, {"QName", new Integer(1)}, {"IDREF", new Integer(1)}, {"ENTITY", new Integer(1)}, {"NMTOKEN", new Integer(1)}, {"NOTATION", new Integer(1)}};
    public static final Object[][] ALIAS = new Object[][]{{"INTEGER", new Integer(2)}};
    public static final String[] OLDDATATYPE = new String[]{"UNKNOWN", "STRING", "INT", "FLOAT", "DAT-8601", "DT-8601", "TM-8601", "MMDDYY", "DATE", "DATETIME", "HHMM", "ANYDATE"};
    public static final String[] OLDBASEDATATYPE = new String[]{"STRING", "INT", "FLOAT", "DAT-8601", "DT-8601", "TM-8601"};
    public static final String[] BASEDATATYPE = new String[]{"string", "integer", "double", "date", "datetime", "time"};
    public static final String[] DATATYPE = new String[]{"UNKNOWN", "string", "integer", "double", "date", "datetime", "time", "MMDDYY", "DATE", "DATETIME", "HHMM", "ANYDTDTE", "ANYDTDTM", "ANYDTTME"};
    public static final int NUMBASETYPES = 6;
    public static final String[] OLDEMITDATATYPE = new String[]{"STRING", "STRING", "INT", "FLOAT", "DAT-8601", "DT-8601", "TM-8601", "DAT-8601", "DAT-8601", "DT-8601", "TM-8601", "DT-8601"};
    public static final String[] EMITDATATYPE = new String[]{"string", "string", "integer", "double", "date", "datetime", "time", "date", "date", "datetime", "time", "date", "datetime", "time"};
    public static final int[] COLUMNTYPE = new int[]{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static Pattern[] m_patterns;
    private static final int[][] m_lookup;

    private Datatype() {
    }

    public static final int bestMatch(String data) {
        if (data == null) {
            return 0;
        }
        if (m_patterns[2].matcher(data = data.trim()).matches()) {
            if (data.length() > 9) {
                try {
                    Integer.parseInt(data);
                }
                catch (NumberFormatException nfe) {
                    return 1;
                }
            }
            return 2;
        }
        if (m_patterns[3].matcher(data).matches()) {
            return 3;
        }
        if (m_patterns[5].matcher(data).matches()) {
            return 5;
        }
        if (m_patterns[6].matcher(data).matches()) {
            return 6;
        }
        if (m_patterns[4].matcher(data).matches()) {
            return 4;
        }
        if (m_patterns[9].matcher(data).matches()) {
            return 9;
        }
        if (m_patterns[10].matcher(data).matches()) {
            return 10;
        }
        if (m_patterns[8].matcher(data).matches()) {
            return 8;
        }
        if (m_patterns[7].matcher(data).matches()) {
            return 7;
        }
        if (m_patterns[12].matcher(data).matches()) {
            return 12;
        }
        if (m_patterns[11].matcher(data).matches()) {
            return 11;
        }
        if (m_patterns[13].matcher(data).matches()) {
            return 13;
        }
        return 1;
    }

    public static final Format preferredFormat(int type) {
        switch (type) {
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                return Format.STOCKFORMATS[7];
            }
            case 5: 
            case 9: 
            case 12: {
                return Format.STOCKFORMATS[8];
            }
            case 6: 
            case 10: 
            case 13: {
                return Format.STOCKFORMATS[9];
            }
        }
        return null;
    }

    public static final Format preferredInformat(int type) {
        switch (type) {
            default: {
                return null;
            }
            case 4: {
                return Format.STOCKINFORMATS[7];
            }
            case 5: {
                return Format.STOCKINFORMATS[8];
            }
            case 6: {
                return Format.STOCKINFORMATS[9];
            }
            case 8: {
                return Format.STOCKINFORMATS[4];
            }
            case 9: {
                return Format.STOCKINFORMATS[5];
            }
            case 10: {
                return Format.STOCKINFORMATS[6];
            }
            case 7: {
                return Format.STOCKINFORMATS[10];
            }
            case 11: {
                return Format.STOCKINFORMATS[11];
            }
            case 12: {
                return Format.STOCKINFORMATS[12];
            }
            case 13: 
        }
        return Format.STOCKINFORMATS[13];
    }

    public static int resolve(int dt1, int dt2) {
        if (dt1 == dt2) {
            return dt1;
        }
        if (dt1 == 0) {
            return dt2;
        }
        if (dt2 == 0) {
            return dt1;
        }
        return m_lookup[dt1 - 1][dt2 - 1];
    }

    public static int simplifyXSDType(String name) {
        if (name == null) {
            return 0;
        }
        for (int t = 0; t < XSDDATATYPE.length; ++t) {
            if (name.compareTo((String)XSDDATATYPE[t][0]) != 0) continue;
            return (Integer)XSDDATATYPE[t][1];
        }
        return 1;
    }

    public static boolean isValidType(String typeName, int version) {
        return Datatype.lookup(typeName, version) != 0;
    }

    public static int lookup(String typeName, int version) {
        if (version > 2) {
            return Datatype.lookupStrict(typeName);
        }
        return Datatype.lookupLoose(typeName);
    }

    private static int lookupStrict(String typeName) {
        for (int t = 1; t <= 6; ++t) {
            if (typeName.compareTo(DATATYPE[t]) != 0) continue;
            return t;
        }
        return 0;
    }

    private static int lookupLoose(String typeName) {
        int type = Datatype.lookupStrict(typeName);
        if (type != 0) {
            return type;
        }
        for (int t = 1; t <= 6; ++t) {
            if (typeName.compareToIgnoreCase(OLDDATATYPE[t]) != 0) continue;
            return t;
        }
        return 0;
    }

    public static int datatypeToBase(int dt) {
        return m_dt2base[dt];
    }

    static {
        try {
            m_patterns = new Pattern[]{Pattern.compile(""), Pattern.compile("^.+$"), Pattern.compile("^[+-]?\\d+$"), Pattern.compile("(^[+-]?((\\d+(\\.\\d*)?)|(\\.\\d+))([Ee][+-]?\\d+)?$)|(^NaN$)|(^INF$)|(^-INF$)"), Pattern.compile("^(-)?\\d{4,}-\\d{2}-\\d{2}$"), Pattern.compile("^(-)?\\d{4,}-\\d{2}-\\d{2}T\\d{2}:\\d{2}(:\\d{2}?(\\.\\d+)?)?(([Z])|([+-]\\d{2}:\\d{2}))?$"), Pattern.compile("^\\d{2}:\\d{2}(:\\d{2}(\\.\\d+)?)?(([Z])|([+-]\\d{2}:\\d{2}))?$"), Pattern.compile("^\\d{2}[-/. ]\\d{2}[-/. ]((\\d{2})|(\\d{4}))$"), Pattern.compile("^\\d{2}[-\\s]?((JAN)|(FEB)|(MAR)|(APR)|(MAY)|(JUN)|(JUL)|(AUG)|(SEP)|(OCT)|(NOV)|(DEC))[-\\s]?((\\d{2})|(\\d{4}))$", 2), Pattern.compile("^\\d{2}[-\\s]?((JAN)|(FEB)|(MAR)|(APR)|(MAY)|(JUN)|(JUL)|(AUG)|(SEP)|(OCT)|(NOV)|(DEC))[-\\s]?((\\d{2})|(\\d{4}))\\s+\\d{2}[:.]\\d{2}([:.]\\d{2})?(\\s?((AM)|(PM)))?$", 2), Pattern.compile("^\\d{1,2}[:.]\\d{2}([:.]\\d{2})?(\\s?((AM)|(PM)))?$", 2), Pattern.compile("^((JAN)|(FEB)|(MAR)|(APR)|(MAY)|(JUN)|(JUL)|(AUG)|(SEP)|(OCT)|(NOV)|(DEC)).*\\s+\\d{1,2},\\s+\\d{4}$", 2), Pattern.compile("^[a-z]{3}\\s+((JAN)|(FEB)|(MAR)|(APR)|(MAY)|(JUN)|(JUL)|(AUG)|(SEP)|(OCT)|(NOV)|(DEC))\\s+\\d{1,2}\\s+\\d{1,2}:\\d{2}:\\d{2}\\s+[a-z]{3}\\s+\\d{4}$", 2), Pattern.compile("^\\d{1,2}:\\d{2}(:\\d{2})?(\\s+[a-z]{2,3})?$", 2)};
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_lookup = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 4, 5, 5, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 5, 5, 6, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 8, 9, 9, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 9, 9, 10, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 11, 12, 12}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 12, 12}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 12, 13}};
    }
}

