/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Datatype;
import com.sas.sxle.map.Format;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.Polymer;
import com.sas.sxle.map.SASName;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Table;
import com.sas.sxle.map.ValidationIssue;
import com.sas.sxle.map.XPath;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class Column
extends Atom
implements Serializable {
    private static final long serialVersionUID = -8561095294102501797L;
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    public static final int kT_CHARACTER = 0;
    public static final int kT_NUMERIC = 1;
    public static final int kCC_NORMAL = 0;
    public static final int kCC_ORDINAL = 1;
    public static final int kCC_FILENAME = 2;
    public static final int kCC_FILEPATH = 3;
    public static final int k_defaultLen = 32;
    public static final String[] TYPE = new String[]{"character", "numeric"};
    public static final List<String> L_TYPES = Arrays.asList(TYPE);
    private Format m_format = null;
    private Format m_informat = null;
    private String m_default = null;
    private ArrayList<String> m_enumValues = null;
    private int m_type;
    private int m_datatype;
    private int m_length;
    private boolean m_retention = false;
    private final boolean m_replace = false;
    private boolean m_usesNonSupportedSyntax = false;
    private int m_class = 0;
    private XPath m_xPath;
    private XPath m_xPathInc = null;
    private XPath m_xPathDec = null;
    private XPath m_xPathReset = null;
    public static final int kC_ATTRIB_VALUE = 1;
    public static final int kC_POSITIONAL = 2;
    private boolean m_hasCondition = false;
    private int m_condType = 0;
    private String m_condAttribute = null;
    private String m_condValue = null;
    private int m_condPosition = -1;
    private Polymer m_polySource = null;

    public Column() {
    }

    public Column(Column col) {
        this.setName(col.getName());
        this.m_description = col.m_description == null ? null : new String(col.m_description);
        this.m_children = null;
        this.m_xPath = col.m_xPath == null ? null : new XPath(col.m_xPath);
        this.m_parent = col.m_parent;
        this.m_dirty = col.m_dirty;
        this.m_format = col.m_format == null ? null : new Format(col.m_format);
        this.m_informat = col.m_informat == null ? null : new Format(col.m_informat);
        this.m_default = col.m_default == null ? null : new String(col.m_default);
        this.m_enumValues = col.m_enumValues == null ? null : new ArrayList<String>(col.m_enumValues);
        this.m_type = col.m_type;
        this.m_datatype = col.m_datatype;
        this.m_length = col.m_length;
        this.m_retention = col.m_retention;
        this.m_class = col.m_class;
        this.m_xPathInc = col.m_xPathInc == null ? null : new XPath(col.m_xPathInc);
        this.m_xPathReset = col.m_xPathReset == null ? null : new XPath(col.m_xPathReset);
        this.m_hasCondition = col.m_hasCondition;
        this.m_condType = col.m_condType;
        this.m_condAttribute = col.m_condAttribute == null ? null : new String(col.m_condAttribute);
        this.m_condValue = col.m_condValue == null ? null : new String(col.m_condAttribute);
        this.m_condPosition = col.m_condPosition;
        this.m_usesNonSupportedSyntax = col.m_usesNonSupportedSyntax;
        this.m_polySource = col.m_polySource;
    }

    public Format getFormat() {
        return this.m_format;
    }

    public void setFormat(Format format) {
        this.m_format = format;
        this.m_dirty = true;
    }

    public void setPolymer(Polymer p) {
        this.m_polySource = p;
        this.m_dirty = true;
    }

    public Polymer getPolymer() {
        return this.m_polySource;
    }

    public void setInformat(Format informat) {
        this.m_informat = informat;
        this.m_dirty = true;
    }

    public Format getInformat() {
        return this.m_informat;
    }

    public void setDefault(String theDefault) {
        if (this.hasEnumeration() && theDefault != null && !this.getEnumValues().contains(theDefault)) {
            this.addEnumValue(theDefault);
        }
        this.m_default = theDefault;
        this.m_dirty = true;
    }

    public String getDefault() {
        return this.m_default;
    }

    public boolean hasDefault() {
        return this.m_default != null;
    }

    public int getDatatype() {
        return this.m_datatype;
    }

    public void setDatatype(int datatype) {
        this.m_datatype = datatype;
        this.m_dirty = true;
    }

    public void setTypeAndDatatype(int datatype) {
        this.m_datatype = datatype;
        this.setType(Datatype.COLUMNTYPE[datatype]);
        this.setFormat(Datatype.preferredFormat(datatype));
        this.setInformat(Datatype.preferredInformat(datatype));
        this.m_dirty = true;
    }

    public void setDatatype(String datatypename, int version) {
        this.m_datatype = Datatype.isValidType(datatypename, version) ? Datatype.lookup(datatypename, version) : (this.m_type == 0 ? 1 : 3);
        this.m_dirty = true;
    }

    public ArrayList<String> getEnumValues() {
        return this.m_enumValues;
    }

    public void addEnumValue(String val) {
        if (val == null) {
            return;
        }
        if (this.m_enumValues == null) {
            this.m_enumValues = new ArrayList();
            if (this.hasDefault()) {
                this.m_enumValues.add(this.getDefault());
            }
        }
        if (!this.m_enumValues.contains(val)) {
            this.m_enumValues.add(val);
        }
        this.m_dirty = true;
    }

    public void delEnumValue(String val) {
        if (this.m_enumValues != null) {
            this.m_enumValues.remove(val);
            if (this.m_default != null && this.m_default.compareTo(val) == 0) {
                this.m_default = null;
            }
            if (this.m_enumValues.size() == 0) {
                this.m_enumValues = null;
            }
        }
        this.m_dirty = true;
    }

    public void setEnumValues(ArrayList<String> enumValues) {
        this.m_enumValues = enumValues;
        if (this.hasDefault() && this.getEnumValues() != null && !this.getEnumValues().contains(this.getDefault())) {
            this.addEnumValue(this.getDefault());
        }
        this.m_dirty = true;
    }

    public int getLength() {
        if (this.m_type == 1) {
            return 0;
        }
        return this.m_length;
    }

    public void setLength(int length) {
        this.m_length = length < 1 ? 32 : length;
        this.m_dirty = true;
    }

    public boolean isRetained() {
        return this.m_retention;
    }

    public boolean isReplaced() {
        return false;
    }

    public void setRetention(boolean retention) {
        this.m_retention = retention;
        this.m_dirty = true;
    }

    public boolean isNormal() {
        return this.m_class == 0;
    }

    public void setNormal() {
        XPath old = this.getXPath();
        if (this.isOrdinal()) {
            old = this.getIncrementXPath();
        }
        if (this.isOrdinal() && old == null) {
            old = this.getDecrementXPath();
        }
        if (this.isOrdinal() && old == null && this.getPolymer() != null) {
            old = new XPath(this.getPolymer().getXPathName());
        }
        this.clear();
        this.m_class = 0;
        if (old != null) {
            this.setXPath(old);
        }
    }

    public boolean isOrdinal() {
        return this.m_class == 1;
    }

    public void setOrdinal() {
        XPath old = this.getXPath();
        this.clear();
        this.m_class = 1;
        this.setType(1);
        this.setDatatype(2);
        if (old != null) {
            old.setBeginEnd(0);
            this.setIncrementXPath(old);
        }
        this.setXPath((XPath)null);
        this.m_dirty = true;
    }

    public boolean isFilename() {
        return this.m_class == 2;
    }

    public void setFilename() {
        this.clear();
        this.m_class = 2;
        this.setXPath((XPath)null);
        this.setIncrementXPath((XPath)null);
        this.setDecrementXPath((XPath)null);
        this.setResetXPath((XPath)null);
        this.setLength(12);
    }

    public boolean isFilePath() {
        return this.m_class == 3;
    }

    public void setFilePath() {
        this.clear();
        this.m_class = 3;
        this.setXPath((XPath)null);
        this.setIncrementXPath((XPath)null);
        this.setDecrementXPath((XPath)null);
        this.setResetXPath((XPath)null);
        this.setLength(256);
    }

    private void clear() {
        this.setType(0);
        this.setDatatype(1);
        this.setXPath("/");
        this.setIncrementXPath((XPath)null);
        this.setDecrementXPath((XPath)null);
        this.setResetXPath((XPath)null);
        this.setFormat(null);
        this.setInformat(null);
        this.setEnumValues(null);
        this.setDefault(null);
        this.setRetention(false);
        this.setLength(32);
        this.m_dirty = true;
    }

    public int getColumnClass() {
        return this.m_class;
    }

    public void setColumnClass(int colClass) {
        switch (colClass) {
            case 1: {
                this.setOrdinal();
                break;
            }
            case 2: {
                this.setFilename();
                break;
            }
            case 3: {
                this.setFilePath();
                break;
            }
            default: {
                this.setNormal();
            }
        }
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
        this.m_dirty = true;
    }

    public void setType(String typename) {
        this.m_type = typename.equalsIgnoreCase("numeric") ? 1 : 0;
        this.m_dirty = true;
    }

    public boolean hasFormat() {
        return this.m_format != null;
    }

    public boolean hasInformat() {
        return this.m_informat != null;
    }

    public boolean hasEnumeration() {
        return this.m_enumValues != null;
    }

    public XPath getIncrementXPath() {
        return this.m_xPathInc;
    }

    public void setIncrementXPath(XPath xPath) {
        this.m_xPathInc = xPath;
        this.m_dirty = true;
    }

    public void setIncrementXPath(String xp) {
        if (this.m_xPathInc == null) {
            this.m_xPathInc = new XPath(xp);
        } else {
            this.m_xPathInc.setValue(xp);
        }
        this.m_dirty = true;
    }

    public XPath getDecrementXPath() {
        return this.m_xPathDec;
    }

    public void setDecrementXPath(XPath xPath) {
        this.m_xPathDec = xPath;
        this.m_dirty = true;
    }

    public void setDecrementXPath(String xp) {
        if (this.m_xPathDec == null) {
            this.m_xPathDec = new XPath(xp);
        } else {
            this.m_xPathDec.setValue(xp);
        }
        this.m_dirty = true;
    }

    public XPath getResetXPath() {
        return this.m_xPathReset;
    }

    public void setResetXPath(XPath xp) {
        this.m_xPathReset = xp;
        this.m_dirty = true;
    }

    public void setResetXPath(String xp) {
        if (this.m_xPathReset == null) {
            this.m_xPathReset = new XPath(xp);
        } else {
            this.m_xPathReset.setValue(xp);
        }
        this.m_dirty = true;
    }

    public String getCondAttribute() {
        return this.m_condAttribute;
    }

    public int getCondPosition() {
        return this.m_condPosition;
    }

    public int getCondType() {
        return this.m_condType;
    }

    public String getCondValue() {
        return this.m_condValue;
    }

    public void setCondAttribute(String condAttribute) {
        this.m_condAttribute = condAttribute;
        this.m_dirty = true;
    }

    public void setCondPosition(int condPosition) {
        this.m_condPosition = condPosition;
        this.m_dirty = true;
    }

    public void setCondType(int condType) {
        this.m_condType = condType;
        this.m_dirty = true;
    }

    public void setCondValue(String condValue) {
        this.m_condValue = condValue;
        this.m_dirty = true;
    }

    public String getCondText() {
        String txt = "";
        if (this.m_condType == 2 && this.m_condPosition > 0) {
            txt = "[position()=" + Integer.toString(this.m_condPosition) + "]";
        } else if (this.m_condType == 1) {
            txt = "[@" + this.m_condAttribute + "=\"" + this.m_condValue + "\"]";
        }
        return txt;
    }

    public void clearCond() {
        this.m_hasCondition = false;
        this.m_condType = 0;
        this.m_condAttribute = null;
        this.m_condValue = null;
        this.m_condPosition = -1;
    }

    public void setCondText(String condText) {
        this.clearCond();
        int lbpos = condText.indexOf(91);
        int rbpos = condText.indexOf(93);
        int eqpos = condText.indexOf(61);
        int ptxt = condText.indexOf("position()");
        if (lbpos < 0 || rbpos < 0 || eqpos < 0) {
            this.m_hasCondition = false;
            return;
        }
        this.m_hasCondition = true;
        if (ptxt > 0) {
            this.m_condType = 2;
            String val = condText.substring(eqpos + 1, rbpos);
            try {
                this.m_condPosition = Integer.parseInt(val);
            }
            catch (Exception e) {
                this.m_condPosition = 1;
            }
        } else {
            this.m_condType = 1;
            String val = condText.substring(lbpos + 1, eqpos);
            if (val.startsWith("@")) {
                val = val.substring(1);
            }
            this.m_condAttribute = val;
            this.m_condValue = val = condText.substring(eqpos + 2, rbpos - 1);
        }
        this.m_dirty = true;
    }

    public boolean isAttribute() {
        if (this.isOrdinal()) {
            return false;
        }
        if (this.m_xPath == null || this.m_xPath.getValue() == null) {
            return false;
        }
        return this.m_xPath.getValue().indexOf(64) > 0;
    }

    public boolean hasCondition() {
        return this.m_hasCondition;
    }

    public void setHasCondition(boolean hasCondition) {
        this.m_hasCondition = hasCondition;
        if (!this.m_hasCondition) {
            this.clearCond();
        } else {
            this.setRetention(false);
        }
        this.m_dirty = true;
    }

    public void setXPath(String xp) {
        this.m_xPath = new XPath(xp);
        this.m_dirty = true;
    }

    public void parseXPath(String xp) {
        String base;
        int pos = xp.indexOf("[");
        if (pos > 0) {
            base = xp.substring(0, pos);
            String cond = xp.substring(pos);
            this.setCondText(cond);
        } else {
            base = xp;
        }
        this.m_xPath = new XPath(base);
        this.m_dirty = true;
    }

    public boolean validate(ArrayList<ValidationIssue> issues) {
        String msg;
        boolean isOK = true;
        String tName = this.getParent().getName();
        int version = ((Map)this.getParent().getParent()).getVersionID();
        if (version == 0 && this.isOrdinal()) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnNoOrdIn10.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (version < 3) {
            if (this.isFilename()) {
                isOK = false;
                msg = MessageFormat.format(res.getString("VMsgColumnNoFilenameBefore19.txt"), this.getName(), tName);
                issues.add(new ValidationIssue(1, msg, this));
            }
            if (this.isFilePath()) {
                isOK = false;
                msg = MessageFormat.format(res.getString("VMsgColumnNoFilePathBefore19.txt"), this.getName(), tName);
                issues.add(new ValidationIssue(1, msg, this));
            }
        }
        if (!SASName.isValid(this.getName())) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnNameInvalid.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (SASName.isReserved(this.getName())) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnNameReserved.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.isOrdinal() && this.hasEnumeration()) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnOrdEnum.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.isOrdinal() && this.hasCondition()) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnOrdCond.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.isOrdinal()) {
            if (this.m_xPathInc != null && this.m_xPathInc.getValue() != null && this.m_xPathInc.getValue().contains("@")) {
                msg = MessageFormat.format(res.getString("VMsgColumnNoAttrIncPath.txt"), this.m_xPathInc.getValue(), this.getName(), tName);
                issues.add(new ValidationIssue(1, msg, this));
            }
            if (this.m_xPathDec != null && this.m_xPathDec.getValue() != null && this.m_xPathDec.getValue().contains("@")) {
                msg = MessageFormat.format(res.getString("VMsgColumnNoAttrDecPath.txt"), this.m_xPathInc.getValue(), this.getName(), tName);
                issues.add(new ValidationIssue(1, msg, this));
            }
            if (!(this.m_xPathInc != null && this.m_xPathInc.isValid() || this.m_xPathDec != null && this.m_xPathDec.isValid())) {
                msg = MessageFormat.format(res.getString("VMsgColumnNoOrdPath.txt"), this.getName(), tName);
                issues.add(new ValidationIssue(1, msg, this));
            }
            if (this.m_xPathReset != null && this.m_xPathReset.getValue() != null && this.m_xPathReset.getValue().contains("@")) {
                msg = MessageFormat.format(res.getString("VMsgColumnNoAttrResetPath.txt"), this.m_xPathInc.getValue(), this.getName(), tName);
                issues.add(new ValidationIssue(1, msg, this));
            }
        }
        if (this.getDatatype() == 0) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnDatatypeInvalid.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.getType() != 0 && this.getType() != 1) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnTypeInvalid.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.getType() == 1 && this.getLength() != 0) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnNumLen.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(2, msg, this));
        }
        if (this.getType() != Datatype.COLUMNTYPE[this.getDatatype()]) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnTypeMismatch.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.getFormat() != null && !this.getFormat().isValid()) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnFormatInvalid.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.getInformat() != null && !this.getInformat().isValid()) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnInformatInvalid.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.getType() == 0 && (this.getLength() < 1 || this.getLength() > Short.MAX_VALUE)) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnLengthInvalid.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.hasCondition() && this.isAttribute() && this.getCondType() == 2) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgColumnPosCondAttr.txt"), this.getName(), tName);
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.isNormal()) {
            if (this.m_xPath == null) {
                isOK = false;
                msg = MessageFormat.format(res.getString("VMsgColumnNoXPath.txt"), this.getName(), tName);
                issues.add(new ValidationIssue(1, msg, this));
            } else if (!this.m_xPath.isValid()) {
                isOK = false;
                msg = MessageFormat.format(res.getString("VMsgColumnXPathInvalid.txt"), this.getName(), tName, this.m_xPath.getValue());
                issues.add(new ValidationIssue(1, msg, this));
            } else if (!this.hasCondition()) {
                boolean identical;
                String xp = ((Table)this.getParent()).getXPath().getValue();
                int pos = this.getXPath().getValue().indexOf(xp);
                boolean bl = identical = this.getXPath().getValue().compareTo(xp) == 0;
                if (pos != 0 && !identical) {
                    int pos2 = xp.indexOf(this.getXPath().getValue());
                    if (pos2 != 0) {
                        String msg2 = MessageFormat.format(res.getString("VMsgColumnOutsideBranch.txt"), this.getName(), tName);
                        issues.add(new ValidationIssue(2, msg2, this));
                    } else if (!this.m_retention) {
                        String msg3 = MessageFormat.format(res.getString("VMsgColumnRetainNotSet.txt"), this.getName(), tName);
                        issues.add(new ValidationIssue(3, msg3, this));
                    }
                } else if (this.m_retention) {
                    String msg4 = MessageFormat.format(res.getString("VMsgColumnRetainSet.txt"), this.getName(), tName);
                    issues.add(new ValidationIssue(3, msg4, this));
                }
            }
        }
        return isOK;
    }

    public boolean getUsesNonSupportedSyntax() {
        if (SXLEContext.useNonSupportedPathSyntaxMode()) {
            return this.m_usesNonSupportedSyntax;
        }
        return false;
    }

    public void setUsesNonSupportedSyntax(boolean val) {
        if (SXLEContext.useNonSupportedPathSyntaxMode()) {
            this.m_usesNonSupportedSyntax = val;
        }
    }

    @Override
    public String getXPathName() {
        return this.m_xPath != null ? this.m_xPath.getValue() : null;
    }

    public XPath getXPath() {
        return this.m_xPath;
    }

    public void setXPath(XPath xp) {
        this.m_xPath = xp;
        this.m_dirty = true;
    }
}

