/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.AVPair;
import com.sas.sxle.map.Cartographer;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Datatype;
import com.sas.sxle.map.Format;
import com.sas.sxle.map.Namespace;
import com.sas.sxle.map.NamespaceList;
import com.sas.sxle.map.Output;
import com.sas.sxle.map.Table;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class Cartographer_2_1
extends Cartographer {
    @Override
    protected void writeMapTable(Table table) {
        this.m_root.appendChild(this.m_doc.createComment(" ############################################################ "));
        this.m_currentTable = this.m_doc.createElement("TABLE");
        this.m_currentTable.setAttribute("name", table.getName());
        if (!this.xpOK(table.getXPath())) {
            table.setXPath("/");
        }
        if (this.strOK(table.getDescription())) {
            this.m_currentTable.setAttribute("description", table.getDescription());
        }
        Element path = this.m_doc.createElement("TABLE-PATH");
        String ptxt = table.getXPath().getValue();
        this.setPathType(ptxt, path);
        path.appendChild(this.m_doc.createTextNode(ptxt));
        this.m_currentTable.appendChild(path);
        if (this.xpOK(table.getOptXPath())) {
            String begend = table.getOptXPath().getBeginEnd() == 1 ? "END" : "BEGIN";
            Element opath = this.m_doc.createElement("TABLE-END-PATH");
            opath.setAttribute("beginend", begend);
            String ptxt2 = table.getOptXPath().getValue();
            this.setPathType(ptxt2, opath);
            opath.appendChild(this.m_doc.createTextNode(ptxt2));
            this.m_currentTable.appendChild(opath);
        }
        this.m_root.appendChild(this.m_currentTable);
        for (int c = 0; c < table.getColumns().size(); ++c) {
            this.writeMapColumn(table.getColumn(c));
        }
        this.writeBlankLine(this.m_currentTable);
        this.writeBlankLine(this.m_root);
    }

    private void setPathType(String ptxt, Element path) {
        if (ptxt.contains("{")) {
            path.setAttribute("syntax", "XPathENR");
        } else {
            path.setAttribute("syntax", "XPath");
        }
    }

    @Override
    protected void writeMapOutput(Output out) {
        if (out.getTable() == null || out.getTable().length() < 1) {
            return;
        }
        this.m_root.appendChild(this.m_doc.createComment(" ############################################################ "));
        Element output = this.m_doc.createElement("OUTPUT");
        if (out.getAVPairCount() > 0) {
            Element heading = this.m_doc.createElement("HEADING");
            for (int p = 0; p < out.getAVPairCount(); ++p) {
                AVPair avp = out.getAVPair(p);
                Element attr = this.m_doc.createElement("ATTRIBUTE");
                attr.setAttribute("name", avp.getAttribute());
                attr.setAttribute("value", avp.getValue());
                heading.appendChild(attr);
            }
            output.appendChild(heading);
        }
        Element tabref = this.m_doc.createElement("TABLEREF");
        tabref.setAttribute("name", out.getTable());
        output.appendChild(tabref);
        this.m_root.appendChild(output);
        this.writeBlankLine(this.m_root);
    }

    @Override
    protected void writeMapColumn(Column column) {
        ArrayList<String> v;
        this.m_currentColumn = this.m_doc.createElement("COLUMN");
        this.writeBlankLine(this.m_currentTable);
        this.m_currentColumn.setAttribute("name", column.getName());
        this.m_currentTable.appendChild(this.m_currentColumn);
        if (this.xpOK(column.getXPath()) && !column.isOrdinal()) {
            Element path = this.m_doc.createElement("PATH");
            String ptxt = column.getXPath().getValue();
            this.setPathType(ptxt, path);
            if (column.getUsesNonSupportedSyntax()) {
                path.setAttribute("NotSupported", "true");
                path.appendChild(this.m_doc.createTextNode(ptxt));
            } else {
                path.appendChild(this.m_doc.createTextNode(ptxt + column.getCondText()));
            }
            this.m_currentColumn.appendChild(path);
        }
        if (column.isRetained()) {
            this.m_currentColumn.setAttribute("retain", "YES");
        }
        if (column.isReplaced()) {
            this.m_currentColumn.setAttribute("replace", "YES");
        }
        if (this.strOK(column.getDescription())) {
            Element desc = this.m_doc.createElement("DESCRIPTION");
            desc.appendChild(this.m_doc.createTextNode(column.getDescription()));
            this.m_currentColumn.appendChild(desc);
        }
        switch (column.getColumnClass()) {
            case 1: {
                String ptxt;
                String begend;
                this.m_currentColumn.setAttribute("class", "ORDINAL");
                if (this.xpOK(column.getIncrementXPath())) {
                    Element ipath = this.m_doc.createElement("INCREMENT-PATH");
                    begend = column.getIncrementXPath().getBeginEnd() == 1 ? "END" : "BEGIN";
                    ipath.setAttribute("beginend", begend);
                    ptxt = column.getIncrementXPath().getValue();
                    this.setPathType(ptxt, ipath);
                    ipath.appendChild(this.m_doc.createTextNode(ptxt));
                    this.m_currentColumn.appendChild(ipath);
                }
                if (this.xpOK(column.getDecrementXPath())) {
                    Element dpath = this.m_doc.createElement("DECREMENT-PATH");
                    begend = column.getDecrementXPath().getBeginEnd() == 1 ? "END" : "BEGIN";
                    dpath.setAttribute("beginend", begend);
                    ptxt = column.getDecrementXPath().getValue();
                    this.setPathType(ptxt, dpath);
                    dpath.appendChild(this.m_doc.createTextNode(ptxt));
                    this.m_currentColumn.appendChild(dpath);
                }
                if (!this.xpOK(column.getResetXPath())) break;
                Element rpath = this.m_doc.createElement("RESET-PATH");
                begend = column.getResetXPath().getBeginEnd() == 1 ? "END" : "BEGIN";
                rpath.setAttribute("beginend", begend);
                ptxt = column.getResetXPath().getValue();
                this.setPathType(ptxt, rpath);
                rpath.appendChild(this.m_doc.createTextNode(ptxt));
                this.m_currentColumn.appendChild(rpath);
                break;
            }
            case 2: {
                this.m_currentColumn.setAttribute("class", "FILENAME");
                break;
            }
            case 3: {
                this.m_currentColumn.setAttribute("class", "FILEPATH");
                break;
            }
        }
        Element type = this.m_doc.createElement("TYPE");
        type.appendChild(this.m_doc.createTextNode(Column.TYPE[column.getType()]));
        this.m_currentColumn.appendChild(type);
        Element datatype = this.m_doc.createElement("DATATYPE");
        datatype.appendChild(this.m_doc.createTextNode(Datatype.EMITDATATYPE[column.getDatatype()]));
        this.m_currentColumn.appendChild(datatype);
        if (column.getType() == 0) {
            int safelen = column.getLength();
            if (safelen < 1) {
                this.m_currentColumn.appendChild(this.m_doc.createComment("<!-- ### LENGTH was invalid, using default ### -->"));
                safelen = 32;
            }
            Element length = this.m_doc.createElement("LENGTH");
            length.appendChild(this.m_doc.createTextNode(Integer.toString(safelen)));
            this.m_currentColumn.appendChild(length);
        }
        if (column.hasFormat()) {
            Format fmt = column.getFormat();
            Element format = this.m_doc.createElement("FORMAT");
            format.appendChild(this.m_doc.createTextNode(fmt.getName()));
            if (fmt.getLength() > 0) {
                format.setAttribute("width", Integer.toString(fmt.getLength()));
            }
            if (fmt.getNDec() > 0) {
                format.setAttribute("ndec", Integer.toString(fmt.getNDec()));
            }
            this.m_currentColumn.appendChild(format);
        }
        if (column.hasInformat()) {
            Format infmt = column.getInformat();
            Element informat = this.m_doc.createElement("INFORMAT");
            informat.appendChild(this.m_doc.createTextNode(infmt.getName()));
            if (infmt.getLength() > 0) {
                informat.setAttribute("width", Integer.toString(infmt.getLength()));
            }
            if (infmt.getNDec() > 0) {
                informat.setAttribute("ndec", Integer.toString(infmt.getNDec()));
            }
            this.m_currentColumn.appendChild(informat);
        }
        if (column.hasEnumeration() && (v = column.getEnumValues()) != null && v.size() > 0) {
            Element eleEnum = this.m_doc.createElement("ENUM");
            for (int i = 0; i < v.size(); ++i) {
                Element val = this.m_doc.createElement("VALUE");
                val.appendChild(this.m_doc.createTextNode(v.get(i)));
                eleEnum.appendChild(val);
            }
            this.m_currentColumn.appendChild(eleEnum);
        }
        if (column.hasDefault() && this.strOK(column.getDefault())) {
            Element def = this.m_doc.createElement("DEFAULT");
            def.appendChild(this.m_doc.createTextNode(column.getDefault()));
            this.m_currentColumn.appendChild(def);
        }
    }

    @Override
    protected void setMapAttributes() {
        this.m_root.setAttribute("version", this.m_map.getVersion());
        this.m_root.setAttribute("name", this.m_map.getName());
        String desc = this.m_map.getDescription();
        if (this.strOK(desc)) {
            this.m_root.setAttribute("description", desc);
        }
    }

    @Override
    protected void setMapValidation() {
        this.m_root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.m_root.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.sas.com/xml/schema/sxle21.xsd");
    }

    @Override
    protected void writeMapNamespaces(NamespaceList namespaces) {
        if (namespaces != null) {
            Element nsEle = this.m_doc.createElement("NAMESPACES");
            this.m_root.appendChild(nsEle);
            nsEle.setAttribute("count", Integer.toString(namespaces.size()));
            for (int n = 0; n < namespaces.size(); ++n) {
                Namespace ns = namespaces.get(n);
                Element ele = this.m_doc.createElement("NS");
                nsEle.appendChild(ele);
                ele.setAttribute("prefix", ns.getPrefix());
                ele.setAttribute("id", Integer.toString(ns.getIndex()));
                ele.setTextContent(ns.getURI());
            }
            this.writeBlankLine(this.m_root);
        }
    }
}

