/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Namespace;
import com.sas.sxle.map.SXLEContext;
import java.io.Serializable;
import java.util.ArrayList;

public class Atom
implements Serializable {
    private String m_name;
    protected String m_description;
    protected ArrayList<Atom> m_children = new ArrayList();
    protected Atom m_parent = null;
    protected boolean m_dirty = false;
    protected Namespace m_namespace;

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    public void setName(String name) {
        this.m_name = SXLEContext.useIntern() ? (name == null ? null : name.intern()) : name;
        this.m_dirty = true;
    }

    public void setDescription(String description) {
        this.m_description = description;
        this.m_dirty = true;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Atom getParent() {
        return this.m_parent;
    }

    public void setParent(Atom parent) {
        this.m_parent = parent;
    }

    public void addChild(Atom child) {
        child.setParent(this);
        this.m_children.add(child);
        this.m_dirty = true;
    }

    public ArrayList<Atom> getChildren() {
        return this.m_children;
    }

    public Atom getChildMatching(String n, String uri) {
        if (n == null || n.length() < 1) {
            return null;
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            Namespace ns;
            Atom child = this.m_children.get(i);
            if (child.getName() == null || child.getName().compareTo(n) != 0 || !((ns = child.getNamespace()) == null ? uri == null || uri == "" : ns.matches(uri))) continue;
            return child;
        }
        return null;
    }

    public Atom getChildNamed(String n) {
        if (n == null || n.length() < 1) {
            return null;
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            if (this.m_children.get(i).getName() == null || this.m_children.get(i).getName().compareTo(n) != 0) continue;
            return this.m_children.get(i);
        }
        return null;
    }

    public Atom getChildERNamed(String ern) {
        if (ern == null || ern.length() < 1) {
            return null;
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            if (this.m_children.get(i).getERName().compareTo(ern) != 0) continue;
            return this.m_children.get(i);
        }
        return null;
    }

    public boolean hasChildNamed(String n) {
        if (n == null) {
            return false;
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            String name = this.m_children.get(i).getName();
            if (name == null || name.compareToIgnoreCase(n) != 0) continue;
            return true;
        }
        return false;
    }

    public void setChildren(ArrayList<Atom> children) {
        this.m_children = children == null ? null : children;
        this.m_dirty = true;
    }

    public boolean hasChildren() {
        return this.m_children.size() > 0;
    }

    public String getExpandedXPathName() {
        String exxpn = "";
        if (this.m_parent != null) {
            exxpn = exxpn + this.m_parent.getExpandedXPathName();
        } else if (this.getName() == "") {
            return "";
        }
        exxpn = exxpn + "/";
        exxpn = exxpn + this.getExpName();
        return exxpn;
    }

    public String getXPathName() {
        String ern = "";
        if (this.m_parent != null) {
            ern = ern + this.m_parent.getXPathName();
        } else if (this.getName() == "") {
            return "";
        }
        ern = ern + "/";
        ern = ern + this.getERName();
        return ern;
    }

    public String getERName() {
        String ern = "";
        if (this.hasNamespace()) {
            ern = ern + "{" + (this.getNamespace().getIndex() + 1) + "}";
        }
        ern = ern + this.getName();
        return ern;
    }

    public String getExpName() {
        String expn = "";
        if (this.hasNamespace()) {
            expn = expn + "{" + this.getNamespace().getURI() + "}";
        }
        expn = expn + this.getName();
        return expn;
    }

    public int getChildCount() {
        if (this.m_children == null) {
            return 0;
        }
        return this.m_children.size();
    }

    public boolean isDirty() {
        if (this.m_dirty) {
            return true;
        }
        for (int t = 0; t < this.getChildCount(); ++t) {
            if (!(this.m_children.get(t) instanceof Atom) || !this.m_children.get(t).isDirty()) continue;
            this.m_dirty = true;
            return true;
        }
        return false;
    }

    public void clean() {
        this.m_dirty = false;
        for (int t = 0; t < this.getChildCount(); ++t) {
            if (!(this.m_children.get(t) instanceof Atom)) continue;
            this.m_children.get(t).clean();
        }
    }

    public Namespace getNamespace() {
        return this.m_namespace;
    }

    public void setNamespace(Namespace ns) {
        this.m_namespace = ns;
    }

    public boolean hasNamespace() {
        return this.m_namespace != null;
    }
}

