/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.retrieval.dao.util;

import com.sas.svcs.comments.client.Comment;
import com.sas.svcs.comments.client.CommentServiceInterface;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.search.retrieval.dao.CommentCache;
import com.sas.svcs.notifications.client.AlertNotification;
import com.sas.svcs.notifications.client.AlertNotificationRetrievalServiceInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractIndexDataCommentsUtil {
    Logger perfLogger = LogManager.getLogger((String)"perf.com.sas.svcs.content.search.spi.util.IndexDataCommentsUtil");
    private CommentServiceInterface commentService;
    private AlertNotificationRetrievalServiceInterface notificationRetrievalService;

    public void setAlertNotificationRetrievalService(AlertNotificationRetrievalServiceInterface notificationRetrievalService) {
        this.notificationRetrievalService = notificationRetrievalService;
    }

    public void setCommentService(CommentServiceInterface commentService) {
        this.commentService = commentService;
    }

    public CommentCache getCommentCache(CommentCache commentCache, Date lastModifiedDate) {
        if (!this.checkCommentCache(commentCache, lastModifiedDate)) {
            this.loadCommentCache(commentCache, lastModifiedDate);
        }
        return commentCache;
    }

    public boolean checkCommentCache(CommentCache commentCache, Date lastModifiedDate) {
        Date cacheDate = commentCache.getLoadDate();
        return cacheDate.equals(lastModifiedDate);
    }

    protected abstract void mapGuidsToCache(CommentCache var1, List<String> var2);

    public final void loadCommentCache(CommentCache commentCache, Date date) {
        commentCache.clear();
        commentCache.setLoadDate(date);
        List<String> updatedGuids = this.getUpdatedCommentGuidsSince(date);
        List<String> deletedGuids = this.getDeletedCommentGuidsSince(date);
        for (String nextguid : deletedGuids) {
            if (updatedGuids.contains(nextguid)) continue;
            updatedGuids.add(nextguid);
        }
        List<String> retiredGuids = this.getRetiredCommentGuidsSince(date);
        for (String nextguid : retiredGuids) {
            if (updatedGuids.contains(nextguid)) continue;
            updatedGuids.add(nextguid);
        }
        this.mapGuidsToCache(commentCache, updatedGuids);
    }

    public final List<Comment> purgeComments(List<Comment> commentList) {
        Collections.sort(commentList, new Comparator<Comment>(){

            @Override
            public int compare(Comment o1, Comment o2) {
                if (o1.getId() == o2.getId()) {
                    return 0;
                }
                if (o1.getId() > o2.getId()) {
                    return 1;
                }
                return -1;
            }
        });
        ArrayList<Comment> result = new ArrayList<Comment>();
        long lastId = -1L;
        for (Comment nextComment : commentList) {
            if (nextComment.getId() == lastId) continue;
            lastId = nextComment.getId();
            result.add(nextComment);
        }
        return result;
    }

    public final List<String> getUpdatedCommentGuidsSince(Date date) {
        ArrayList<String> result = new ArrayList<String>();
        List<Comment> comments = this.getCommentsSince(date);
        for (Comment nextComment : comments) {
            String guid = nextComment.getObjectId();
            if (result.contains(guid)) continue;
            result.add(guid);
        }
        return result;
    }

    public final List<String> getDeletedCommentGuidsSince(Date date) {
        ArrayList<String> result = new ArrayList<String>();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userid = authentication.getName();
        List notificationList = this.notificationRetrievalService.getNotifications(userid);
        for (AlertNotification notification : notificationList) {
            if (!notification.getEventName().equals("SAS.CommentDeleted")) continue;
            if (notification.getCreatedOn().before(date)) {
                this.notificationRetrievalService.delete(notification.getId());
                continue;
            }
            String parms = notification.getTargetParms();
            if (result.contains(parms = parms.substring(9))) continue;
            result.add(parms);
        }
        return result;
    }

    public final List<String> getRetiredCommentGuidsSince(Date date) {
        ArrayList<String> result = new ArrayList<String>();
        List comments = this.commentService.findRetiredSince(date);
        for (Comment nextComment : comments) {
            String guid = nextComment.getObjectId();
            if (result.contains(guid)) continue;
            result.add(guid);
        }
        return result;
    }

    public List<Comment> getAllComments(List<String> guidList) {
        List commentList = this.commentService.find(0L, guidList);
        return commentList;
    }

    public List<Comment> getCommentsSince(Date modifiedDate) {
        List commentList = this.commentService.findAllSince(modifiedDate);
        return commentList;
    }

    public void addComments(List<Comment> commentList, Map<String, Object> attrMap) {
        String guid = (String)attrMap.get("guid");
        if (guid != null) {
            ArrayList<String> subjectList = new ArrayList<String>();
            ArrayList<String> bodyList = new ArrayList<String>();
            for (Comment nextComment : commentList) {
                String text;
                if (!nextComment.getObjectId().equals(guid)) continue;
                String subject = nextComment.getSubject();
                if (subject != null && subject.length() > 0) {
                    subjectList.add(subject);
                }
                if ((text = nextComment.getText()) == null || text.length() <= 0) continue;
                bodyList.add(text);
            }
            if (subjectList.size() > 0) {
                attrMap.put("commentssubject", this.makeMultiValueString(subjectList));
            }
            if (bodyList.size() > 0) {
                attrMap.put("commentscontent", this.makeMultiValueString(bodyList));
            }
        }
    }

    private void getComments(Map<String, Object> attrMap, ObjectIdentity identity) {
        if (this.commentService != null) {
            List commentDataList = null;
            String guid = (String)attrMap.get("guid");
            if (guid != null) {
                long start = System.currentTimeMillis();
                commentDataList = this.commentService.find(0L, guid);
                long end = System.currentTimeMillis();
                this.perfLogger.debug("Retrieving comments took " + (end - start) + " milliseconds.");
            }
            if (commentDataList != null && commentDataList.size() > 0) {
                ArrayList<String> subjectList = new ArrayList<String>();
                ArrayList<String> bodyList = new ArrayList<String>();
                for (Comment comment : commentDataList) {
                    String text;
                    String subject = comment.getSubject();
                    if (subject != null && subject.length() > 0) {
                        subjectList.add(subject);
                    }
                    if ((text = comment.getText()) == null || text.length() <= 0) continue;
                    bodyList.add(text);
                }
                if (subjectList.size() > 0) {
                    attrMap.put("commentssubject", this.makeMultiValueString(subjectList));
                }
                if (bodyList.size() > 0) {
                    attrMap.put("commentscontent", this.makeMultiValueString(bodyList));
                }
            }
        }
    }

    String makeMultiValueString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String nextString : list) {
            this.addToStringBuilder(sb, nextString);
        }
        return sb.toString();
    }

    public void addToStringBuilder(StringBuilder sb, String string) {
        if (sb.length() > 0) {
            sb.append(";");
        }
        sb.append(string);
    }
}

