/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.mapping;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.Nested;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.client.TransportOperation;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.mapping.MappingDiscovery;
import com.sas.svcs.content.lifecycle.dao.mapping.PromptedConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.mapping.TransportMappingScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ConnectionMappingUtil {
    public static final String UNKNOWN_MAPPING = "#Unknown#";
    static Map<String, List<ConnectionMapping>> mappingsByType = new HashMap<String, List<ConnectionMapping>>();
    static Map<String, ConnectionMapping> mappingsByName = new HashMap<String, ConnectionMapping>();

    public ConnectionMappingUtil() {
        try {
            mappingsByType = TransportMappingScanner.getConnectionMappingsByType();
            if (mappingsByType != null) {
                for (Map.Entry<String, List<ConnectionMapping>> entry : mappingsByType.entrySet()) {
                    List<ConnectionMapping> mappings = entry.getValue();
                    for (ConnectionMapping mapping : mappings) {
                        String name = mapping.getMappingName();
                        if (mappingsByName.containsKey(name)) continue;
                        mappingsByName.put(name, mapping);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public List<ConnectionMapping> getAllConnectionMappings() {
        if (mappingsByType == null) {
            return Collections.emptyList();
        }
        ArrayList<ConnectionMapping> mappings = new ArrayList<ConnectionMapping>();
        for (Map.Entry<String, List<ConnectionMapping>> entry : mappingsByType.entrySet()) {
            mappings.addAll((Collection<ConnectionMapping>)entry.getValue());
        }
        return mappings;
    }

    private ConnectionMapping getConnectionMappingByName(String name) {
        return mappingsByName == null ? null : mappingsByName.get(name);
    }

    private List<ConnectionMapping> getConnectionMappingsByType(String type) {
        return mappingsByType == null ? null : mappingsByType.get(type);
    }

    public ConnectionMapping getConnectionMapping(ConnectionPoint cp) {
        return this.getConnectionMappingByName(cp.getMappingName());
    }

    public ConnectionMapping discoverConnectionMapping(ConnectionPoint cp) {
        ConnectionMapping mapping;
        block3: {
            List<ConnectionMapping> mappings;
            block4: {
                ConnectionMapping tempMapping;
                block5: {
                    mapping = null;
                    String type = this.getConnectionType(cp);
                    mappings = this.getConnectionMappingsByType(type);
                    if (mappings == null) break block3;
                    if (mappings.size() != 1) break block4;
                    tempMapping = mappings.get(0);
                    if (!(tempMapping instanceof MappingDiscovery)) break block5;
                    if (!((MappingDiscovery)((Object)tempMapping)).isMappingFor(cp)) break block3;
                    mapping = tempMapping;
                    break block3;
                }
                mapping = tempMapping;
                break block3;
            }
            for (ConnectionMapping cm : mappings) {
                if (!(cm instanceof MappingDiscovery) || !((MappingDiscovery)((Object)cm)).isMappingFor(cp)) continue;
                mapping = cm;
                break;
            }
            if (mapping != null) {
                for (ConnectionMapping cm : mappings) {
                    if (cm instanceof MappingDiscovery) continue;
                    mapping = cm;
                    break;
                }
            }
        }
        return mapping;
    }

    private String getConnectionType(ConnectionPoint cp) {
        if (cp != null) {
            if (cp instanceof ContentConnectionPoint) {
                return ((ContentConnectionPoint)cp).getTypeName();
            }
            String sourceid = cp.getSourceId();
            int index = sourceid.indexOf(47);
            if (index > -1) {
                String type = sourceid.substring(index + 1);
                return type;
            }
        }
        return null;
    }

    public ConnectionPoint getConnectionPoint(ContentOperation<? extends TransportNode> operation, String connectionPointId) {
        return this.getConnectionPoint(operation.getOperationNodes(), connectionPointId);
    }

    public ConnectionPoint getConnectionPoint(List<? extends TransportNode> nodes, String connectionPointId) {
        if (connectionPointId == null) {
            return null;
        }
        for (TransportNode transportNode : nodes) {
            List connections = transportNode.getConnectionPoints();
            if (connections == null) continue;
            for (ConnectionPoint pt : connections) {
                if (!connectionPointId.equalsIgnoreCase(pt.getSourceId())) continue;
                return pt;
            }
        }
        return null;
    }

    public Set<ConnectionPoint> getConnectionPoints(List<? extends TransportNode> nodes) {
        return this.getConnectionPoints(nodes, false);
    }

    public Set<ConnectionPoint> getConnectionPoints(List<? extends TransportNode> nodes, boolean onlyActiveConnections) {
        return this.getConnectionPoints(nodes, onlyActiveConnections, false);
    }

    public Set<ConnectionPoint> getConnectionPoints(List<? extends TransportNode> nodes, boolean onlyActiveConnections, boolean onlyPromptedConnections) {
        LinkedHashSet<ConnectionPoint> cps = new LinkedHashSet<ConnectionPoint>();
        for (TransportNode transportNode : nodes) {
            this.loadConnectionPoints(transportNode, cps, onlyActiveConnections, onlyPromptedConnections);
            List nestedNodes = transportNode.getNestedNodes();
            this.loadConnectionPointsForNested(nestedNodes, cps, onlyActiveConnections, onlyPromptedConnections);
        }
        return cps;
    }

    private void loadConnectionPoints(TransportNode node, Set<ConnectionPoint> cps, boolean onlyActiveConnections, boolean onlyPromptedConnections) {
        List connections = node.getConnectionPoints();
        if (connections != null) {
            for (ConnectionPoint pt : connections) {
                ConnectionMapping mapping;
                if (onlyActiveConnections && (!onlyActiveConnections || !pt.isActive()) || onlyPromptedConnections && !((mapping = this.getConnectionMapping(pt)) instanceof PromptedConnectionMapping)) continue;
                cps.add(pt);
            }
        }
    }

    private void loadConnectionPointsForNested(List<Nested> nestedNodes, Set<ConnectionPoint> cps, boolean onlyActiveConnections, boolean onlyPromptedConnections) {
        if (nestedNodes != null && !nestedNodes.isEmpty()) {
            for (Nested nestedNode : nestedNodes) {
                if (!(nestedNode instanceof TransportNode)) continue;
                this.loadConnectionPoints((TransportNode)nestedNode, cps, onlyActiveConnections, onlyPromptedConnections);
                List list = ((TransportNode)nestedNode).getNestedNodes();
                this.loadConnectionPointsForNested(list, cps, onlyActiveConnections, onlyPromptedConnections);
            }
        }
    }

    public Map<ConnectionMapping, Set<ConnectionPoint>> getConnectionPointsByMapping(List<? extends TransportNode> nodes) {
        HashMap<ConnectionMapping, Set<ConnectionPoint>> cpCache = new HashMap<ConnectionMapping, Set<ConnectionPoint>>();
        for (TransportNode transportNode : nodes) {
            List connections = transportNode.getConnectionPoints();
            if (connections == null) continue;
            for (ConnectionPoint cp : connections) {
                ConnectionMapping mapping = this.getConnectionMapping(cp);
                if (mapping == null) continue;
                LinkedHashSet<ConnectionPoint> cpSet = (LinkedHashSet<ConnectionPoint>)cpCache.get(mapping);
                if (cpSet == null) {
                    cpSet = new LinkedHashSet<ConnectionPoint>();
                    cpCache.put(mapping, cpSet);
                }
                cpSet.add(cp);
            }
        }
        return cpCache;
    }

    public List<ConnectionPoint> getConnectionPointsForMapping(ConnectionMapping mapping, ContentOperation<? extends TransportNode> operation) {
        Set<ConnectionPoint> allConnections = this.getConnectionPoints(operation.getOperationNodes());
        ArrayList<ConnectionPoint> connections = new ArrayList<ConnectionPoint>();
        if (mapping != null) {
            for (ConnectionPoint cp : allConnections) {
                ConnectionMapping cm = this.getConnectionMapping(cp);
                if (!mapping.equals(cm)) continue;
                connections.add(cp);
            }
        }
        return connections;
    }

    public List<ConnectionPoint> getConnectionPointsForMapping(ConnectionMapping mapping, List<ConnectionPoint> connectionPoints) {
        ArrayList<ConnectionPoint> connections = new ArrayList<ConnectionPoint>();
        if (mapping != null) {
            for (ConnectionPoint cp : connectionPoints) {
                ConnectionMapping cm = this.getConnectionMapping(cp);
                if (!mapping.equals(cm)) continue;
                connections.add(cp);
            }
        }
        return connections;
    }

    public Map<ConnectionMapping, List<ConnectionPoint>> getConnectionsByMapping(TransportOperation<? extends TransportNode> operation, List<? extends TransportNode> nodes, boolean onlyPromptedConnections, boolean includeMappedConnections) {
        Set<ConnectionPoint> cpCache = this.getConnectionPoints(nodes, true, onlyPromptedConnections);
        LinkedHashMap<ConnectionMapping, List<Object>> mappingCache = new LinkedHashMap<ConnectionMapping, List<ConnectionPoint>>();
        for (ConnectionPoint cp : cpCache) {
            ConnectionMapping connectionMapping;
            if (!includeMappedConnections && cp.isMapped() || (connectionMapping = this.getConnectionMapping(cp)) == null) continue;
            ArrayList<ConnectionPoint> connectionsByType = (ArrayList<ConnectionPoint>)mappingCache.get(connectionMapping);
            if (connectionsByType == null) {
                connectionsByType = new ArrayList<ConnectionPoint>();
                mappingCache.put(connectionMapping, connectionsByType);
            }
            connectionsByType.add(cp);
        }
        if (mappingCache.size() > 1) {
            TreeSet<Map.Entry<ConnectionMapping, List<ConnectionPoint>>> sortedSet = new TreeSet<Map.Entry<ConnectionMapping, List<ConnectionPoint>>>(new MappingSorter(operation.getLocale()));
            sortedSet.addAll(mappingCache.entrySet());
            mappingCache = new LinkedHashMap();
            for (Map.Entry entry : sortedSet) {
                mappingCache.put((ConnectionMapping)entry.getKey(), (List)entry.getValue());
            }
        }
        return mappingCache;
    }

    class MappingSorter
    implements Comparator<Map.Entry<ConnectionMapping, List<ConnectionPoint>>> {
        private Locale locale;
        private SASStringComparator stringComp;

        public MappingSorter(Locale locale) {
            this.locale = locale;
            this.stringComp = SASCollatorFactory.createCollator((Locale)locale);
        }

        @Override
        public int compare(Map.Entry<ConnectionMapping, List<ConnectionPoint>> mapping1, Map.Entry<ConnectionMapping, List<ConnectionPoint>> mapping2) {
            if (!(mapping1.getKey() instanceof PromptedConnectionMapping)) {
                return 1;
            }
            if (!(mapping2.getKey() instanceof PromptedConnectionMapping)) {
                return -1;
            }
            List<ConnectionPoint> cps1 = mapping1.getValue();
            List<ConnectionPoint> cps2 = mapping2.getValue();
            for (ConnectionPoint cp1 : cps1) {
                for (ConnectionPoint parent1 = cp1.getParentConnection(); parent1 != null; parent1 = parent1.getParentConnection()) {
                    if (!cps2.contains(parent1)) continue;
                    return 1;
                }
            }
            for (ConnectionPoint cp2 : cps2) {
                for (ConnectionPoint parent2 = cp2.getParentConnection(); parent2 != null; parent2 = parent2.getParentConnection()) {
                    if (!cps1.contains(parent2)) continue;
                    return -1;
                }
            }
            PromptedConnectionMapping m1 = (PromptedConnectionMapping)mapping1.getKey();
            PromptedConnectionMapping m2 = (PromptedConnectionMapping)mapping2.getKey();
            return this.stringComp.compare(m1.getTypeLabel(this.locale), m2.getTypeLabel(this.locale));
        }
    }
}

