/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao;

import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.InvalidLengthException;
import com.sas.svcs.content.framework.client.NameInUseException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.lifecycle.client.Container;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.ContentValidationService;
import com.sas.svcs.content.lifecycle.client.Nested;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TargetTransportOperation;
import com.sas.svcs.content.lifecycle.client.TransportUtil;
import com.sas.svcs.content.lifecycle.dao.NameValidator;
import com.sas.svcs.content.lifecycle.dao.RB;
import com.sas.svcs.content.logging.client.LogItem;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIService;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TransportNodeRenameUtil {
    private ContentValidationService validationService;
    private ObjectTypeUIService objectTypeUIService;

    @Autowired
    public void setObjectTypeUIService(ObjectTypeUIService objectTypeUIService) {
        this.objectTypeUIService = objectTypeUIService;
    }

    @Autowired
    public void setContentValidationService(ContentValidationService validationService) {
        this.validationService = validationService;
    }

    public String generateDefaultCopyName(String originalName) {
        return this.generateDefaultCopyName(originalName, 1);
    }

    public String generateDefaultCopyName(String originalName, int copyIndex) {
        return this.generateDefaultCopyName(originalName, copyIndex, false);
    }

    public String generateDefaultCopyName(String originalName, int copyIndex, boolean extensionsSupported) {
        int index;
        if (copyIndex < 0) {
            throw new IllegalArgumentException("Invalid index used to generate object's name.");
        }
        if (copyIndex == 0) {
            return originalName;
        }
        if (extensionsSupported && (index = originalName.lastIndexOf(46)) > -1) {
            String name = originalName.substring(0, index);
            String extension = originalName.substring(index);
            return name + "(" + copyIndex + ")" + extension;
        }
        return originalName + "(" + copyIndex + ")";
    }

    public String generateNewName(TargetTransportNode node, Set<String> names, TargetTransportOperation<?> operation) throws ValidationException {
        return this.generateNewName(node, names, 0, null, operation);
    }

    private String generateNewName(TargetTransportNode node, Set<String> names, int renameCount, NameValidator validator, TargetTransportOperation<?> operation) throws ValidationException {
        TargetTransportNode tnn;
        if (node == null) {
            throw new IllegalArgumentException("Illegal node name");
        }
        String originalName = null;
        ContentComponent comp = node.getContentObject();
        originalName = comp != null ? comp.getName() : node.getName();
        ObjectIdentity parentIdentity = null;
        Container container = node.getContainer();
        if (container == null) {
            parentIdentity = ObjectIdentityUtils.createObjectIdentity((Identifiable)operation.getTargetContainer());
        } else if (container instanceof TargetTransportNode && (tnn = (TargetTransportNode)container).getTargetId() != null) {
            parentIdentity = new ObjectIdentity();
            parentIdentity.setId(tnn.getTargetId());
            parentIdentity.setObjectType(tnn.getObjectType());
        }
        String newName = null;
        boolean extensionsSupported = validator == null ? false : validator.areExtensionsSupported();
        int count = 9999;
        for (int index = renameCount + 1; index < count; ++index) {
            String tmpName;
            newName = this.generateDefaultCopyName(originalName, index, extensionsSupported);
            if (validator != null && (tmpName = validator.generateNewName(newName)) != null) {
                newName = tmpName;
            }
            if ((newName = this.validateName(node, names, originalName, parentIdentity, newName, validator)) == null) continue;
            return newName;
        }
        if (newName == null) {
            newName = this.generateDefaultCopyName(originalName, renameCount, extensionsSupported);
        }
        String msg = Message.format((String)RB.getStringResource("TransportNodeRenameUtil.SameName.fmt.txt", operation.getLocale()), (Object)newName);
        throw new IllegalStateException(msg);
    }

    private String validateName(TargetTransportNode node, Set<String> names, String originalName, ObjectIdentity parentIdentity, String generatedName, NameValidator nameValidator) throws ValidationException {
        String newName = null;
        if (!names.contains(generatedName)) {
            try {
                this.validationService.canCreate(generatedName, node.getObjectType(), parentIdentity);
                newName = generatedName;
            }
            catch (InvalidLengthException e) {
                int maxLength = e.getMaxLength();
                if (maxLength > 0) {
                    boolean extensionsSupported = nameValidator == null ? false : nameValidator.areExtensionsSupported();
                    generatedName = this.truncateName(originalName, generatedName, maxLength, extensionsSupported);
                    newName = this.validateName(node, names, originalName, parentIdentity, generatedName, nameValidator);
                }
            }
            catch (NameInUseException e) {
            }
            catch (ValidationException e) {
                throw e;
            }
        }
        return newName;
    }

    private String truncateName(String originalName, String generatedName, int maxLength, boolean extensionsSupported) {
        int numChars = generatedName.length() - originalName.length();
        if (extensionsSupported && generatedName.lastIndexOf(46) > -1) {
            int extensionIndex = generatedName.lastIndexOf(46);
            String extension = generatedName.substring(extensionIndex);
            String name = generatedName.substring(0, generatedName.length() - (numChars += extension.length()));
            String copyCounter = generatedName.substring(generatedName.length() - numChars, extensionIndex);
            generatedName = name.substring(0, maxLength - numChars).trim();
            generatedName = generatedName + copyCounter + extension;
        } else {
            String copyCounter = generatedName.substring(generatedName.length() - numChars);
            generatedName = generatedName.substring(0, maxLength - numChars).trim();
            generatedName = generatedName + copyCounter;
        }
        return generatedName;
    }

    public <T extends TargetTransportNode> List<T> getRenamedNodes(List<T> nodes, NameValidator validator, TargetTransportOperation<T> operation, List<LogItem> logItems) throws ValidationException {
        LinkedHashSet<TargetTransportNode> renamedNodes = new LinkedHashSet<TargetTransportNode>();
        for (TargetTransportNode node : nodes) {
            if (!node.isRenamed()) continue;
            renamedNodes.add(node);
            if (validator == null) continue;
            String newName = null;
            String currentName = node.getName();
            boolean rename = false;
            if (validator.areExtensionsSupported() && currentName.lastIndexOf(46) > -1) {
                String originalName;
                ContentComponent comp = node.getContentObject();
                String string = originalName = comp == null ? currentName : comp.getName();
                if (!originalName.equalsIgnoreCase(currentName)) {
                    int numChars = currentName.length() - originalName.length();
                    String copyCounter = currentName.substring(currentName.length() - numChars);
                    String baseName = currentName.substring(0, currentName.length() - numChars);
                    int extensionIndex = baseName.lastIndexOf(46);
                    String extension = baseName.substring(extensionIndex);
                    baseName = baseName.substring(0, extensionIndex);
                    currentName = baseName + copyCounter + extension;
                    rename = true;
                }
            }
            if ((newName = validator.generateNewName(currentName)) != null && !newName.equals(currentName)) {
                rename = true;
            }
            if (!rename) continue;
            HashSet<String> names = new HashSet<String>();
            Container container = node.getContainer();
            if (container != null) {
                long objectType = node.getObjectType();
                List children = container.getChildren();
                for (TargetTransportNode child : children) {
                    if (child.getObjectType() != objectType) continue;
                    names.add(child.getName());
                }
            }
            if ((newName = this.generateNewName(node, names, 0, validator, operation)) == null) continue;
            node.rename(newName);
        }
        if (validator != null) {
            for (TargetTransportNode nextNode : nodes) {
                if (!TransportUtil.isCreating((TargetTransportNode)nextNode)) continue;
                this.validateNode(nextNode, validator, operation, renamedNodes, logItems);
                this.renameNestedNodes(nextNode, renamedNodes);
            }
        }
        return new ArrayList(renamedNodes);
    }

    private <T extends TargetTransportNode> void validateNode(T node, NameValidator validator, TargetTransportOperation<T> operation, Set<T> renamedNodes, List<LogItem> logItems) throws ValidationException {
        ContentComponent comp;
        Set<String> names = null;
        int renameCount = 0;
        boolean failedValidation = false;
        boolean validated = false;
        while (!validated) {
            String name = node.getName();
            validated = validator.isValidName(name, node, operation);
            if (!validated) {
                if (names == null) {
                    names = this.getSiblingNames(node);
                }
                renameCount = this.renameNode(node, names, renameCount, operation, renamedNodes, validator);
                failedValidation = true;
                continue;
            }
            if (renamedNodes.isEmpty() || !this.duplicateNodeExists(node, renamedNodes)) continue;
            if (names == null) {
                names = this.getSiblingNames(node);
            }
            int originalCount = renameCount;
            if ((renameCount = this.renameNode(node, names, renameCount, operation, renamedNodes, validator)) <= originalCount) continue;
            validated = false;
        }
        if (failedValidation && (comp = node.getContentObject()) != null) {
            String displayType = TransportUtil.getDisplayType((String)comp.getObjectTypeName(), (Locale)operation.getLocale(), (ObjectTypeUIService)this.objectTypeUIService);
            String originalName = node.getContentObject().getName();
            String msg = Message.format((String)RB.getStringResource("TransportNodeRenameUtil.RenamedObjectConflict.fmt.txt", operation.getLocale()), (Object)displayType, (Object)originalName, (Object)node.getName());
            LogItem logItem = this.createLogItem((ContentOperation<?>)operation, 200, msg, comp.getObjectTypeName());
            if (logItems != null) {
                logItems.add(logItem);
            }
        }
    }

    private <T extends TargetTransportNode> int renameNode(T node, Set<String> names, int renameCount, TargetTransportOperation<T> operation, Set<T> renamedNodes, NameValidator validator) throws ValidationException {
        String name = this.generateNewName(node, names, renameCount, validator, operation);
        if (name != null) {
            node.rename(name);
            renamedNodes.add(node);
            ++renameCount;
        }
        return renameCount;
    }

    private <T extends TargetTransportNode> boolean duplicateNodeExists(T node, Set<T> renamedNodes) {
        for (TargetTransportNode renamedNode : renamedNodes) {
            if (renamedNode == node || renamedNode.getObjectType() != node.getObjectType() || !renamedNode.getName().equalsIgnoreCase(node.getName()) || renamedNode.getContainer() != node.getContainer()) continue;
            return true;
        }
        return false;
    }

    private <T extends TargetTransportNode> Set<String> getSiblingNames(T node) {
        HashSet<String> names = new HashSet<String>();
        Container container = node.getContainer();
        if (container != null) {
            long objectType = node.getObjectType();
            List children = container.getChildren();
            for (TargetTransportNode child : children) {
                if (child.getObjectType() != objectType) continue;
                names.add(child.getName());
            }
        }
        return names;
    }

    private <T extends TargetTransportNode> void renameNestedNodes(T node, Set<T> renamedNodes) {
        List nestedNodes = node.getNestedNodes();
        if (nestedNodes != null && !nestedNodes.isEmpty()) {
            for (Nested nestedNode : nestedNodes) {
                if (!(nestedNode instanceof TargetTransportNode)) continue;
                if (((TargetTransportNode)nestedNode).isRenamed()) {
                    renamedNodes.add((TargetTransportNode)nestedNode);
                }
                this.renameNestedNodes((TargetTransportNode)nestedNode, renamedNodes);
            }
        }
    }

    private LogItem createLogItem(ContentOperation<?> operation, int priority, String text, String objectTypeName) {
        String displayType = TransportUtil.getDisplayType((String)objectTypeName, (Locale)operation.getLocale(), (ObjectTypeUIService)this.objectTypeUIService);
        LogItem logItem = new LogItem(null);
        logItem.setDate(new Date());
        logItem.setClassifier(displayType);
        logItem.setPriority(priority);
        logItem.setText(text);
        return logItem;
    }
}

