/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao;

import com.sas.svcs.content.lifecycle.client.TransportOperation;
import com.sas.svcs.content.lifecycle.dao.AbstractOperationDAO;
import com.sas.svcs.content.lifecycle.dao.ContentLogEvent;
import com.sas.svcs.content.logging.client.ContentLoggingService;
import com.sas.svcs.content.logging.client.LogItem;
import com.sas.svcs.content.logging.client.util.ContentLoggingUtil;
import com.sas.svcs.content.streaming.client.StreamService;
import com.sas.svcs.content.transport.client.ContentItem;
import com.sas.svcs.content.transport.client.ExportPackage;
import com.sas.svcs.content.transport.client.ExportPackageService;
import com.sas.svcs.content.transport.client.ExportTypeSubpackage;
import java.util.List;
import java.util.StringTokenizer;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPromotionDAO
extends AbstractOperationDAO {
    protected String persistencePath;
    protected ExportPackageService exportPackageService;
    protected ContentLoggingService contentLoggingService;
    protected StreamService streamService;

    @Autowired
    public void setExportPackageService(ExportPackageService exportPackageService) {
        this.exportPackageService = exportPackageService;
    }

    @Autowired
    public void setStreamService(StreamService streamService) {
        this.streamService = streamService;
    }

    @Autowired
    public void setContentLoggingService(ContentLoggingService contentLoggingService) {
        this.contentLoggingService = contentLoggingService;
    }

    protected final ExportPackageService getExportPackageService() {
        return this.exportPackageService;
    }

    protected final StreamService getStreamService() {
        return this.streamService;
    }

    protected final void logEnumerationMessages(TransportOperation<?> operation, int priority, List<String> messages, String objectTypeName) {
        if (operation.getContentLog() == null) {
            return;
        }
        String contentLogId = operation.getContentLog().getId();
        String displayType = this.getDisplayType(objectTypeName, operation.getLocale());
        ContentLoggingUtil.logEnumerationMessages((ContentLoggingService)this.contentLoggingService, (String)contentLogId, messages, (int)priority, (String)displayType);
    }

    protected final void logMessage(TransportOperation<?> operation, String text, int priority, Throwable t, String objectTypeName) {
        if (operation.getContentLog() == null) {
            return;
        }
        String contentLogId = operation.getContentLog().getId();
        String displayType = this.getDisplayType(objectTypeName, operation.getLocale());
        ContentLoggingUtil.logMessage((ContentLoggingService)this.contentLoggingService, (String)contentLogId, (String)text, (int)priority, (String)displayType, (Throwable)t);
    }

    protected final void logTransportEvent(ContentLogEvent event) {
        LogItem item = event.getLogItem();
        this.contentLoggingService.addLogItem(item);
    }

    protected final void addSubpackage(ExportPackage exportPackage, ExportTypeSubpackage subpackage) {
        if (this.persistencePath == null || this.persistencePath.length() == 0) {
            exportPackage.addTypeSubpackage(subpackage);
            return;
        }
        List subpackageList = exportPackage.getTypeSubpackages();
        StringTokenizer st = new StringTokenizer(this.persistencePath, "/");
        ExportTypeSubpackage parentSubpackage = null;
        while (st.hasMoreTokens()) {
            String nextType = st.nextToken();
            parentSubpackage = this.getSubpackage(subpackageList, nextType);
            subpackageList = parentSubpackage.getSubpackages();
        }
        parentSubpackage.addSubpackage(subpackage);
    }

    protected final ExportTypeSubpackage getSubpackage(ExportPackage exportPackage, String typeName) {
        List subpackages = exportPackage.getTypeSubpackages();
        ExportTypeSubpackage subpackage = null;
        if (this.persistencePath != null && this.persistencePath.length() > 0) {
            StringTokenizer st = new StringTokenizer(this.persistencePath, "/");
            while (st.hasMoreTokens()) {
                String nextType = st.nextToken();
                subpackage = this.getSubpackage(subpackages, nextType);
                subpackages = subpackage.getSubpackages();
            }
        }
        subpackage = this.getSubpackage(subpackages, typeName);
        return subpackage;
    }

    protected final ExportTypeSubpackage getSubpackage(List<ExportTypeSubpackage> subpackageList, String typeName) {
        for (ExportTypeSubpackage nextSubpackage : subpackageList) {
            if (!nextSubpackage.getTypeName().equals(typeName)) continue;
            return nextSubpackage;
        }
        return null;
    }

    protected final ContentItem getContentItemFromPackage(List<ContentItem> items, String name) {
        if (items != null) {
            for (ContentItem item : items) {
                if (!name.equalsIgnoreCase(item.getName())) continue;
                return item;
            }
        }
        return null;
    }

    protected final ContentItem getContentItemFromPackage(ExportTypeSubpackage subpackage, String name) {
        List contentItems = subpackage.getContentItems();
        return this.getContentItemFromPackage(contentItems, name);
    }
}

