/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao;

import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.lifecycle.client.ImportNode;
import com.sas.svcs.content.lifecycle.client.ImportOperation;
import com.sas.svcs.content.lifecycle.client.Nested;
import com.sas.svcs.content.lifecycle.client.NestedImportNode;
import com.sas.svcs.content.lifecycle.client.OperationNode;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TransportState;
import com.sas.svcs.content.lifecycle.client.TransportUtil;
import com.sas.svcs.content.lifecycle.dao.NestedNodeMerger;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractNestedNodeMerger
implements NestedNodeMerger {
    private boolean _addObjectsDuringMerge = true;
    private boolean _updateObjectsDuringMerge = true;
    private boolean _deleteObjectsDuringMerge = false;
    protected ImportOperation operation;

    public AbstractNestedNodeMerger(ImportOperation operation) {
        this.operation = operation;
    }

    protected final boolean isOverwritingExistingObjects() {
        return this._updateObjectsDuringMerge;
    }

    protected final boolean isAddingNewObjects() {
        return this._addObjectsDuringMerge;
    }

    protected final boolean isDeletingTargetObjects() {
        return this._deleteObjectsDuringMerge;
    }

    public void setOverwritingExistingObjects(boolean value) {
        this._updateObjectsDuringMerge = value;
    }

    public void setAddingNewObjects(boolean value) {
        this._addObjectsDuringMerge = value;
    }

    public void setDeletingTargetObjects(boolean value) {
        this._deleteObjectsDuringMerge = value;
    }

    public abstract List<ContentComponent> getTargetChildReferences(ObjectIdentity var1);

    @Override
    public void mergeNestedNodes(List<ImportNode> importNodes) {
        for (ImportNode node : importNodes) {
            if (!TransportUtil.isOverwriting((TargetTransportNode)node)) continue;
            ObjectIdentity identity = new ObjectIdentity(node.getObjectType(), node.getTargetId());
            List<ContentComponent> targetChildList = this.getTargetChildReferences(identity);
            List nestedNodes = node.getNestedNodes();
            if (nestedNodes != null && !nestedNodes.isEmpty()) {
                for (Nested nestedNode : nestedNodes) {
                    if (!(nestedNode instanceof NestedImportNode) || ((NestedImportNode)nestedNode).getTransportState() != TransportState.UNSET_NODE_STATE) continue;
                    NestedImportNode nestedImportNode = (NestedImportNode)nestedNode;
                    ContentComponent targetChild = this.findMatchingChild(nestedImportNode, targetChildList);
                    this.setMergeState(nestedImportNode, targetChild);
                }
            }
            if (!this.isDeletingTargetObjects()) continue;
            this.processTargetObjectsToDelete(node, targetChildList);
        }
    }

    private void processTargetObjectsToDelete(ImportNode node, List<ContentComponent> targetChildList) {
        HashMap<String, NestedImportNode> nodeCache = new HashMap<String, NestedImportNode>();
        List nestedNodes = node.getNestedNodes();
        if (nestedNodes != null) {
            for (Nested nestedNode : nestedNodes) {
                if (!(nestedNode instanceof NestedImportNode)) continue;
                NestedImportNode nestedImportNode = (NestedImportNode)nestedNode;
                nodeCache.put(nestedImportNode.getName(), nestedImportNode);
            }
        }
        for (ContentComponent targetChild : targetChildList) {
            if (nodeCache.containsKey(targetChild.getName())) continue;
            NestedImportNode deleteTargetNode = new NestedImportNode();
            deleteTargetNode.setParent((OperationNode)node);
            deleteTargetNode.setTargetId(targetChild.getId());
            deleteTargetNode.setTransportState(new TransportState(8));
            deleteTargetNode.setContentObject(targetChild);
            this.deletingTargetNestedNode(deleteTargetNode);
        }
    }

    protected void deletingTargetNestedNode(NestedImportNode deleteTargetNode) {
    }

    private void setMergeState(NestedImportNode nestedImportNode, ContentComponent targetChild) {
        if (targetChild != null) {
            if (this.isOverwritingExistingObjects()) {
                nestedImportNode.setTransportState(new TransportState(4));
                nestedImportNode.setTargetId(targetChild.getId());
            }
        } else if (this.isAddingNewObjects()) {
            nestedImportNode.setTransportState(new TransportState(2));
        }
    }

    private ContentComponent findMatchingChild(NestedImportNode nestedNode, List<ContentComponent> childList) {
        for (ContentComponent child : childList) {
            if (!this.isMatchingChild(nestedNode, child)) continue;
            return child;
        }
        return null;
    }

    protected boolean isMatchingChild(NestedImportNode nestedImportNode, ContentComponent targetObject) {
        String name = nestedImportNode.getName();
        return name == null ? false : name.equals(targetObject.getName());
    }
}

