/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

abstract class SASLibraryConnectStatement {
    final MdModelUtil.SAS9Generator sas9Generator;
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char BLANK_SPACE = ' ';
    protected final String[] portableOptions = new String[]{"CONNECTION", "CONNECTION_GROUP", "DBCONINIT", "DBINITCMD", "INITCMD", "DBCONTERM", "DBTERMCMD", "TERMCMD", "DBGEN_NAME", "DBMAX_TEXT", "TEXTSIZE", "DBMAX_TEXT_TYPES", "DEFER", "VALIDVARNAME", "ENCODING"};
    protected final int noDelimiterFound = Integer.MAX_VALUE;
    StringBuilder connectionOptions = new StringBuilder();

    @Nonnull
    static SASLibraryConnectStatement newInstance(MdModelUtil.SAS9Generator sas9Generator, SASLibrary iMeta) throws RemoteException {
        String engineName = iMeta.getEngine();
        SASLibraryConnectStatement engineConnection = "DB2".equalsIgnoreCase(engineName) ? new Db2Connection(sas9Generator) : ("ODBC".equalsIgnoreCase(engineName) ? new OdbcConnection(sas9Generator) : ("ASTER".equalsIgnoreCase(engineName) ? new AsterConnection(sas9Generator) : ("MYSQL".equalsIgnoreCase(engineName) ? new MySqlConnection(sas9Generator) : ("OLEDB".equalsIgnoreCase(engineName) ? new OleDbConnection(sas9Generator) : ("EXCEL".equalsIgnoreCase(engineName) ? new ExcelConnection(sas9Generator) : ("SYBASE".equalsIgnoreCase(engineName) ? new SybaseConnection(sas9Generator) : ("ORACLE".equalsIgnoreCase(engineName) ? new OracleConnection(sas9Generator) : ("SQLSVR".equalsIgnoreCase(engineName) ? new SqlServerConnection(sas9Generator) : ("ACCESS".equalsIgnoreCase(engineName) ? new AccessConnection(sas9Generator) : ("HADOOP".equalsIgnoreCase(engineName) || "SASIOSK".equalsIgnoreCase(engineName) ? new HadoopConnection(sas9Generator) : ("FEDSVR".equalsIgnoreCase(engineName) ? new TableServerConnection(sas9Generator) : ("NETEZZA".equalsIgnoreCase(engineName) ? new NetezzaConnection(sas9Generator) : ("NEOVIEW".equalsIgnoreCase(engineName) ? new NeoviewConnection(sas9Generator) : ("SASSPDS".equalsIgnoreCase(engineName) ? new SpdsConnection(sas9Generator) : ("PCFILES".equalsIgnoreCase(engineName) ? new PcFilesConnection(sas9Generator) : ("VERTICA".equalsIgnoreCase(engineName) ? new VerticaConnection(sas9Generator) : ("GREENPLM".equalsIgnoreCase(engineName) ? new GreenplumConnection(sas9Generator) : ("INFORMIX".equalsIgnoreCase(engineName) ? new InformixConnection(sas9Generator) : ("SYBASEIQ".equalsIgnoreCase(engineName) ? new SybaseIqConnection(sas9Generator) : ("TERADATA".equalsIgnoreCase(engineName) ? new TeradataConnection(sas9Generator) : ("POSTGRES".equalsIgnoreCase(engineName) ? new PostgresConnection(sas9Generator) : ("SASIOHNA".equalsIgnoreCase(engineName) ? new SapHanaConnection(sas9Generator) : ("SASIOIMP".equalsIgnoreCase(engineName) ? new ImpalaConnection(sas9Generator) : ("SASIOHWQ".equalsIgnoreCase(engineName) ? new HawqConnection(sas9Generator) : ("REDSHIFT".equalsIgnoreCase(engineName) || "SASIORST".equalsIgnoreCase(engineName) ? new RedshiftConnection(sas9Generator) : ("SASIOJDB".equalsIgnoreCase(engineName) ? new JdbcConnection(sas9Generator) : ("SASIOSLF".equalsIgnoreCase(engineName) ? new SalesforceConnection(sas9Generator) : ("SASIOMGO".equalsIgnoreCase(engineName) ? new MongoConnection(sas9Generator) : ("SASIOSNF".equalsIgnoreCase(engineName) ? new SnowlakeConnection(sas9Generator) : ("SASIOGBQ".equalsIgnoreCase(engineName) ? new BigQueryConnection(sas9Generator) : ("SASIOYLB".equalsIgnoreCase(engineName) ? new YellowbrickConnection(sas9Generator) : new UnknownEngineConnection(sas9Generator))))))))))))))))))))))))))))))));
        return engineConnection;
    }

    SASLibraryConnectStatement(MdModelUtil.SAS9Generator sas9Generator) {
        this.sas9Generator = sas9Generator;
    }

    abstract String getConnectionOptions(SASLibrary var1, SASClientConnection var2) throws RemoteException, MdException;

    protected String addSchemaOption(SASLibrary iMeta) throws RemoteException, MdException {
        StringBuilder schemaOption = new StringBuilder();
        DatabaseSchema iSchema = (DatabaseSchema)iMeta.getUsingPackages().get(0);
        schemaOption.append(" schema=\"" + iSchema.getSchemaName() + '\"');
        return schemaOption.toString();
    }

    protected String addCredentials(SASLibrary iMeta, boolean isUserNameToBeQuoted) throws RemoteException, MdException {
        boolean isPasswordToBeQuoted = true;
        Connection currentConnection = null;
        return this.sas9Generator.genCredentials(iMeta, currentConnection, isUserNameToBeQuoted, true);
    }

    protected String getConnectionProperties(List<Property> lProps, String[] optionNames, ArrayList<SasLibnameOption> sasOptions) throws RemoteException {
        StringBuffer optionString = new StringBuffer();
        int totalOptionCount = optionNames.length;
        for (Property iProp : lProps) {
            String propertyName = iProp.getPropertyName();
            optionString.append(this.findSupportedOption(optionNames, totalOptionCount, iProp, propertyName, sasOptions));
        }
        return optionString.toString();
    }

    protected boolean isDNSOptionPresent(SASClientConnection iDbms) throws RemoteException, MdException {
        boolean foundDSNOption = false;
        if (iDbms != null) {
            AssociationList lProps = iDbms.getProperties();
            for (Property iProp : lProps) {
                String propertyName = iProp.getPropertyName();
                if (!"DSN".equalsIgnoreCase(propertyName)) continue;
                foundDSNOption = true;
                break;
            }
        }
        return foundDSNOption;
    }

    private String findSupportedOption(String[] optionNames, int totalOptionCount, Property iProp, String currentOptionName, ArrayList<SasLibnameOption> sasOptions) throws RemoteException {
        StringBuffer optionString = new StringBuffer();
        for (String optionName : optionNames) {
            boolean isFreeFormatOptionPresent = iProp.getUseValueOnly() != 0;
            boolean isOptionFound = false;
            if (isFreeFormatOptionPresent) {
                boolean isNeedingTokenization;
                String freeFormOptions = iProp.getDefaultValue();
                if (!this.isOptionStringPresent(freeFormOptions, optionName)) continue;
                boolean bl = isNeedingTokenization = sasOptions == null;
                if (isNeedingTokenization) {
                    sasOptions = this.tokenizeFreeFormatOptionString(freeFormOptions);
                }
                optionString.append(this.getFreeFormatOption(optionName, sasOptions));
                continue;
            }
            isOptionFound = currentOptionName.equalsIgnoreCase(optionName);
            if (!isOptionFound) continue;
            SasLibnameOption optionElement = new SasLibnameOption(optionName, iProp.getDelimiter(), iProp.getDefaultValue());
            optionString.append(this.assembleOption(optionElement, true));
            break;
        }
        return optionString.toString();
    }

    protected String assembleOption(SasLibnameOption optionElement, boolean isQuoteable) {
        if (optionElement.isValidSQLOptionValue()) {
            StringBuffer optionString = new StringBuffer();
            optionString.append(' ');
            if (isQuoteable) {
                optionString.append(optionElement.getOptionCheckingForQuotes());
            } else {
                optionString.append(optionElement.getSyntacticallyCorrectOption());
            }
            return optionString.toString();
        }
        return "";
    }

    private boolean isOptionStringPresent(String freeFormatOptions, String optionName) {
        String uppercasedFreeFormatOptions = freeFormatOptions.toUpperCase();
        String uppercasedOptionName = optionName.toUpperCase();
        return uppercasedFreeFormatOptions.contains(uppercasedOptionName);
    }

    private ArrayList<SasLibnameOption> tokenizeFreeFormatOptionString(String freeFormString) {
        freeFormString = freeFormString.trim();
        FreeFormatOptionsText optionText = new FreeFormatOptionsText(freeFormString);
        ArrayList<SasLibnameOption> tokenizedOptions = new ArrayList<SasLibnameOption>();
        SasLibnameOption currentOption = null;
        do {
            if (optionText.isParsingName()) {
                currentOption = new SasLibnameOption();
                tokenizedOptions.add(currentOption);
            }
            optionText.getToken(currentOption);
        } while (!optionText.isParsingFinished());
        return tokenizedOptions;
    }

    private String getFreeFormatOption(String desiredOptionName, ArrayList<SasLibnameOption> optionList) {
        boolean isQuoteable = false;
        StringBuffer optionString = new StringBuffer();
        for (SasLibnameOption currentOptionElement : optionList) {
            String currentOptionName = currentOptionElement.getName();
            if (!currentOptionName.equalsIgnoreCase(desiredOptionName)) continue;
            optionString.append(this.assembleOption(currentOptionElement, false));
        }
        return optionString.toString();
    }

    protected String genPassThruOptionsString(SASLibrary iMeta, SASClientConnection iDbms, boolean isUserNameToBeQuoted, String[] specificOptions) throws MdException, RemoteException {
        AssociationList iMetaProperties = iMeta.getProperties();
        AssociationList iDbmsProperties = iDbms != null ? iDbms.getProperties() : null;
        boolean isDbmsPropertiesAvailable = iDbmsProperties != null;
        StringBuilder optionsString = new StringBuilder();
        ArrayList<SasLibnameOption> tokenizedSasOptions = null;
        optionsString.append(this.getConnectionProperties(iMetaProperties, this.portableOptions, tokenizedSasOptions));
        if (isDbmsPropertiesAvailable) {
            optionsString.append(this.getConnectionProperties(iDbmsProperties, this.portableOptions, tokenizedSasOptions));
        }
        optionsString.append(this.getConnectionProperties(iMetaProperties, specificOptions, tokenizedSasOptions));
        if (isDbmsPropertiesAvailable) {
            optionsString.append(this.getConnectionProperties(iDbmsProperties, specificOptions, tokenizedSasOptions));
        }
        optionsString.append(this.addCredentials(iMeta, isUserNameToBeQuoted));
        if (this.isSchemaOptionSupported(specificOptions)) {
            DeployedDataPackage iPkg = this.sas9Generator.getDeployedDataPackage(iMeta);
            DatabaseSchema iSchema = this.sas9Generator.getSchema(iPkg);
            boolean isSpdsEngine = false;
            optionsString.append(this.sas9Generator.getSchemaOption(false, iSchema));
        }
        return optionsString.toString();
    }

    private boolean isSchemaOptionSupported(String[] specificOptions) {
        boolean isSupported = false;
        for (String specificOption : specificOptions) {
            if (!"SCHEMA".equalsIgnoreCase(specificOption)) continue;
            isSupported = true;
            break;
        }
        return isSupported;
    }

    private static final class Db2Connection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"AUTOCOMMIT", "CURSOR_TYPE", "CURSOR", "QUERY_TIMEOUT", "READBUFF", "ROWSET", "ROWSET_SIZE", "READ_ISOLATION_LEVEL", "RIL", "DATASRC", "DSN", "DATABASE", "COMPLETE", "NOPROMPT", "PROMPT", "REQUIRED", "SSID", "SERVER", "LOCATION", "AUTHID", "DBPROMPT", "AUTHDOMAIN"};

        Db2Connection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static class OdbcConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"AUTOCOMMIT", "CURSOR_TYPE", "CURSOR", "KEYSET_SIZE", "KEYSET", "QUERY_TIMEOUT", "READBUFF", "ROWSET_SIZE", "READ_ISOLATION_LEVEL", "RIL", "TRACE", "TRACEFILE", "USE_ODBC_CL", "UTILCONN_TRANSIENT", "DATASRC", "DSN", "DB", "DATABASE", "COMPLETE", "NOPROMPT", "PROMPT", "REQUIRED", "AUTHDOMAIN", "DBPROMPT", "DELETE_MULT_ROWS", "IGNORE_READ_ONLY_COLUMNS", "IGNORE_READONLY", "INSERT_SQL", "INSERTBUFF", "LOGIN_TIMEOUT", "QUOTE_CHAR", "STRINGDATES", "UPDATE_ISOLATION_LEVEL", "UPDATE_MULT_ROWS", "UPDATE_SQL"};

        OdbcConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = true;
            return this.genPassThruOptionsString(iMeta, iDbms, true, this.specificOptions);
        }
    }

    private static final class AsterConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"SERVER", "ENGINENAME", "DATABASE", "DB", "PORT", "SERVICE", "SERVICE_NAME", "DSN", "DS", "DATASRC", "NOPROMPT", "PROMPT", "REQUIRED", "AUTHDOMAIN", "AUTOCOMMIT", "DBSASLABEL", "IGNORE_READ_ONLY_COLUMNS", "IGNORE_READONLY", "INSERTBUFF", "QUERY_TIMEOUT", "TIMEOUT", "READBUFF", "ROWSET", "ROWSET_SIZE", "STRINGDATES", "STRDATES", "TRACE", "TRACEFILE", "USE_ODBC_CL", "UTILCONN_TRANSIENT", "DBPROMPT"};

        AsterConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class MySqlConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DATABASE", "DB", "PORT", "MYSQL_PORT", "SERVER", "HOST", "AUTOCOMMIT", "RESULTS", "SSL_KEY", "SSL_CERT", "SSL_CA", "SSL_CIPHER", "DBPROMPT", "AUTHDOMAIN"};

        MySqlConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class OleDbConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"AUTOCOMMIT", "CELLPROP", "COMMAND_TIMEOUT", "TIMEOUT", "CURSOR_TYPE", "CURSOR", "QUALIFY_ROWS", "QUALIFY", "READ_ISOLATION_LEVEL", "RIL", "READBUFF", "ROWSET", "ROWSET_SIZE", "STRINGDATES", "STRDATES", "DATASOURCE", "DS", "DSN", "PROPERTIES", "PROPS", "PROP", "PROVIDER", "PROV", "PROVIDER_STRING", "PROV_STRING", "EXTENDEDPROPERTIES", "EXTENDED_PROPERTIES", "EXPROPS", "OLEDB_SERVICES", "SERVICES", "PROMPT", "UDL_FILE", "UDL", "INIT_STRING", "INIT", "COMPLETE", "REQUIRED", "AUTHDOMAIN", "DELETE_MULT_ROWS", "IGNORE_READ_ONLY_COLUMNS", "IGNORE_READONLY", "IGNORE_READ_ONLY", "INSERT_SQL", "INSERT_ICOMMAND", "QUALIFIER", "QUOTE_CHAR", "SCHEMA", "OWNER", "UPDATE_ISOLATION_LEVEL", "UIL", "UPDATE_MULT_ROWS", "UTILCONN_TRANSIENT"};

        OleDbConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class ExcelConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"INIT", "PATH", "PROMPT", "UDL", "UDL_FILE", "AUTOCOMMIT", "COMMAND_TIMEOUT", "TIMEOUT", "DBENCODING", "MSENGINE", "STRINGDATES", "STRDATES", "USE_DATETYPE", "USEDATE", "INSERT_SQL", "SCAN_TEXTSIZE", "SCAN_TIMETYPE", "SQL_COMMAND", "UNICODE", "DBPROMPT"};

        ExcelConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = true;
            return this.genPassThruOptionsString(iMeta, iDbms, true, this.specificOptions);
        }
    }

    private static final class SybaseConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DATABASE", "DB", "SERVER", "INTERFACE", "INTRF", "INTERF", "SYBBUFSZ", "READ_BUFFER", "BUFFSIZE", "READBUFF", "SYBUFFER", "MAX_CONNECTS", "PACKETSIZE", "DBPROMPT", "AUTHDOMAIN"};

        SybaseConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class OracleConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"PATH", "BUFFSIZE", "READBUFF", "BUFF", "PRESERVE_COMMENTS", "PRESERVE", "OR_THREADS", "OR_ENABLE_INTERRUPT", "DBSERVER_MAX_BYTES", "DBCLIENT_MAX_BYTES", "EXPAND_BYTE_SEMANTIC_COLUMN_LENGTHS", "ADJUST_BYTE_SEMANTIC_COLUMN_LENGTHS", "ADJUST_NCHAR_COLUMN_LENGTHS", "DB_LENGTH_SEMANTICS_BYTE", "DBSERVER_ENCODING_FIXED", "DBCLIENT_ENCODING_FIXED", "OR_BINARY_DOUBLE", "READBUFF_MEMORYSIZE", "DBPROMPT", "AUTHDOMAIN"};

        OracleConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class SqlServerConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"AUTOCOMMIT", "CURSOR_TYPE", "KEYSET_SIZE", "QUERY_TIMEOUT", "READBUFF", "READ_ISOLATION_LEVEL", "TRACE", "TRACEFILE", "USE_ODBC_CL", "DATASRC", "COMPLETE", "NOPROMPT", "PROMPT", "REQUIRED", "AUTHDOMAIN"};

        SqlServerConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class AccessConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"INIT", "PATH", "PROMPT", "UDL", "UDL_FILE", "AUTOCOMMIT", "COMMAND_TIMEOUT", "TIMEOUT", "DBENCODING", "MSENGINE", "STRINGDATES", "STRDATES", "USE_DATETYPE", "USEDATE", "DBPASSWORD", "DBSYSFILE", "INSERT_SQL", "SCAN_TEXTSIZE", "SCAN_TIMETYPE", "SQL_COMMAND", "UNICODE", "DBPROMPT", "AUTHDOMAIN"};

        AccessConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = true;
            return this.genPassThruOptionsString(iMeta, iDbms, true, this.specificOptions);
        }
    }

    private static final class HadoopConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"SERVER", "HOST", "PORT", "SERVICE", "SCHEMA", "DATABASE", "DB", "READBUFF", "AUTHDOMAIN", "CFG", "CONFIG", "HD_CONFIG", "SUBPROTOCOL", "SUBPROTO", "HIVE_KERBEROS_PRINCIPAL", "HIVE_PRINCIPAL", "PROPERTIES", "HDFS_PRINCIPAL", "HDFS_KERBEROS_PRINCIPAL", "DRIVERCLASS", "CLASS", "HIVE_CLASS", "HIVEDRIVER_CLASS", "HIVECL", "DRIVER", "URI", "URL", "DBCREATE_TABLE_EXTERNAL", "DBCREATE_EXTERNAL", "DBCREATE_EXT", "HDFS_TEMPDIR", "HDFS_DATADIR", "HDFS_PERMDIR", "HDFS_METADIR", "READ_METHOD", "CTAS_METHOD", "BULKLOAD", "MAX_PARTSLOTS", "TRANSCODE_FAIL", "DECIMAL_PLACES", "VIEW_NULL_WHERE_CLAUSE", "CHARACTER_OUTPUT_TYPE", "USE_CONFIG_FILES", "COPY_CONFIG", "LOGIN_TIMEOUT", "CHECK_TRANSCODING", "SCRATCH_DB", "CLASSPATH", "CHARACTER_MULTIPLIER"};

        HadoopConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            String options = this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
            String connectionProperties = this.sas9Generator.processHadoopConnectionProperties(iDbms, iMeta);
            return options + connectionProperties;
        }
    }

    private static final class TableServerConnection
    extends OdbcConnection {
        TableServerConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = true;
            this.connectionOptions.append(this.genPassThruOptionsString(iMeta, iDbms, true, this.specificOptions));
            if (iDbms != null) {
                this.connectionOptions.append(this.sas9Generator.processTableConnectionProperties(iDbms, iMeta));
            }
            return this.connectionOptions.toString();
        }
    }

    private static final class NetezzaConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DATASRC", "DSN", "DS", "DATABASE", "DB", "SERVER", "PORT", "AUTOCOMMIT", "ROWSET_SIZE", "ROWSET", "READBUFF", "STRINGDATES", "STRDATES", "CONNECT_OPTIONS", "CONOPTS", "QUERY_TIMEOUT", "TIMEOUT", "TRACE", "TRACEFILE", "LOGIN_TIMEOUT", "READ_ONLY", "READONLY", "PRESERVE_USER", "DBPROMPT", "AUTHDOMAIN"};

        NetezzaConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class NeoviewConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"SERVER", "SCHEMA", "OWNER", "PORT", "SERVICE", "SERVICE_NAME", "DSN", "DS", "DATASRC", "DBPROMPT", "AUTHDOMAIN"};

        NeoviewConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            if (!this.isDNSOptionPresent(iDbms)) {
                this.connectionOptions.append(this.addSchemaOption(iMeta));
            }
            boolean isUserNameToBeQuoted = true;
            this.connectionOptions.append(this.genPassThruOptionsString(iMeta, iDbms, true, this.specificOptions));
            return this.connectionOptions.toString();
        }
    }

    private static final class SpdsConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DBQ", "HOST", "SERVICE", "SERV", "PROMPT"};

        SpdsConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            AssociationList iDbmsProperties = iDbms.getProperties();
            ArrayList<SasLibnameOption> tokenizedSasOptions = null;
            this.connectionOptions.append(this.getConnectionProperties(iDbmsProperties, this.specificOptions, tokenizedSasOptions));
            if (!this.isDNSOptionPresent(iDbms)) {
                this.connectionOptions.append(this.addSchemaOption(iMeta));
            }
            Connection currentConnection = null;
            boolean isUserNameToBeQuoted = true;
            boolean isPasswordToBeQuoted = true;
            this.connectionOptions.append(this.sas9Generator.genCredentials(iMeta, currentConnection, true, true));
            return this.connectionOptions.toString();
        }

        @Override
        protected String assembleOption(SasLibnameOption optionElement, boolean isQuoteable) {
            if (optionElement.isValidSQLOptionValue()) {
                String optionKeyword = optionElement.getName();
                String delimiter = optionElement.getDelimiter();
                String optionValue = optionElement.getValue();
                StringBuffer optionString = new StringBuffer();
                optionString.append(' ');
                optionString.append(MdModelUtil.genOptionPairQuoted(optionKeyword, delimiter, optionValue));
                return optionString.toString();
            }
            return "";
        }
    }

    private static final class PcFilesConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DSN", "DATASRC", "DS", "DATABASE", "DB", "CONNECT_STRING", "CONNECTSTR", "NOPROMPT", "PATH", "PORT", "SERVICE", "SERVICE_NAME", "SERVER", "DBSYSFILE", "SYSTEMDB", "MSENGINE", "MSDE", "VERSION", "VER", "READBUFF", "ROWSET_SIZE", "ROWSET", "STRINGDATES", "STRDATES", "SERVERUSER", "SERVERUID", "SERVERPASS", "SERVERPASSWORD", "SERVERPW", "SERVERPWD", "SSPI", "IN", "CREATE_IN", "READ_ISOLATION_LEVEL", "RIL", "UPDATE_ISOLATION_LEVEL", "UIL", "DUMMY_CONNECT", "INSERTBUFF", "QUERY_TIMEOUT", "TIMEOUT", "TRACE", "TRACEFILE", "UPDATE_MULT_ROWS", "DELETE_MULT_ROWS", "QUOTE_CHAR", "KEYSET_SIZE", "KEYSET", "USE_ODBC_CL", "INSERT_SQL", "UPDATE_SQL", "TYPE", "IGNORE_READ_ONLY_COLUMNS", "IGNORE_READONLY", "UNICODE_CONNECTION", "UNICODE", "FETCH_IDENTITY", "DBSERVER_MAX_BYTES", "DB_MAX_BYTES", "DBCLIENT_MAX_BYTES", "CLIENT_MAX_BYTES", "DBPROMPT", "AUTHDOMAIN"};

        PcFilesConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class VerticaConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DATABASE", "DB", "PORT", "SERVICE", "SERVICE_NAME", "SERVER", "DSN", "AUTHDOMAIN", "AUTOCOMMIT", "DBPROMPT", "DELETE_MULT_ROWS", "IGNORE_READ_ONLY_COLUMNS", "IGNORE_READONLY", "INSERTBUFF", "QUERY_TIMEOUT", "TIMEOUT", "READBUFF", "ROWSET_SIZE", "ROWSET", "READ_ISOLATION_LEVEL", "RIL", "STRINGDATES", "STRDATES", "TRACE", "TRACEFILE", "UPDATE_ISOLATION_LEVEL", "UIL", "UPDATE_MULT_ROWS", "UTILCONN_TRANSIENT"};

        VerticaConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = true;
            return this.genPassThruOptionsString(iMeta, iDbms, true, this.specificOptions);
        }
    }

    private static final class GreenplumConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DATASRC", "DS", "DSN", "DATABASE", "DB", "AUTOCOMMIT", "ROWSET_SIZE", "ROWSET", "READBUFF", "STRINGDATES", "STRDATES", "NOPROMPT", "CONNECTSTR", "CONNECT_STRING", "COMPLETE", "PROMPT", "QUERY_TIMEOUT", "TIMEOUT", "TRACE", "TRACEFILE", "CURSOR_TYPE", "CURSOR", "PORT", "SERVICE", "SERVICE_NAME", "SERVER", "HOST", "PATH", "CONNECT_OPTIONS", "CONOPTS", "SAS_TO_DB_ENCODING", "DBPROMPT", "AUTHDOMAIN"};

        GreenplumConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class InformixConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"SERVER", "AUTOCOMMIT", "DBPROMPT", "AUTHDOMAIN"};

        InformixConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class SybaseIqConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"HOST", "HOSTNAME", "SERVER", "ENGINENAME", "DATABASE", "DB", "PORT", "SERVICE", "SERVICE_NAME", "DSN", "DATASRC", "DS", "AUTOSTOP", "IN", "CREATE_IN", "READ_ISOLATION_LEVEL", "RIL", "UPDATE_ISOLATION_LEVEL", "UIL", "AUTOCOMMIT", "READBUFF", "ROWSET", "ROWSET_SIZE", "STRINGDATES", "STRDATES", "QUERY_TIMEOUT", "TIMEOUT", "TRACE", "TRACEFILE", "UPDATE_MULT_ROWS", "DELETE_MULT_ROWS", "CURSOR_TYPE", "CURSOR", "KEYSET_SIZE", "KEYSET", "INSERT_SQL", "UPDATE_SQL", "IGNORE_READ_ONLY_COLUMNS", "IGNORE_READONLY", "LOGIN_TIMEOUT", "CONNECT_OPTIONS", "CONOPTS", "DBPROMPT", "AUTHDOMAIN"};

        SybaseIqConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class TeradataConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"SLEEP", "TENACITY", "DBSLICEPARM", "FASTEXPORT", "SESSIONS", "OVERRIDE_RESP_LEN", "MODE", "ACCOUNT", "TDPID", "SERVER", "DATABASE", "DB", "DATABASE_QUOTED", "QUERY_BAND", "DBPROMPT", "AUTHDOMAIN", "TPT", "TPT_MIN_SESSIONS", "TPT_MAX_SESSIONS"};

        TeradataConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class PostgresConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DSN", "DATABASE", "DB", "AUTOCOMMIT", "DUMMY_CONNECT", "ROWSET_SIZE", "ROWSET", "READBUFF", "STRINGDATES", "STRDATES", "NOPROMPT", "CONNECTSTR", "CONNECT_STRING", "COMPLETE", "PROMPT", "QUERY_TIMEOUT", "TRACE", "TRACEFILE", "CURSOR_TYPE", "CURSOR", "PORT", "SERVICE", "SERVICE_NAME", "SERVER", "LOGIN_TIMEOUT", "CONNECT_OPTIONS", "CONOPTS", "DBSERVER_MAX_BYTES", "DB_MAX_BYTES", "DBCLIENT_NAX_BYTES", "DRIVER_VENDOR", "AUTHDOMAIN"};

        PostgresConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class SapHanaConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"SERVER", "SERVERNODE", "HOST", "PORT", "SERVICE", "SERVICE_NAME", "INSTANCE", "USER", "UID", "PASSWORD", "PASS", "PW", "PWD", "USING", "DSN", "DATABASE", "DATASRC", "DB", "DS", "NOPROMPT", "CONNECTSTR", "CONNECT_STRING", "PROMPT", "DRIVER", "ENCRYPT", "SSLCRYPTOPROVIDER", "SSLPROVIDER", "SSLKEYSTORE", "SSLTRUSTSTORE", "SSLVALIDATECERTIFICATE", "SSLHOSTNAMEINCERTIFICATE", "SSLHOSTNAMEINCERT", "SSLCREATESELFSIGNEDCERTIFICATE", "SSLCREATECERT", "AUTHDOMAIN", "AUTOCOMMIT", "CURSOR_TYPE", "CURSOR", "COMPLETE", "DBINDEX", "DBPROMPT", "DELETE_MULT_ROWS", "IGNORE_READ_ONLY_COLUMNS", "IGNORE_READONLY", "INSERTBUFF", "KEYSET_SIZE", "KEYSET", "LOGIN_TIMEOUT", "MULTI_DATASRC_OPT", "QUERY_TIMEOUT", "QUOTE_CHAR", "READBUFF", "ROWSET_SIZE", "ROWSET", "READ_ISOLATION_LEVEL", "RIL", "REQUIRED", "SQL_FUNCTIONS", "SQL_FUNCTIONS_COPY", "STRINGDATES", "TRACE", "TRACEFILE", "UPDATE_ISOLATION_LEVEL", "UPDATE_MULT_ROWS", "USE_ODBC_CL", "UTILCONN_TRANSIENT"};

        SapHanaConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class ImpalaConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DATASRC", "DSN", "DS", "DB", "DATABASE", "CONNECT_OPTIONS", "CONOPTS", "ROWSET_SIZE", "ROWSET", "READUFF", "STRINGDATES", "STRDATES", "QUERY_TIMEOUT", "TIMEOUT", "TRACE", "TRACEFILE", "PORT", "SERVICE", "SERVICE_NAME", "SERVER", "HOST", "HOSTNAME", "LOGIN_TIMEOUT", "DBSERVER_MAX_BYTES", "DB_MAX_BYTES", "DBCLINET_MAX_BYTES", "CLIENT_MAX_BYTES", "USE_DATADIRECT", "USE_PROGRESS", "HDFS_PRINCIPAL", "HDFS_KERBEROS_PRINCIPAL", "IMPALA_PRINCIPAL", "IMPALA_KERBEROS_PRINCIPAL", "CONFIG", "CFG", "HD_CONFIG", "CONFIGDIR", "CFGDIR", "HD_CONFIGDIR", "AUTHDOMAIN"};

        ImpalaConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class HawqConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DATASRC", "DS", "DSN", "DATABASE", "DB", "AUTOCOMMIT", "ROWSET_SIZE", "ROWSET", "READBUFF", "STRINGDATES", "STRDATES", "NOPROMPT", "CONNECTSTR", "CONNECT_STRING", "COMPLETE", "PROMPT", "QUERY_TIMEOUT", "TIMEOUT", "TRACE", "TRACEFILE", "CURSOR_TYPE", "CURSOR", "PORT", "SERVICE", "SERVICE_NAME", "SERVER", "HOST", "PATH", "CONNECT_OPTIONS", "CONOPTS", "SAS_TO_DB_ENCODING", "DBPROMPT", "AUTHDOMAIN"};

        HawqConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class RedshiftConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DSN", "DATABASE", "DB", "AUTOCOMMIT", "DUMMY_CONNECT", "ROWSET_SIZE", "ROWSET", "READBUFF", "STRINGDATES", "STRDATES", "NOPROMPT", "CONNECTSTR", "CONNECT_STRING", "COMPLETE", "PROMPT", "QUERY_TIMEOUT", "TRACE", "TRACEFILE", "CURSOR_TYPE", "CURSOR", "PORT", "SERVICE", "SERVICE_NAME", "SERVER", "LOGIN_TIMEOUT", "CONNECT_OPTIONS", "CONOPTS", "DBSERVER_MAX_BYTES", "DB_MAX_BYTES", "DBCLIENT_NAX_BYTES", "DRIVER_VENDOR", "AUTHDOMAIN"};

        RedshiftConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class JdbcConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"SERVER", "HOST", "PORT", "SERVICE", "SCHEMA", "DATABASE", "DB", "READBUFF", "AUTHDOMAIN", "DRIVERCLASS", "CLASS", "DRIVER", "URI", "URL", "BULKLOAD", "TRANSCODE_FAIL", "DECIMAL_PLACES", "VIEW_NULL_WHERE_CLAUSE", "CHARACTER_OUTPUT_TYPE", "LOGIN_TIMEOUT", "CHECK_TRANSCODING", "CLASSPATH", "CHARACTER_MULTIPLIER"};

        JdbcConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            String options = this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
            String connectionProperties = this.sas9Generator.processHadoopConnectionProperties(iDbms, iMeta);
            return options + connectionProperties;
        }
    }

    private static final class SalesforceConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"SCHEMA", "READBUFF", "STRINGDATES", "LOGIN_TIMEOUT", "QUERY_TIMEOUT", "CLASSPATH", "CP", "SAS_SFORCE_JAR_PATH", "ENDPOINT", "PROXY_HOST", "PROXYHOST", "PROXY_USER", "PROXYUSER", "PROXY_PASS", "PROXYPASS", "AUTHDOMAIN"};

        SalesforceConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            String options = this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
            String connectionProperties = this.sas9Generator.processHadoopConnectionProperties(iDbms, iMeta);
            return options + connectionProperties;
        }
    }

    private static final class MongoConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"SERVER", "HOST", "DATABASE", "DS", "DSN", "DATASRC", "DB", "SCHEMA", "READBUFF", "STRINGDATES", "LOGIN_TIMEOUT", "QUERY_TIMEOUT", "SCHEMA_SERVER", "SCHEMA_PORT", "SCHEMA_DB", "SCHEMA_USER", "SCHEMA_UID", "SCHEMA_PASSWORD", "SCHEMA_PWD", "SCHEMA_COLLECTION", "SCHEMA_URL", "AUTHDOMAIN"};

        MongoConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            String options = this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
            String connectionProperties = this.sas9Generator.processHadoopConnectionProperties(iDbms, iMeta);
            return options + connectionProperties;
        }
    }

    private static final class SnowlakeConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DATASRC", "DS", "DSN", "SCHEMA", "READBUFF", "ROWSET_SIZE", "ROWSET", "STRINGDATES", "STRDATES", "DATABASE", "DB", "CONOPTS", "CONNECT_OPTIONS", "QUERY_TIMEOUT", "TIMEOUT", "TRACE", "TRACEFILE", "LOGIN_TIMEOUT", "DBSERVER_MAX_BYTES", "SERVER_MAX_BYTES", "DBCLIENT_MAX_BYTES", "CLIENT_MAX_BYTES", "SERVER", "HOST", "HOSTNAME", "PORT", "SERVICE", "SERVICE_NAME", "DRIVER", "AUTOCOMMIT", "ROLE", "WAREHOUSE", "AUTHDOMAIN"};

        SnowlakeConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            String options = this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
            String connectionProperties = this.sas9Generator.processHadoopConnectionProperties(iDbms, iMeta);
            return options + connectionProperties;
        }
    }

    private static final class BigQueryConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"READBUFF", "ROWSET_SIZE", "ROWSET", "STRINGDATES", "STRDATES", "TRACE", "TRACEFILE", "TRACEFLAGS", "PROJECT", "CRED_PATH", "CRED_FILE", "CREDPATH", "CREDFILE", "KMS_PATH", "KMS_FILE", "KMS_NAME", "KMSPATH", "KMSFILE", "KMSNAME", "LOCATION", "MAX_BINARY_LEN", "MAX_CHAR_LEN", "USE_INFORMATION_SCHEMA", "PROXY", "SCHEMA", "REFRESH_TOKEN", "CLIENT_ID", "CLIENT_SECRET", "AUTHDOMAIN"};

        BigQueryConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            String options = this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
            String connectionProperties = this.sas9Generator.processHadoopConnectionProperties(iDbms, iMeta);
            return options + connectionProperties;
        }
    }

    private static final class YellowbrickConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"DSN", "DATABASE", "DB", "AUTOCOMMIT", "DUMMY_CONNECT", "ROWSET_SIZE", "ROWSET", "READBUFF", "STRINGDATES", "STRDATES", "NOPROMPT", "CONNECTSTR", "CONNECT_STRING", "COMPLETE", "PROMPT", "QUERY_TIMEOUT", "TRACE", "TRACEFILE", "CURSOR_TYPE", "CURSOR", "PORT", "SERVICE", "SERVICE_NAME", "SERVER", "LOGIN_TIMEOUT", "CONNECT_OPTIONS", "CONOPTS", "DBSERVER_MAX_BYTES", "DB_MAX_BYTES", "DBCLIENT_NAX_BYTES", "DRIVER_VENDOR", "AUTHDOMAIN"};

        YellowbrickConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            boolean isUserNameToBeQuoted = false;
            return this.genPassThruOptionsString(iMeta, iDbms, false, this.specificOptions);
        }
    }

    private static final class UnknownEngineConnection
    extends SASLibraryConnectStatement {
        final String[] specificOptions = new String[]{"CONNECTION"};

        UnknownEngineConnection(MdModelUtil.SAS9Generator sas9Generator) {
            super(sas9Generator);
        }

        @Override
        protected String getConnectionOptions(SASLibrary iMeta, SASClientConnection iDbms) throws RemoteException, MdException {
            if (iDbms != null) {
                AssociationList iDbmsProperties = iDbms.getProperties();
                this.connectionOptions.append(MdModelUtil.processProperties(iMeta.getEngine(), iDbmsProperties));
            }
            ArrayList<SasLibnameOption> tokenizedSasOptions = null;
            AssociationList iMetaProperties = iMeta.getProperties();
            this.connectionOptions.append(this.getConnectionProperties(iMetaProperties, this.specificOptions, tokenizedSasOptions));
            this.connectionOptions.append(this.sas9Generator.genCredentials(iMeta, null, false, true));
            return this.connectionOptions.toString();
        }
    }

    static class SasLibnameOption {
        private String name;
        private String delimiter;
        private String value;

        SasLibnameOption() {
        }

        SasLibnameOption(String name, String delimiter, String value) {
            this.name = name;
            this.delimiter = delimiter;
            this.value = value;
        }

        void setName(String name) {
            this.name = name;
        }

        void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        void setValue(String value) {
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        @Nonnull
        String getDelimiter() {
            String d = this.delimiter == null ? "" : this.delimiter;
            return d;
        }

        @Nonnull
        String getValue() {
            String v = this.value == null ? "" : this.value;
            return v;
        }

        String getOptionCheckingForQuotes() {
            if (this.delimiter == null && this.value == null) {
                return this.name;
            }
            String optionValue = this.getValue();
            String optionName = this.getName();
            String delimiter = this.getDelimiter();
            String option = MdModelUtil.genOptionPair(optionName, delimiter, optionValue);
            return option;
        }

        String getSyntacticallyCorrectOption() {
            if (this.delimiter == null && this.value == null) {
                return this.name;
            }
            String optionValue = this.getValue();
            String optionName = this.getName();
            String delimiter = this.getDelimiter();
            String option = MdModelUtil.genOptionPairUnquoted(optionName, delimiter, optionValue);
            return option;
        }

        boolean isValidSQLOptionValue() {
            String connectionOption = "CONNECTION";
            boolean matchingValues = false;
            String optionName = this.getName();
            String optionValue = this.getValue();
            boolean isValidValue = false;
            if (connectionOption.length() == optionName.length() && connectionOption.compareToIgnoreCase(optionName) == 0) {
                int valueCount = 2;
                String[] validSQLConnectionValue = new String[]{"SHARED", "GLOBAL"};
                for (int valueIndex = 0; valueIndex < 2; ++valueIndex) {
                    if (validSQLConnectionValue[valueIndex].length() != optionValue.length() || validSQLConnectionValue[valueIndex].compareToIgnoreCase(optionValue) != 0) continue;
                    isValidValue = true;
                    break;
                }
            } else {
                isValidValue = true;
            }
            return isValidValue;
        }
    }

    class FreeFormatOptionsText {
        private String freeFormatText;
        private int currentIndex;
        private OptionParseState parseState;
        private int maxIndex;
        private final OptionNameState optionNameState;
        private final OptionDelimiterState optionDelimiterState;
        private final OptionValueState optionValueState;
        private final OptionsFinishedState optionsFinishedState;

        protected FreeFormatOptionsText(String optionsText) {
            this.optionNameState = new OptionNameState();
            this.optionDelimiterState = new OptionDelimiterState();
            this.optionValueState = new OptionValueState();
            this.optionsFinishedState = new OptionsFinishedState();
            this.currentIndex = 0;
            this.maxIndex = optionsText.length();
            this.freeFormatText = optionsText;
            this.parseState = this.optionNameState;
        }

        protected void getToken(SasLibnameOption currentOption) {
            this.parseState.getToken(this, currentOption, this.optionNameState, this.optionDelimiterState, this.optionValueState, this.optionsFinishedState);
        }

        protected void updateCurrentIndex(int index) {
            this.currentIndex += index;
            assert (this.currentIndex <= this.maxIndex) : "Exceeded max index: " + this.currentIndex;
        }

        protected int getCurrentIndex() {
            return this.currentIndex;
        }

        protected String getCurrentOptionsText() {
            return this.freeFormatText.substring(this.currentIndex);
        }

        protected boolean isParsingName() {
            return this.parseState == this.optionNameState;
        }

        protected boolean isParsingDelimiter() {
            return this.parseState == this.optionDelimiterState;
        }

        protected boolean isParsingFinished() {
            return this.parseState == this.optionsFinishedState;
        }

        protected void setNextState(OptionParseState nextParseState) {
            this.parseState = nextParseState;
        }

        protected void ignoreBlanks() {
            boolean isMoreOptionsTextString;
            int blanksCount = 0;
            String optionText = this.getCurrentOptionsText();
            boolean bl = isMoreOptionsTextString = optionText.length() != 0;
            if (isMoreOptionsTextString) {
                boolean isBlank;
                do {
                    char currentChar;
                    boolean bl2 = isBlank = (currentChar = optionText.charAt(blanksCount)) == ' ';
                    if (!isBlank) continue;
                    ++blanksCount;
                } while (isBlank);
            }
            if (blanksCount > 0) {
                this.updateCurrentIndex(blanksCount);
            }
        }

        protected boolean isRemainingText() {
            return this.freeFormatText.length() > this.currentIndex;
        }
    }

    class OptionValueState
    extends OptionParseState {
        OptionValueState() {
        }

        @Override
        protected void getToken(FreeFormatOptionsText freeFormatOptions, SasLibnameOption sasOption, OptionNameState optionNameState, OptionDelimiterState optionDelimiterState, OptionValueState optionValueState, OptionsFinishedState optionsFinishedState) {
            boolean beginIndex = false;
            String options = freeFormatOptions.getCurrentOptionsText();
            ValueUndeterminedState parseState = new ValueUndeterminedState();
            int endOfValueIndex = ((ValueParseState)parseState).getEndIndex(options);
            endOfValueIndex = this.verifyEndOfValue(options, endOfValueIndex);
            freeFormatOptions.updateCurrentIndex(endOfValueIndex);
            freeFormatOptions.ignoreBlanks();
            freeFormatOptions.setNextState(this.nextState(optionNameState, optionDelimiterState, optionValueState, optionsFinishedState, freeFormatOptions));
            String valueString = options.substring(0, endOfValueIndex);
            sasOption.setValue(valueString);
        }

        private int verifyEndOfValue(String options, int endOfValueIndex) {
            boolean isEndOfOptionText;
            int remainingTextLen = options.length();
            boolean bl = isEndOfOptionText = endOfValueIndex == remainingTextLen;
            if (!isEndOfOptionText) {
                boolean isLastCharABlank;
                char currentChar = options.charAt(endOfValueIndex);
                boolean bl2 = isLastCharABlank = currentChar == ' ';
                if (!isLastCharABlank) {
                    int nextBlank = options.indexOf(32, endOfValueIndex);
                    endOfValueIndex = nextBlank == -1 ? options.length() : nextBlank;
                }
            }
            return endOfValueIndex;
        }

        @Override
        protected OptionParseState nextState(OptionNameState optionNameState, OptionDelimiterState optionDelimiterState, OptionValueState optionValueState, OptionsFinishedState optionsFinishedState, FreeFormatOptionsText freeFormatOptions) {
            if (freeFormatOptions.isRemainingText()) {
                return optionNameState;
            }
            return optionsFinishedState;
        }
    }

    class OptionsFinishedState
    extends OptionParseState {
        OptionsFinishedState() {
        }

        @Override
        protected void getToken(FreeFormatOptionsText freeFormatOptions, SasLibnameOption sasOption, OptionNameState optionNameState, OptionDelimiterState optionDelimiterState, OptionValueState optionValueState, OptionsFinishedState optionsFinishedState) {
        }

        @Override
        protected OptionParseState nextState(OptionNameState optionNameState, OptionDelimiterState optionDelimiterState, OptionValueState optionValueState, OptionsFinishedState optionsFinishedState, FreeFormatOptionsText freeFormatOptions) {
            return optionsFinishedState;
        }
    }

    class OptionDelimiterState
    extends OptionParseState {
        private boolean isDelimiterFound;

        OptionDelimiterState() {
        }

        @Override
        protected void getToken(FreeFormatOptionsText freeFormatOptions, SasLibnameOption sasOption, OptionNameState optionNameState, OptionDelimiterState optionDelimiterState, OptionValueState optionValueState, OptionsFinishedState optionsFinishedState) {
            char nextCharacter;
            boolean startOfStringindex = false;
            String options = freeFormatOptions.getCurrentOptionsText();
            this.isDelimiterFound = options.length() > 0 ? (nextCharacter = options.charAt(0)) == '=' : false;
            if (this.isDelimiterFound) {
                boolean charLength = true;
                freeFormatOptions.updateCurrentIndex(1);
                String delimiterString = Character.toString('=');
                sasOption.setDelimiter(delimiterString);
            } else {
                String noDelimiterString = null;
                sasOption.setDelimiter(noDelimiterString);
                String noValueString = null;
                sasOption.setValue(noValueString);
            }
            freeFormatOptions.ignoreBlanks();
            freeFormatOptions.setNextState(this.nextState(optionNameState, optionDelimiterState, optionValueState, optionsFinishedState, freeFormatOptions));
        }

        @Override
        protected OptionParseState nextState(OptionNameState optionNameState, OptionDelimiterState optionDelimiterState, OptionValueState optionValueState, OptionsFinishedState optionsFinishedState, FreeFormatOptionsText freeFormatOptions) {
            OptionParseState optionState = freeFormatOptions.isRemainingText() ? (this.isDelimiterFound ? optionValueState : optionNameState) : optionsFinishedState;
            return optionState;
        }
    }

    class OptionNameState
    extends OptionParseState {
        OptionNameState() {
        }

        @Override
        protected void getToken(FreeFormatOptionsText freeFormatOptions, SasLibnameOption sasOption, OptionNameState optionNameState, OptionDelimiterState optionDelimiterState, OptionValueState optionValueState, OptionsFinishedState optionsFinishedState) {
            boolean startOfStringindex = false;
            String options = freeFormatOptions.getCurrentOptionsText();
            int endOfNameIndex = this.getEndOfNameIndex(options);
            freeFormatOptions.updateCurrentIndex(endOfNameIndex);
            freeFormatOptions.ignoreBlanks();
            freeFormatOptions.setNextState(this.nextState(optionNameState, optionDelimiterState, optionValueState, optionsFinishedState, freeFormatOptions));
            String optionName = options.substring(0, endOfNameIndex);
            sasOption.setName(optionName);
        }

        @Override
        protected OptionParseState nextState(OptionNameState optionNameState, OptionDelimiterState optionDelimiterState, OptionValueState optionValueState, OptionsFinishedState optionsFinishedState, FreeFormatOptionsText freeFormatOptions) {
            if (freeFormatOptions.isRemainingText()) {
                return optionDelimiterState;
            }
            return optionsFinishedState;
        }

        private int getEndOfNameIndex(String text) {
            boolean isBlankFound;
            boolean isDelimiterFound;
            boolean startOfStringindex = false;
            int blankIndex = text.indexOf(32, 0);
            int delimiterIndex = text.indexOf(61, 0);
            boolean bl = isDelimiterFound = delimiterIndex != -1;
            if (!isDelimiterFound) {
                delimiterIndex = Integer.MAX_VALUE;
            }
            boolean bl2 = isBlankFound = blankIndex != -1;
            if (!isBlankFound) {
                blankIndex = Integer.MAX_VALUE;
            }
            int endOfNameIndex = isBlankFound || isDelimiterFound ? Math.min(blankIndex, delimiterIndex) : text.length();
            return endOfNameIndex;
        }
    }

    class ValueUndeterminedState
    extends ValueParseState {
        ValueUndeterminedState() {
        }

        @Override
        int getEndIndex(String valueText) {
            return this.getValueEndIndex(valueText);
        }
    }

    class ValueTextState
    extends ValueParseState {
        ValueTextState() {
        }

        @Override
        int getEndIndex(String valueText) {
            int expectedChar = 32;
            return this.getEndIndex(' ', valueText);
        }

        private int getEndIndex(char expectedChar, String valueText) {
            char[] relevantDelimiters = new char[]{' '};
            int nextOptionIndex = this.getIndexOfClosestDelimiter(valueText, relevantDelimiters);
            return nextOptionIndex;
        }
    }

    class ValueDoubleQuoteState
    extends ValueQuotesState {
        ValueDoubleQuoteState() {
        }

        @Override
        int getEndIndex(String valueText) {
            int requiredDelimiter = 34;
            int possibleDelimiter = 39;
            int endIndex = this.getEndIndex('\"', '\'', valueText);
            return endIndex;
        }
    }

    class ValueSingleQuoteState
    extends ValueQuotesState {
        ValueSingleQuoteState() {
        }

        @Override
        int getEndIndex(String valueText) {
            int requiredDelimiter = 39;
            int possibleDelimiter = 34;
            int endIndex = this.getEndIndex('\'', '\"', valueText);
            return endIndex;
        }
    }

    abstract class ValueQuotesState
    extends ValueParseState {
        ValueQuotesState() {
        }

        protected int getEndIndex(char requiredDelimiter, char possibleDelimiter, String valueText) {
            int endIndex = 0;
            int currentIndex = 0;
            boolean isStillSearching = true;
            ValueParseState.StripLeadingChar tempValue = new ValueParseState.StripLeadingChar(valueText, endIndex);
            valueText = tempValue.getText();
            endIndex = tempValue.getIndex();
            tempValue = null;
            do {
                boolean isEmbeddedQuotes;
                if (currentIndex > 0) {
                    valueText = valueText.substring(currentIndex);
                    currentIndex = 0;
                }
                int nextRequiredCharIndex = this.getIndexOfChar(valueText, requiredDelimiter);
                int nextPossibleCharindex = this.getIndexOfChar(valueText, possibleDelimiter);
                boolean bl = isEmbeddedQuotes = nextPossibleCharindex < nextRequiredCharIndex;
                if (isEmbeddedQuotes) {
                    currentIndex = nextPossibleCharindex;
                    endIndex += currentIndex;
                    valueText = valueText.substring(currentIndex);
                    currentIndex = this.getValueEndIndex(valueText);
                    endIndex += currentIndex;
                    continue;
                }
                int endingDelimiter = 0;
                int valueTextLen = valueText.length();
                if (nextRequiredCharIndex == Integer.MAX_VALUE) {
                    nextRequiredCharIndex = valueTextLen;
                } else {
                    boolean isEndOfText;
                    boolean bl2 = isEndOfText = valueTextLen == 0;
                    if (isEndOfText) {
                        boolean noDelimiterPresent = false;
                        endingDelimiter = 0;
                    } else {
                        boolean delimiterPresent = true;
                        endingDelimiter = 1;
                    }
                }
                endIndex += nextRequiredCharIndex + currentIndex + endingDelimiter;
                isStillSearching = false;
            } while (isStillSearching);
            return endIndex;
        }
    }

    class ValueParensState
    extends ValueParseState {
        ValueParensState() {
        }

        @Override
        int getEndIndex(String valueText) {
            int expectedChar = 41;
            return this.getEndIndex(')', valueText);
        }

        private int getEndIndex(char expectedChar, String valueText) {
            int endIndex = 0;
            int delimiterIndex = 0;
            boolean isStillSearching = true;
            ValueParseState.StripLeadingChar tempValue = new ValueParseState.StripLeadingChar(valueText, endIndex);
            valueText = tempValue.getText();
            endIndex = tempValue.getIndex();
            tempValue = null;
            char[] relevantDelimiters = new char[]{'(', ')', '\'', '\"'};
            while (isStillSearching) {
                boolean isDelimiterWithinValueText;
                delimiterIndex = this.getIndexOfClosestDelimiter(valueText, relevantDelimiters);
                boolean bl = isDelimiterWithinValueText = delimiterIndex < valueText.length();
                if (isDelimiterWithinValueText) {
                    char foundDelimiterChar = valueText.charAt(delimiterIndex);
                    boolean bl2 = isStillSearching = foundDelimiterChar != expectedChar;
                    if (isStillSearching) {
                        valueText = valueText.substring(delimiterIndex);
                        endIndex += delimiterIndex;
                        delimiterIndex = this.getValueEndIndex(valueText);
                        valueText = valueText.substring(delimiterIndex);
                        endIndex += delimiterIndex;
                        continue;
                    }
                    if (expectedChar == ' ') continue;
                    ++delimiterIndex;
                    continue;
                }
                isStillSearching = false;
            }
            return endIndex += delimiterIndex;
        }
    }

    abstract class ValueParseState {
        static final char OPEN_PAREN = '(';
        static final char CLOSE_PAREN = ')';
        static final int CHAR_LEN = 1;

        ValueParseState() {
        }

        abstract int getEndIndex(String var1);

        public int getValueEndIndex(String valueText) {
            boolean startOfStringindex = false;
            char currentCharacter = valueText.charAt(0);
            ValueParseState parseState = currentCharacter == '(' ? new ValueParensState() : (currentCharacter == '\'' ? new ValueSingleQuoteState() : (currentCharacter == '\"' ? new ValueDoubleQuoteState() : new ValueTextState()));
            int endIndex = ((ValueParseState)parseState).getEndIndex(valueText);
            parseState = null;
            return endIndex;
        }

        protected int getIndexOfChar(String valueText, char desiredChar) {
            int desiredCharIndex = valueText.indexOf(desiredChar);
            if (desiredCharIndex == -1) {
                desiredCharIndex = Integer.MAX_VALUE;
            }
            return desiredCharIndex;
        }

        protected int getIndexOfClosestDelimiter(String optionText, char[] revelantDelimiters) {
            ValueDelimiters nextDelimiter = new ValueDelimiters(optionText, revelantDelimiters);
            int delimiterIndex = nextDelimiter.getNextDelimiterIndex();
            nextDelimiter = null;
            return delimiterIndex;
        }

        class ValueDelimiters {
            private int delimiterIndex;

            public ValueDelimiters(String valueText, char[] relevantDelimiters) {
                this.getClosestDelimiterIndex(valueText, relevantDelimiters);
            }

            private void getClosestDelimiterIndex(String valueText, char[] relevantDelimiters) {
                int closestDelimiterIndex = Integer.MAX_VALUE;
                int delimiterCount = relevantDelimiters.length;
                for (int i = 0; i < delimiterCount; ++i) {
                    int currentDelimiterIndex = ValueParseState.this.getIndexOfChar(valueText, relevantDelimiters[i]);
                    closestDelimiterIndex = Math.min(currentDelimiterIndex, closestDelimiterIndex);
                }
                if (closestDelimiterIndex == Integer.MAX_VALUE) {
                    boolean isBlankSeparatorPresent;
                    int nextBlank = valueText.indexOf(32);
                    int noBlankFound = -1;
                    boolean bl = isBlankSeparatorPresent = nextBlank != -1;
                    this.delimiterIndex = isBlankSeparatorPresent ? nextBlank + 1 : valueText.length();
                } else {
                    this.delimiterIndex = closestDelimiterIndex;
                }
            }

            public int getNextDelimiterIndex() {
                return this.delimiterIndex;
            }
        }

        protected class StripLeadingChar {
            private final String text;
            private final int index;

            protected StripLeadingChar(String text, int index) {
                this.text = text.substring(1);
                this.index = ++index;
            }

            protected String getText() {
                return this.text;
            }

            protected int getIndex() {
                return this.index;
            }
        }
    }

    abstract class OptionParseState {
        static final char DELIMITER = '=';

        OptionParseState() {
        }

        abstract void getToken(FreeFormatOptionsText var1, SasLibnameOption var2, OptionNameState var3, OptionDelimiterState var4, OptionValueState var5, OptionsFinishedState var6);

        abstract OptionParseState nextState(OptionNameState var1, OptionDelimiterState var2, OptionValueState var3, OptionsFinishedState var4, FreeFormatOptionsText var5);
    }
}

